#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "stdio.h"
#include "strings.h"
#include <string.h>
#include <errno.h>

//NO WE USE g_assert for portability
//#include "assert.h"

#include <gtk/gtk.h>

#ifdef USE_IMLIB
#include <gdk_imlib.h>
#else
#include <gdk-pixbuf/gdk-pixbuf.h>
#endif

#include <gdk/gdk.h>


#include "gdk-pixbuf-extra.h"

#include "gtktopdata.h"

#include "callbacks.h"
#include "interface.h"
#include "support.h"
//#include "pixmaps.h"
#include "mesh-gtk.h"
#include "utils.h"
#include "main.h"
extern gtkmorph_status_t   *sp ;


/*******************************************************************/






/***************************** colors ***************/





/* color for selected points */
GdkGC   *mps_gc;
/* color for resulting points */
GdkGC   *mpr_gc;
/* color for mesh lines */
GdkGC *mpl_gc;

/* color flashing */
GdkGC *flash_gc;





void allocate_colors(GtkWidget * widget)
{
  //FIXME CRUDE PROGRAMMING

  mpl_gc = gdk_gc_new(widget->window);

  gdk_gc_copy(mpl_gc, widget->style->white_gc );
  gdk_gc_set_line_attributes (mpl_gc,
			      1, //gint line_width,
			      GDK_LINE_ON_OFF_DASH,//GdkLineStyle line_style,
			      GDK_CAP_BUTT, //GdkCapStyle cap_style,
			      GDK_JOIN_MITER //GdkJoinStyle join_style
			      );
#ifdef FIXME
  /* the xor method  flashes on/off 
       we should use the same clipping rectangle as above, but we dont */
  gdk_gc_set_function(mpl_gc,GDK_XOR);
#endif

  flash_gc = gdk_gc_new(widget->window);
  gdk_gc_copy(flash_gc,mpl_gc );
  gdk_gc_set_function(flash_gc,GDK_XOR);

  {
    GdkColor    color =   {
      0L, //gulong  pixel;
      60000, //gushort red;
      60000, //gushort green;
      10000 //gushort blue;
    };
    
    if(gdk_colormap_alloc_color (gdk_colormap_get_system (),
				 & color,
				 FALSE , //gboolean writeable,
				 TRUE //gboolean best_match
				 )
       == FALSE)
      g_warning("%s %d : can't allocate color\n",__FILE__,__LINE__);
    
    mps_gc= gdk_gc_new (widget->window);
    gdk_gc_copy ( mps_gc, widget->style->white_gc  );
    gdk_gc_set_foreground ( mps_gc, &color); 
  }
  {
    GdkColor    color =   {
      0L, //gulong  pixel;
      10000, //gushort red;
      60000, //gushort green;
      60000 //gushort blue;
    };
    
    if(gdk_colormap_alloc_color (gdk_colormap_get_system (),
				 & color,
				 FALSE , //gboolean writeable,
				 TRUE //gboolean best_match
				 )
       == FALSE)
      g_warning("%s %d : can't allocate color\n",__FILE__,__LINE__);
    
    mpr_gc= gdk_gc_new (widget->window);
    gdk_gc_copy ( mpr_gc, widget->style->white_gc  );
    gdk_gc_set_foreground ( mpr_gc, &color);
  }
}











void
flash_point(GdkDrawable  *drawable,
	    int x,int y	    )
{ 
  int MP_SIZE=10, MP_ARC=360 * 64;
  gdk_draw_arc  (drawable, flash_gc,
		 TRUE,
		 x - MP_SIZE/2,  y - MP_SIZE/2, MP_SIZE,MP_SIZE,0,MP_ARC);
}


























/***********************************************************************
allocates / deallocate  pixbufs and pixmaps

********************************************************************/


/* which image are we displaying?    */

GdkPixbuf **
which_pixbuf(int lp, int what)
{
  GdkPixbuf **pb ;
  switch( what)
    {
    case PIXLOADED:
      pb=&sp->im_loaded_pixbuf[lp];
      break;
    case PIXSUBIMAGE:
      pb=&sp->im_subimage_pixbuf[lp];
      break; 
    case PIXWARPED:
      pb=&sp->im_warped_pixbuf[lp];
      break;
    default: abort();
    }
  return pb;
}

GdkPixbuf **
which_pixbuf_is_visible(int lp)
{
  return which_pixbuf(lp,sp->which_pix[lp]);
}

GdkPixmap **
which_pixmap(int lp, int what)
{
  GdkPixmap **pb ;
  switch( what)
    {
    case PIXLOADED:
      pb=&sp->im_loaded_pixmap[lp];
      break;
    case PIXSUBIMAGE:
      pb=&sp->im_subimage_pixmap[lp];
      break; 
    case PIXWARPED:
      pb=&sp->im_warped_pixmap[lp];
      break;
    default: abort();
    }
  return pb;
}

GdkPixmap **
which_pixmap_is_visible(int lp)
{
  return which_pixmap(lp,sp->which_pix[lp]);
}


void
destroy_pixbuf(int lp, int what)
{
  GdkPixbuf **pb=which_pixbuf(lp,what);
  if(*pb)
    gdk_pixbuf_unref(*pb);
  *pb=NULL;
}

void
destroy_pixmap(int lp, int what)
{
  GdkPixmap **pm=which_pixmap(lp,what);
  if(*pm)
    gdk_pixmap_unref(*pm);
  *pm=NULL;
}

void
create_pixbuf(int lp, int what)
{
  GdkPixbuf **pb=which_pixbuf(lp,what);
  int w,h;
  which_pixbuf_size(lp, what, &w, &h);

  g_assert(*pb == NULL);
  
  *pb=gdk_pixbuf_new (GDK_COLORSPACE_RGB,//GdkColorspace colorspace,
		      FALSE, //gboolean has_alpha,
		      8,//int bits_per_sample,
		      sp->resulting_width, sp->resulting_height);
  
  g_assert( gdk_pixbuf_get_bits_per_sample (*pb) == 8);  
  gdk_pixbuf_clear(*pb);
}

void
create_pixmap_(int lp, int what)
{
  GdkPixmap **pm=which_pixmap(lp,what);
  int w,h;
  which_pixbuf_size(lp, what, &w, &h);

  g_assert(*pm == NULL);
  
  /* creates backing pixmaps anyway */
  *pm = gdk_pixmap_new(sp->im_widget[lp]->window,
		       w,
		       h,
		       -1);
  
  gdk_draw_rectangle (*pm,
		      sp->im_widget[lp]->style->black_gc,
		      TRUE,
		      0, 0,
		      w,
		      h);
}

void
render_pixmap(int lp, int what)
{
  GdkPixbuf **pb=which_pixbuf(lp,what);
  GdkPixmap **pm=which_pixmap(lp,what);
  int w,h;

  which_pixbuf_size(lp, what, &w, &h);

  if( *pm==NULL)
    create_pixmap_(lp,what);
  if( *pb==NULL)
    create_pixbuf(lp,what);
  
  {
    gdk_pixbuf_render_to_drawable  
      (*pb,
       *pm,
       sp->im_widget[lp]->style->black_gc, //GdkGC *gc,
       0, //int src_x,
       0, //int src_y,
       0, //int dest_x,
       0, //int dest_y,
       w,h, //width, height,
       GDK_RGB_DITHER_NORMAL,//GdkRgbDither dither,
       0, //int x_dither,
       0 ); //int y_dither);
  }
}

/*  if (sp->im_editshow[lp] != EDITSHOW_EDIT ) */
/*     { */
/*       pb = sp-> im_pixbufwarped[lp]; */
/*     } */
/*   else */
/*     { */
/*       pb = sp-> im_pixbuf_subimage[lp]; */
/*     } */



















/*********************** 
			 some commonly used routines 
********************** 
*/



/*sets things according to the edit view menu value */
void
editview_callback(int i)
{
  if(i!= MAX_WINS+1)    {
    GtkWidget *m=gtk_widget_get_data_top(sp->im_widget[i],"handleboxsubimage");
    g_assert(m);
    if(sp->im_editshow[i] == EDITSHOW_EYES)
      gtk_widget_show(m);
    else
      gtk_widget_hide(m);
  }
  if(sp->im_editshow[i] == EDITSHOW_EYES)
    sp->which_pix[i]=PIXLOADED;
  else
    if(sp->im_editshow[i] == EDITSHOW_SHOW)
      sp->which_pix[i]=PIXWARPED;
    else
      sp->which_pix[i]=PIXSUBIMAGE;
  
  drawingarea_configure(i);
  //gtk_widget_configure(sp->im_drawingarea_widget[i]);
}



/******** sets the "edit mesh/show warp" option menu value */

void
set_editshow(int lp, /* window number */
	     int status)
{
  
  /* this trick comes from the FAQ of glade*/
  GtkWidget * option_menu = lookup_widget (sp->im_widget[lp],
					   "optionmenu_editview");
  sp->im_editshow[lp]=status;

  gtk_option_menu_set_history(GTK_OPTION_MENU( option_menu),
			      status);
  
  editview_callback(lp);

  gtk_widget_draw(option_menu, NULL);
}  

/*****************************************************/



/************************** pixbuf <-> r g b
 *  these copy data 
 */

void
pixbuf_to_rrrgggbb(GdkPixbuf *pb, guint8 *r, guint8 *g, guint8 *b)
  /* copy pixbuf data  to RGB data for morphing	   */
{ 
  int i,j,
    width =  gdk_pixbuf_get_width(pb),
    height = gdk_pixbuf_get_height(pb);
  long //size = width *  height,
    pos=0, dp=0;

  int rowstride= gdk_pixbuf_get_rowstride (pb) ;
  guchar  *data = gdk_pixbuf_get_pixels(pb);

  int ch= gdk_pixbuf_get_n_channels(pb);

  g_assert ( r != NULL);  g_assert ( g != NULL);  g_assert ( b != NULL);  
  g_assert ( pb != NULL);

  
  /*    g_message("\ */
/*  gdk pixbuf info:\n\ */
/*  gdk_pixbuf_get_n_channels %d \n\ */
/*  gdk_pixbuf_get_has_alpha %d \n\ */
/*  ", */
	  /*      gdk_pixbuf_get_n_channels(pb), */
/*  	      gdk_pixbuf_get_has_alpha(pb) */
/*  	      ); */

  /* FIXME I am not absolutely sure
     that the data are RGB with lines strictly packed!!
  */
  g_assert(gdk_pixbuf_get_colorspace(pb) == 
	   GDK_COLORSPACE_RGB);
	

 
	
  g_assert( pb != NULL);

  for( j=0; j<  height ; j++)	  
    {
      dp= rowstride * j;
      for( i=0; i<  width ; i++)
	{
		
	  r[pos]= data[dp++];
	  g[pos]=data[dp++];
	  b[pos]=data[dp++];
	  pos++; 
	  if (ch==4)	 dp ++;
	}
    }
	
}   

void
rrrgggbbb_add_to_pixbuf(GdkPixbuf *pb, /* destination */
			const guint8 *r, const  guint8 *g, const guint8 *b,
			/* source */
			double factor /* dissolving factor */
			)
{ 
  int i,j,
    width =  gdk_pixbuf_get_width(pb),
    height = gdk_pixbuf_get_height(pb);
  long //size =  width *  height,
    pos=0, dp=0;
  
  guchar  *data = gdk_pixbuf_get_pixels(pb);	

  int rowstride= gdk_pixbuf_get_rowstride (pb) ;

  int ch= gdk_pixbuf_get_n_channels(pb);

  g_assert ( r != NULL);  g_assert ( g != NULL);  g_assert ( b != NULL);  
  g_assert ( pb != NULL);	

 /*   g_message("\ */
/*  gdk pixbuf info:\n\ */
/*  gdk_pixbuf_get_n_channels %d \n\ */
/*  gdk_pixbuf_get_has_alpha %d \n\ */
/*  ", */
	 /*       gdk_pixbuf_get_n_channels(pb), */
/*  	      gdk_pixbuf_get_has_alpha(pb) */
/*  	      ); */

    /* FIXME I am not absolutely sure
     that the data are RGB with lines strictly packed!!
  */
  g_assert(gdk_pixbuf_get_colorspace(pb) == 
	   GDK_COLORSPACE_RGB);
	
  for( j=0; j<  height; j++)	      
    {
      dp= rowstride * j;
      for( i=0; i< width; i++)
	{
	  data[dp++] += (double)r[pos] * factor;
	  data[dp++] += (double)g[pos] * factor;
	  data[dp++] += (double)b[pos] * factor;
	  pos++; 
	  if ( 4 == ch)	 dp ++;
	}
    }
}




/**********************************************************/
//FIXME no better ways?
//int on_warped_im_in_other_win_val=1;

void
do_warp_an_image(int lp, char * r, char *g, char * b)
{
  int   nx=sp-> im_mesh[MAX_WINS+1].nx,
    ny=sp-> im_mesh[MAX_WINS+1].ny;
  GdkPixbuf *pb = sp-> im_warped_pixbuf[lp];
 
#define UCHAR unsigned char
  //prototype
  void
    warp_image(const UCHAR *in, UCHAR *out, int img_width, int img_height,
	       const double *xs, const double *ys,
	       const double *xd, const double *yd,
	       int mesh_width, int mesh_height);

 if(pb==NULL) {
    create_pixbuf(lp,PIXWARPED);
    pb = sp-> im_warped_pixbuf[lp];
  }

#define warpthis(IN,OUT) \
	warp_image(IN,OUT, \
		   sp->resulting_width,	 sp->resulting_height, \
		   sp->im_mesh[lp].x,	   sp->im_mesh[lp].y, \
		   dstmesh->x, dstmesh->y, \
		   nx,ny); 

  gdk_pixbuf_clear(pb);

  if( nx != sp->im_mesh[lp].nx  || ny != sp->im_mesh[lp].ny)
    {
      show_warning
	(g_strdup_printf
	 (_("\
The image %d has an %ld by %ld mesh while the resulting mesh is %d by %d!\n\
I cant warp it!\n\
I suggest that you add lines so that both meshes are %d by %d"),
	  lp, sp->im_mesh[lp].nx, sp->im_mesh[lp].ny , nx, ny,
	  sp->meshes_x,
	  sp->meshes_y));

    }
  else
    {

      warpthis(sp->red[lp], r);
      warpthis(sp->green[lp], g);
      warpthis(sp->blue[lp], b);
    
      g_message("writing pixels for %d\n",lp);
          
      rrrgggbbb_add_to_pixbuf(pb,     r,g,b,     1.0 );
    }

  {
    int val=1;

    val =  settings_get_value("warped image in other win");      
    if( val)
      {
	if( sp->im_warped_widget[lp]==NULL) {
	  sp->im_warped_widget[lp]=create_window_warped(); 
	  gtk_widget_set_data_top(sp->im_warped_widget[lp],"imagenum",
				  GUINT_TO_POINTER(lp));
	}
	{
	  /* resizes the viewport so that the scrolling bars will work ok */ 
	  int w=sp->resulting_width, h=sp->resulting_height;
	  
	  GtkWidget *g =gtk_widget_get_data_top
	    (sp->im_warped_widget[lp],"drawingarea_warped");
	  g_assert(g);
	  gtk_widget_set_usize(g,  w,h);
	}

	render_pixmap(lp,2);
/* 	gdk_pixbuf_render_to_drawable   */
/* 	  (pb , //sp->im_pixbufwarped[lp], */
/* 	   sp->im_pixwarped[lp], */
/* 	   sp->im_widget[lp]->style->black_gc, //GdkGC *gc, */
/* 	   0, //int src_x, */
/* 	   0, //int src_y, */
/* 	   0, //int dest_x, */
/* 	   0, //int dest_y, */
/* 	   sp->resulting_width,	 sp->resulting_height, */
/* 	   GDK_RGB_DITHER_NORMAL,//GdkRgbDither dither, */
/* 	   0, //int x_dither, */
/* 	   0 ); //int y_dither); */

	gtk_widget_show (sp->im_warped_widget[lp]); 
	gtk_widget_draw (sp->im_warped_widget[lp] , NULL); 
      }
    else
      {	
	set_editshow(lp,   settings_get_value( "show warp after warp"));

	render_pixmap(lp,2);
/* 	gdk_pixbuf_render_to_drawable   */
/* 	  (pb , //sp->im_pixbufwarped[lp], */
/* 	   sp->im_pixwarped[lp], */
/* 	   sp->im_widget[lp]->style->black_gc, //GdkGC *gc, */
/* 	   0, //int src_x, */
/* 	   0, //int src_y, */
/* 	   0, //int dest_x, */
/* 	   0, //int dest_y, */
/* 	   sp->resulting_width,	 sp->resulting_height, */
/* 	   GDK_RGB_DITHER_NORMAL,//GdkRgbDither dither, */
/* 	   0, //int x_dither, */
/* 	   0 ); //int y_dither); */

	gtk_widget_show (sp->im_widget[lp]);  
	gtk_widget_draw (sp->im_widget[lp] , NULL);  
      }
  }
}





/**********************************************************
 * accepts new backing pixmap of the appropriate size 
 *  save it in the data of the top window 
 * and in the sp-> structure
 * resizes the viewport
 * now it is done in a more ordered way
*/

/* gboolean */
/* set_backing_pixmap        (GtkWidget       *widget, */
/* 		   GdkPixmap *newpixmap, */
/* 		   int width, int height) */
/* { */
/*   int i= */
/*     GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,"imagenum"));  */
/*   g_assert(i > 0); */
/*   g_assert(newpixmap != NULL); */
/*   //save_pixmap_addr(widget,newpixmap); */
/*   // FIXME this blocks resizing of the window !! WHY??? */
/*        //gtk_widget_set_usize(gtk_widget_get_data_top(widget, */
/*      //					   "viewport widget"), */
/* 			      //		   im->width,im->height); */
/*   //gtk_widget_set_data_top(widget,"image width", */
/*   //			  GUINT_TO_POINTER(width)); */
/*   //gtk_widget_set_data_top(widget,"image height", */
/*   //			  GUINT_TO_POINTER(height)); */ 
/*   //meshReset(&(sp->im_mesh[i]), width, height); */
/*   if ( sp->im_pixmap_subimage[i] != NULL) */
/*     gdk_pixmap_unref( sp->im_pixmap_subimage[i]); */
/*   sp->im_pixmap_subimage[i]=newpixmap; */
/*   return TRUE; */
/* } */



/********************************************************************
		loads image from pixbuf to pixmap for image window "lp"
		you should unref the pixbuf   when it exists
		
		copies its data to r,g,b,
*/



void scale_loaded_pixbuf_et_rrggbb(
		 GdkPixbuf      *impixfile,
		 int lp //image number
		 )
{
  
  //int width,height;
  //GdkPixmap    *newpixmap;

  GdkPixbuf * impixinterm,
    //**pbl = which_pixbuf(lp,PIXLOADED),
    **pbs = which_pixbuf(lp,PIXSUBIMAGE),
    * impix ;
  
  int alpha=gdk_pixbuf_get_has_alpha(impixfile);

  impixinterm=
  /* this function was written by me */
    gdk_pixbuf_subimage      (impixfile,
			      sp->subimasel[lp].subimage.x, //int src_x,
			      sp->subimasel[lp].subimage.y, // int src_y,
			      sp->subimasel[lp].subimage.width,
			      sp->subimasel[lp].subimage.height);

  if  ( impixinterm == NULL)
    {
      show_warning( _("\
error: probably your subimage was not contained in the image"));
      return ;
    }

  if(*pbs) {
    gdk_pixbuf_unref(*pbs);
    *pbs=NULL;  
  }

  if(settings_get_value("preserve aspect ratio"))
    {
      int nw=(long)sp->resulting_height * (long)sp->subimasel[lp].subimage.width
	/ sp->subimasel[lp].subimage.height  ;
      GdkPixbuf * impixbanda;	
      impix=gdk_pixbuf_new (GDK_COLORSPACE_RGB,//GdkColorspace colorspace,
			    alpha, //gboolean has_alpha,
			    8,//int bits_per_sample,
			    sp->resulting_width,sp->resulting_height); 
      g_assert(impix);
      
      impixbanda=
	gdk_pixbuf_scale_simple (impixinterm, //const GdkPixbuf *src,
				 nw,
				 sp->resulting_height, //int dest_height,
				 GDK_INTERP_HYPER //GdkInterpType interp_type
				 );
      g_assert(impixbanda);
      if(sp->resulting_width-nw>0)
	gdk_pixbuf_copy_area   (impixbanda,//const GdkPixbuf *src_pixbuf,
				0,//int src_x,
				0,//int src_y,
				nw,//int width,
				sp->resulting_height, //int height,
				impix,//GdkPixbuf *dest_pixbuf,
				(sp->resulting_width-nw)/2,//int dest_x,
				0);//int dest_y);
      else
	gdk_pixbuf_copy_area   (impixbanda,//const GdkPixbuf *src_pixbuf,
				-(sp->resulting_width-nw)/2,//int src_x,
				0,//int src_y,
				sp->resulting_width,//int width,
				sp->resulting_height, //int height,
				impix,//GdkPixbuf *dest_pixbuf,
				0,//int dest_x,
				0);//int dest_y);
      gdk_pixbuf_unref(impixbanda);
    }
  else
    impix=
      gdk_pixbuf_scale_simple (impixinterm, //const GdkPixbuf *src,
			       sp->resulting_width, //int dest_width,
			       sp->resulting_height, //int dest_height,
			       GDK_INTERP_HYPER //GdkInterpType interp_type
			       );
  
  // it is implicit
  //sp->im_pixbuf_subimage[lp]=impix;
  *pbs=impix;



  /*width= gdk_pixbuf_get_width (impix);
    height= gdk_pixbuf_get_height (impix);      
  */
  /* newpixmap=gdk_pixmap_new(  ( sp->im_widget[lp])->window, */
/* 			     width, height, -1); */
  
/*   gdk_pixbuf_render_to_drawable   */
/*     (impix, */
/*      newpixmap, */
/*      sp->im_widget[lp]->style->black_gc, //GdkGC *gc, */
/*      0, //int src_x, */
/*      0, //int src_y, */
/*      0, //int dest_x, */
/*      0, //int dest_y, */
/*      width, height, */
/*      //int width,       int height, */
/* 	 GDK_RGB_DITHER_NORMAL,//GdkRgbDither dither, */
/*      0, //int x_dither, */
/*      0 ); //int y_dither); */
/*   set_backing_pixmap( sp->im_widget[lp], */
/* 	      newpixmap, */
/* 	      width, height); */

  pixbuf_to_rrrgggbb(impix,
		     sp->red[lp],
		     sp->green[lp],
		     sp->blue[lp]  );
}










/***************************************************************

 *		drawing area bookkeeping

 ***********************************************************
*/ 




void
drawingarea_configure (int i)
{
  
  //GdkPixmap *pixmap = NULL;
  int w,h;

  //GtkWidget * widget = sp-> im_widget[i];

  GtkWidget *d=gtk_widget_get_data_top((sp->im_widget[i]),
				       "drawingarea widget");

  g_assert(sp-> im_widget[i]);

  if(d) {
    which_pixbuf_size(i,sp->which_pix[i],  &w, &h);
    render_pixmap(i, sp->which_pix[i]); 
					 
   /* resizes the viewport so that the scrolling bars will work ok */
      gtk_widget_set_usize(d,      w,h);
  }
  //else
  /* this is not an error: this function gets called before the
     windows are realized :-( */
  //g_warning("drawing area %i unavailable\n",i);
}











/************************************************************************

************************************************************************

 load/save hooks 

 see  on_ok_button1_realize ()

************************************************************************

************************************************************************/

inline  void 
showerr(char *file, char *msg)
{
  char *s = 
	g_strdup_printf( msg, file, strerror(errno));
			
  show_warning(s  );
  g_free(s);
}


gboolean load_image_from_file(int lp,
			      char *file)
{
  GdkPixbuf      *impixfile;

  g_assert(lp>0);
  
  impixfile= gdk_pixbuf_new_from_file(file);

  if (impixfile ==NULL)
    {
      showerr(file,_("\
the attempt to load the image file %s as produced error: %s"));

      return FALSE;
    }
  else
    {
      char s[600];

      sprintf(s,"%s %d: %s",_("in img"),lp,     file);
            
      sp->subimasel[lp].subimage.width=
	sp->im_width[lp]= gdk_pixbuf_get_width(impixfile);

      sp->subimasel[lp].subimage.height=
	sp->im_height[lp]= gdk_pixbuf_get_height(impixfile);
      
      sp->subimasel[lp].subimage.x=0;
      sp->subimasel[lp].subimage.y=0;			      

      scale_loaded_pixbuf_et_rrggbb(impixfile, lp);
      render_pixmap(lp, PIXSUBIMAGE);

      sp->im_loaded_pixbuf[lp]=impixfile;
      //gdk_pixbuf_unref(impixfile);

      if(sp->im_filename[lp]!=NULL)
	g_free(sp->im_filename[lp]);
      
      sp->im_filename[lp]=g_strdup(file);

      gtk_window_set_title ( GTK_WINDOW(sp->im_widget[lp]),   s);

      set_editshow( lp, EDITSHOW_EDIT); 

      drawingarea_configure(lp);

      gtk_widget_draw( sp-> im_widget[lp], NULL);  

      return TRUE;
    }  
}

/* reloads image , if necessary,  and rescales it */
void
reload_and_scale_image(int i)
{
  GdkPixbuf **impixfile=which_pixbuf(i,PIXLOADED);
  g_assert(i > 0);

  if ( sp-> im_filename[i] != NULL
       && strlen( sp-> im_filename[i]) > 0)
    {
      if(*impixfile == NULL)
	*impixfile= gdk_pixbuf_new_from_file(sp-> im_filename[i]);

      if (impixfile ==NULL)
	{
	  showerr(sp-> im_filename[i], _("\
the attempt to load the image file %s as produced error: %s"));	
	}
      else {
	scale_loaded_pixbuf_et_rrggbb(*impixfile, i);
	render_pixmap(i, PIXSUBIMAGE);
      }
    }  
}





/* it looks bad: it would be nicer if done with a static inline fun...
 but it must return the caller, not itself !*/

#define myfputc(F,C) \
{ \
 if( EOF == fputc(C,F)) { \
      showerr(file,_("\
the attempt to save the image file %s as produced error: %s")); \
      return FALSE; \
    } \
}

gboolean save_image_to_file(int lp,
			    char *file)
{

  FILE *f;
  int  w= sp-> resulting_width;
  int h= sp-> resulting_height;
  int size;
  GdkPixbuf * pb=*(which_pixbuf_is_visible(lp));

  if( pb ==NULL)
    {
      show_warning(_("\
internal error: the image doesnt exist!"));
      return FALSE;
    }

 

  f = fopen(file, "w");
  if( f ==NULL)
    {
      showerr(file,_("\
the attempt to save the image file %s as produced error: %s"));
      return FALSE;
    }
  

  /* save as ppm format */
  
  fprintf(f,"\
P6\n\
# CREATOR: " PACKAGE " " VERSION "\n\
%d %d\n\
255\n",
	  w,h);

  size= w*h;
 
  {
    guchar  *data = gdk_pixbuf_get_pixels(pb);	
    
    if ( fwrite(data, 3,size, f) != size)
      {
	showerr(file,_("\
the attempt to save the image file %s as produced error: %s"));
      }
  }

  if( 0 != fclose (f))
     showerr(file,_("\
the attempt to close the saved image file %s as produced error: %s"));

  return TRUE;  
}


gboolean save_mesh_to_file(int lp, char * file)
{
  if (meshWrite( &(sp-> im_mesh[lp]), file) ==0)
    {
      /* memory leak */
      sp->im_mesh_filename[lp] = g_strdup(file);
      return TRUE;
    }
  else
    {
      showerr(file, "\
the attempt to save the mesh in file %s as produced error: %s");
      return FALSE;
    }
}














/****************************************************************************
 promote meshes to have same lines and columns 
***************************************************************************/



/* adds lines and columns to have this mesh of the given size */
void
promote_mesh(MeshT * mesh,int nx, int ny)
{
  while( nx > mesh->nx) {
    int i=0;
    while( i < mesh->nx-1 && mesh->nx < nx)
      {
	meshLineAdd(mesh, i, 0.5, 1);
	i+=2;
      }
  }
  while( ny > mesh->ny) {
    int i=0;
    while( i < mesh->ny-1 && mesh->ny < ny)
      {
	meshLineAdd(mesh, i, 0.5, 2);
	i+=2;
      }
  }
}

void
promote_meshes()
{
  int lp=MAX_WINS+1;
  for(; lp>=0; lp--) 
    if( sp->im_widget[lp] != NULL) {
      int c=sp->im_mesh[lp].changed;
      promote_mesh(&sp->im_mesh[lp], sp->meshes_x,sp->meshes_y);
      if ( c != sp->im_mesh[lp].changed)
	gtk_widget_draw(sp->im_widget[lp],NULL);
    }
}
/***************************************************************
 synch mesh labels
********/

/* we want the negative labels to be the highest, as if casting to unsigned */
#define MESHLABELMAP(A)   (((A)<0)? 20000-(A) : (A))
#define MESHLABELDEMAP(A) (((A)>20000)? 20000-(A) : (A))
#define MAXLABEL(A,B) MESHLABELDEMAP( MAX( MESHLABELMAP(A),MESHLABELDEMAP(B)))

/***************************************************************
 load mesh from file
*/

gboolean load_mesh_from_file(int lp, char * file)
{
  if (meshRead( &(sp-> im_mesh[lp]), file) ==0)
    {
      /* memory leak :-) */
      sp->im_mesh_filename[lp] = g_strdup(file);

      
      meshScale( &(sp->im_mesh[lp]),
		 sp->resulting_width, sp->resulting_height);
       
      set_editshow( lp, EDITSHOW_EDIT);
      gtk_widget_draw( sp-> im_widget[lp], NULL);  

      sp->meshes_x= MAX(sp->meshes_x, sp->im_mesh[lp].nx);
      sp->meshes_y= MAX(sp->meshes_y, sp->im_mesh[lp].ny);

      if (settings_get_value("mesh auto sync")) {
	int xi,yi,t=0;
	MeshT *this, *res;
	promote_meshes();
	this=&(sp-> im_mesh[lp]);
	res=&(sp-> im_mesh[MAX_WINS+1]);

	for(yi=0; yi < this->ny; yi++) {
	  for(xi=0; xi < this->nx; xi++) {
	    t+= meshGetLabel(this,xi,yi);
	    /* this does a sort of fuzzy union */
	    meshSetLabel(res, xi,yi,
			 MAXLABEL(meshGetLabel(this,xi,yi),
				  meshGetLabel(res ,xi,yi)));
	  }}

	if(t==0) {
	  /* this is an old style mesh, with no labels:
	     then we select all points so that they cant be smoothed
	  */
	  g_message(" this mesh %s had no labels: autoselecting all point",
		    file);
	  for(yi=0; yi < this->ny; yi++) {
	    for(xi=0; xi < this->nx; xi++) {
	      meshSetLabel(this , xi,yi, -1);
	    }}}
      }
      return TRUE;
    }
  else
    {
      showerr(file, "\
the attempt to load the mesh from file %s as produced error: %s");
      return FALSE;
    }
}











/************************************


setup_handlebox_factors()

if there is only one image , then we may only warp it
so the handlebox is hidden

otherwise they are shown, and the user may set the factors and warp the image

***********************************/
void
setup_handlebox_factors()
{
  int lp;
  if( sp->max_wins==1)
    {      
      for(lp=1 ; lp <= MAX_WINS;  lp ++)
	if(sp->im_widget[lp] != NULL)
	  {
	    GtkWidget* hb= lookup_widget  ( sp->im_widget[lp]  ,
					    "handlebox_factors");
	    g_assert(hb);
	    gtk_widget_hide(hb);
	  }
      show_warning( _("\
You have only one input images: all you can do is to warp it;\n\
that is, if you hit the warp button, the 'input image 1' will be warped\n\
from to the 'input mesh' to the 'resulting mesh'. If you want to \n\
morph images, select `add image' in the file menu."));
    }
  if( sp->max_wins==2)
    { 
      for(lp=1 ; lp <= MAX_WINS;  lp ++)
	if(sp->im_widget[lp] != NULL)
	  {
	    GtkWidget* hb= lookup_widget  ( sp->im_widget[lp]  ,
					    "handlebox_factors");
	    g_assert(hb);
	    gtk_widget_show(hb);
	  } 
      show_warning( _("\
You have two input images: you may morph them to a resulting image."));
    }
  
}



















































/****************************************************************************

 *             create/ destroy image windows

 ***************************************************************************/


void
destroy_image_win_data(int lp)
{ 
  g_free(sp->red[lp]);   g_free(sp->blue[lp]  ); g_free( sp->green[lp] );
  
  { int j ; for (j=2;j>=0;j--) {
    destroy_pixbuf(lp,j);    destroy_pixmap(lp,j);
  }}

  if(sp->im_warped_widget[lp])
    {
      gtk_widget_destroy(sp->im_warped_widget[lp]);
      sp->im_warped_widget[lp]=NULL;
    }
}

/**********
	   pixbufs and rr gg bb buffers are alloced here,
	   whilst the im_pixmap_subimage and im_pixwarped are set elsewhere 
*/

void
alloc_image_win_data(int lp)
{ 

 /* there is no image associated to this window */
#ifdef USE_IMLIB
  sp->im_image[lp]=NULL;
  sp->im_imlib[lp]=NULL;
#endif

  {       
    long size = sp->resulting_width *  sp->resulting_height ;
    sp->red[lp] = g_malloc( size );
    sp->blue[lp]  = g_malloc( size );
    sp->green[lp] = g_malloc( size ) ;
  }


  //meshInit( &(  sp->im_mesh[lp] ));
  //meshAlloc( &(sp->im_mesh[lp]), sp->meshes_x, sp->meshes_y);
  //meshReset( &(sp->im_mesh[lp]), sp->resulting_width, sp->resulting_height);


  /* the rgb warped mixed data
     is never copied to this mred mblue mgreen... it is  added
     in the pixbuf*/
  /*        sp->mred[i] = g_malloc( size ); */
  /*        sp->mblue[i]  = g_malloc( size ); */
  /*        sp->mgreen[i] = g_malloc( size ) ; */
  /*      } */
}
void
set_image_win_initially(int lp)
{
  
  /* to start with... until the user loads an image */
  sp->im_width[lp]=sp->resulting_width;
  sp->im_height[lp]=sp->resulting_height;

  gtk_subimasel_reset(&(sp->subimasel[lp]));

  /* NO : this would mean that the image has been loaded
     sp->im_filename[lp] = g_strdup_printf("%s%d.png",_("image"),lp);
  */
}



void
init_image_win_data_and_set_all(int lp, /* the slot where the data are put
					   in the arrays in sp-> */
				GtkWidget * topw, /* the top window */
				char * name)
{
  /* FIXME bad programming */
  //HACK it was =lp; I want to find where I use it
  fileselection1_for_image_num_g=-1 ;

  set_image_win_initially(lp);
 
  alloc_image_win_data(lp);
    
  gtk_window_set_title (GTK_WINDOW(topw), name);


  {
    /* this trick comes from the FAQ of glade*/
    GtkWidget *
      option_menu = lookup_widget (topw, "optionmenu_editview");
    gtk_signal_connect(GTK_OBJECT (GTK_OPTION_MENU (option_menu)->menu),
		       "deactivate",
		       GTK_SIGNAL_FUNC (on_optionmenu_editview__selected ),
		       GUINT_TO_POINTER(lp));
  }
	
  /* NOTE THE ORDER: first the widget is created
   then we set the "imagenum"
   then we show it, so the pixmaps are created and stored in 
   the  *sp  structure 
  */
  gtk_widget_set_data_top(topw,"imagenum",
			  GUINT_TO_POINTER(lp));
  
  //FIXME this is risky ... and messy
  gtk_widget_set_data_top(topw,"gtk_subimagesel", &(sp->subimasel[lp]));
	
  //gtk_widget_set_data_top(sp->im_widget[lp],"image filename",
  //			  sp->im_filename[lp]);

  
  //this is set in "set_backing_pixmap()"
  //sp->im_pixmap_subimage[lp] =  get_pixmap_addr (sp->im_widget[lp]);

  meshInit( &(  sp->im_mesh[lp] ));
  meshAlloc( &(sp->im_mesh[lp]), sp->meshes_x, sp->meshes_y);
  meshReset( &(sp->im_mesh[lp]), sp->resulting_width, sp->resulting_height);

  sp->mf.im_warp_factor[lp]=0.1;
  sp->mf.im_dissolve_factor[lp]=0.1;
}


/** 
    this was used when the resulting image was a different
    window from the main window
**/


void
create_and_show_image_win(int lp)
{ 
  
  char s[100];

  if (lp== MAX_WINS+1)
    {
      sp->im_widget[lp]=create_resultingimage();
      sprintf(s,"%s",_("resulting image"));
    }
  else
    {
      sp->im_widget[lp]=create_image_win_1();
      sprintf(s,"%s %d",_("input image"),lp);     
    }
  
  init_image_win_data_and_set_all(lp, /* the slot where the data are put
					 in the arrays in sp-> */
				  sp->im_widget[lp], /* the top window */
				  s);

  editview_callback(lp);
  
  gtk_widget_show (sp->im_widget[lp]);
  redraw_spins();
}















