/*
 *	$COPYRIGHT$
 *
 *	$Id: xmpi_tr_file.cc,v 1.3 2000/10/29 19:32:02 bbarrett Exp $
 *
 *	Function:	- select a trace file
 */

#include <stdio.h>
#include <string.h>

#include <Xm/Xm.h>
#include <Xm/FileSB.h>
#include "xmpi.h"
#include "xmpi_tr_file.h"
#include "xmpi_error.h"
#include "xmpi_db_parse.h"

/*
 * local functions
 */
static void parse(Widget, caddr_t, 
		  XmFileSelectionBoxCallbackStruct*);

/*
 * external variables
 */
extern char tracefile[];	       /* name of trace file */

/*
 * local variables
 */
static Widget fsdialog = 0;	       /* file selection dialog */

/*
 *	xmpi_tr_file
 *
 *	Function:	- selects trace file via a dialog and parses it
 *	Accepts:	- parent widget
 */
void
xmpi_tr_file(Widget parent)
{
  Arg args[2];

  XmString oklabel;

  XmString title;

  Widget help_btn;

  if (fsdialog == 0) {
    title = XmStringCreateSimple((char*) "XMPI Trace Selection");
    oklabel = XmStringCreateSimple((char*) "View");

    XtSetArg(args[0], XmNdialogTitle, title);
    XtSetArg(args[1], XmNokLabelString, oklabel);
/*
 * The trace file extension is the "dirMask" resource and may be set
 * in the application defaults file.  It defaults to ".lamtr".
 */
    fsdialog = XmCreateFileSelectionDialog(parent,
					   (char*) "trace_selector", args, 2);

    XtAddCallback(fsdialog, XmNokCallback, 
		  (XtCallbackProc) parse, NULL);
    XtAddCallback(fsdialog, XmNcancelCallback,
		  (XtCallbackProc) XtUnmanageChild, NULL);

    help_btn = XmFileSelectionBoxGetChild(fsdialog,
					  XmDIALOG_HELP_BUTTON);
    XtUnmanageChild(help_btn);

    XmStringFree(title);
    XmStringFree(oklabel);
  } else {
    XmFileSelectionDoSearch(fsdialog, 0);
  }

  XtManageChild(fsdialog);
}

/*
 *	parse
 *
 *	Function:	- parse selected trace file (OK callback)
 *	Accepts:	- callback data
 */
static void
parse(Widget w, caddr_t, XmFileSelectionBoxCallbackStruct *cbs)
{
  char *name;			       /* file name */

  FILE *trfs;			       /* trace file stream */

  if (XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &name))
    strncpy(tracefile, name, XMPI_PATHMAX);

  XtFree(name);

  trfs = fopen(tracefile, "r");

  if (trfs == 0) {
    xmpi_error(0, tracefile);
  } else {
    XtUnmanageChild(w);
    xmpi_parse_tracefile(trfs);
  }
}
