/*
 * Copyright (c) 2001-2008 XORP, Inc.
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'tgt-gen'.
 */

#ident "$XORP: xorp/xrl/targets/rib_base.cc,v 1.43 2008/07/23 05:12:07 pavlin Exp $"


#include "rib_base.hh"


XrlRibTargetBase::XrlRibTargetBase(XrlCmdMap* cmds)
    : _cmds(cmds)
{
    if (_cmds)
	add_handlers();
}

XrlRibTargetBase::~XrlRibTargetBase()
{
    if (_cmds)
	remove_handlers();
}

bool
XrlRibTargetBase::set_command_map(XrlCmdMap* cmds)
{
    if (_cmds == 0 && cmds) {
        _cmds = cmds;
        add_handlers();
        return true;
    }
    if (_cmds && cmds == 0) {
	remove_handlers();
        _cmds = cmds;
        return true;
    }
    return false;
}

const XrlCmdError
XrlRibTargetBase::handle_common_0_1_get_target_name(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_target_name");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string name;
    try {
	XrlCmdError e = common_0_1_get_target_name(
	    name);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_target_name", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("name", name);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_common_0_1_get_version(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_version");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string version;
    try {
	XrlCmdError e = common_0_1_get_version(
	    version);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_version", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("version", version);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_common_0_1_get_status(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_status");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t status;
    string reason;
    try {
	XrlCmdError e = common_0_1_get_status(
	    status,
	    reason);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_status", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("status", status);
	pxa_outputs->add("reason", reason);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_common_0_1_shutdown(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/shutdown");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = common_0_1_shutdown();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/shutdown", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_finder_event_observer_0_1_xrl_target_birth(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "finder_event_observer/0.1/xrl_target_birth");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = finder_event_observer_0_1_xrl_target_birth(
	    xa_inputs.get_string("target_class"),
	    xa_inputs.get_string("target_instance"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "finder_event_observer/0.1/xrl_target_birth", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_finder_event_observer_0_1_xrl_target_death(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "finder_event_observer/0.1/xrl_target_death");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = finder_event_observer_0_1_xrl_target_death(
	    xa_inputs.get_string("target_class"),
	    xa_inputs.get_string("target_instance"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "finder_event_observer/0.1/xrl_target_death", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_policy_backend_0_1_configure(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "policy_backend/0.1/configure");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = policy_backend_0_1_configure(
	    xa_inputs.get_uint32("filter"),
	    xa_inputs.get_string("conf"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "policy_backend/0.1/configure", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_policy_backend_0_1_reset(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "policy_backend/0.1/reset");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = policy_backend_0_1_reset(
	    xa_inputs.get_uint32("filter"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "policy_backend/0.1/reset", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_policy_backend_0_1_push_routes(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "policy_backend/0.1/push_routes");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = policy_backend_0_1_push_routes();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "policy_backend/0.1/push_routes", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_enable_rib(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/enable_rib");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_enable_rib();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/enable_rib", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_disable_rib(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/disable_rib");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_disable_rib();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/disable_rib", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_start_rib(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/start_rib");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_start_rib();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/start_rib", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_stop_rib(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/stop_rib");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_stop_rib();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/stop_rib", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_make_errors_fatal(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/make_errors_fatal");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_make_errors_fatal();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/make_errors_fatal", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_get_registered_protocols(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/get_registered_protocols");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList ipv4_unicast_protocols;
    XrlAtomList ipv6_unicast_protocols;
    XrlAtomList ipv4_multicast_protocols;
    XrlAtomList ipv6_multicast_protocols;
    try {
	XrlCmdError e = rib_0_1_get_registered_protocols(
	    xa_inputs.get_bool("ipv4"),
	    xa_inputs.get_bool("ipv6"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"),
	    ipv4_unicast_protocols,
	    ipv6_unicast_protocols,
	    ipv4_multicast_protocols,
	    ipv6_multicast_protocols);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/get_registered_protocols", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("ipv4_unicast_protocols", ipv4_unicast_protocols);
	pxa_outputs->add("ipv6_unicast_protocols", ipv6_unicast_protocols);
	pxa_outputs->add("ipv4_multicast_protocols", ipv4_multicast_protocols);
	pxa_outputs->add("ipv6_multicast_protocols", ipv6_multicast_protocols);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_add_igp_table4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/add_igp_table4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_add_igp_table4(
	    xa_inputs.get_string("protocol"),
	    xa_inputs.get_string("target_class"),
	    xa_inputs.get_string("target_instance"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/add_igp_table4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_add_igp_table6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/add_igp_table6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_add_igp_table6(
	    xa_inputs.get_string("protocol"),
	    xa_inputs.get_string("target_class"),
	    xa_inputs.get_string("target_instance"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/add_igp_table6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_delete_igp_table4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/delete_igp_table4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_delete_igp_table4(
	    xa_inputs.get_string("protocol"),
	    xa_inputs.get_string("target_class"),
	    xa_inputs.get_string("target_instance"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/delete_igp_table4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_delete_igp_table6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/delete_igp_table6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_delete_igp_table6(
	    xa_inputs.get_string("protocol"),
	    xa_inputs.get_string("target_class"),
	    xa_inputs.get_string("target_instance"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/delete_igp_table6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_add_egp_table4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/add_egp_table4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_add_egp_table4(
	    xa_inputs.get_string("protocol"),
	    xa_inputs.get_string("target_class"),
	    xa_inputs.get_string("target_instance"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/add_egp_table4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_add_egp_table6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/add_egp_table6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_add_egp_table6(
	    xa_inputs.get_string("protocol"),
	    xa_inputs.get_string("target_class"),
	    xa_inputs.get_string("target_instance"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/add_egp_table6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_delete_egp_table4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/delete_egp_table4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_delete_egp_table4(
	    xa_inputs.get_string("protocol"),
	    xa_inputs.get_string("target_class"),
	    xa_inputs.get_string("target_instance"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/delete_egp_table4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_delete_egp_table6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/delete_egp_table6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_delete_egp_table6(
	    xa_inputs.get_string("protocol"),
	    xa_inputs.get_string("target_class"),
	    xa_inputs.get_string("target_instance"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/delete_egp_table6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_add_route4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 7) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(7), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/add_route4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_add_route4(
	    xa_inputs.get_string("protocol"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"),
	    xa_inputs.get_ipv4net("network"),
	    xa_inputs.get_ipv4("nexthop"),
	    xa_inputs.get_uint32("metric"),
	    xa_inputs.get_list("policytags"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/add_route4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_add_route6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 7) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(7), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/add_route6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_add_route6(
	    xa_inputs.get_string("protocol"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"),
	    xa_inputs.get_ipv6net("network"),
	    xa_inputs.get_ipv6("nexthop"),
	    xa_inputs.get_uint32("metric"),
	    xa_inputs.get_list("policytags"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/add_route6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_replace_route4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 7) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(7), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/replace_route4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_replace_route4(
	    xa_inputs.get_string("protocol"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"),
	    xa_inputs.get_ipv4net("network"),
	    xa_inputs.get_ipv4("nexthop"),
	    xa_inputs.get_uint32("metric"),
	    xa_inputs.get_list("policytags"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/replace_route4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_replace_route6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 7) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(7), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/replace_route6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_replace_route6(
	    xa_inputs.get_string("protocol"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"),
	    xa_inputs.get_ipv6net("network"),
	    xa_inputs.get_ipv6("nexthop"),
	    xa_inputs.get_uint32("metric"),
	    xa_inputs.get_list("policytags"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/replace_route6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_delete_route4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/delete_route4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_delete_route4(
	    xa_inputs.get_string("protocol"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"),
	    xa_inputs.get_ipv4net("network"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/delete_route4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_delete_route6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/delete_route6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_delete_route6(
	    xa_inputs.get_string("protocol"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"),
	    xa_inputs.get_ipv6net("network"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/delete_route6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_add_interface_route4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 9) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(9), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/add_interface_route4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_add_interface_route4(
	    xa_inputs.get_string("protocol"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"),
	    xa_inputs.get_ipv4net("network"),
	    xa_inputs.get_ipv4("nexthop"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_uint32("metric"),
	    xa_inputs.get_list("policytags"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/add_interface_route4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_add_interface_route6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 9) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(9), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/add_interface_route6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_add_interface_route6(
	    xa_inputs.get_string("protocol"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"),
	    xa_inputs.get_ipv6net("network"),
	    xa_inputs.get_ipv6("nexthop"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_uint32("metric"),
	    xa_inputs.get_list("policytags"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/add_interface_route6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_replace_interface_route4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 9) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(9), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/replace_interface_route4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_replace_interface_route4(
	    xa_inputs.get_string("protocol"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"),
	    xa_inputs.get_ipv4net("network"),
	    xa_inputs.get_ipv4("nexthop"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_uint32("metric"),
	    xa_inputs.get_list("policytags"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/replace_interface_route4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_replace_interface_route6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 9) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(9), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/replace_interface_route6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_replace_interface_route6(
	    xa_inputs.get_string("protocol"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"),
	    xa_inputs.get_ipv6net("network"),
	    xa_inputs.get_ipv6("nexthop"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_uint32("metric"),
	    xa_inputs.get_list("policytags"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/replace_interface_route6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_lookup_route_by_dest4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/lookup_route_by_dest4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv4 nexthop;
    try {
	XrlCmdError e = rib_0_1_lookup_route_by_dest4(
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"),
	    nexthop);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/lookup_route_by_dest4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("nexthop", nexthop);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_lookup_route_by_dest6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/lookup_route_by_dest6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv6 nexthop;
    try {
	XrlCmdError e = rib_0_1_lookup_route_by_dest6(
	    xa_inputs.get_ipv6("addr"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"),
	    nexthop);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/lookup_route_by_dest6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("nexthop", nexthop);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_new_vif(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/new_vif");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_new_vif(
	    xa_inputs.get_string("name"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/new_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_add_vif_addr4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/add_vif_addr4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_add_vif_addr4(
	    xa_inputs.get_string("name"),
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_ipv4net("subnet"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/add_vif_addr4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_add_vif_addr6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/add_vif_addr6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_add_vif_addr6(
	    xa_inputs.get_string("name"),
	    xa_inputs.get_ipv6("addr"),
	    xa_inputs.get_ipv6net("subnet"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/add_vif_addr6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_redist_enable4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/redist_enable4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_redist_enable4(
	    xa_inputs.get_string("to_xrl_target"),
	    xa_inputs.get_string("from_protocol"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"),
	    xa_inputs.get_ipv4net("network_prefix"),
	    xa_inputs.get_string("cookie"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/redist_enable4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_redist_enable6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/redist_enable6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_redist_enable6(
	    xa_inputs.get_string("to_xrl_target"),
	    xa_inputs.get_string("from_protocol"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"),
	    xa_inputs.get_ipv6net("network_prefix"),
	    xa_inputs.get_string("cookie"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/redist_enable6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_redist_disable4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/redist_disable4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_redist_disable4(
	    xa_inputs.get_string("to_xrl_target"),
	    xa_inputs.get_string("from_protocol"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"),
	    xa_inputs.get_string("cookie"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/redist_disable4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_redist_disable6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/redist_disable6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_redist_disable6(
	    xa_inputs.get_string("to_xrl_target"),
	    xa_inputs.get_string("from_protocol"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"),
	    xa_inputs.get_string("cookie"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/redist_disable6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_redist_transaction_enable4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/redist_transaction_enable4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_redist_transaction_enable4(
	    xa_inputs.get_string("to_xrl_target"),
	    xa_inputs.get_string("from_protocol"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"),
	    xa_inputs.get_ipv4net("network_prefix"),
	    xa_inputs.get_string("cookie"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/redist_transaction_enable4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_redist_transaction_enable6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/redist_transaction_enable6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_redist_transaction_enable6(
	    xa_inputs.get_string("to_xrl_target"),
	    xa_inputs.get_string("from_protocol"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"),
	    xa_inputs.get_ipv6net("network_prefix"),
	    xa_inputs.get_string("cookie"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/redist_transaction_enable6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_redist_transaction_disable4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/redist_transaction_disable4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_redist_transaction_disable4(
	    xa_inputs.get_string("to_xrl_target"),
	    xa_inputs.get_string("from_protocol"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"),
	    xa_inputs.get_string("cookie"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/redist_transaction_disable4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_redist_transaction_disable6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/redist_transaction_disable6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_redist_transaction_disable6(
	    xa_inputs.get_string("to_xrl_target"),
	    xa_inputs.get_string("from_protocol"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"),
	    xa_inputs.get_string("cookie"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/redist_transaction_disable6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_register_interest4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/register_interest4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool resolves;
    IPv4 base_addr;
    uint32_t prefix_len;
    uint32_t real_prefix_len;
    IPv4 nexthop;
    uint32_t metric;
    try {
	XrlCmdError e = rib_0_1_register_interest4(
	    xa_inputs.get_string("target"),
	    xa_inputs.get_ipv4("addr"),
	    resolves,
	    base_addr,
	    prefix_len,
	    real_prefix_len,
	    nexthop,
	    metric);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/register_interest4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("resolves", resolves);
	pxa_outputs->add("base_addr", base_addr);
	pxa_outputs->add("prefix_len", prefix_len);
	pxa_outputs->add("real_prefix_len", real_prefix_len);
	pxa_outputs->add("nexthop", nexthop);
	pxa_outputs->add("metric", metric);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_deregister_interest4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/deregister_interest4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_deregister_interest4(
	    xa_inputs.get_string("target"),
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_uint32("prefix_len"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/deregister_interest4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_register_interest6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/register_interest6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool resolves;
    IPv6 base_addr;
    uint32_t prefix_len;
    uint32_t real_prefix_len;
    IPv6 nexthop;
    uint32_t metric;
    try {
	XrlCmdError e = rib_0_1_register_interest6(
	    xa_inputs.get_string("target"),
	    xa_inputs.get_ipv6("addr"),
	    resolves,
	    base_addr,
	    prefix_len,
	    real_prefix_len,
	    nexthop,
	    metric);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/register_interest6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("resolves", resolves);
	pxa_outputs->add("base_addr", base_addr);
	pxa_outputs->add("prefix_len", prefix_len);
	pxa_outputs->add("real_prefix_len", real_prefix_len);
	pxa_outputs->add("nexthop", nexthop);
	pxa_outputs->add("metric", metric);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_deregister_interest6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/deregister_interest6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_deregister_interest6(
	    xa_inputs.get_string("target"),
	    xa_inputs.get_ipv6("addr"),
	    xa_inputs.get_uint32("prefix_len"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/deregister_interest6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_insert_policy_redist_tags(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/insert_policy_redist_tags");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_insert_policy_redist_tags(
	    xa_inputs.get_string("protocol"),
	    xa_inputs.get_list("policytags"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/insert_policy_redist_tags", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_reset_policy_redist_tags(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/reset_policy_redist_tags");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_reset_policy_redist_tags();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/reset_policy_redist_tags", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_get_protocol_admin_distances(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/get_protocol_admin_distances");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList protocols;
    XrlAtomList admin_distances;
    try {
	XrlCmdError e = rib_0_1_get_protocol_admin_distances(
	    xa_inputs.get_bool("ipv4"),
	    xa_inputs.get_bool("unicast"),
	    protocols,
	    admin_distances);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/get_protocol_admin_distances", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("protocols", protocols);
	pxa_outputs->add("admin_distances", admin_distances);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_get_protocol_admin_distance(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/get_protocol_admin_distance");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t admin_distance;
    try {
	XrlCmdError e = rib_0_1_get_protocol_admin_distance(
	    xa_inputs.get_string("protocol"),
	    xa_inputs.get_bool("ipv4"),
	    xa_inputs.get_bool("unicast"),
	    admin_distance);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/get_protocol_admin_distance", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("admin_distance", admin_distance);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_rib_0_1_set_protocol_admin_distance(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "rib/0.1/set_protocol_admin_distance");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_0_1_set_protocol_admin_distance(
	    xa_inputs.get_string("protocol"),
	    xa_inputs.get_bool("ipv4"),
	    xa_inputs.get_bool("ipv6"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"),
	    xa_inputs.get_uint32("admin_distance"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib/0.1/set_protocol_admin_distance", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_profile_0_1_enable(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "profile/0.1/enable");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = profile_0_1_enable(
	    xa_inputs.get_string("pname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "profile/0.1/enable", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_profile_0_1_disable(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "profile/0.1/disable");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = profile_0_1_disable(
	    xa_inputs.get_string("pname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "profile/0.1/disable", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_profile_0_1_get_entries(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "profile/0.1/get_entries");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = profile_0_1_get_entries(
	    xa_inputs.get_string("pname"),
	    xa_inputs.get_string("instance_name"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "profile/0.1/get_entries", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_profile_0_1_clear(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "profile/0.1/clear");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = profile_0_1_clear(
	    xa_inputs.get_string("pname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "profile/0.1/clear", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRibTargetBase::handle_profile_0_1_list(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "profile/0.1/list");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string info;
    try {
	XrlCmdError e = profile_0_1_list(
	    info);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "profile/0.1/list", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("info", info);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

void
XrlRibTargetBase::add_handlers()
{
	if (_cmds->add_handler("common/0.1/get_target_name",
	    callback(this, &XrlRibTargetBase::handle_common_0_1_get_target_name)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "common/0.1/get_target_name");
	}
	if (_cmds->add_handler("common/0.1/get_version",
	    callback(this, &XrlRibTargetBase::handle_common_0_1_get_version)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "common/0.1/get_version");
	}
	if (_cmds->add_handler("common/0.1/get_status",
	    callback(this, &XrlRibTargetBase::handle_common_0_1_get_status)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "common/0.1/get_status");
	}
	if (_cmds->add_handler("common/0.1/shutdown",
	    callback(this, &XrlRibTargetBase::handle_common_0_1_shutdown)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "common/0.1/shutdown");
	}
	if (_cmds->add_handler("finder_event_observer/0.1/xrl_target_birth",
	    callback(this, &XrlRibTargetBase::handle_finder_event_observer_0_1_xrl_target_birth)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "finder_event_observer/0.1/xrl_target_birth");
	}
	if (_cmds->add_handler("finder_event_observer/0.1/xrl_target_death",
	    callback(this, &XrlRibTargetBase::handle_finder_event_observer_0_1_xrl_target_death)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "finder_event_observer/0.1/xrl_target_death");
	}
	if (_cmds->add_handler("policy_backend/0.1/configure",
	    callback(this, &XrlRibTargetBase::handle_policy_backend_0_1_configure)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "policy_backend/0.1/configure");
	}
	if (_cmds->add_handler("policy_backend/0.1/reset",
	    callback(this, &XrlRibTargetBase::handle_policy_backend_0_1_reset)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "policy_backend/0.1/reset");
	}
	if (_cmds->add_handler("policy_backend/0.1/push_routes",
	    callback(this, &XrlRibTargetBase::handle_policy_backend_0_1_push_routes)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "policy_backend/0.1/push_routes");
	}
	if (_cmds->add_handler("rib/0.1/enable_rib",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_enable_rib)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/enable_rib");
	}
	if (_cmds->add_handler("rib/0.1/disable_rib",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_disable_rib)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/disable_rib");
	}
	if (_cmds->add_handler("rib/0.1/start_rib",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_start_rib)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/start_rib");
	}
	if (_cmds->add_handler("rib/0.1/stop_rib",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_stop_rib)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/stop_rib");
	}
	if (_cmds->add_handler("rib/0.1/make_errors_fatal",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_make_errors_fatal)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/make_errors_fatal");
	}
	if (_cmds->add_handler("rib/0.1/get_registered_protocols",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_get_registered_protocols)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/get_registered_protocols");
	}
	if (_cmds->add_handler("rib/0.1/add_igp_table4",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_add_igp_table4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/add_igp_table4");
	}
	if (_cmds->add_handler("rib/0.1/add_igp_table6",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_add_igp_table6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/add_igp_table6");
	}
	if (_cmds->add_handler("rib/0.1/delete_igp_table4",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_delete_igp_table4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/delete_igp_table4");
	}
	if (_cmds->add_handler("rib/0.1/delete_igp_table6",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_delete_igp_table6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/delete_igp_table6");
	}
	if (_cmds->add_handler("rib/0.1/add_egp_table4",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_add_egp_table4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/add_egp_table4");
	}
	if (_cmds->add_handler("rib/0.1/add_egp_table6",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_add_egp_table6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/add_egp_table6");
	}
	if (_cmds->add_handler("rib/0.1/delete_egp_table4",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_delete_egp_table4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/delete_egp_table4");
	}
	if (_cmds->add_handler("rib/0.1/delete_egp_table6",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_delete_egp_table6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/delete_egp_table6");
	}
	if (_cmds->add_handler("rib/0.1/add_route4",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_add_route4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/add_route4");
	}
	if (_cmds->add_handler("rib/0.1/add_route6",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_add_route6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/add_route6");
	}
	if (_cmds->add_handler("rib/0.1/replace_route4",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_replace_route4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/replace_route4");
	}
	if (_cmds->add_handler("rib/0.1/replace_route6",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_replace_route6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/replace_route6");
	}
	if (_cmds->add_handler("rib/0.1/delete_route4",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_delete_route4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/delete_route4");
	}
	if (_cmds->add_handler("rib/0.1/delete_route6",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_delete_route6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/delete_route6");
	}
	if (_cmds->add_handler("rib/0.1/add_interface_route4",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_add_interface_route4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/add_interface_route4");
	}
	if (_cmds->add_handler("rib/0.1/add_interface_route6",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_add_interface_route6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/add_interface_route6");
	}
	if (_cmds->add_handler("rib/0.1/replace_interface_route4",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_replace_interface_route4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/replace_interface_route4");
	}
	if (_cmds->add_handler("rib/0.1/replace_interface_route6",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_replace_interface_route6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/replace_interface_route6");
	}
	if (_cmds->add_handler("rib/0.1/lookup_route_by_dest4",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_lookup_route_by_dest4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/lookup_route_by_dest4");
	}
	if (_cmds->add_handler("rib/0.1/lookup_route_by_dest6",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_lookup_route_by_dest6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/lookup_route_by_dest6");
	}
	if (_cmds->add_handler("rib/0.1/new_vif",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_new_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/new_vif");
	}
	if (_cmds->add_handler("rib/0.1/add_vif_addr4",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_add_vif_addr4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/add_vif_addr4");
	}
	if (_cmds->add_handler("rib/0.1/add_vif_addr6",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_add_vif_addr6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/add_vif_addr6");
	}
	if (_cmds->add_handler("rib/0.1/redist_enable4",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_redist_enable4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/redist_enable4");
	}
	if (_cmds->add_handler("rib/0.1/redist_enable6",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_redist_enable6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/redist_enable6");
	}
	if (_cmds->add_handler("rib/0.1/redist_disable4",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_redist_disable4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/redist_disable4");
	}
	if (_cmds->add_handler("rib/0.1/redist_disable6",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_redist_disable6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/redist_disable6");
	}
	if (_cmds->add_handler("rib/0.1/redist_transaction_enable4",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_redist_transaction_enable4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/redist_transaction_enable4");
	}
	if (_cmds->add_handler("rib/0.1/redist_transaction_enable6",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_redist_transaction_enable6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/redist_transaction_enable6");
	}
	if (_cmds->add_handler("rib/0.1/redist_transaction_disable4",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_redist_transaction_disable4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/redist_transaction_disable4");
	}
	if (_cmds->add_handler("rib/0.1/redist_transaction_disable6",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_redist_transaction_disable6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/redist_transaction_disable6");
	}
	if (_cmds->add_handler("rib/0.1/register_interest4",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_register_interest4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/register_interest4");
	}
	if (_cmds->add_handler("rib/0.1/deregister_interest4",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_deregister_interest4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/deregister_interest4");
	}
	if (_cmds->add_handler("rib/0.1/register_interest6",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_register_interest6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/register_interest6");
	}
	if (_cmds->add_handler("rib/0.1/deregister_interest6",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_deregister_interest6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/deregister_interest6");
	}
	if (_cmds->add_handler("rib/0.1/insert_policy_redist_tags",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_insert_policy_redist_tags)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/insert_policy_redist_tags");
	}
	if (_cmds->add_handler("rib/0.1/reset_policy_redist_tags",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_reset_policy_redist_tags)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/reset_policy_redist_tags");
	}
	if (_cmds->add_handler("rib/0.1/get_protocol_admin_distances",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_get_protocol_admin_distances)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/get_protocol_admin_distances");
	}
	if (_cmds->add_handler("rib/0.1/get_protocol_admin_distance",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_get_protocol_admin_distance)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/get_protocol_admin_distance");
	}
	if (_cmds->add_handler("rib/0.1/set_protocol_admin_distance",
	    callback(this, &XrlRibTargetBase::handle_rib_0_1_set_protocol_admin_distance)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "rib/0.1/set_protocol_admin_distance");
	}
	if (_cmds->add_handler("profile/0.1/enable",
	    callback(this, &XrlRibTargetBase::handle_profile_0_1_enable)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "profile/0.1/enable");
	}
	if (_cmds->add_handler("profile/0.1/disable",
	    callback(this, &XrlRibTargetBase::handle_profile_0_1_disable)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "profile/0.1/disable");
	}
	if (_cmds->add_handler("profile/0.1/get_entries",
	    callback(this, &XrlRibTargetBase::handle_profile_0_1_get_entries)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "profile/0.1/get_entries");
	}
	if (_cmds->add_handler("profile/0.1/clear",
	    callback(this, &XrlRibTargetBase::handle_profile_0_1_clear)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "profile/0.1/clear");
	}
	if (_cmds->add_handler("profile/0.1/list",
	    callback(this, &XrlRibTargetBase::handle_profile_0_1_list)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rib", "profile/0.1/list");
	}
	_cmds->finalize();
}

void
XrlRibTargetBase::remove_handlers()
{
	_cmds->remove_handler("common/0.1/get_target_name");
	_cmds->remove_handler("common/0.1/get_version");
	_cmds->remove_handler("common/0.1/get_status");
	_cmds->remove_handler("common/0.1/shutdown");
	_cmds->remove_handler("finder_event_observer/0.1/xrl_target_birth");
	_cmds->remove_handler("finder_event_observer/0.1/xrl_target_death");
	_cmds->remove_handler("policy_backend/0.1/configure");
	_cmds->remove_handler("policy_backend/0.1/reset");
	_cmds->remove_handler("policy_backend/0.1/push_routes");
	_cmds->remove_handler("rib/0.1/enable_rib");
	_cmds->remove_handler("rib/0.1/disable_rib");
	_cmds->remove_handler("rib/0.1/start_rib");
	_cmds->remove_handler("rib/0.1/stop_rib");
	_cmds->remove_handler("rib/0.1/make_errors_fatal");
	_cmds->remove_handler("rib/0.1/get_registered_protocols");
	_cmds->remove_handler("rib/0.1/add_igp_table4");
	_cmds->remove_handler("rib/0.1/add_igp_table6");
	_cmds->remove_handler("rib/0.1/delete_igp_table4");
	_cmds->remove_handler("rib/0.1/delete_igp_table6");
	_cmds->remove_handler("rib/0.1/add_egp_table4");
	_cmds->remove_handler("rib/0.1/add_egp_table6");
	_cmds->remove_handler("rib/0.1/delete_egp_table4");
	_cmds->remove_handler("rib/0.1/delete_egp_table6");
	_cmds->remove_handler("rib/0.1/add_route4");
	_cmds->remove_handler("rib/0.1/add_route6");
	_cmds->remove_handler("rib/0.1/replace_route4");
	_cmds->remove_handler("rib/0.1/replace_route6");
	_cmds->remove_handler("rib/0.1/delete_route4");
	_cmds->remove_handler("rib/0.1/delete_route6");
	_cmds->remove_handler("rib/0.1/add_interface_route4");
	_cmds->remove_handler("rib/0.1/add_interface_route6");
	_cmds->remove_handler("rib/0.1/replace_interface_route4");
	_cmds->remove_handler("rib/0.1/replace_interface_route6");
	_cmds->remove_handler("rib/0.1/lookup_route_by_dest4");
	_cmds->remove_handler("rib/0.1/lookup_route_by_dest6");
	_cmds->remove_handler("rib/0.1/new_vif");
	_cmds->remove_handler("rib/0.1/add_vif_addr4");
	_cmds->remove_handler("rib/0.1/add_vif_addr6");
	_cmds->remove_handler("rib/0.1/redist_enable4");
	_cmds->remove_handler("rib/0.1/redist_enable6");
	_cmds->remove_handler("rib/0.1/redist_disable4");
	_cmds->remove_handler("rib/0.1/redist_disable6");
	_cmds->remove_handler("rib/0.1/redist_transaction_enable4");
	_cmds->remove_handler("rib/0.1/redist_transaction_enable6");
	_cmds->remove_handler("rib/0.1/redist_transaction_disable4");
	_cmds->remove_handler("rib/0.1/redist_transaction_disable6");
	_cmds->remove_handler("rib/0.1/register_interest4");
	_cmds->remove_handler("rib/0.1/deregister_interest4");
	_cmds->remove_handler("rib/0.1/register_interest6");
	_cmds->remove_handler("rib/0.1/deregister_interest6");
	_cmds->remove_handler("rib/0.1/insert_policy_redist_tags");
	_cmds->remove_handler("rib/0.1/reset_policy_redist_tags");
	_cmds->remove_handler("rib/0.1/get_protocol_admin_distances");
	_cmds->remove_handler("rib/0.1/get_protocol_admin_distance");
	_cmds->remove_handler("rib/0.1/set_protocol_admin_distance");
	_cmds->remove_handler("profile/0.1/enable");
	_cmds->remove_handler("profile/0.1/disable");
	_cmds->remove_handler("profile/0.1/get_entries");
	_cmds->remove_handler("profile/0.1/clear");
	_cmds->remove_handler("profile/0.1/list");
}
