/*
 *  Extract version from RCS Revision string.
 *
 *  Copyright (c) 2002  Brendan O'Dea <bod@debian.org>
 *
 *  This is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include <stdio.h>
#include <ctype.h>
#include "misc.h"
#include "version.h"

RCS_Id("$Id: version.c,v 1.1 2002/01/20 07:14:25 bod Exp $")

char const *version()
{
#   define MAX_REV 15 /* should be heaps */
    static char str[MAX_REV+1];
    static char const *rev = "$Revision: 1.1 $";
    char const *r;
    int i;

    for (r = rev, i = 0; *r && i < MAX_REV; r++)
	if (isdigit(*r) || *r == '.')
	    str[i++] = *r;

    if (!i)
	return "0.0";

    str[i] = 0;
    return str;
}
