// file      : xsde/cxx/parser/non-validating/idrefs.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#include <xsde/cxx/pre.hxx>

#include <xsde/cxx/config.hxx>

#include <xsde/cxx/parser/non-validating/idrefs.hxx>

namespace xsde
{
  namespace cxx
  {
    namespace parser
    {
      namespace non_validating
      {
        idrefs_pimpl::
        ~idrefs_pimpl ()
        {
          delete seq_;
        }

        idrefs_pimpl::
        idrefs_pimpl ()
            : seq_ (0)
        {
        }

        void idrefs_pimpl::
        _pre ()
        {
          delete seq_;
          seq_ = new string_sequence ();

#ifndef XSDE_EXCEPTIONS
          if (seq_ == 0)
          {
            _sys_error (sys_error::no_memory);
            return;
          }
#endif

          idrefs_pskel::_pre ();
        }

        string_sequence* idrefs_pimpl::
        post_idrefs ()
        {
          string_sequence* r = seq_;
          seq_ = 0;
          return r;
        }

#ifdef XSDE_EXCEPTIONS
        struct string_guard
        {
          ~string_guard () { delete[] p_; }
          string_guard (char* p) : p_ (p) {}

          void
          release () { p_ = 0; }

        private:
          char* p_;
        };

        void idrefs_pimpl::
        _xsde_parse_item (const ro_string& s)
        {
          parser_.pre ();
          parser_._pre ();
          parser_._characters (s);
          parser_._post ();
          char* x = parser_.post_idref ();
          string_guard guard (x);
          seq_->push_back_attach (x);
          guard.release ();
        }
#else
        void idrefs_pimpl::
        _xsde_parse_item (const ro_string& s)
        {
          parser_.pre ();

          if (!parser_._error_p ())
            parser_._pre ();

          if (!parser_._error_p ())
            parser_._characters (s);

          if (!parser_._error_p ())
            parser_._post ();

          if (!parser_._error_p ())
          {
            char* x = parser_.post_idref ();

            if (!parser_._error_p ())
            {
              if (seq_->push_back_attach (x))
              {
                delete[] x;
                _sys_error (sys_error::no_memory);
                return;
              }
            }
          }

          if (parser_._error_p ())
            _copy_error (&parser_);
        }
#endif
      }
    }
  }
}

#include <xsde/cxx/post.hxx>
