/*
 * YH - Console Chinese Environment -
 * Copyright (C) 1999 Red Flag Linux (office@sonata.iscas.ac.cn)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY TAKASHI MANABE ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */


/*****************---writescr.c----*********************/


#include <stdio.h>
#include <signal.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include "display.h"
#include "chncon.h"
#include "timer.h"
#include <vga.h>

#define IPPORT_LICENSE		8900

int		sem_disp;

static int	prompt = 0;
static int	conflict = 0;

static void	catch_prompt();
static void	catch_conflict();
static void	catch_hup();
static void	catch_term();
static void	ListenLicense();
static void	BroadcastLicense();
extern int 	should_rel_screen;
extern int 	should_acq_screen;

extern void RedrawScreen();
extern struct screen g_scrn;
extern int isdisplayed;
extern void clear_screen(struct screen *);

void	WriteScr()
{
	struct sigaction	act;
	int			rv;
	u_char			buf[8193];
	int			n;
        long 			count=0;
        
	pidWrite = getpid();

#if 0
	if ((pidListen = fork()) == 0)
	{
		close(pipeCom[1]);
		ListenLicense();	/* never return */
	}
#endif

	/*
	 * Create the semaphore for controling display
	 */
	rv = initdisplay();
	act.sa_flags = 0;
	memset(&act.sa_mask, 0, sizeof(act.sa_mask));
	act.sa_handler = catch_prompt;
#if (defined(OPENSERVER) || defined(GEMINI))
	act.sa_sigaction = catch_prompt;
#endif
	sigaction(SIGPIPE, &act, NULL);
	act.sa_handler = catch_conflict;
#if (defined(OPENSERVER) || defined(GEMINI))
	act.sa_sigaction = catch_conflict;
#endif
	sigaction(SIGPROF, &act, NULL);
	act.sa_handler = catch_hup;
#if (defined(OPENSERVER) || defined(GEMINI))
	act.sa_sigaction = catch_hup;
#endif
	sigaction(SIGHUP, &act, NULL);
        write(pipeCom[1], &rv, sizeof(rv));
	write(pipeCom[1], &pidListen, sizeof(pidListen));
	if (rv < 0)
		exit(1);

	timercounter = 0;
	settimer(333);

	while (1)
	{
                if (should_rel_screen)
		{
			should_rel_screen = 0;
			rel_screen();
		}

		if (should_acq_screen)
		{
			should_acq_screen = 0;
			acq_screen();
		}
	
		n = read(fdm, buf, sizeof(buf) - 1);
		
		if(n>0)
		{
			buf[n] = '\0';
			in_ansi = 1;
			ansi(buf, n);

			if(isdisplayed)	  
				RedrawScreen(&g_scrn);

			in_ansi = 0;
		}
		else if (prompt)
		{
			n = read(pipePrompt[0], buf, sizeof(buf) - 1);
			if (n > 0)
			{
				u_char	*p;

				buf[n] = '\0';
				p = buf;
				while (n > 83)
				{
					n -= 83;
					p += 83;
				}

				in_ansi = 1;
				ansi(p, n);
				in_ansi = 0;
                              
			}
			prompt = 0;
		}
		else if (conflict)
		{
			u_char *msg = (u_char *) "\033[37;1;41m"
				"кųͻ빺֧ǷչĶ\n\r"
				"\033[37;0;40m";

			ansi(msg, strlen((char *) msg));

			if(isdisplayed)  
				RedrawScreen(&g_scrn);

			conflict = 0;
		}
		else
                        vga1_scurs(ECHO_ON);
	}
}


static void	ListenLicense()
{
	static int		getmyname = 1;
	int			sockfd, sockfd2;
	struct sockaddr_in	myname, yourname;
	int			port;
	int			rv;
	char			yourlicense[LICENSE_SIZE];
#ifdef OPENSERVER
	int			len;
#else
	size_t			len;
#endif
	struct sigaction	act;

	act.sa_handler = catch_term;
#if (defined(OPENSERVER) || defined(GEMINI))
	act.sa_sigaction = catch_term;
#endif
	act.sa_flags = 0;
	memset(&act.sa_mask, 0, sizeof(act.sa_mask));
	sigaction(SIGTERM, &act, NULL);
	setpgrp();
	sockfd = socket(PF_INET, SOCK_DGRAM, 0);
	myname.sin_family = PF_INET;
	myname.sin_addr.s_addr = INADDR_ANY;
	port = IPPORT_LICENSE;
	do
		myname.sin_port = htons(port++);
	while ((bind(sockfd, (struct sockaddr *) &myname, 
		sizeof(myname)) < 0) && (port < IPPORT_LICENSE + 4));

	while (1)
	{
		len = sizeof(yourname);
		recvfrom(sockfd, yourlicense, sizeof(yourlicense), 0, 
			(struct sockaddr *) &yourname, &len);
		yourlicense[LICENSE_SIZE - 1] = '\0';
		if (getmyname)
		{
			sockfd2 = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
			yourname.sin_port = htons(IPPORT_ECHO);
			connect(sockfd2, (struct sockaddr *) &yourname, sizeof(yourname));
			len = sizeof(myname);
			getsockname(sockfd2, (struct sockaddr *) &myname, &len);
			close(sockfd2);
			getmyname = 0;
		}
		if (myname.sin_addr.s_addr != yourname.sin_addr.s_addr)
		{
			if (strcmp(yourlicense, mylicense) == 0)
				kill(pidWrite, SIGPROF);
		}
	}
}


static void	BroadcastLicense()
{
	int			sockfd;
	struct sockaddr_in	name;
	int			opt = 1;
	int			i;
	static int		port = IPPORT_LICENSE;

	if (port >= IPPORT_LICENSE + 4)
		port = IPPORT_LICENSE; 
	sockfd = socket(PF_INET, SOCK_DGRAM, 0);
	setsockopt(sockfd, SOL_SOCKET, SO_BROADCAST, &opt, sizeof(opt));
	name.sin_family = PF_INET;
	name.sin_addr.s_addr = INADDR_BROADCAST;
	name.sin_port = htons(port++);
	sendto(sockfd, mylicense, sizeof(mylicense), 0, 
		(struct sockaddr *) &name, sizeof(name));
	close(sockfd);
}


static void	catch_prompt()
{
	prompt = 1;
}


static void	catch_conflict()
{
	conflict = 1;
}


static void	catch_hup()
{
	killtimer();
        vga_setmode(TEXT);
        exit(0);
}


static void	catch_term()
{
	vga_setmode(TEXT);
        exit(0);
}

