/*
	Process handling
 */


#ifndef PROCHANDLE_H
#define PROCHANDLE_H

#include <sys/types.h>


#ifdef __cplusplus
extern "C" {
#endif


extern char **ExecExplodeCommand(const char *cmd, int *strc);

extern void Execute(const char *cmd);

extern pid_t Exec(const char *cmd);
extern pid_t ExecAOE(
	const char *cmd, const char *stdout_path, const char *stderr_path
);
extern pid_t ExecAO(
	const char *cmd, const char *stdout_path
);

extern pid_t ExecB(const char *cmd);
extern pid_t ExecBAOE(
	const char *cmd, const char *stdout_path, const char *stderr_path
);
extern pid_t ExecBAO(
	const char *cmd, const char *stdout_path
);


#ifdef __cplusplus
}
#endif

#endif	/* PROCHANDLE_H */
