/*
                              File Browser
 */

#ifndef FB_H
#define FB_H

#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef gbool
# define gbool	guchar
#endif


/*
 *	File browser file extension type structure:
 */
typedef struct {

	char *ext;	/* Extension(s), space separated list. */
	char *name;	/* Description of type. */

} fb_type_struct;

/*
 *	File browser structure:
 */
typedef struct {

        gbool initialized;
	gbool map_state;

        GtkWidget	*file_browser,	/* File selection widget. */
			*type_combo;

	GList		*type_combo_glist;

} fb_data_struct;




extern int FileBrowserInit(void);
extern gbool FileBrowserIsQuery(void);
extern void FileBrowserBreakQuery(void);
extern gbool FileBrowserGetResponse(
        const char *title,
        const char *ok_label, const char *cancel_label,
        const char *path,
        fb_type_struct **type, int total_types,
        char ***path_rtn, int *path_total_rtns,
        fb_type_struct **type_rtn
);
extern void FileBrowserMap(fb_data_struct *fb);
extern void FileBrowserUnmap(fb_data_struct *fb);
extern void FileBrowserShutdown(void);

extern int FileBrowserTypeListNew(
        fb_type_struct ***list, int *total,
        const char *ext,        /* Space separated list of extensions. */
        const char *name        /* Descriptive name. */
);
extern void FileBrowserDeleteTypeList(
	fb_type_struct **t, int total
);

#endif	/* FB_H */
