/*
                                Prompt Dialog
 */

#ifndef PDIALOG_H
#define PDIALOG_H

#include <sys/types.h>

#include <gtk/gtk.h>

#ifndef gbool
# define gbool	guchar
#endif


/*
 *	Response codes:
 */
#define PDIALOG_RESPONSE_NOT_AVAILABLE	-1
#define PDIALOG_RESPONSE_CANCEL		0
#define PDIALOG_RESPONSE_SUBMIT 	1
#define PDIALOG_RESPONSE_HELP		2


/*
  *	Prompt icon codes, specifies the icon displayed next to
 *	the prompts:
 */
#define PDIALOG_ICON_INFO	0
#define PDIALOG_ICON_WARNING    1
#define PDIALOG_ICON_ERROR	2
#define PDIALOG_ICON_QUESTION	3


/*
 *	Button display flags:
 */
#define PDIALOG_BTNFLAG_SUBMIT	(1 << 1)
#define PDIALOG_BTNFLAG_CANCEL	(1 << 2)
#define PDIALOG_BTNFLAG_HELP	(1 << 3)


/*
 *	Prompt dialog prompt structure:
 */
typedef struct {

	GtkWidget	*toplevel,	/* A table. */
                        *icon_pm,
                        *icon_fixed,
			*label,
			*entry,		/* Can be NULL. */
			*browse_btn,	/* Can be NULL. */
			*spin,		/* Can be NULL. */
			*scale;		/* Can be NULL. */

	GtkAdjustment	*scale_adj;

	void *client_data;

	/* Args: prompt dialog, client data, prompt number. */
        char *(*browse_cb)(void *, void *, int);

} pdialog_prompt_struct;

/*
 *	Prompt dialog structure:
 */
typedef struct {

	gbool initialized;
	gbool map_state;

	gint last_icon_code;

	GtkWidget	*toplevel,
			*main_vbox,	/* For holding the prompts. */
			*icon_pm,
			*icon_fixed;

	pdialog_prompt_struct **prompt;
	int total_prompts;

	GtkWidget	*submit_btn,
			*submit_btn_label,
			*cancel_btn,
			*cancel_btn_label,
			*help_btn;

} pdialog_struct;



extern int PDialogInit(void);

extern gbool PDialogIsQuery(void);
extern void PDialogBreakQuery(void);

extern void PDialogAddPrompt(
	const u_int8_t **icon_data,	/* Can be NULL. */
        const char *label,		/* Can be NULL. */
        const char *value		/* Can be NULL. */
);
extern void PDialogAddPromptWithBrowse(
	const u_int8_t **icon_data,	/* Can be NULL. */
	const char *label,		/* Can be NULL. */
	const char *value,		/* Can be NULL. */
	void *client_data,		/* Can be NULL. */
	char *(*browse_cb)(void *, void *, int)	/* Can be NULL. */
);
extern void PDialogSetPromptValue(
	int prompt_num,
	const u_int8_t **icon_data,
	const char *label,
	const char *value
);
extern char *PDialogGetPromptValue(
        int prompt_num
);
extern void PDialogDeleteAllPrompts(void);

extern char **PDialogGetResponse(
	const char *title,
	const char *message,
	const char *explaination,
	int icon_code,
	const char *submit_label,
	const char *cancel_label,
	unsigned int show_buttons,
	unsigned int default_button,
	int *nvalues
);

extern void PDialogMap(pdialog_struct *d);
extern void PDialogUnmap(pdialog_struct *d);

extern void PDialogShutdown(void);


#endif	/* PDIALOG_H */
