#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>

#include <gtk/gtk.h>
#include "../include/Y2/Y.h"
#include "../include/Y2/Ylib.h"

#include "guiutils.h"
#include "cdialog.h"

#include "yc.h"
#include "config.h"


void YCPageChange(yc_struct *yc, gint prev_page, gint new_page);


/*
 *      Procedure to change the current nariative and page to the
 *      specified page_num.
 *
 *      All nessesary widgets will be mapped/unmapped and values
 *      for each widget updated as needed.
 *
 *      Other operations including connecting to Y server and saving
 *      of configuration file (amoung other things) are performed nere.
 */
void YCPageChange(yc_struct *yc, gint prev_page, gint new_page)
{
	GtkWidget *w;

	if(yc == NULL)
	    return;

	/* ******************************************************** */
	/* Welcome page? */
	else if(new_page == YC_PAGE_NUM_WELCOME)
	{


	}
	/* ******************************************************** */
	/* Locations page */
	else if(new_page == YC_PAGE_NUM_LOCATIONS)
	{
	    /* Backward page change? */
	    if(prev_page == (new_page + 1))
	    {
		/* Came from ymode page, we need to disconnect from
		 * the Y server.
		 */
		YCloseConnection(yc->recorder, False);
		yc->recorder = NULL;
	    }
	}
	/* ******************************************************** */
	/* YModes page */
	else if(new_page == YC_PAGE_NUM_YMODES)
	{
	    /* Forward page change? */
	    if(prev_page == (new_page - 1))
	    {
		/* Came from locations page, we need to first load the
		 * YIFF server configuration and update the
		 * device, mixer, and port values, resave and then
		 * connect to the Y server if specified by
		 * yiff_start_toggle.
		 */
		int status;
		gchar	*strptr,
			*configuration_file,
			*dsp_device,
			*mixer_device,
			*address_str,
			*port_str;
		gboolean configuration_load_succ = FALSE;


		/* Check installation with respect to the path values
		 * currently specified on the widgets.
		 */
		YCCheckInstallation(
		    yc,
		    NULL,	/* YIFF configuration file location */
		    NULL,	/* YIFF program location */
		    TRUE	/* Report problems */
		);


		/* Get coppies of current path values, so we can
		 * preserve them after the configuration is loaded.
		 */

		/* YIFF Sound Server configuration file */
		w = yc->yiff_configuration_file_entry;
		if(w == NULL)
		    strptr = NULL;
		else
		    strptr = gtk_entry_get_text(GTK_ENTRY(w));
		configuration_file = ((strptr == NULL) ?
		    NULL : g_strdup(strptr)
		);

		/* DSP device path */
		w = yc->dsp_device_entry;
		if(w == NULL)
		    strptr = NULL;
		else
		    strptr = gtk_entry_get_text(GTK_ENTRY(w));
		dsp_device = ((strptr == NULL) ?
		    NULL : g_strdup(strptr)
		);

		/* Mixer device path */
		w = yc->mixer_device_entry;
		if(w == NULL)
		    strptr = NULL;
		else
		    strptr = gtk_entry_get_text(GTK_ENTRY(w));
		mixer_device = ((strptr == NULL) ?
		    NULL : g_strdup(strptr)
		);

		/* Address (as a string) */
		w = yc->address_entry;
		if(w == NULL)
		    strptr = NULL;
		else
		    strptr = gtk_entry_get_text(GTK_ENTRY(w));
		address_str = ((strptr == NULL) ?
		    NULL : g_strdup(strptr)
		);

		/* Port number (as a string) */
		w = yc->port_entry;
		if(w == NULL)
		    strptr = NULL;
		else
		    strptr = gtk_entry_get_text(GTK_ENTRY(w));
		port_str = ((strptr == NULL) ?
		    NULL : g_strdup(strptr)
		);


		/* Configuration file specified? */
		if((configuration_file == NULL) ?
			0 : !((*configuration_file) == '\0')
		)
		{
		    struct stat stat_buf;

		    /* Configuration file exists? */
		    if(stat(configuration_file, &stat_buf))
		    {
			/* No such file, prompt to create new one? */
			gchar *buf = g_strdup_printf(
"Create new configuration file:\n\
\n\
    %s\n",
			    configuration_file
			);
			CDialogSetTransientFor(yc->toplevel);
			status = CDialogGetResponse(
"Create New Configuration File",
			    buf,
"The specified YIFF Sound Server configuration file\n\
does not exist, you are being asked if you want to\n\
create a new configuration file in the specified\n\
location. If you feel that the given location is\n\
incorrect, then say 'No' and click on 'Back' then\n\
enter the correct location.",
			    CDIALOG_ICON_QUESTION,
			    CDIALOG_BTNFLAG_YES | CDIALOG_BTNFLAG_NO |
			    CDIALOG_BTNFLAG_HELP,
			    CDIALOG_BTNFLAG_YES
			);
			CDialogSetTransientFor(NULL);

			g_free(buf);

 			switch(status)
			{
			  case CDIALOG_RESPONSE_YES:
			  case CDIALOG_RESPONSE_YES_TO_ALL:
			  case CDIALOG_RESPONSE_OK:
			    /* Response was yes, so consider the
			     * new configuration file created
			     * and mark its success
			     */
			    configuration_load_succ = TRUE;
			    break;
			}
		    }
		    else
		    {
			/* Exists, check if its valid and writeable */

			if(S_ISDIR(stat_buf.st_mode))
			{
			    CDialogSetTransientFor(yc->toplevel);
			    CDialogGetResponse(
"Invalid Location",
"The specified location for the configuration file\n\
is a directory.\n",
"The specified location for the YIFF Sound Server\n\
configuration file is a directory. This location\n\
can neither be loaded nor saved. Please specify\n\
a path to a file within a directory.",
				CDIALOG_ICON_WARNING,
				CDIALOG_BTNFLAG_OK | CDIALOG_BTNFLAG_HELP,
				CDIALOG_BTNFLAG_OK
			    );
			    CDialogSetTransientFor(NULL);
			}
			else
			{
			    /* Exists and is valid to load, so load it */
			    YCLoadConfiguration(yc, configuration_file);

			    configuration_load_succ = TRUE;
			}
		    }
		}

		/* Restore values */

		/* DSP device */
		strptr = dsp_device;
		w = yc->dsp_device_entry;
		if((w != NULL) && (strptr != NULL))
		    gtk_entry_set_text(GTK_ENTRY(w), strptr);

		/* Mixer device */
		strptr = mixer_device;
		w = yc->mixer_device_entry;
		if((w != NULL) && (strptr != NULL))
		    gtk_entry_set_text(GTK_ENTRY(w), strptr);

		/* Address */
		strptr = address_str;
		w = yc->address_entry;
		if((w != NULL) && (strptr != NULL))
		    gtk_entry_set_text(GTK_ENTRY(w), strptr);

		/* Port */
		strptr = port_str;
		w = yc->port_entry;
		if((w != NULL) && (strptr != NULL))
		    gtk_entry_set_text(GTK_ENTRY(w), strptr);


		/* Was configuration loaded suceessfully? */
		if(configuration_load_succ)
		{
		    /* Save YIFF Sound Server configuration before
		     * starting the Y server.
		     */
		    YCSaveConfiguration(yc, configuration_file);
		}
		else
		{
		    /* Print warning about configuration file not able
		     * to be loaded
		     */
		    CDialogSetTransientFor(yc->toplevel);
		    CDialogGetResponse(
"Unable Open Configuration",
"Unable to open the YIFF Sound Server configuration file.",
"The YIFF Sound Server configuration file could not\n\
be loaded at the specified location. Please go 'Back'\n\
and check the given location for the YIFF Sound\n\
Server configuration file.",
			CDIALOG_ICON_WARNING,
			CDIALOG_BTNFLAG_OK | CDIALOG_BTNFLAG_HELP,
			CDIALOG_BTNFLAG_OK
		    );
		    CDialogSetTransientFor(NULL);
		}


		/* Delete coppied values */
		g_free(configuration_file);
		configuration_file = NULL;

		g_free(dsp_device);
		dsp_device = NULL;

		g_free(mixer_device);
		mixer_device = NULL;

		g_free(address_str);
		address_str = NULL;

		g_free(port_str);
		port_str = NULL;


		/* Start yiff server if yiff_start_toggle says so and
		 * that configuration_load_succ is TRUE.
		 */
		w = yc->yiff_start_toggle;
		if(((w == NULL) ? 0 : GTK_TOGGLE_BUTTON(w)->active) &&
		   configuration_load_succ
		)
		{
		    gchar start_arg[2048], con_arg[1024];
		    gchar *strptr;


		    /* Begin setting up start argument */
		    (*start_arg) = '\0';

		    /* Program location */
		    w = yc->yiff_program_entry;
		    strptr = ((w == NULL) ?
			NULL : gtk_entry_get_text(GTK_ENTRY(w))
		    );
		    if(strptr == NULL)
			strncat(start_arg, YC_DEF_YIFF_PROGRAM, 768);
		    else
			strncat(start_arg, strptr, 768);

		    /* Space */
		    strcat(start_arg, " ");
		    w = yc->yiff_configuration_file_entry;

		    /* First argument is configuration file location */
		    w = yc->yiff_configuration_file_entry;
		    strptr = ((w == NULL) ?
			NULL : gtk_entry_get_text(GTK_ENTRY(w))
		    );
		    if(strptr == NULL)
			strncat(start_arg, YC_DEF_CONFIG_FILE, 768);
		    else
			strncat(start_arg, strptr, 768);


		    /* Begin gathering values for the connect argument,
		     * which should look like "<address>:<port>".
		     */
		    (*con_arg) = '\0';

		    /* Address */
		    w = yc->address_entry;
		    strptr = ((w == NULL) ?
			NULL : gtk_entry_get_text(GTK_ENTRY(w))
		    );
		    if(strptr == NULL)
			strncat(con_arg, YC_DEF_ADDRESS, 512);
		    else
			strncat(con_arg, strptr, 512);

		    /* Deliminator */
		    strcat(con_arg, ":");

		    /* Port */
		    w = yc->port_entry;
		    strptr = ((w == NULL) ?
			NULL : gtk_entry_get_text(GTK_ENTRY(w))
		    );
		    if(strptr == NULL)
			strncat(con_arg, YC_DEF_PORT, 80);
		    else
			strncat(con_arg, strptr, 80);


		    /* Close connection just in case */
		    YCloseConnection(yc->recorder, False);
		    yc->recorder = NULL;


		    /* Rewrite YIFF Sound Server configuration file */





		    /* Open connection */
		    yc->recorder = YOpenConnection(
	                start_arg,
			con_arg
		    );
		    if(yc->recorder == NULL)
		    {
			/* Could not start up Y server */
			CDialogSetTransientFor(yc->toplevel);
			CDialogGetResponse(
"Unable To Start Y Sound Server",
"Unable to start the Y Sound Server, please verify\n\
that YIFF has been installed properly and the specified\n\
locations are correct.",
"The YIFF Sound Server chould not be started, this\n\
may indicate a variety of problems. Please go\n\
'Back' and verify that the values you specified\n\
for the locations are correct and that the YIFF\n\
Sound Server has been installed properly. Also\n\
check to make sure dependant resources (ie sound\n\
drivers) have been set up properly.",
			    CDIALOG_ICON_WARNING,
			    CDIALOG_BTNFLAG_OK | CDIALOG_BTNFLAG_HELP,
			    CDIALOG_BTNFLAG_OK
			);
			CDialogSetTransientFor(NULL);
		    }
		    else
		    {
			/* Set up mixers? */





		    }

		}

		/* Update sensitivity of apply audio values button */
		w = yc->ymode_apply_to_yiff_btn;
		if(w != NULL)
		{
		    gtk_widget_set_sensitive(
			w,
			(yc->recorder == NULL) ? FALSE : TRUE
		    );
		}
		/* Update sensitivity of play button */
		w = yc->ymode_play_btn;
		if(w != NULL)
		{
		    gtk_widget_set_sensitive(
			w,
			(yc->recorder == NULL) ? FALSE : TRUE
		    );
		}
	    }
	}
	/* ******************************************************** */
	/* Timings page */
	else if(new_page == YC_PAGE_NUM_TIMINGS)
	{
	    /* Forward page change? */
	    if(prev_page == (new_page - 1))  
	    {
		gint selected_row = yc->selected_ymode;
		GtkCList *clist = (GtkCList *)yc->ymodes_clist;
		if(clist != NULL)
		{
		    /* Need to apply values from widgets to currently
		     * selected Y Audio Mode.
		     */
		    if((selected_row >= 0) && (selected_row < clist->rows))
		    {
			yc_ymode_data_struct *ymode_data_ptr = (yc_ymode_data_struct *)
			    gtk_clist_get_row_data(clist, selected_row);

			/* Apply values */
			YCYModeFetchFromWidgets(
			    yc, ymode_data_ptr
			);
		    }

		    /* Atleast one Y Audio Mode exist? */
		    if(clist->rows <= 0)
		    {
			CDialogSetTransientFor(yc->toplevel);
			CDialogGetResponse(
			    "No Y Audio Modes Defined",
"You should have atleast one preset Y Audio Mode defined,\n\
preferably by the name of 'Default'. You are strongly\n\
encuraged to go 'Back' and define atleast one preset Y Audio\n\
Mode.",
			    NULL,
			    CDIALOG_ICON_WARNING,
			    CDIALOG_BTNFLAG_OK,
			    CDIALOG_BTNFLAG_OK
			);
			CDialogSetTransientFor(NULL);
		    }
		    else
		    {
			/* Else check if first Y Audio Mode name
			 * is named 'Default'
			 */
			gchar *strptr = NULL;

			gtk_clist_get_text(
			    clist, 0, 0, &strptr
			);
			if(strcasecmp(
			    (strptr == NULL) ? "" : strptr,
			    "Default"
			))
			{
			    CDialogSetTransientFor(yc->toplevel);
			    CDialogGetResponse(
"Default Y Audio Mode Not First Item",
"The first Preset Y Audio Mode name should be named\n\
'Default', this is to ensure that Y client programs\n\
which expect this standard can run properly. You\n\
should go 'Back' and name the first listed Y Audio Mode\n\
'Default'.",
				NULL,
				CDIALOG_ICON_WARNING,
				CDIALOG_BTNFLAG_OK,
				CDIALOG_BTNFLAG_OK
			    );
			    CDialogSetTransientFor(NULL);
			}
		    }

		}

	    }
	}
	/* ******************************************************** */
	/* MIDI page */
	else if(new_page == YC_PAGE_NUM_MIDI)
	{


	}
	/* ******************************************************** */
	/* YSound paths page */
	else if(new_page == YC_PAGE_NUM_YSOUNDPATHS)
	{
	    /* Forward page change? */
	    if(prev_page == (new_page - 1))
	    {
		/* Check if the midi play command had a substitution
		 * in the command for the file name.
		 */		
		gchar *strptr;


		w = yc->midi_play_cmd_entry;
		if(w == NULL)
		    strptr = NULL;
		else
		    strptr = gtk_entry_get_text(GTK_ENTRY(w));

		/* Check if we got a string and that it is not empty */
		if((strptr == NULL) ? 0 : (*strptr) != '\0')
		{
		    /* Look for atleast one occurance of the sub string */
		    if(strstr(strptr, "%f") == NULL)
		    {
			/* Substitution string not found, print warning */
			CDialogSetTransientFor(yc->toplevel);
			CDialogGetResponse(
"Missing Substitution",
"MIDI player command string is missing a \"%f\"\n\
substitution. You should go 'Back' and correct this.",
"The MIDI player command string is missing a \"%f\"\n\
substitution. This would be replaced with the sound\n\
object file when the MIDI player is actually called.\n\
You should go 'Back' and fix this or else the MIDI\n\
player may not function properly.",
			    CDIALOG_ICON_WARNING,
			    CDIALOG_BTNFLAG_OK,
			    CDIALOG_BTNFLAG_OK
			);
			CDialogSetTransientFor(NULL);
		    }
		}

	    }

	}
	/* ******************************************************** */
	/* Conferm finish page */
	else if(new_page == YC_PAGE_NUM_CONFERM)
	{
	    /* Forward page change? */
	    if(prev_page == (new_page - 1))
	    {
		/* Update confermation clist */
		YCConfermListRefresh(yc);
	    }
	}

	return;
}
