/* w_youbin.c */

#include <windows.h>
#include <process.h>
#include <windowsx.h>
#include <stdio.h>
#include <signal.h>

#include "resource.h"
#include "w_youbin.h"
#include "userdata.h"

LRESULT CALLBACK WindowFunc(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK DialogFunc(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK dialog_func_message_option(HWND ,
		UINT, WPARAM, LPARAM);

void w_youbin_init(HWND, HINSTANCE);
void w_youbin_exit(HWND);
void w_repaint(HWND);
void set_mailarrive(HWND hwnd);
void reset_mailarrive(HWND hwnd);
void ys_caller(HWND hwnd);
void w_show_message(HINSTANCE g_hInstance,HWND hwnd);
void w_show_message_current(HINSTANCE g_hInstance, HWND hwnd);
void w_disp_win(HWND);
void w_disp_tsk(HWND);
void w_flash_icon();
BOOL reg_read_user();
BOOL reg_read_win_pos(int *left, int *top);
void reg_write_win_pos(int left,int top);
void change_disp_win_top(HWND hwnd);
int check_disp_win_top();

char szWinName[] = "W_YOUBIN"; /* ɥ饹̾ */
HINSTANCE g_hInstance;

int WINAPI WinMain(HINSTANCE hThisInst, HINSTANCE hPrevInst,
				   LPSTR lpszArgs, int nWinMode)
{
	HWND hwnd;
	MSG msg;
	WNDCLASSEX wcl;
	int dlg;
	unsigned long ys_thread;
	HANDLE hMutex;

	/* ¿ŵưɻ߽ */
	hMutex = OpenMutex(MUTEX_ALL_ACCESS, FALSE, "W_YOUBIN");
	if(hMutex){
		CloseHandle(hMutex);
		return FALSE;
	}
	hMutex = CreateMutex( FALSE, 0, "W_YOUBIN");

	g_hInstance = hThisInst;

	/* ɥ饹 */
	wcl.hInstance = hThisInst;		/* Υ󥹥󥹤ؤΥϥɥ */
	wcl.lpszClassName = szWinName;	/* ɥ饹̾ */
	wcl.lpfnWndProc = WindowFunc;	/* ɥؿ */
	wcl.style = CS_DBLCLKS; 		/* ǥեȥ */

	wcl.cbSize = sizeof(WNDCLASSEX);
							/* WNDCLASSEX¤ΤΥꤹ */

	wcl.hIcon = (HICON)LoadImage( hThisInst,
						MAKEINTRESOURCE(WYOU_SICON_N),
						IMAGE_ICON, 32, 32, 0); 	/* 顼 */
	wcl.hIconSm = (HICON)LoadImage( hThisInst,
						MAKEINTRESOURCE(WYOU_SICON_N),
						IMAGE_ICON, 16, 16, 0); 	/* ⡼륢 */

	wcl.hCursor = LoadCursor(NULL, IDC_ARROW);		/* 륹 */
	wcl.lpszMenuName = NULL;						/* ˥塼ʤ */

	wcl.cbClsExtra = 0;
	wcl.cbWndExtra = 0;

	wcl.hbrBackground = (HBRUSH) GetStockObject(BLACK_BRUSH);

	/* ɥ饹Ͽ */
	if(!RegisterClassEx(&wcl)) return 0;

	hwnd = CreateWindow(
		szWinName,				/* ɥ饹̾ */
		"Youbin",				/* ȥ */
		WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX
		,	/* ɥ */
		CW_USEDEFAULT,			/* غɸWindowsˤޤ */
		CW_USEDEFAULT,			/* ٺɸWindowsˤޤ */
		120,						/*  */
		GetSystemMetrics(SM_CYCAPTION) + 2 * GetSystemMetrics(SM_CYEDGE)
		+ 2 * GetSystemMetrics(SM_CYBORDER) +72,
		/* ⤵ */
		HWND_DESKTOP,			/* ƥɥʤ */
		NULL,					/* ˥塼ʤ */
		hThisInst,	/* ΥץΥ󥹥󥹤Υϥɥ */
		NULL		/* ɲðʤ */
	);
	reg_read_user();

	if( get_dlg_check() ){
		dlg = DialogBox(hThisInst, "DATA_INPUT", hwnd, DialogFunc);
		if(dlg == 0){
			exit(0);
		}
	}

	ys_thread = _beginthread(ys_caller, 0, &hwnd);

	w_youbin_init(hwnd, hThisInst);
	/* å롼פ */
	while(GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg); /* ܡѤǽˤ */
		DispatchMessage(&msg);	/* Windows᤹ */
	}
	ReleaseMutex(hMutex);
	return msg.wParam;
}

/* ɥؿ */
LRESULT CALLBACK WindowFunc(HWND hwnd, UINT message,
							WPARAM wParam, LPARAM lParam)
{

	switch(message){
	case WM_CREATE:
		{
			int left,top;
			if( reg_read_win_pos(&left,&top) )
				MoveWindow( hwnd, left, top, 120,
					GetSystemMetrics(SM_CYCAPTION) + 2 * GetSystemMetrics(SM_CYEDGE)
					+ 2 * GetSystemMetrics(SM_CYBORDER) +72 , FALSE );
			return 0;
		}/* WM_CREATE */
	case WM_PAINT:
		w_repaint(hwnd);
		break;
	case WM_DESTROY:	/* ץλ */
		{
			RECT rect;

			if ( !(IsIconic(hwnd)) ){
				GetWindowRect( hwnd, &rect );
				reg_write_win_pos(rect.left,rect.top);
			}
			w_youbin_exit(hwnd);
	    raise(SIGTERM);
			PostQuitMessage(0);
		}
		break;
	case WM_LBUTTONDOWN:
		reset_mailarrive(hwnd);
		break;
	case WM_LBUTTONDBLCLK:
		w_show_message(g_hInstance,hwnd);
		reset_mailarrive(hwnd);
		break;
	case WM_RBUTTONUP:
		{
			POINT pt;
			HMENU hMenu;
			HMENU hSubMenu;

			pt.x = LOWORD(lParam);
			pt.y = HIWORD(lParam);
			ClientToScreen(hwnd, &pt);
			hMenu = LoadMenu( g_hInstance,
				MAKEINTRESOURCE(IDR_MENU_MAIN) );
			hSubMenu = GetSubMenu( hMenu, 0 );
	    CheckMenuRadioItem(hSubMenu,ID_MENUITEM_DISP_WIN,ID_MENUITEM_DISP_TSK,
					       ID_MENUITEM_DISP_WIN,MF_BYCOMMAND);
	    if( check_disp_win_top() )
			    CheckMenuItem(hSubMenu,ID_MENUITEM_DISP_WIN_TOP,MF_CHECKED);
			TrackPopupMenu( hSubMenu, TPM_LEFTALIGN |
				TPM_RIGHTBUTTON, pt.x, pt.y, 0, hwnd, NULL);
			return 0;
		}
	case W_YOUBIN_NONE_MAIL:
		reset_mailarrive(hwnd);
		break;
	case W_YOUBIN_HAVE_MAIL:
		set_mailarrive(hwnd);
	w_show_message_current(g_hInstance, hwnd);
		break;
	case NOTIFY_TRAYICON:
		{
			if( wParam == TRAY_ID ){
				switch( lParam ){
				case WM_LBUTTONDOWN:
					reset_mailarrive(hwnd);
					break;
				case WM_LBUTTONDBLCLK:
					SetForegroundWindow(hwnd);
					w_show_message(g_hInstance,hwnd);
					reset_mailarrive(hwnd);
					break;
				case WM_RBUTTONUP:
					{
						POINT pt;
						HMENU hMenu;
						HMENU hSubMenu;

						GetCursorPos( &pt );
						hMenu = LoadMenu( g_hInstance,
							MAKEINTRESOURCE(IDR_MENU_MAIN) );
						hSubMenu = GetSubMenu( hMenu, 0 );
			CheckMenuRadioItem(hSubMenu,ID_MENUITEM_DISP_WIN,ID_MENUITEM_DISP_TSK,
								       ID_MENUITEM_DISP_TSK,MF_BYCOMMAND);
			if( check_disp_win_top() )
				CheckMenuItem(hSubMenu,ID_MENUITEM_DISP_WIN_TOP,MF_CHECKED);
						TrackPopupMenu( hSubMenu, TPM_BOTTOMALIGN | TPM_LEFTALIGN |
							TPM_RIGHTBUTTON, pt.x, pt.y, 0, hwnd, NULL);
						break;
					}

				default:
					break;
				}
			}
		}
		return 0;
	case WM_TIMER:
		{
			w_flash_icon();
			return 0;
		}
	case WM_COMMAND:
		switch(LOWORD(wParam)){
		case ID_MENUITEM_USERDATA:
			{
				int dlg = 0;
				dlg = DialogBox(g_hInstance, "DATA_INPUT", hwnd, DialogFunc);
				if(dlg == 1)
					MessageBox(hwnd, "¸줿ϼưͭˤʤޤ", "ѹ", MB_OK);
				break;
			}
		case ID_MENUITEM_OPTION:
			{
				int dlg = 0;
				dlg = DialogBox(g_hInstance, "MESSAGE_OPTION", hwnd, dialog_func_message_option);
				break;
			}
		case ID_MENUITEM_DISP_WIN:
			w_disp_win(hwnd);
			break;
		case ID_MENUITEM_DISP_TSK:
			w_disp_tsk(hwnd);
			break;
		case ID_MENUITEM_DISP_WIN_TOP:
			change_disp_win_top(hwnd);
			break;
		case ID_MENUITEM_HELP:
	    MessageBox(hwnd, "޺", "إ", MB_OK);
			break;
		case ID_MENUITEM_VERSION:
			{
				char mess[256] = "Youbin for Windows  ver. ";
				strcat(mess, W_YOUBIN_VERSION);
				strcat(mess, "\nCopyright (C)  K.Maeda\n");
				MessageBox(hwnd, mess, "С", MB_OK);
			}
			break;
		case ID_MENUITEM_EXIT:
			{
				RECT rect;
				GetWindowRect( hwnd, &rect );
				reg_write_win_pos(rect.left,rect.top);
			}
			w_youbin_exit(hwnd);
	    raise(SIGTERM);
			PostQuitMessage(0);
			break;
		}
		break;
	default:
		/* 嵭ʳΥåWindows 95˽ */
		return DefWindowProc(hwnd, message, wParam, lParam);
	}
	return 0;
}
