/** 
 *  Yudit Unicode Editor Source File
 *
 *  GNU Copyright (C) 2002  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2001  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2000  Gaspar Sinai <gsinai@yudit.org>  
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef SToolBar_h
#define SToolBar_h

#include "stoolkit/SProperties.h"
#include "swidget/SPanel.h"
#include "swidget/SButton.h"
#include "swidget/SLabel.h"
#include "stoolkit/SBinVector.h"

/**
 * A caret that redraws itself differently for lr and rl text 
 */
class SToolBarListener
{
public:
  SToolBarListener(void);
  virtual ~SToolBarListener();
  virtual void buttonPressed (void* src, int button, bool accel)=0;
  virtual void buttonEnter (void* src, int button);
  virtual void buttonLeave (void* src, int button);
};

class SToolBar  : public SPanel, public SButtonListener
{
public:
  enum SButtonIndex {SS_OPEN=0, 
   SS_SAVE, SS_PRINT, SS_PRINT_PREVIEW, SS_FIND, SS_GOTO, 
   SS_UNDO, SS_REDO, SS_FINGER, SS_MAGNIFY_PLUS, SS_MAGNIFY_MINUS, 
   SS_FONT, SS_INPUT, SS_LINE_BREAK, SS_MAX };

  SToolBar (const SProperties props);
  virtual ~SToolBar ();

  SButton* buttons[SS_MAX];
  void setListener (SToolBarListener* listener);
  void setFileName (const SString& fileName, const SString& encoding);
  void inputChanged (const SStringVector& _inputs, unsigned int _current);

  virtual void buttonPressed (void* source, const SAccelerator* accel);
  virtual void leaveWindow (void* source);
  virtual void enterWindow (void* source);
  virtual void redraw(SWindow* w, int x, int y,
     unsigned int width ,unsigned int height);
  virtual void resize(const SDimension & d);
  unsigned int  currentFontSize;
  SStringVector fontsizes;
  unsigned int  currentInput;
  SStringVector inputs;
  unsigned int  currentFont;
  SStringVector fonts;

  enum SFormatIndex { SS_FORMAT_UNIX=0, SS_FORMAT_DOS, 
     SS_FORMAT_MAC, SS_FORMAT_LS, SS_FORMAT_PS };

  void setLineBreak (int index);
  SStringVector linebreakStrings;
  unsigned int  currentLineBreak;
  SStringVector linebreaks;

  void   setModified (bool flag);
  void   setPrinting (bool flag);
  bool   right;
  bool   modified;
  bool   printing;

private:
  SOpaqueLabel*     title;
  SOpaqueLabel*     titleEncoding;
  SLabel*           tooltip;

  void setFont (int index);
  void setFontSize (int index);
  void setInput (int index);
  void setButton (SButtonIndex index, const SString& txt);

  SDimension getMaxSize(SButton* b, const SStringVector&l, const SString& str);
  void setFAccelerator (SButton* b, unsigned int se, bool ctrl);
  int getFAccelerator (const SAccelerator* accel);
  unsigned int preferredWidth;
  SToolBarListener* listener;
  bool  xmanagerCludge;
};

#endif /* SToolBar_h */
