/** 
 *  Yudit Unicode Editor Source File
 *
 *  GNU Copyright (C) 2002  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2001  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2000  Gaspar Sinai <gsinai@yudit.org>  
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <swidget/SFrame.h>
#include <swidget/SLayout.h>
#include <swidget/SDrawing.h>
#include <stoolkit/SEvent.h>

class WML : public SFrameListener
{
public:
  virtual bool close (SPanel* comp) 
  {
    fprintf (stderr, "Closing window %lx\n", (unsigned long) comp);
    return true;
  };
};

int
main (int argc, char* argv[])
{
  SFrame *frame = new SFrame();
  WML *windowListener = new WML();
  frame->setFrameListener (windowListener);

  frame->forceLayout (SLayout ( SLocation (0,0), SLocation (40,40)));
  SDrawing* drawing = new SDrawing();
  
  drawing->forceLayout (
    SLayout (
       SLocation (5, 5),
       SLocation (35, 35),
       SLocation (0, 0),
       SLocation (100, 100))
  );

  SColor c("gray50");
  SColor metal((unsigned char) 73,
      (unsigned char) 121, (unsigned char) 134, (unsigned char) 255);
  drawing->setBackground (c);
  frame->setBackground (c);
  drawing->setTextBackground (SColor("black"));
  drawing->setForeground (SColor("green"), SColor("yellow"));


  frame->add (drawing);

  frame->resize(SDimension(200, 200));
  frame->setTitle ((argc == 2) ? argv[1] : "Drawing");
  frame->show();
  SEventHandler::start();
}
