/** 
 *  Yudit Unicode Editor Source File
 *
 *  GNU Copyright (C) 2002  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2001  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2000  Gaspar Sinai <gsinai@yudit.org>  
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <swidget/SFrame.h>
#include <swidget/SLayout.h>
#include <swidget/SFreeHand.h>
#include <stoolkit/SEvent.h>
#include <stoolkit/SUniMap.h>
#include <swindow/SFontImpl.h>

class WML : public SFrameListener
{
public:
  virtual bool close (SPanel* comp) 
  {
    fprintf (stderr, "Closing window %lx\n", (unsigned long) comp);
    SEventHandler::exit();
    return true;
  };
};

int
main (int argc, char* argv[])
{
  SString str;
  fprintf (stderr, "%d\n", str.hashCode());
  //unsigned int mod = str.hashCode() % 7;
  SUniMap::guessPath();
  SFontImpl::guessPath ();
  SLineCurve lc;
  lc.append (SLocation (0,0));
  lc.append (SLocation (3,4));
  fprintf (stderr, "len=%u\n", lc.length());
  lc.append (SLocation (6,0));
  fprintf (stderr, "len=%u distance=%u %u=%u\n", lc.length(), lc.distance(), lc.distance(1,2), lc.length(2));
  SFrame *frame = new SFrame();
  WML *windowListener = new WML();
  frame->setFrameListener (windowListener);

  SFreeHand* freehand = new SFreeHand();


  SColor c("gray50");
  SColor metal((unsigned char) 73,
      (unsigned char) 121, (unsigned char) 134, (unsigned char) 255);
  freehand->setBackground (c);
  frame->setBackground (c);
  freehand->setDrawingBackground (SColor("black"));
  freehand->setDrawingForeground (SColor("green"), SColor("yellow"));
  SDimension ps = freehand->getPreferredSize() + SDimension(10, 10);
  /* first set layout of components */
  freehand->setLayout (
    SLayout (
       SLocation (5, 5),
       SLocation ((int)ps.width-5, (int)ps.height-5),
       SLocation (0, 0),
       SLocation (100, 100))
  );
  frame->setLayout (SLayout (ps + SDimension (10,10)));
  frame->add (freehand);

/*
  freehand->resize(SDimension (ps.width-10, ps.height-10));
  freehand->forceLayout (
    SLayout (
       SLocation (5, 5),
       SLocation ((int)ps.width-5, (int)ps.height-5),
       SLocation (0, 0),
       SLocation (100, 100))
  );
*/
  frame->resize(SDimension (ps.width+10, ps.height+10));
  fprintf (stderr, "drawing-empty is %s\n", freehand->isOK() ? "ok" : "not ok");
  freehand->setConverter ("kanji");
  fprintf (stderr, "drawing-kanji is %s\n", freehand->isOK() ? "ok" : "not ok");
  freehand->setConverter ("hanzi");
  fprintf (stderr, "drawing-hanzi is %s\n", freehand->isOK() ? "ok" : "not ok");
  freehand->setConverter ("hanzi2");
  fprintf (stderr, "drawing-hanzi2 is %s\n", freehand->isOK() ? "ok" : "not ok");
  freehand->setConverter ("hanzi");
  fprintf (stderr, "drawing-hanzi is %s\n", freehand->isOK() ? "ok" : "not ok");
  freehand->setConverter ("hiragana");
  fprintf (stderr, "drawing-hiragana is %s\n", freehand->isOK() ? "ok" : "not ok");
  frame->resize(ps);
  frame->setMinimumSize (ps);

  frame->setTitle ((argc == 2) ? argv[1] : "Drawing");
  frame->show();
  SEventHandler::start();
  return 0;
}
