/** 
 *  Yudit Unicode Editor Source File
 *
 *  GNU Copyright (C) 2002  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2001  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2000  Gaspar Sinai <gsinai@yudit.org>  
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#include "stoolkit/SEvent.h"
#include "stoolkit/SIO.h"
#include "stoolkit/SIOStream.h"
#include <stdio.h>

main (int argc, char* argv[])
{
  if (argc < 3)
  {
    fprintf (stderr, "Usage: i|o command\n");
    return 1;
  }
  if (argv[1][0] == 'i')
  {
    SPipe p(argv[2]);
    SInputStream is = p.getInputStream();
    if (!is.isOK())
    {
      fprintf (stderr, "Usage: can not open input pipe %s\n",  argv[2]);
      return 1;
    }
    SString s;
    SReader r(is);
    if (!r.read(&s))
    {
      fprintf (stderr, "Usage: error reading input pipe %s\n",  argv[2]);
      return 1;
    }
    printf ("Read: %*.*s\n", SSARGS(s));
  }
  if (argv[1][0] == 'o')
  {
    SPipe p(argv[2]);
    SOutputStream os = p.getOutputStream();
    if (!os.isOK())
    {
      fprintf (stderr, "Usage: can not open output pipe %s\n",  argv[2]);
      return 1;
    }
    SPipe stdinn;
    SInputStream is = stdinn.getInputStream();
    SReader r(is, "\n");
    SString s;
    SWriter w(os);
    while  (r.read(&s) && s.size() > 0)
    {
      fprintf (stderr, "Reading %*.*s",  SSARGS(s));
      if (!w.write(s))
      {
        fprintf (stderr, "ERROR WRITING\n");
        return 1;
      }
    }
  }
  return 0;
}
