/** 
 *  Yudit Unicode Editor Source File
 *
 *  GNU Copyright (C) 1997-2006  Gaspar Sinai <gaspar@yudit.org>  
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 

#include "stoolkit/SExcept.h"
#include "swindow/SAwt.h"
#include "swindow/SGEngine.h"
#include "swindow/SFontImpl.h"

#ifdef USE_WINAPI
# include "swin32/SWin32.h"
# else
# if USE_X11
#  include "sx11/SX11Impl.h"
#  include "sx11/SX11Window.h"
# endif
#endif


/**
 * @author: Gaspar Sinai <gaspar@yudit.org>
 * @version: 2000-04-23
 * This is the abstract widget toolkit
 */

/**
 * This class should be implemented for a window toolkit implementation
 */
SAwtImpl::SAwtImpl()
{
}
SAwtImpl::~SAwtImpl()
{
}

SWindow*
SAwtImpl::getWindow (SWindowListener* l, const SString& name)
{
  return 0;
}

SFontNative*
SAwtImpl::getFont (const SString& enc)
{
  return 0;
}

/**
 * Set the encoder for locale conversions.
 */
void
SAwtImpl::setEncoding (const SString& encoder)
{
}

SAwt::SAwt (bool cacheOn, unsigned int cacheSize)
{
  if (!delegate)
  {
    SGEngine::setCacheSize (cacheSize);
    SGEngine::setCacheOn (cacheOn);

#ifdef USE_WINAPI
    SW32Impl* i = new SW32Impl();
    delegate =  (i->isOK()) ? i : 0;
    SW32Window::setPixmapCacheSize (cacheSize);
    SW32Window::setPixmapCacheOn (cacheOn);
#else
# if USE_X11
    SX11Impl* i = new SX11Impl();
    delegate =  (i->isOK()) ? i : 0;
    SX11Window::setPixmapCacheSize (cacheSize);
    SX11Window::setPixmapCacheOn (cacheOn);
# else
    delegate = 0;
#endif
#endif
  }
}
// Destroys the implementation.
SAwt::~SAwt ()
{
  if (delegate) delete delegate;
}

void
SAwt::setImpl (SAwtImpl* impl)
{
  delegate = impl;
}

SWindow*
SAwt::getWindow (SWindowListener* l, const SString& name)
{
  if (delegate==0) return 0;
  return delegate->getWindow(l, name);
}

SFontNative*
SAwt::getFont (const SString& enc)
{
  if (delegate==0) return 0;
  return delegate->getFont(enc);
}

void
SAwt::setEncoding (const SString& encoder)
{
  if (delegate==0) return;
  delegate->setEncoding(encoder);
}

bool
SAwt::implemented()
{
  return (delegate!=0);
}

SAwtImpl* SAwt::delegate = 0;
