/* mainview.h 
 * (c) 2002 Christian Tpp <c.toepp@gmx.de>
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#ifndef MAINVIEW_H
#define MAINVIEW_H

#include <qmainwindow.h>
#include <qpixmap.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qabstractlayout.h>
#include <qtoolbar.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qtabwidget.h>
#include <qstatusbar.h>
#include <qvaluelist.h>
#include <qtextbrowser.h>
#include <qcheckbox.h>
#include <qsizepolicy.h>
#include <qlistbox.h>
#include <qdatetimeedit.h>
#include <qmultilineedit.h>
#include <qmessagebox.h>
#include <qfile.h>
#include <qtranslator.h>
#include <qtextcodec.h>

#include "zbconfig.hh"
//#include "userparkview.hh"
#include "computerview.hh"
#include "cfg_cmp.hh"
#include "cfg_tf.hh"
#include "cfg_prod.hh"
#include "cfg_cli.hh"

class mainview:public QMainWindow
{
Q_OBJECT public:
    mainview ();
   ~mainview ();
  QStatusBar *status;
private:
  void initHead ();
  void initPark ();
  void initStatus ();
  void initTab ();
  void initHelp ();
  void initConfig ();
  void initConfiguration ();
  void viewConfiguration ();
  void viewStandard ();
private:
  // head
    QToolBar * mainBar;
  QPixmap logo;
  ZLabel *pixLabel;
  QComboBox *selectView;
  QPushButton *selectOk;
  QPixmap icoOk;
  QSpacerItem *space;
  // park
  QToolBar *parkBar;
  QGroupBox *parkGroup;
  QLabel *userParkView;
  //typedef QValueList < userparkview * >parkList;
  parkList parkView;
  // tabs
  QTabWidget *tabView;
  QLabel *testLabel;
  tarifList tarife;
  zbconfig *zbCfg;
  productList prod;
  groupList groups;
  int tabWidth;
  int tabHeight;
  unsigned int maxItems;
  QString curency;
  bool CfgWrite;
  companyInfo company;
  int parkCount;
  printInfo prints;
  //////////////////////////
  // configuration view
  QTabWidget *cfgTab;
  QToolBar *cfgHelpBar;
  QGroupBox *cfgHelpBox;
  QTextBrowser *cfgHelp;
  // company info (cmp*)
  cfg_cmp *cmpWidget;
  // tarife (tf*)
  cfg_tf *tfWidget;
  // additional items (adi*)
  cfg_prod *adiWidget;
  // clients (cli*)
  cfg_cli *cliWidget;
  private slots:void slotResize ();
  void slotSelect (int i);
  void slotSelectOk ();
  void slotConfigChanged ();
  void slotCurencyChanged (QString s);
  void slotUserDropped (QString oldView, QString newView, QString type);
  void slotAbout ();
  void slotNewCompUser(zbuser *usr, QString group, QString client);
  void slotNewParkUser(zbuser *usr);
  void updUser();
};

#endif
