/* server.cc */

#include "server.hh"

#define PORT 7010

server::server (QObject * parent, const char *name):
QObject (parent, name)
{
  if (name != NULL)
    {
      sock = new QSocket (this);
      sock->connectToHost (name, PORT);
      hostName = name;
    }
}

server::~server ()
{
  if (name () == NULL)
    return;
  sock->close ();
}

void
server::stopComputer ()
{
  if (name () == NULL)
    return;
  sendCmd ("<ZEIBERBUDE><STOP /></ZEIBERBUDE>");
}

void
server::startComputer ()
{
  if (name () == NULL)
    return;
  sendCmd ("<ZEIBERBUDE><START /></ZEIBERBUDE>");
}

void
server::sendStatus (QString time, QString price)
{
  QString buf;
  QString msg =
    "<ZEIBERBUDE><STATUS TIME=\"" + time + "\" PRICE=\"" + price +
    "\" /></ZEIBERBUDE>";
  sendCmd (msg);
}

void
server::sendCmd (QString msg)
{
  //sock = new QSocket(this);
  sock->connectToHost(hostName,PORT);
  //if(sock->state() != QSocket::Connected)
  //	return;
  QTextStream s (sock);
  s << msg << "\n";
}
