/* userparkview.hh 
 * (c) 2002 Christian Tpp <c.toepp@gmx.de>
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef USERPARKVIEW_H
#define USERPARKVIEW_H
#include <qgroupbox.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qlayout.h>
#include <qpixmap.h>
#include <qlistbox.h>
#include <qdragobject.h>
#include <qmessagebox.h>
#include <qdragobject.h>
#include <qgrid.h>
#include "zbbutton.hh"
#include "zbuser.hh"
//#include "zbconfig.hh"
#include "newuser.hh"
#include "zblabel.hh"
#include "computerview.hh"
#include "zbtabwidget.hh"

typedef struct compInfo
{
  QString name;
  QString address;
  int number;
  computerview *view;
}
compInfo;
typedef QValueList < compInfo > compList;

typedef struct groupInfo
{
  QString name;
  compList comp;
  zbtabwidget *priv;
  QGrid *grid;
}
groupInfo;
typedef QValueList < groupInfo > groupList;

typedef struct companyInfo
{
  QString name;
  QString owner;
  QString street;
  QString zip;
  QString city;
  QString tel;
  QString fax;
  QString mail;
  QString web;
}
companyInfo;

class userparkview:public QGroupBox
{
Q_OBJECT public:
    userparkview (QWidget * parent, QString title, tarifList * tfList,
		  groupList * gList, productList * pList, printInfo * prints,
		  const char *name = 0);
   ~userparkview ();
  zbuser *zbUser;
  void setOff ();
  bool isOn();
  void setOn();
private:
  void initView ();
  void initData();
  void dragEnterEvent (QDragEnterEvent * event);
  void dragLeaveEvent (QDragLeaveEvent * event);
  void dropEvent (QDropEvent * event);
  void updateMenu();
  void setTarif(int i);
  void addProd(int i);
  void addPrint();
  void delUser();
private:
  // frei
    tarifList * tarife;
  groupList *groups;
  productList *prods;
  printInfo *pInfo;
  QPixmap icoOk;
  QWidget *freeWidget;
  QGridLayout *freeGrid;
  QLabel *freeLabel;
  zbbutton *newUser;
  // belegt
  QWidget *belWidget;
  QGridLayout *grid;
  QHBoxLayout *hbox;
  QLabel *timeView;
  QLabel *priceView;
  QLabel *curency;
  QComboBox *menuBox;
  QPixmap icoLedYellow;
  QPixmap icoLedRed;
  QPixmap griff;
  ZLabel *lbGriff;
  int menuTarifId;
  int menuProdId;
  int menuPrintId;
private slots:
  void slotNewUser ();
  void slotMenu (int i);
  void slotNameChanged (QString s);
  void slotTimeChanged (QTime t);
  void slotPriceChanged (float p);
  void startDrag ();
  void slotUpdateUser() {emit updateUser();}
  signals:
  void updateUser();
};
typedef QValueList < userparkview * >parkList;
#endif
