/* zeitgeist-fts.c generated by valac 0.14.2, the Vala compiler
 * generated from zeitgeist-fts.vala, do not modify */

/* zeitgeist-fts.vala
 *
 * Copyright © 2012 Canonical Ltd.
 * Copyright © 2012 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <zeitgeist-internal.h>
#include <fts.h>
#include <float.h>
#include <math.h>
#include <signal.h>
#include <stdio.h>
#include <config.h>


#define ZEITGEIST_TYPE_REMOTE_DBUS (zeitgeist_remote_dbus_get_type ())
#define ZEITGEIST_REMOTE_DBUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_REMOTE_DBUS, ZeitgeistRemoteDBus))
#define ZEITGEIST_IS_REMOTE_DBUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_REMOTE_DBUS))
#define ZEITGEIST_REMOTE_DBUS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZEITGEIST_TYPE_REMOTE_DBUS, ZeitgeistRemoteDBusIface))

typedef struct _ZeitgeistRemoteDBus ZeitgeistRemoteDBus;
typedef struct _ZeitgeistRemoteDBusIface ZeitgeistRemoteDBusIface;

#define ZEITGEIST_TYPE_REMOTE_DBUS_PROXY (zeitgeist_remote_dbus_proxy_get_type ())
typedef GDBusProxy ZeitgeistRemoteDBusProxy;
typedef GDBusProxyClass ZeitgeistRemoteDBusProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define ZEITGEIST_TYPE_FTS_DAEMON (zeitgeist_fts_daemon_get_type ())
#define ZEITGEIST_FTS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_FTS_DAEMON, ZeitgeistFtsDaemon))
#define ZEITGEIST_FTS_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_FTS_DAEMON, ZeitgeistFtsDaemonClass))
#define ZEITGEIST_IS_FTS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_FTS_DAEMON))
#define ZEITGEIST_IS_FTS_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_FTS_DAEMON))
#define ZEITGEIST_FTS_DAEMON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_FTS_DAEMON, ZeitgeistFtsDaemonClass))

typedef struct _ZeitgeistFtsDaemon ZeitgeistFtsDaemon;
typedef struct _ZeitgeistFtsDaemonClass ZeitgeistFtsDaemonClass;
typedef struct _ZeitgeistFtsDaemonPrivate ZeitgeistFtsDaemonPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _zeitgeist_indexer_free0(var) ((var == NULL) ? NULL : (var = (zeitgeist_indexer_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _ZeitgeistFtsDaemonNotifyInsertData ZeitgeistFtsDaemonNotifyInsertData;
typedef struct _ZeitgeistFtsDaemonNotifyDeleteData ZeitgeistFtsDaemonNotifyDeleteData;
typedef struct _ZeitgeistFtsDaemonSearchData ZeitgeistFtsDaemonSearchData;
typedef struct _ZeitgeistFtsDaemonSearchWithRelevanciesData ZeitgeistFtsDaemonSearchWithRelevanciesData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _ZeitgeistRemoteDBusIface {
	GTypeInterface parent_iface;
	gboolean (*name_has_owner) (ZeitgeistRemoteDBus* self, const gchar* name, GError** error);
};

struct _ZeitgeistFtsDaemon {
	GObject parent_instance;
	ZeitgeistFtsDaemonPrivate * priv;
};

struct _ZeitgeistFtsDaemonClass {
	GObjectClass parent_class;
};

struct _ZeitgeistFtsDaemonPrivate {
	ZeitgeistDbReader* engine;
	ZeitgeistIndexer* indexer;
	guint indexer_register_id;
	guint monitor_register_id;
	GDBusConnection* connection;
};

struct _ZeitgeistFtsDaemonNotifyInsertData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ZeitgeistFtsDaemon* self;
	GVariant* time_range;
	GVariant* events;
	GVariant* _tmp0_;
	GPtrArray* _tmp1_;
	GPtrArray* events_arr;
	ZeitgeistIndexer* _tmp2_;
	GError * _inner_error_;
};

struct _ZeitgeistFtsDaemonNotifyDeleteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ZeitgeistFtsDaemon* self;
	GVariant* time_range;
	guint32* event_ids;
	gint event_ids_length1;
	ZeitgeistIndexer* _tmp0_;
	guint32* _tmp1_;
	gint _tmp1__length1;
};

struct _ZeitgeistFtsDaemonSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ZeitgeistFtsDaemon* self;
	gchar* query_string;
	GVariant* time_range;
	GVariant* filter_templates;
	guint offset;
	guint count;
	guint result_type;
	GVariant* events;
	guint matches;
	GVariant* _tmp0_;
	ZeitgeistTimeRange* _tmp1_;
	ZeitgeistTimeRange* tr;
	GVariant* _tmp2_;
	GPtrArray* _tmp3_;
	GPtrArray* templates;
	ZeitgeistFtsDaemon* _tmp4_;
	ZeitgeistIndexer* _tmp5_;
	const gchar* _tmp6_;
	ZeitgeistTimeRange* _tmp7_;
	GPtrArray* _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	GPtrArray* _tmp13_;
	GPtrArray* results;
	GPtrArray* _tmp14_;
	GVariant* _tmp15_;
	GError * _inner_error_;
};

struct _ZeitgeistFtsDaemonSearchWithRelevanciesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ZeitgeistFtsDaemon* self;
	gchar* query_string;
	GVariant* time_range;
	GVariant* filter_templates;
	guint storage_state;
	guint offset;
	guint count;
	guint result_type;
	GVariant* events;
	gdouble* relevancies;
	gint relevancies_length1;
	guint matches;
	GVariant* _tmp0_;
	ZeitgeistTimeRange* _tmp1_;
	ZeitgeistTimeRange* tr;
	GVariant* _tmp2_;
	GPtrArray* _tmp3_;
	GPtrArray* templates;
	ZeitgeistFtsDaemon* _tmp4_;
	ZeitgeistIndexer* _tmp5_;
	const gchar* _tmp6_;
	ZeitgeistTimeRange* _tmp7_;
	GPtrArray* _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	gdouble* _tmp13_;
	gint _tmp14_;
	guint _tmp15_;
	GPtrArray* _tmp16_;
	GPtrArray* results;
	GPtrArray* _tmp17_;
	GVariant* _tmp18_;
	GError * _inner_error_;
};


static gpointer zeitgeist_fts_daemon_parent_class = NULL;
static gboolean zeitgeist_fts_daemon_show_version_info;
static gboolean zeitgeist_fts_daemon_show_version_info = FALSE;
static gchar* zeitgeist_fts_daemon_log_level;
static gchar* zeitgeist_fts_daemon_log_level = NULL;
static ZeitgeistFtsDaemon* zeitgeist_fts_daemon_instance;
static ZeitgeistFtsDaemon* zeitgeist_fts_daemon_instance = NULL;
static GMainLoop* zeitgeist_fts_daemon_mainloop;
static GMainLoop* zeitgeist_fts_daemon_mainloop = NULL;
static gboolean zeitgeist_fts_daemon_name_acquired;
static gboolean zeitgeist_fts_daemon_name_acquired = FALSE;
static gboolean zeitgeist_fts_daemon_zeitgeist_up;
static gboolean zeitgeist_fts_daemon_zeitgeist_up = FALSE;
static ZeitgeistRemoteSimpleIndexerIface* zeitgeist_fts_daemon_zeitgeist_remote_simple_indexer_parent_iface = NULL;
static ZeitgeistRemoteMonitorIface* zeitgeist_fts_daemon_zeitgeist_remote_monitor_parent_iface = NULL;

GType zeitgeist_remote_dbus_proxy_get_type (void) G_GNUC_CONST;
guint zeitgeist_remote_dbus_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType zeitgeist_remote_dbus_get_type (void) G_GNUC_CONST;
gboolean zeitgeist_remote_dbus_name_has_owner (ZeitgeistRemoteDBus* self, const gchar* name, GError** error);
static void zeitgeist_remote_dbus_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static gboolean zeitgeist_remote_dbus_proxy_name_has_owner (ZeitgeistRemoteDBus* self, const gchar* name, GError** error);
static void zeitgeist_remote_dbus_proxy_zeitgeist_remote_dbus_interface_init (ZeitgeistRemoteDBusIface* iface);
static void _dbus_zeitgeist_remote_dbus_name_has_owner (ZeitgeistRemoteDBus* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void zeitgeist_remote_dbus_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* zeitgeist_remote_dbus_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean zeitgeist_remote_dbus_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _zeitgeist_remote_dbus_unregister_object (gpointer user_data);
GType zeitgeist_fts_daemon_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_FTS_DAEMON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_FTS_DAEMON, ZeitgeistFtsDaemonPrivate))
enum  {
	ZEITGEIST_FTS_DAEMON_DUMMY_PROPERTY
};
#define ZEITGEIST_FTS_DAEMON_DBUS_NAME "org.gnome.zeitgeist.SimpleIndexer"
#define ZEITGEIST_FTS_DAEMON_ZEITGEIST_DBUS_NAME "org.gnome.zeitgeist.Engine"
ZeitgeistFtsDaemon* zeitgeist_fts_daemon_new (GError** error);
ZeitgeistFtsDaemon* zeitgeist_fts_daemon_construct (GType object_type, GError** error);
static void zeitgeist_fts_daemon_close (ZeitgeistFtsDaemon* self);
void zeitgeist_fts_daemon_register_dbus_object (ZeitgeistFtsDaemon* self, GDBusConnection* conn, GError** error);
void zeitgeist_fts_daemon_unregister_dbus_object (ZeitgeistFtsDaemon* self);
static void zeitgeist_fts_daemon_real_notify_insert_data_free (gpointer _data);
static void zeitgeist_fts_daemon_real_notify_insert (ZeitgeistRemoteMonitor* base, GVariant* time_range, GVariant* events, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean zeitgeist_fts_daemon_real_notify_insert_co (ZeitgeistFtsDaemonNotifyInsertData* _data_);
static void zeitgeist_fts_daemon_real_notify_delete_data_free (gpointer _data);
static void zeitgeist_fts_daemon_real_notify_delete (ZeitgeistRemoteMonitor* base, GVariant* time_range, guint32* event_ids, int event_ids_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
static guint32* _vala_array_dup1 (guint32* self, int length);
static gboolean zeitgeist_fts_daemon_real_notify_delete_co (ZeitgeistFtsDaemonNotifyDeleteData* _data_);
static void zeitgeist_fts_daemon_real_search_data_free (gpointer _data);
static void zeitgeist_fts_daemon_real_search (ZeitgeistRemoteSimpleIndexer* base, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint offset, guint count, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean zeitgeist_fts_daemon_real_search_co (ZeitgeistFtsDaemonSearchData* _data_);
static void zeitgeist_fts_daemon_real_search_with_relevancies_data_free (gpointer _data);
static void zeitgeist_fts_daemon_real_search_with_relevancies (ZeitgeistRemoteSimpleIndexer* base, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint storage_state, guint offset, guint count, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean zeitgeist_fts_daemon_real_search_with_relevancies_co (ZeitgeistFtsDaemonSearchWithRelevanciesData* _data_);
static void zeitgeist_fts_daemon_name_acquired_callback (GDBusConnection* conn);
static void zeitgeist_fts_daemon_name_lost_callback (GDBusConnection* conn);
static void zeitgeist_fts_daemon_zeitgeist_vanished (void);
static void zeitgeist_fts_daemon_run (GError** error);
static void _zeitgeist_fts_daemon_name_acquired_callback_gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void _zeitgeist_fts_daemon_name_lost_callback_gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void __lambda0_ (void);
static void ___lambda0__gbus_name_appeared_callback (GDBusConnection* connection, const gchar* name, const gchar* name_owner, gpointer self);
static void _zeitgeist_fts_daemon_zeitgeist_vanished_gbus_name_vanished_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void zeitgeist_fts_daemon_safe_exit (void);
static gint zeitgeist_fts_daemon_main (gchar** args, int args_length1);
static void _zeitgeist_fts_daemon_safe_exit_sighandler_t (gint signal);
static void ____lambda1_ (void);
static void _____lambda1__glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
static void zeitgeist_fts_daemon_finalize (GObject* obj);

static const GDBusArgInfo _zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_name = {-1, "name", "s"};
static const GDBusArgInfo _zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_result = {-1, "result", "b"};
static const GDBusArgInfo * const _zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_in[] = {&_zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_name, NULL};
static const GDBusArgInfo * const _zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_out[] = {&_zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_result, NULL};
static const GDBusMethodInfo _zeitgeist_remote_dbus_dbus_method_info_name_has_owner = {-1, "NameHasOwner", (GDBusArgInfo **) (&_zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_in), (GDBusArgInfo **) (&_zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_out)};
static const GDBusMethodInfo * const _zeitgeist_remote_dbus_dbus_method_info[] = {&_zeitgeist_remote_dbus_dbus_method_info_name_has_owner, NULL};
static const GDBusSignalInfo * const _zeitgeist_remote_dbus_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _zeitgeist_remote_dbus_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _zeitgeist_remote_dbus_dbus_interface_info = {-1, "org.freedesktop.DBus", (GDBusMethodInfo **) (&_zeitgeist_remote_dbus_dbus_method_info), (GDBusSignalInfo **) (&_zeitgeist_remote_dbus_dbus_signal_info), (GDBusPropertyInfo **) (&_zeitgeist_remote_dbus_dbus_property_info)};
static const GDBusInterfaceVTable _zeitgeist_remote_dbus_dbus_interface_vtable = {zeitgeist_remote_dbus_dbus_interface_method_call, zeitgeist_remote_dbus_dbus_interface_get_property, zeitgeist_remote_dbus_dbus_interface_set_property};
static const GOptionEntry ZEITGEIST_FTS_DAEMON_options[3] = {{"version", 'v', 0, G_OPTION_ARG_NONE, &zeitgeist_fts_daemon_show_version_info, "Print program's version number and exit", NULL}, {"log-level", (gchar) 0, 0, G_OPTION_ARG_STRING, &zeitgeist_fts_daemon_log_level, "How much information should be printed; possible values: " "DEBUG, INFO, WARNING, ERROR, CRITICAL", "LEVEL"}, {NULL}};

gboolean zeitgeist_remote_dbus_name_has_owner (ZeitgeistRemoteDBus* self, const gchar* name, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return ZEITGEIST_REMOTE_DBUS_GET_INTERFACE (self)->name_has_owner (self, name, error);
}


static void zeitgeist_remote_dbus_base_init (ZeitgeistRemoteDBusIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType zeitgeist_remote_dbus_get_type (void) {
	static volatile gsize zeitgeist_remote_dbus_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_remote_dbus_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistRemoteDBusIface), (GBaseInitFunc) zeitgeist_remote_dbus_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType zeitgeist_remote_dbus_type_id;
		zeitgeist_remote_dbus_type_id = g_type_register_static (G_TYPE_INTERFACE, "ZeitgeistRemoteDBus", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (zeitgeist_remote_dbus_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (zeitgeist_remote_dbus_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) zeitgeist_remote_dbus_proxy_get_type);
		g_type_set_qdata (zeitgeist_remote_dbus_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.DBus");
		g_type_set_qdata (zeitgeist_remote_dbus_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) zeitgeist_remote_dbus_register_object);
		g_once_init_leave (&zeitgeist_remote_dbus_type_id__volatile, zeitgeist_remote_dbus_type_id);
	}
	return zeitgeist_remote_dbus_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (ZeitgeistRemoteDBusProxy, zeitgeist_remote_dbus_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (ZEITGEIST_TYPE_REMOTE_DBUS, zeitgeist_remote_dbus_proxy_zeitgeist_remote_dbus_interface_init) )
static void zeitgeist_remote_dbus_proxy_class_init (ZeitgeistRemoteDBusProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = zeitgeist_remote_dbus_proxy_g_signal;
}


static void zeitgeist_remote_dbus_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void zeitgeist_remote_dbus_proxy_init (ZeitgeistRemoteDBusProxy* self) {
}


static gboolean zeitgeist_remote_dbus_proxy_name_has_owner (ZeitgeistRemoteDBus* self, const gchar* name, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result;
	GVariant* _tmp0_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus", "NameHasOwner");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp0_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp0_);
	g_variant_unref (_tmp0_);
	g_object_unref (_reply_message);
	return _result;
}


static void zeitgeist_remote_dbus_proxy_zeitgeist_remote_dbus_interface_init (ZeitgeistRemoteDBusIface* iface) {
	iface->name_has_owner = zeitgeist_remote_dbus_proxy_name_has_owner;
}


static void _dbus_zeitgeist_remote_dbus_name_has_owner (ZeitgeistRemoteDBus* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* name = NULL;
	GVariant* _tmp1_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	result = zeitgeist_remote_dbus_name_has_owner (self, name, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (name);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void zeitgeist_remote_dbus_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "NameHasOwner") == 0) {
		_dbus_zeitgeist_remote_dbus_name_has_owner (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* zeitgeist_remote_dbus_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean zeitgeist_remote_dbus_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint zeitgeist_remote_dbus_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_zeitgeist_remote_dbus_dbus_interface_info), &_zeitgeist_remote_dbus_dbus_interface_vtable, data, _zeitgeist_remote_dbus_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _zeitgeist_remote_dbus_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


ZeitgeistFtsDaemon* zeitgeist_fts_daemon_construct (GType object_type, GError** error) {
	ZeitgeistFtsDaemon * self = NULL;
	ZeitgeistDbReader* _tmp0_;
	ZeitgeistDbReader* _tmp1_;
	ZeitgeistDbReader* _tmp2_;
	ZeitgeistIndexer* _tmp3_;
	ZeitgeistIndexer* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (ZeitgeistFtsDaemon*) g_object_new (object_type, NULL);
	_tmp0_ = zeitgeist_db_reader_new (&_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_object_unref0 (self->priv->engine);
	self->priv->engine = _tmp1_;
	_tmp2_ = self->priv->engine;
	_tmp3_ = zeitgeist_indexer_new (_tmp2_, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_zeitgeist_indexer_free0 (self->priv->indexer);
	self->priv->indexer = _tmp4_;
	return self;
}


ZeitgeistFtsDaemon* zeitgeist_fts_daemon_new (GError** error) {
	return zeitgeist_fts_daemon_construct (ZEITGEIST_TYPE_FTS_DAEMON, error);
}


static void zeitgeist_fts_daemon_close (ZeitgeistFtsDaemon* self) {
	ZeitgeistDbReader* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->engine;
	zeitgeist_db_reader_close (_tmp0_);
	_zeitgeist_indexer_free0 (self->priv->indexer);
	self->priv->indexer = NULL;
}


void zeitgeist_fts_daemon_register_dbus_object (ZeitgeistFtsDaemon* self, GDBusConnection* conn, GError** error) {
	GDBusConnection* _tmp0_;
	GDBusConnection* _tmp1_;
	guint _tmp2_ = 0U;
	guint _tmp3_;
	GDBusConnection* _tmp4_;
	guint _tmp5_ = 0U;
	guint _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	_tmp0_ = conn;
	self->priv->connection = _tmp0_;
	_tmp1_ = conn;
	_tmp2_ = zeitgeist_remote_simple_indexer_register_object ((ZeitgeistRemoteSimpleIndexer*) self, _tmp1_, "/org/gnome/zeitgeist/index/activity", &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	self->priv->indexer_register_id = _tmp3_;
	_tmp4_ = conn;
	_tmp5_ = zeitgeist_remote_monitor_register_object ((ZeitgeistRemoteMonitor*) self, _tmp4_, "/org/gnome/zeitgeist/monitor/special", &_inner_error_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	self->priv->monitor_register_id = _tmp6_;
}


void zeitgeist_fts_daemon_unregister_dbus_object (ZeitgeistFtsDaemon* self) {
	guint _tmp0_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->indexer_register_id;
	if (_tmp0_ != ((guint) 0)) {
		GDBusConnection* _tmp1_;
		guint _tmp2_;
		_tmp1_ = self->priv->connection;
		_tmp2_ = self->priv->indexer_register_id;
		g_dbus_connection_unregister_object (_tmp1_, _tmp2_);
		self->priv->indexer_register_id = (guint) 0;
	}
	_tmp3_ = self->priv->monitor_register_id;
	if (_tmp3_ != ((guint) 0)) {
		GDBusConnection* _tmp4_;
		guint _tmp5_;
		_tmp4_ = self->priv->connection;
		_tmp5_ = self->priv->monitor_register_id;
		g_dbus_connection_unregister_object (_tmp4_, _tmp5_);
		self->priv->monitor_register_id = (guint) 0;
	}
}


static void zeitgeist_fts_daemon_real_notify_insert_data_free (gpointer _data) {
	ZeitgeistFtsDaemonNotifyInsertData* _data_;
	_data_ = _data;
	_g_variant_unref0 (_data_->time_range);
	_g_variant_unref0 (_data_->events);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistFtsDaemonNotifyInsertData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static void zeitgeist_fts_daemon_real_notify_insert (ZeitgeistRemoteMonitor* base, GVariant* time_range, GVariant* events, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistFtsDaemon * self;
	ZeitgeistFtsDaemonNotifyInsertData* _data_;
	ZeitgeistFtsDaemon* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	self = (ZeitgeistFtsDaemon*) base;
	_data_ = g_slice_new0 (ZeitgeistFtsDaemonNotifyInsertData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, zeitgeist_fts_daemon_real_notify_insert);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, zeitgeist_fts_daemon_real_notify_insert_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = time_range;
	_tmp2_ = _g_variant_ref0 (_tmp1_);
	_data_->time_range = _tmp2_;
	_tmp3_ = events;
	_tmp4_ = _g_variant_ref0 (_tmp3_);
	_data_->events = _tmp4_;
	zeitgeist_fts_daemon_real_notify_insert_co (_data_);
}


static void zeitgeist_fts_daemon_real_notify_insert_finish (ZeitgeistRemoteMonitor* base, GAsyncResult* _res_, GError** error) {
	ZeitgeistFtsDaemonNotifyInsertData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean zeitgeist_fts_daemon_real_notify_insert_co (ZeitgeistFtsDaemonNotifyInsertData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("zeitgeist-fts.vala:105: got insertion notification");
	_data_->_tmp0_ = _data_->events;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = zeitgeist_events_from_variant (_data_->_tmp0_, &_data_->_inner_error_);
	_data_->events_arr = _data_->_tmp1_;
	if (_data_->_inner_error_ != NULL) {
		if ((_data_->_inner_error_->domain == G_IO_ERROR) || (_data_->_inner_error_->domain == ZEITGEIST_ENGINE_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp2_ = _data_->self->priv->indexer;
	zeitgeist_indexer_index_events (_data_->_tmp2_, _data_->events_arr);
	_g_ptr_array_unref0 (_data_->events_arr);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void zeitgeist_fts_daemon_real_notify_delete_data_free (gpointer _data) {
	ZeitgeistFtsDaemonNotifyDeleteData* _data_;
	_data_ = _data;
	_g_variant_unref0 (_data_->time_range);
	_data_->event_ids = (g_free (_data_->event_ids), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistFtsDaemonNotifyDeleteData, _data_);
}


static guint32* _vala_array_dup1 (guint32* self, int length) {
	return g_memdup (self, length * sizeof (guint32));
}


static void zeitgeist_fts_daemon_real_notify_delete (ZeitgeistRemoteMonitor* base, GVariant* time_range, guint32* event_ids, int event_ids_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistFtsDaemon * self;
	ZeitgeistFtsDaemonNotifyDeleteData* _data_;
	ZeitgeistFtsDaemon* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	guint32* _tmp3_;
	gint _tmp3__length1;
	guint32* _tmp4_;
	gint _tmp4__length1;
	self = (ZeitgeistFtsDaemon*) base;
	_data_ = g_slice_new0 (ZeitgeistFtsDaemonNotifyDeleteData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, zeitgeist_fts_daemon_real_notify_delete);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, zeitgeist_fts_daemon_real_notify_delete_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = time_range;
	_tmp2_ = _g_variant_ref0 (_tmp1_);
	_data_->time_range = _tmp2_;
	_tmp3_ = event_ids;
	_tmp3__length1 = event_ids_length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup1 (_tmp3_, _tmp3__length1) : ((gpointer) _tmp3_);
	_tmp4__length1 = _tmp3__length1;
	_data_->event_ids = _tmp4_;
	_data_->event_ids_length1 = _tmp4__length1;
	zeitgeist_fts_daemon_real_notify_delete_co (_data_);
}


static void zeitgeist_fts_daemon_real_notify_delete_finish (ZeitgeistRemoteMonitor* base, GAsyncResult* _res_, GError** error) {
	ZeitgeistFtsDaemonNotifyDeleteData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean zeitgeist_fts_daemon_real_notify_delete_co (ZeitgeistFtsDaemonNotifyDeleteData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("zeitgeist-fts.vala:113: got deletion notification");
	_data_->_tmp0_ = _data_->self->priv->indexer;
	_data_->_tmp1_ = _data_->event_ids;
	_data_->_tmp1__length1 = _data_->event_ids_length1;
	zeitgeist_indexer_delete_events (_data_->_tmp0_, _data_->_tmp1_, _data_->_tmp1__length1);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void zeitgeist_fts_daemon_real_search_data_free (gpointer _data) {
	ZeitgeistFtsDaemonSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->query_string);
	_g_variant_unref0 (_data_->time_range);
	_g_variant_unref0 (_data_->filter_templates);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistFtsDaemonSearchData, _data_);
}


static void zeitgeist_fts_daemon_real_search (ZeitgeistRemoteSimpleIndexer* base, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint offset, guint count, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistFtsDaemon * self;
	ZeitgeistFtsDaemonSearchData* _data_;
	ZeitgeistFtsDaemon* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	self = (ZeitgeistFtsDaemon*) base;
	_data_ = g_slice_new0 (ZeitgeistFtsDaemonSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, zeitgeist_fts_daemon_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, zeitgeist_fts_daemon_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = query_string;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->query_string = _tmp2_;
	_tmp3_ = time_range;
	_tmp4_ = _g_variant_ref0 (_tmp3_);
	_data_->time_range = _tmp4_;
	_tmp5_ = filter_templates;
	_tmp6_ = _g_variant_ref0 (_tmp5_);
	_data_->filter_templates = _tmp6_;
	_tmp7_ = offset;
	_data_->offset = _tmp7_;
	_tmp8_ = count;
	_data_->count = _tmp8_;
	_tmp9_ = result_type;
	_data_->result_type = _tmp9_;
	zeitgeist_fts_daemon_real_search_co (_data_);
}


static void zeitgeist_fts_daemon_real_search_finish (ZeitgeistRemoteSimpleIndexer* base, GAsyncResult* _res_, GVariant** events, guint* matches, GError** error) {
	ZeitgeistFtsDaemonSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (events) {
		*events = _data_->events;
	} else {
		_g_variant_unref0 (_data_->events);
	}
	_data_->events = NULL;
	if (matches) {
		*matches = _data_->matches;
	}
}


static gboolean zeitgeist_fts_daemon_real_search_co (ZeitgeistFtsDaemonSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->time_range;
	_data_->_tmp1_ = zeitgeist_time_range_new_from_variant (_data_->_tmp0_, &_data_->_inner_error_);
	_data_->tr = _data_->_tmp1_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->filter_templates;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = zeitgeist_events_from_variant (_data_->_tmp2_, &_data_->_inner_error_);
	_data_->templates = _data_->_tmp3_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->tr);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = zeitgeist_fts_daemon_instance;
	_data_->_tmp5_ = _data_->_tmp4_->priv->indexer;
	_data_->_tmp6_ = _data_->query_string;
	_data_->_tmp7_ = _data_->tr;
	_data_->_tmp8_ = _data_->templates;
	_data_->_tmp9_ = _data_->offset;
	_data_->_tmp10_ = _data_->count;
	_data_->_tmp11_ = _data_->result_type;
	_data_->_tmp12_ = 0U;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = zeitgeist_indexer_search (_data_->_tmp5_, _data_->_tmp6_, _data_->_tmp7_, _data_->_tmp8_, _data_->_tmp9_, _data_->_tmp10_, (ZeitgeistResultType) _data_->_tmp11_, &_data_->_tmp12_, &_data_->_inner_error_);
	_data_->matches = _data_->_tmp12_;
	_data_->results = _data_->_tmp13_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_ptr_array_unref0 (_data_->templates);
		_g_object_unref0 (_data_->tr);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp14_ = _data_->results;
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = zeitgeist_events_to_variant (_data_->_tmp14_);
	_g_variant_unref0 (_data_->events);
	_data_->events = _data_->_tmp15_;
	_g_ptr_array_unref0 (_data_->results);
	_g_ptr_array_unref0 (_data_->templates);
	_g_object_unref0 (_data_->tr);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void zeitgeist_fts_daemon_real_search_with_relevancies_data_free (gpointer _data) {
	ZeitgeistFtsDaemonSearchWithRelevanciesData* _data_;
	_data_ = _data;
	_g_free0 (_data_->query_string);
	_g_variant_unref0 (_data_->time_range);
	_g_variant_unref0 (_data_->filter_templates);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistFtsDaemonSearchWithRelevanciesData, _data_);
}


static void zeitgeist_fts_daemon_real_search_with_relevancies (ZeitgeistRemoteSimpleIndexer* base, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint storage_state, guint offset, guint count, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistFtsDaemon * self;
	ZeitgeistFtsDaemonSearchWithRelevanciesData* _data_;
	ZeitgeistFtsDaemon* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	self = (ZeitgeistFtsDaemon*) base;
	_data_ = g_slice_new0 (ZeitgeistFtsDaemonSearchWithRelevanciesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, zeitgeist_fts_daemon_real_search_with_relevancies);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, zeitgeist_fts_daemon_real_search_with_relevancies_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = query_string;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->query_string = _tmp2_;
	_tmp3_ = time_range;
	_tmp4_ = _g_variant_ref0 (_tmp3_);
	_data_->time_range = _tmp4_;
	_tmp5_ = filter_templates;
	_tmp6_ = _g_variant_ref0 (_tmp5_);
	_data_->filter_templates = _tmp6_;
	_tmp7_ = storage_state;
	_data_->storage_state = _tmp7_;
	_tmp8_ = offset;
	_data_->offset = _tmp8_;
	_tmp9_ = count;
	_data_->count = _tmp9_;
	_tmp10_ = result_type;
	_data_->result_type = _tmp10_;
	zeitgeist_fts_daemon_real_search_with_relevancies_co (_data_);
}


static void zeitgeist_fts_daemon_real_search_with_relevancies_finish (ZeitgeistRemoteSimpleIndexer* base, GAsyncResult* _res_, GVariant** events, gdouble** relevancies, int* relevancies_length1, guint* matches, GError** error) {
	ZeitgeistFtsDaemonSearchWithRelevanciesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (events) {
		*events = _data_->events;
	} else {
		_g_variant_unref0 (_data_->events);
	}
	_data_->events = NULL;
	if (relevancies) {
		*relevancies = _data_->relevancies;
	} else {
		_data_->relevancies = (g_free (_data_->relevancies), NULL);
	}
	if (relevancies_length1) {
		*relevancies_length1 = _data_->relevancies_length1;
	}
	_data_->relevancies = NULL;
	if (matches) {
		*matches = _data_->matches;
	}
}


static gboolean zeitgeist_fts_daemon_real_search_with_relevancies_co (ZeitgeistFtsDaemonSearchWithRelevanciesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->time_range;
	_data_->_tmp1_ = zeitgeist_time_range_new_from_variant (_data_->_tmp0_, &_data_->_inner_error_);
	_data_->tr = _data_->_tmp1_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->filter_templates;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = zeitgeist_events_from_variant (_data_->_tmp2_, &_data_->_inner_error_);
	_data_->templates = _data_->_tmp3_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->tr);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = zeitgeist_fts_daemon_instance;
	_data_->_tmp5_ = _data_->_tmp4_->priv->indexer;
	_data_->_tmp6_ = _data_->query_string;
	_data_->_tmp7_ = _data_->tr;
	_data_->_tmp8_ = _data_->templates;
	_data_->_tmp9_ = _data_->storage_state;
	_data_->_tmp10_ = _data_->offset;
	_data_->_tmp11_ = _data_->count;
	_data_->_tmp12_ = _data_->result_type;
	_data_->_tmp13_ = NULL;
	_data_->_tmp14_ = 0;
	_data_->_tmp15_ = 0U;
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = zeitgeist_indexer_search_with_relevancies (_data_->_tmp5_, _data_->_tmp6_, _data_->_tmp7_, _data_->_tmp8_, (ZeitgeistStorageState) _data_->_tmp9_, _data_->_tmp10_, _data_->_tmp11_, (ZeitgeistResultType) _data_->_tmp12_, &_data_->_tmp13_, &_data_->_tmp14_, &_data_->_tmp15_, &_data_->_inner_error_);
	_data_->relevancies = (g_free (_data_->relevancies), NULL);
	_data_->relevancies = _data_->_tmp13_;
	_data_->relevancies_length1 = _data_->_tmp14_;
	_data_->matches = _data_->_tmp15_;
	_data_->results = _data_->_tmp16_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_ptr_array_unref0 (_data_->templates);
		_g_object_unref0 (_data_->tr);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp17_ = _data_->results;
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = zeitgeist_events_to_variant (_data_->_tmp17_);
	_g_variant_unref0 (_data_->events);
	_data_->events = _data_->_tmp18_;
	_g_ptr_array_unref0 (_data_->results);
	_g_ptr_array_unref0 (_data_->templates);
	_g_object_unref0 (_data_->tr);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void zeitgeist_fts_daemon_name_acquired_callback (GDBusConnection* conn) {
	g_return_if_fail (conn != NULL);
	zeitgeist_fts_daemon_name_acquired = TRUE;
}


static void zeitgeist_fts_daemon_name_lost_callback (GDBusConnection* conn) {
	GDBusConnection* _tmp0_;
	_tmp0_ = conn;
	if (_tmp0_ == NULL) {
		GMainLoop* _tmp1_;
		_tmp1_ = zeitgeist_fts_daemon_mainloop;
		g_main_loop_quit (_tmp1_);
	} else {
		gboolean _tmp2_ = FALSE;
		ZeitgeistFtsDaemon* _tmp3_;
		gboolean _tmp5_;
		_tmp3_ = zeitgeist_fts_daemon_instance;
		if (_tmp3_ != NULL) {
			gboolean _tmp4_;
			_tmp4_ = zeitgeist_fts_daemon_name_acquired;
			_tmp2_ = _tmp4_;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp5_ = _tmp2_;
		if (_tmp5_) {
			GMainLoop* _tmp6_;
			_tmp6_ = zeitgeist_fts_daemon_mainloop;
			g_main_loop_quit (_tmp6_);
		}
	}
}


static void zeitgeist_fts_daemon_zeitgeist_vanished (void) {
	gboolean _tmp0_;
	_tmp0_ = zeitgeist_fts_daemon_zeitgeist_up;
	if (_tmp0_) {
		GMainLoop* _tmp1_;
		_tmp1_ = zeitgeist_fts_daemon_mainloop;
		g_main_loop_quit (_tmp1_);
	}
	zeitgeist_fts_daemon_zeitgeist_up = FALSE;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void _zeitgeist_fts_daemon_name_acquired_callback_gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	zeitgeist_fts_daemon_name_acquired_callback (connection);
}


static void _zeitgeist_fts_daemon_name_lost_callback_gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	zeitgeist_fts_daemon_name_lost_callback (connection);
}


static void __lambda0_ (void) {
	zeitgeist_fts_daemon_zeitgeist_up = TRUE;
}


static void ___lambda0__gbus_name_appeared_callback (GDBusConnection* connection, const gchar* name, const gchar* name_owner, gpointer self) {
	__lambda0_ ();
}


static void _zeitgeist_fts_daemon_zeitgeist_vanished_gbus_name_vanished_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	zeitgeist_fts_daemon_zeitgeist_vanished ();
}


static void zeitgeist_fts_daemon_run (GError** error) {
	GDBusConnection* _tmp0_ = NULL;
	GDBusConnection* connection;
	GDBusConnection* _tmp1_;
	ZeitgeistRemoteDBus* _tmp2_ = NULL;
	ZeitgeistRemoteDBus* proxy;
	ZeitgeistRemoteDBus* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	GDBusConnection* _tmp16_;
	guint _tmp17_ = 0U;
	guint owner_id;
	GMainLoop* _tmp18_;
	GMainLoop* _tmp19_;
	ZeitgeistFtsDaemon* _tmp20_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
	connection = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = connection;
	_tmp2_ = g_initable_new (ZEITGEIST_TYPE_REMOTE_DBUS_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", "org.freedesktop.DBus", "g-connection", _tmp1_, "g-object-path", "/org/freedesktop/DBus", "g-interface-name", "org.freedesktop.DBus", NULL);
	proxy = (ZeitgeistRemoteDBus*) _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (connection);
		return;
	}
	_tmp3_ = proxy;
	_tmp4_ = zeitgeist_remote_dbus_name_has_owner (_tmp3_, ZEITGEIST_FTS_DAEMON_DBUS_NAME, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (proxy);
		_g_object_unref0 (connection);
		return;
	}
	if (_tmp5_) {
		GError* _tmp6_;
		_tmp6_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_EXISTING_INSTANCE, "The FTS daemon is running already.");
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (proxy);
		_g_object_unref0 (connection);
		return;
	}
	{
		ZeitgeistFtsDaemon* _tmp7_;
		ZeitgeistFtsDaemon* _tmp8_;
		ZeitgeistFtsDaemon* _tmp9_;
		GDBusConnection* _tmp10_;
		_tmp7_ = zeitgeist_fts_daemon_new (&_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_g_object_unref0 (zeitgeist_fts_daemon_instance);
		zeitgeist_fts_daemon_instance = _tmp8_;
		_tmp9_ = zeitgeist_fts_daemon_instance;
		_tmp10_ = connection;
		zeitgeist_fts_daemon_register_dbus_object (_tmp9_, _tmp10_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp11_;
		GError* _tmp14_;
		GError* _tmp15_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = err;
		if (g_error_matches (_tmp11_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_CANTOPEN)) {
			const gchar* _tmp12_ = NULL;
			_tmp12_ = zeitgeist_utils_get_database_file_path ();
			g_warning ("Could not access the database file.\n" "Please check the permissions of file %s.", _tmp12_);
		} else {
			GError* _tmp13_;
			_tmp13_ = err;
			if (g_error_matches (_tmp13_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_BUSY)) {
				g_warning ("zeitgeist-fts.vala:213: %s", "It looks like another Zeitgeist instance " "is already running (the database is locked).");
			}
		}
		_tmp14_ = err;
		_tmp15_ = _g_error_copy0 (_tmp14_);
		_inner_error_ = _tmp15_;
		_g_error_free0 (err);
		goto __finally0;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (proxy);
		_g_object_unref0 (connection);
		return;
	}
	_tmp16_ = connection;
	_tmp17_ = g_bus_own_name_on_connection_with_closures (_tmp16_, ZEITGEIST_FTS_DAEMON_DBUS_NAME, G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) ((_zeitgeist_fts_daemon_name_acquired_callback_gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _zeitgeist_fts_daemon_name_acquired_callback_gbus_name_acquired_callback, NULL, NULL)), (GClosure*) ((_zeitgeist_fts_daemon_name_lost_callback_gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _zeitgeist_fts_daemon_name_lost_callback_gbus_name_lost_callback, NULL, NULL)));
	owner_id = _tmp17_;
	g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, ZEITGEIST_FTS_DAEMON_ZEITGEIST_DBUS_NAME, 0, (GClosure*) ((___lambda0__gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda0__gbus_name_appeared_callback, NULL, NULL)), (GClosure*) ((_zeitgeist_fts_daemon_zeitgeist_vanished_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _zeitgeist_fts_daemon_zeitgeist_vanished_gbus_name_vanished_callback, NULL, NULL)));
	_tmp18_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (zeitgeist_fts_daemon_mainloop);
	zeitgeist_fts_daemon_mainloop = _tmp18_;
	_tmp19_ = zeitgeist_fts_daemon_mainloop;
	g_main_loop_run (_tmp19_);
	_tmp20_ = zeitgeist_fts_daemon_instance;
	if (_tmp20_ != NULL) {
		ZeitgeistFtsDaemon* _tmp21_;
		guint _tmp22_;
		ZeitgeistFtsDaemon* _tmp23_;
		_tmp21_ = zeitgeist_fts_daemon_instance;
		zeitgeist_fts_daemon_close (_tmp21_);
		_tmp22_ = owner_id;
		g_bus_unown_name (_tmp22_);
		_tmp23_ = zeitgeist_fts_daemon_instance;
		zeitgeist_fts_daemon_unregister_dbus_object (_tmp23_);
		_g_object_unref0 (zeitgeist_fts_daemon_instance);
		zeitgeist_fts_daemon_instance = NULL;
		{
			GDBusConnection* _tmp24_;
			_tmp24_ = connection;
			g_dbus_connection_flush_sync (_tmp24_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp25_;
			const gchar* _tmp26_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp25_ = e;
			_tmp26_ = _tmp25_->message;
			g_warning ("zeitgeist-fts.vala:249: %s", _tmp26_);
			_g_error_free0 (e);
		}
		__finally1:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (proxy);
			_g_object_unref0 (connection);
			return;
		}
	}
	_g_object_unref0 (proxy);
	_g_object_unref0 (connection);
}


static void zeitgeist_fts_daemon_safe_exit (void) {
	GMainLoop* _tmp0_;
	_tmp0_ = zeitgeist_fts_daemon_mainloop;
	g_main_loop_quit (_tmp0_);
}


static void _zeitgeist_fts_daemon_safe_exit_sighandler_t (gint signal) {
	zeitgeist_fts_daemon_safe_exit ();
}


static void ____lambda1_ (void) {
}


static void _____lambda1__glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
	____lambda1_ ();
}


static gint zeitgeist_fts_daemon_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* _tmp0_;
	GOptionContext* opt_context;
	GOptionContext* _tmp1_;
	GError * _inner_error_ = NULL;
	signal (SIGHUP, _zeitgeist_fts_daemon_safe_exit_sighandler_t);
	signal (SIGINT, _zeitgeist_fts_daemon_safe_exit_sighandler_t);
	signal (SIGTERM, _zeitgeist_fts_daemon_safe_exit_sighandler_t);
	_tmp0_ = g_option_context_new (" - Zeitgeist FTS daemon");
	opt_context = _tmp0_;
	_tmp1_ = opt_context;
	g_option_context_add_main_entries (_tmp1_, ZEITGEIST_FTS_DAEMON_options, NULL);
	{
		GOptionContext* _tmp2_;
		gboolean _tmp3_;
		GLogLevelFlags discarded;
		const gchar* _tmp5_;
		GLogLevelFlags _tmp24_;
		_tmp2_ = opt_context;
		g_option_context_parse (_tmp2_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		_tmp3_ = zeitgeist_fts_daemon_show_version_info;
		if (_tmp3_) {
			FILE* _tmp4_;
			_tmp4_ = stdout;
			fprintf (_tmp4_, "%s", VERSION "\n");
			result = 0;
			_g_option_context_free0 (opt_context);
			return result;
		}
		discarded = G_LOG_LEVEL_DEBUG;
		_tmp5_ = zeitgeist_fts_daemon_log_level;
		if (_tmp5_ != NULL) {
			GLogLevelFlags ld;
			GLogLevelFlags li;
			GLogLevelFlags lm;
			GLogLevelFlags lw;
			GLogLevelFlags lc;
			const gchar* _tmp6_;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			GQuark _tmp10_ = 0U;
			static GQuark _tmp9_label0 = 0;
			static GQuark _tmp9_label1 = 0;
			static GQuark _tmp9_label2 = 0;
			static GQuark _tmp9_label3 = 0;
			static GQuark _tmp9_label4 = 0;
			ld = G_LOG_LEVEL_DEBUG;
			li = G_LOG_LEVEL_INFO;
			lm = G_LOG_LEVEL_MESSAGE;
			lw = G_LOG_LEVEL_WARNING;
			lc = G_LOG_LEVEL_CRITICAL;
			_tmp6_ = zeitgeist_fts_daemon_log_level;
			_tmp7_ = g_utf8_strup (_tmp6_, (gssize) (-1));
			_tmp8_ = _tmp7_;
			_tmp10_ = (NULL == _tmp8_) ? 0 : g_quark_from_string (_tmp8_);
			g_free (_tmp8_);
			if (_tmp10_ == ((0 != _tmp9_label0) ? _tmp9_label0 : (_tmp9_label0 = g_quark_from_static_string ("DEBUG")))) {
				switch (0) {
					default:
					{
						discarded = 0;
						break;
					}
				}
			} else if (_tmp10_ == ((0 != _tmp9_label1) ? _tmp9_label1 : (_tmp9_label1 = g_quark_from_static_string ("INFO")))) {
				switch (0) {
					default:
					{
						GLogLevelFlags _tmp11_;
						_tmp11_ = ld;
						discarded = _tmp11_;
						break;
					}
				}
			} else if (_tmp10_ == ((0 != _tmp9_label2) ? _tmp9_label2 : (_tmp9_label2 = g_quark_from_static_string ("WARNING")))) {
				switch (0) {
					default:
					{
						GLogLevelFlags _tmp12_;
						GLogLevelFlags _tmp13_;
						GLogLevelFlags _tmp14_;
						_tmp12_ = ld;
						_tmp13_ = li;
						_tmp14_ = lm;
						discarded = (_tmp12_ | _tmp13_) | _tmp14_;
						break;
					}
				}
			} else if (_tmp10_ == ((0 != _tmp9_label3) ? _tmp9_label3 : (_tmp9_label3 = g_quark_from_static_string ("CRITICAL")))) {
				switch (0) {
					default:
					{
						GLogLevelFlags _tmp15_;
						GLogLevelFlags _tmp16_;
						GLogLevelFlags _tmp17_;
						GLogLevelFlags _tmp18_;
						_tmp15_ = ld;
						_tmp16_ = li;
						_tmp17_ = lm;
						_tmp18_ = lw;
						discarded = ((_tmp15_ | _tmp16_) | _tmp17_) | _tmp18_;
						break;
					}
				}
			} else if (_tmp10_ == ((0 != _tmp9_label4) ? _tmp9_label4 : (_tmp9_label4 = g_quark_from_static_string ("ERROR")))) {
				switch (0) {
					default:
					{
						GLogLevelFlags _tmp19_;
						GLogLevelFlags _tmp20_;
						GLogLevelFlags _tmp21_;
						GLogLevelFlags _tmp22_;
						GLogLevelFlags _tmp23_;
						_tmp19_ = ld;
						_tmp20_ = li;
						_tmp21_ = lm;
						_tmp22_ = lw;
						_tmp23_ = lc;
						discarded = (((_tmp19_ | _tmp20_) | _tmp21_) | _tmp22_) | _tmp23_;
						break;
					}
				}
			}
		}
		_tmp24_ = discarded;
		if (_tmp24_ != 0) {
			GLogLevelFlags _tmp25_;
			_tmp25_ = discarded;
			g_log_set_handler ("", _tmp25_, _____lambda1__glog_func, NULL);
		} else {
			g_setenv ("G_MESSAGES_DEBUG", "all", TRUE);
		}
		zeitgeist_fts_daemon_run (&_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* err = NULL;
		GError* _tmp26_;
		GError* _tmp27_;
		GError* _tmp28_;
		const gchar* _tmp29_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp26_ = err;
		if (g_error_matches (_tmp26_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_CANTOPEN)) {
			result = 21;
			_g_error_free0 (err);
			_g_option_context_free0 (opt_context);
			return result;
		}
		_tmp27_ = err;
		if (g_error_matches (_tmp27_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_BUSY)) {
			result = 22;
			_g_error_free0 (err);
			_g_option_context_free0 (opt_context);
			return result;
		}
		_tmp28_ = err;
		_tmp29_ = _tmp28_->message;
		g_warning ("zeitgeist-fts.vala:325: %s", _tmp29_);
		result = 1;
		_g_error_free0 (err);
		_g_option_context_free0 (opt_context);
		return result;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (opt_context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	_g_option_context_free0 (opt_context);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return zeitgeist_fts_daemon_main (argv, argc);
}


static void zeitgeist_fts_daemon_class_init (ZeitgeistFtsDaemonClass * klass) {
	gchar* _tmp0_;
	zeitgeist_fts_daemon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistFtsDaemonPrivate));
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_fts_daemon_finalize;
	_tmp0_ = g_strdup ("");
	zeitgeist_fts_daemon_log_level = _tmp0_;
}


static void zeitgeist_fts_daemon_zeitgeist_remote_simple_indexer_interface_init (ZeitgeistRemoteSimpleIndexerIface * iface) {
	zeitgeist_fts_daemon_zeitgeist_remote_simple_indexer_parent_iface = g_type_interface_peek_parent (iface);
	iface->search = (void (*)(ZeitgeistRemoteSimpleIndexer*, const gchar*, GVariant*, GVariant*, guint, guint, guint, GVariant**, guint*, GError**)) zeitgeist_fts_daemon_real_search;
	iface->search_finish = zeitgeist_fts_daemon_real_search_finish;
	iface->search_with_relevancies = (void (*)(ZeitgeistRemoteSimpleIndexer*, const gchar*, GVariant*, GVariant*, guint, guint, guint, guint, GVariant**, gdouble**, int*, guint*, GError**)) zeitgeist_fts_daemon_real_search_with_relevancies;
	iface->search_with_relevancies_finish = zeitgeist_fts_daemon_real_search_with_relevancies_finish;
}


static void zeitgeist_fts_daemon_zeitgeist_remote_monitor_interface_init (ZeitgeistRemoteMonitorIface * iface) {
	zeitgeist_fts_daemon_zeitgeist_remote_monitor_parent_iface = g_type_interface_peek_parent (iface);
	iface->notify_insert = (void (*)(ZeitgeistRemoteMonitor*, GVariant*, GVariant*, GError**)) zeitgeist_fts_daemon_real_notify_insert;
	iface->notify_insert_finish = zeitgeist_fts_daemon_real_notify_insert_finish;
	iface->notify_delete = (void (*)(ZeitgeistRemoteMonitor*, GVariant*, guint32*, int, GError**)) zeitgeist_fts_daemon_real_notify_delete;
	iface->notify_delete_finish = zeitgeist_fts_daemon_real_notify_delete_finish;
}


static void zeitgeist_fts_daemon_instance_init (ZeitgeistFtsDaemon * self) {
	self->priv = ZEITGEIST_FTS_DAEMON_GET_PRIVATE (self);
}


static void zeitgeist_fts_daemon_finalize (GObject* obj) {
	ZeitgeistFtsDaemon * self;
	self = ZEITGEIST_FTS_DAEMON (obj);
	_g_object_unref0 (self->priv->engine);
	_zeitgeist_indexer_free0 (self->priv->indexer);
	G_OBJECT_CLASS (zeitgeist_fts_daemon_parent_class)->finalize (obj);
}


GType zeitgeist_fts_daemon_get_type (void) {
	static volatile gsize zeitgeist_fts_daemon_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_fts_daemon_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistFtsDaemonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_fts_daemon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistFtsDaemon), 0, (GInstanceInitFunc) zeitgeist_fts_daemon_instance_init, NULL };
		static const GInterfaceInfo zeitgeist_remote_simple_indexer_info = { (GInterfaceInitFunc) zeitgeist_fts_daemon_zeitgeist_remote_simple_indexer_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo zeitgeist_remote_monitor_info = { (GInterfaceInitFunc) zeitgeist_fts_daemon_zeitgeist_remote_monitor_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType zeitgeist_fts_daemon_type_id;
		zeitgeist_fts_daemon_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistFtsDaemon", &g_define_type_info, 0);
		g_type_add_interface_static (zeitgeist_fts_daemon_type_id, ZEITGEIST_TYPE_REMOTE_SIMPLE_INDEXER, &zeitgeist_remote_simple_indexer_info);
		g_type_add_interface_static (zeitgeist_fts_daemon_type_id, ZEITGEIST_TYPE_REMOTE_MONITOR, &zeitgeist_remote_monitor_info);
		g_once_init_leave (&zeitgeist_fts_daemon_type_id__volatile, zeitgeist_fts_daemon_type_id);
	}
	return zeitgeist_fts_daemon_type_id__volatile;
}



