/* engine.c generated by valac 0.14.2, the Vala compiler
 * generated from engine.vala, do not modify */

/* engine.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *             By Seif Lotfy <seif@lotfy.com>
 *
 * Based upon a Python implementation (2009-2011) by:
 *  Markus Korn <thekorn@gmx.net>
 *  Mikkel Kamstrup Erlandsen <mikkel.kamstrup@gmail.com>
 *  Seif Lotfy <seif@lotfy.com>
 *  Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>


#define ZEITGEIST_TYPE_DB_READER (zeitgeist_db_reader_get_type ())
#define ZEITGEIST_DB_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReader))
#define ZEITGEIST_DB_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReaderClass))
#define ZEITGEIST_IS_DB_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_DB_READER))
#define ZEITGEIST_IS_DB_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_DB_READER))
#define ZEITGEIST_DB_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReaderClass))

typedef struct _ZeitgeistDbReader ZeitgeistDbReader;
typedef struct _ZeitgeistDbReaderClass ZeitgeistDbReaderClass;
typedef struct _ZeitgeistDbReaderPrivate ZeitgeistDbReaderPrivate;

#define ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP (zeitgeist_sq_lite_table_lookup_get_type ())
#define ZEITGEIST_SQ_LITE_TABLE_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP, ZeitgeistSQLiteTableLookup))
#define ZEITGEIST_SQ_LITE_TABLE_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP, ZeitgeistSQLiteTableLookupClass))
#define ZEITGEIST_SQ_LITE_IS_TABLE_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP))
#define ZEITGEIST_SQ_LITE_IS_TABLE_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP))
#define ZEITGEIST_SQ_LITE_TABLE_LOOKUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP, ZeitgeistSQLiteTableLookupClass))

typedef struct _ZeitgeistSQLiteTableLookup ZeitgeistSQLiteTableLookup;
typedef struct _ZeitgeistSQLiteTableLookupClass ZeitgeistSQLiteTableLookupClass;

#define ZEITGEIST_TYPE_ENGINE (zeitgeist_engine_get_type ())
#define ZEITGEIST_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngine))
#define ZEITGEIST_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngineClass))
#define ZEITGEIST_IS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_ENGINE))
#define ZEITGEIST_IS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_ENGINE))
#define ZEITGEIST_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngineClass))

typedef struct _ZeitgeistEngine ZeitgeistEngine;
typedef struct _ZeitgeistEngineClass ZeitgeistEngineClass;
typedef struct _ZeitgeistEnginePrivate ZeitgeistEnginePrivate;

#define ZEITGEIST_TYPE_EXTENSION_STORE (zeitgeist_extension_store_get_type ())
#define ZEITGEIST_EXTENSION_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EXTENSION_STORE, ZeitgeistExtensionStore))
#define ZEITGEIST_EXTENSION_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EXTENSION_STORE, ZeitgeistExtensionStoreClass))
#define ZEITGEIST_IS_EXTENSION_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EXTENSION_STORE))
#define ZEITGEIST_IS_EXTENSION_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EXTENSION_STORE))
#define ZEITGEIST_EXTENSION_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EXTENSION_STORE, ZeitgeistExtensionStoreClass))

typedef struct _ZeitgeistExtensionStore ZeitgeistExtensionStore;
typedef struct _ZeitgeistExtensionStoreClass ZeitgeistExtensionStoreClass;

#define ZEITGEIST_TYPE_EXTENSION_COLLECTION (zeitgeist_extension_collection_get_type ())
#define ZEITGEIST_EXTENSION_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EXTENSION_COLLECTION, ZeitgeistExtensionCollection))
#define ZEITGEIST_EXTENSION_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EXTENSION_COLLECTION, ZeitgeistExtensionCollectionClass))
#define ZEITGEIST_IS_EXTENSION_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EXTENSION_COLLECTION))
#define ZEITGEIST_IS_EXTENSION_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EXTENSION_COLLECTION))
#define ZEITGEIST_EXTENSION_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EXTENSION_COLLECTION, ZeitgeistExtensionCollectionClass))

typedef struct _ZeitgeistExtensionCollection ZeitgeistExtensionCollection;
typedef struct _ZeitgeistExtensionCollectionClass ZeitgeistExtensionCollectionClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define ZEITGEIST_SQ_LITE_TYPE_DATABASE (zeitgeist_sq_lite_database_get_type ())
#define ZEITGEIST_SQ_LITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE, ZeitgeistSQLiteDatabase))
#define ZEITGEIST_SQ_LITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_SQ_LITE_TYPE_DATABASE, ZeitgeistSQLiteDatabaseClass))
#define ZEITGEIST_SQ_LITE_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE))
#define ZEITGEIST_SQ_LITE_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_SQ_LITE_TYPE_DATABASE))
#define ZEITGEIST_SQ_LITE_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE, ZeitgeistSQLiteDatabaseClass))

typedef struct _ZeitgeistSQLiteDatabase ZeitgeistSQLiteDatabase;
typedef struct _ZeitgeistSQLiteDatabaseClass ZeitgeistSQLiteDatabaseClass;

#define ZEITGEIST_TYPE_EVENT (zeitgeist_event_get_type ())
#define ZEITGEIST_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EVENT, ZeitgeistEvent))
#define ZEITGEIST_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EVENT, ZeitgeistEventClass))
#define ZEITGEIST_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EVENT))
#define ZEITGEIST_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EVENT))
#define ZEITGEIST_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EVENT, ZeitgeistEventClass))

typedef struct _ZeitgeistEvent ZeitgeistEvent;
typedef struct _ZeitgeistEventClass ZeitgeistEventClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define ZEITGEIST_TYPE_SUBJECT (zeitgeist_subject_get_type ())
#define ZEITGEIST_SUBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubject))
#define ZEITGEIST_SUBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubjectClass))
#define ZEITGEIST_IS_SUBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_SUBJECT))
#define ZEITGEIST_IS_SUBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_SUBJECT))
#define ZEITGEIST_SUBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubjectClass))

typedef struct _ZeitgeistSubject ZeitgeistSubject;
typedef struct _ZeitgeistSubjectClass ZeitgeistSubjectClass;
#define __g_slist_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_free0_ (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ZeitgeistSQLiteDatabasePrivate ZeitgeistSQLiteDatabasePrivate;

#define ZEITGEIST_TYPE_TIME_RANGE (zeitgeist_time_range_get_type ())
#define ZEITGEIST_TIME_RANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRange))
#define ZEITGEIST_TIME_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRangeClass))
#define ZEITGEIST_IS_TIME_RANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_TIME_RANGE))
#define ZEITGEIST_IS_TIME_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_TIME_RANGE))
#define ZEITGEIST_TIME_RANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRangeClass))

typedef struct _ZeitgeistTimeRange ZeitgeistTimeRange;
typedef struct _ZeitgeistTimeRangeClass ZeitgeistTimeRangeClass;

struct _ZeitgeistDbReader {
	GObject parent_instance;
	ZeitgeistDbReaderPrivate * priv;
	sqlite3* db;
	ZeitgeistSQLiteTableLookup* interpretations_table;
	ZeitgeistSQLiteTableLookup* manifestations_table;
	ZeitgeistSQLiteTableLookup* mimetypes_table;
	ZeitgeistSQLiteTableLookup* actors_table;
};

struct _ZeitgeistDbReaderClass {
	GObjectClass parent_class;
	void (*close) (ZeitgeistDbReader* self);
};

struct _ZeitgeistEngine {
	ZeitgeistDbReader parent_instance;
	ZeitgeistEnginePrivate * priv;
	ZeitgeistExtensionStore* extension_store;
};

struct _ZeitgeistEngineClass {
	ZeitgeistDbReaderClass parent_class;
};

struct _ZeitgeistEnginePrivate {
	ZeitgeistExtensionCollection* extension_collection;
	guint32 last_id;
};

typedef enum  {
	ZEITGEIST_ENGINE_ERROR_BACKUP_FAILED,
	ZEITGEIST_ENGINE_ERROR_DATABASE_BUSY,
	ZEITGEIST_ENGINE_ERROR_DATABASE_CANTOPEN,
	ZEITGEIST_ENGINE_ERROR_DATABASE_CORRUPT,
	ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR,
	ZEITGEIST_ENGINE_ERROR_DATABASE_RETIRE_FAILED,
	ZEITGEIST_ENGINE_ERROR_EXISTING_INSTANCE,
	ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT,
	ZEITGEIST_ENGINE_ERROR_INVALID_KEY,
	ZEITGEIST_ENGINE_ERROR_INVALID_SIGNATURE,
	ZEITGEIST_ENGINE_ERROR_TOO_MANY_RESULTS
} ZeitgeistEngineError;
#define ZEITGEIST_ENGINE_ERROR zeitgeist_engine_error_quark ()
struct _ZeitgeistSQLiteDatabase {
	GObject parent_instance;
	ZeitgeistSQLiteDatabasePrivate * priv;
	sqlite3_stmt* event_insertion_stmt;
	sqlite3_stmt* id_retrieval_stmt;
	sqlite3_stmt* move_handling_stmt;
	sqlite3_stmt* payload_insertion_stmt;
	sqlite3* database;
};

struct _ZeitgeistSQLiteDatabaseClass {
	GObjectClass parent_class;
};


static gpointer zeitgeist_engine_parent_class = NULL;

GType zeitgeist_db_reader_get_type (void) G_GNUC_CONST;
GType zeitgeist_sq_lite_table_lookup_get_type (void) G_GNUC_CONST;
GType zeitgeist_engine_get_type (void) G_GNUC_CONST;
GType zeitgeist_extension_store_get_type (void) G_GNUC_CONST;
GType zeitgeist_extension_collection_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_ENGINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_ENGINE, ZeitgeistEnginePrivate))
enum  {
	ZEITGEIST_ENGINE_DUMMY_PROPERTY
};
GQuark zeitgeist_engine_error_quark (void);
ZeitgeistEngine* zeitgeist_engine_new (GError** error);
ZeitgeistEngine* zeitgeist_engine_construct (GType object_type, GError** error);
ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_new (GError** error);
ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_construct (GType object_type, GError** error);
GType zeitgeist_sq_lite_database_get_type (void) G_GNUC_CONST;
ZeitgeistSQLiteDatabase* zeitgeist_db_reader_get_database (ZeitgeistDbReader* self);
guint32 zeitgeist_sq_lite_database_get_last_id (ZeitgeistSQLiteDatabase* self, GError** error);
ZeitgeistExtensionCollection* zeitgeist_extension_collection_new (ZeitgeistEngine* engine);
ZeitgeistExtensionCollection* zeitgeist_extension_collection_construct (GType object_type, ZeitgeistEngine* engine);
gchar** zeitgeist_engine_get_extension_names (ZeitgeistEngine* self, int* result_length1);
gchar** zeitgeist_extension_collection_get_extension_names (ZeitgeistExtensionCollection* self, int* result_length1);
GType zeitgeist_event_get_type (void) G_GNUC_CONST;
guint32* zeitgeist_engine_insert_events (ZeitgeistEngine* self, GPtrArray* events, const char* sender, int* result_length1, GError** error);
static void zeitgeist_engine_preprocess_event (ZeitgeistEngine* self, ZeitgeistEvent* event, GError** error);
void zeitgeist_extension_collection_call_pre_insert_events (ZeitgeistExtensionCollection* self, GPtrArray* events, const char* sender);
void zeitgeist_sq_lite_database_begin_transaction (ZeitgeistSQLiteDatabase* self, GError** error);
static guint32 zeitgeist_engine_insert_event (ZeitgeistEngine* self, ZeitgeistEvent* event, GError** error);
void zeitgeist_sq_lite_database_end_transaction (ZeitgeistSQLiteDatabase* self, GError** error);
void zeitgeist_sq_lite_database_abort_transaction (ZeitgeistSQLiteDatabase* self, GError** error);
void zeitgeist_extension_collection_call_post_insert_events (ZeitgeistExtensionCollection* self, GPtrArray* events, const char* sender);
gint zeitgeist_event_num_subjects (ZeitgeistEvent* self);
GType zeitgeist_subject_get_type (void) G_GNUC_CONST;
GPtrArray* zeitgeist_event_get_subjects (ZeitgeistEvent* self);
gboolean zeitgeist_utils_is_empty_string (const gchar* s);
const gchar* zeitgeist_subject_get_current_uri (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_uri (ZeitgeistSubject* self);
void zeitgeist_subject_set_current_uri (ZeitgeistSubject* self, const gchar* value);
const gchar* zeitgeist_event_get_interpretation (ZeitgeistEvent* self);
#define ZEITGEIST_ZG_MOVE_EVENT "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#MoveEvent"
const gchar* zeitgeist_subject_get_manifestation (ZeitgeistSubject* self);
const gchar* zeitgeist_manifestation_for_uri (const gchar* uri);
void zeitgeist_subject_set_manifestation (ZeitgeistSubject* self, const gchar* value);
const gchar* zeitgeist_subject_get_interpretation (ZeitgeistSubject* self);
const gchar* zeitgeist_interpretation_for_mimetype (const gchar* mimetype);
const gchar* zeitgeist_subject_get_mimetype (ZeitgeistSubject* self);
void zeitgeist_subject_set_interpretation (ZeitgeistSubject* self, const gchar* value);
guint32 zeitgeist_event_get_id (ZeitgeistEvent* self);
void zeitgeist_event_set_id (ZeitgeistEvent* self, guint32 value);
static void _g_free0_ (gpointer var);
const gchar* zeitgeist_event_get_origin (ZeitgeistEvent* self);
static void _g_slist_free__g_free0_ (GSList* self);
const gchar* zeitgeist_subject_get_origin (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_text (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_storage (ZeitgeistSubject* self);
void zeitgeist_sq_lite_database_insert_or_ignore_into_table (ZeitgeistSQLiteDatabase* self, const gchar* table_name, GPtrArray* values, GError** error);
static gint64 zeitgeist_engine_store_payload (ZeitgeistEngine* self, ZeitgeistEvent* event);
gint64 zeitgeist_event_get_timestamp (ZeitgeistEvent* self);
gint zeitgeist_sq_lite_table_lookup_id_for_string (ZeitgeistSQLiteTableLookup* self, const gchar* name, GError** error);
const gchar* zeitgeist_event_get_manifestation (ZeitgeistEvent* self);
const gchar* zeitgeist_event_get_actor (ZeitgeistEvent* self);
void zeitgeist_sq_lite_database_assert_not_corrupt (ZeitgeistSQLiteDatabase* self, gint rc, GError** error);
static void zeitgeist_engine_handle_move_event (ZeitgeistEngine* self, ZeitgeistEvent* event);
GType zeitgeist_time_range_get_type (void) G_GNUC_CONST;
ZeitgeistTimeRange* zeitgeist_engine_delete_events (ZeitgeistEngine* self, guint32* event_ids, int event_ids_length1, const char* sender, GError** error);
guint32* zeitgeist_extension_collection_call_pre_delete_events (ZeitgeistExtensionCollection* self, guint32* event_ids, int event_ids_length1, const char* sender, int* result_length1);
ZeitgeistTimeRange* zeitgeist_sq_lite_database_get_time_range_for_event_ids (ZeitgeistSQLiteDatabase* self, guint32* event_ids, int event_ids_length1, GError** error);
gchar* zeitgeist_sq_lite_database_get_sql_string_from_event_ids (ZeitgeistSQLiteDatabase* self, guint32* event_ids, int event_ids_length1);
void zeitgeist_sq_lite_database_assert_query_success (ZeitgeistSQLiteDatabase* self, gint rc, const gchar* msg, gint success_code, GError** error);
void zeitgeist_extension_collection_call_post_delete_events (ZeitgeistExtensionCollection* self, guint32* event_ids, int event_ids_length1, const char* sender);
static void zeitgeist_engine_real_close (ZeitgeistDbReader* base);
void zeitgeist_db_reader_close (ZeitgeistDbReader* self);
GByteArray* zeitgeist_event_get_payload (ZeitgeistEvent* self);
static GObject * zeitgeist_engine_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
ZeitgeistExtensionStore* zeitgeist_extension_store_new (ZeitgeistEngine* engine);
ZeitgeistExtensionStore* zeitgeist_extension_store_construct (GType object_type, ZeitgeistEngine* engine);
static void zeitgeist_engine_finalize (GObject* obj);


ZeitgeistEngine* zeitgeist_engine_construct (GType object_type, GError** error) {
	ZeitgeistEngine * self = NULL;
	ZeitgeistSQLiteDatabase* _tmp0_;
	ZeitgeistSQLiteDatabase* _tmp1_;
	ZeitgeistSQLiteDatabase* _tmp2_;
	ZeitgeistSQLiteDatabase* _tmp3_;
	ZeitgeistSQLiteDatabase* _tmp4_;
	guint32 _tmp5_ = 0U;
	guint32 _tmp6_;
	ZeitgeistExtensionCollection* _tmp7_;
	GError * _inner_error_ = NULL;
	_tmp0_ = zeitgeist_sq_lite_database_new (&_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = _tmp1_;
	self = (ZeitgeistEngine*) g_object_new (object_type, "database", _tmp2_, NULL);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = zeitgeist_sq_lite_database_get_last_id (_tmp4_, &_inner_error_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	self->priv->last_id = _tmp6_;
	_tmp7_ = zeitgeist_extension_collection_new (self);
	_g_object_unref0 (self->priv->extension_collection);
	self->priv->extension_collection = _tmp7_;
	return self;
}


ZeitgeistEngine* zeitgeist_engine_new (GError** error) {
	return zeitgeist_engine_construct (ZEITGEIST_TYPE_ENGINE, error);
}


gchar** zeitgeist_engine_get_extension_names (ZeitgeistEngine* self, int* result_length1) {
	gchar** result = NULL;
	ZeitgeistExtensionCollection* _tmp0_;
	gint _tmp1_ = 0;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_;
	gint _tmp3__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->extension_collection;
	_tmp2_ = zeitgeist_extension_collection_get_extension_names (_tmp0_, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp1_;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


guint32* zeitgeist_engine_insert_events (ZeitgeistEngine* self, GPtrArray* events, const char* sender, int* result_length1, GError** error) {
	guint32* result = NULL;
	ZeitgeistExtensionCollection* _tmp10_;
	GPtrArray* _tmp11_;
	const char* _tmp12_;
	GPtrArray* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	guint32* _tmp16_ = NULL;
	guint32* event_ids;
	gint event_ids_length1;
	gint _event_ids_size_;
	GError* err;
	ZeitgeistSQLiteDatabase* _tmp17_;
	ZeitgeistSQLiteDatabase* _tmp18_;
	GError* _tmp43_;
	ZeitgeistExtensionCollection* _tmp46_;
	GPtrArray* _tmp47_;
	const char* _tmp48_;
	guint32* _tmp49_;
	gint _tmp49__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (events != NULL, NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				GPtrArray* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				GPtrArray* _tmp7_;
				gint _tmp8_;
				gconstpointer _tmp9_ = NULL;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = events;
				_tmp5_ = g_ptr_array_get_length (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp3_ < _tmp6_)) {
					break;
				}
				_tmp7_ = events;
				_tmp8_ = i;
				_tmp9_ = g_ptr_array_index (_tmp7_, (guint) _tmp8_);
				zeitgeist_engine_preprocess_event (self, (ZeitgeistEvent*) _tmp9_, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return NULL;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
			}
		}
	}
	_tmp10_ = self->priv->extension_collection;
	_tmp11_ = events;
	_tmp12_ = sender;
	zeitgeist_extension_collection_call_pre_insert_events (_tmp10_, _tmp11_, _tmp12_);
	_tmp13_ = events;
	_tmp14_ = g_ptr_array_get_length (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_new0 (guint32, _tmp15_);
	event_ids = _tmp16_;
	event_ids_length1 = _tmp15_;
	_event_ids_size_ = event_ids_length1;
	err = NULL;
	_tmp17_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp18_ = _tmp17_;
	zeitgeist_sq_lite_database_begin_transaction (_tmp18_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			return NULL;
		} else {
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	{
		ZeitgeistSQLiteDatabase* _tmp37_;
		ZeitgeistSQLiteDatabase* _tmp38_;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp19_;
				_tmp19_ = TRUE;
				while (TRUE) {
					gboolean _tmp20_;
					gint _tmp22_;
					GPtrArray* _tmp23_;
					gint _tmp24_;
					gint _tmp25_;
					GPtrArray* _tmp26_;
					gint _tmp27_;
					gconstpointer _tmp28_ = NULL;
					_tmp20_ = _tmp19_;
					if (!_tmp20_) {
						gint _tmp21_;
						_tmp21_ = i;
						i = _tmp21_ + 1;
					}
					_tmp19_ = FALSE;
					_tmp22_ = i;
					_tmp23_ = events;
					_tmp24_ = g_ptr_array_get_length (_tmp23_);
					_tmp25_ = _tmp24_;
					if (!(_tmp22_ < _tmp25_)) {
						break;
					}
					_tmp26_ = events;
					_tmp27_ = i;
					_tmp28_ = g_ptr_array_index (_tmp26_, (guint) _tmp27_);
					if (((ZeitgeistEvent*) _tmp28_) != NULL) {
						GPtrArray* _tmp29_;
						gint _tmp30_;
						gconstpointer _tmp31_ = NULL;
						guint32 _tmp32_ = 0U;
						guint32 _tmp33_;
						guint32* _tmp34_;
						gint _tmp34__length1;
						gint _tmp35_;
						guint32 _tmp36_;
						_tmp29_ = events;
						_tmp30_ = i;
						_tmp31_ = g_ptr_array_index (_tmp29_, (guint) _tmp30_);
						_tmp32_ = zeitgeist_engine_insert_event (self, (ZeitgeistEvent*) _tmp31_, &_inner_error_);
						_tmp33_ = _tmp32_;
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
								goto __catch7_zeitgeist_engine_error;
							}
							_g_error_free0 (err);
							event_ids = (g_free (event_ids), NULL);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
						_tmp34_ = event_ids;
						_tmp34__length1 = event_ids_length1;
						_tmp35_ = i;
						_tmp34_[_tmp35_] = _tmp33_;
						_tmp36_ = _tmp34_[_tmp35_];
					}
				}
			}
		}
		_tmp37_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
		_tmp38_ = _tmp37_;
		zeitgeist_sq_lite_database_end_transaction (_tmp38_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch7_zeitgeist_engine_error;
			}
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	goto __finally7;
	__catch7_zeitgeist_engine_error:
	{
		GError* e = NULL;
		GError* _tmp39_;
		GError* _tmp40_;
		ZeitgeistSQLiteDatabase* _tmp41_;
		ZeitgeistSQLiteDatabase* _tmp42_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp39_ = e;
		_tmp40_ = _g_error_copy0 (_tmp39_);
		_g_error_free0 (err);
		err = _tmp40_;
		_tmp41_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
		_tmp42_ = _tmp41_;
		zeitgeist_sq_lite_database_abort_transaction (_tmp42_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_error_free0 (e);
			goto __finally7;
		}
		_g_error_free0 (e);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			return NULL;
		} else {
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp43_ = err;
	if (_tmp43_ != NULL) {
		GError* _tmp44_;
		GError* _tmp45_;
		_tmp44_ = err;
		_tmp45_ = _g_error_copy0 (_tmp44_);
		_inner_error_ = _tmp45_;
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			return NULL;
		} else {
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp46_ = self->priv->extension_collection;
	_tmp47_ = events;
	_tmp48_ = sender;
	zeitgeist_extension_collection_call_post_insert_events (_tmp46_, _tmp47_, _tmp48_);
	_tmp49_ = event_ids;
	_tmp49__length1 = event_ids_length1;
	if (result_length1) {
		*result_length1 = _tmp49__length1;
	}
	result = _tmp49_;
	_g_error_free0 (err);
	return result;
}


static void zeitgeist_engine_preprocess_event (ZeitgeistEngine* self, ZeitgeistEvent* event, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				ZeitgeistEvent* _tmp4_;
				gint _tmp5_ = 0;
				ZeitgeistEvent* _tmp6_;
				GPtrArray* _tmp7_;
				GPtrArray* _tmp8_;
				gint _tmp9_;
				gconstpointer _tmp10_ = NULL;
				ZeitgeistSubject* subject;
				ZeitgeistSubject* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				gboolean _tmp14_ = FALSE;
				gboolean _tmp19_ = FALSE;
				ZeitgeistEvent* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				gboolean _tmp29_;
				ZeitgeistSubject* _tmp43_;
				const gchar* _tmp44_;
				const gchar* _tmp45_;
				gboolean _tmp46_ = FALSE;
				ZeitgeistSubject* _tmp54_;
				const gchar* _tmp55_;
				const gchar* _tmp56_;
				gboolean _tmp57_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = event;
				_tmp5_ = zeitgeist_event_num_subjects (_tmp4_);
				if (!(_tmp3_ < _tmp5_)) {
					break;
				}
				_tmp6_ = event;
				_tmp7_ = zeitgeist_event_get_subjects (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = i;
				_tmp10_ = g_ptr_array_index (_tmp8_, (guint) _tmp9_);
				subject = (ZeitgeistSubject*) _tmp10_;
				_tmp11_ = subject;
				_tmp12_ = zeitgeist_subject_get_current_uri (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = zeitgeist_utils_is_empty_string (_tmp13_);
				if (_tmp14_) {
					ZeitgeistSubject* _tmp15_;
					ZeitgeistSubject* _tmp16_;
					const gchar* _tmp17_;
					const gchar* _tmp18_;
					_tmp15_ = subject;
					_tmp16_ = subject;
					_tmp17_ = zeitgeist_subject_get_uri (_tmp16_);
					_tmp18_ = _tmp17_;
					zeitgeist_subject_set_current_uri (_tmp15_, _tmp18_);
				}
				_tmp20_ = event;
				_tmp21_ = zeitgeist_event_get_interpretation (_tmp20_);
				_tmp22_ = _tmp21_;
				if (g_strcmp0 (_tmp22_, ZEITGEIST_ZG_MOVE_EVENT) == 0) {
					ZeitgeistSubject* _tmp23_;
					const gchar* _tmp24_;
					const gchar* _tmp25_;
					ZeitgeistSubject* _tmp26_;
					const gchar* _tmp27_;
					const gchar* _tmp28_;
					_tmp23_ = subject;
					_tmp24_ = zeitgeist_subject_get_uri (_tmp23_);
					_tmp25_ = _tmp24_;
					_tmp26_ = subject;
					_tmp27_ = zeitgeist_subject_get_current_uri (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp19_ = g_strcmp0 (_tmp25_, _tmp28_) == 0;
				} else {
					_tmp19_ = FALSE;
				}
				_tmp29_ = _tmp19_;
				if (_tmp29_) {
					GError* _tmp30_;
					_tmp30_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, "Redundant event: event.interpretation indicates " "the uri has been moved yet the subject.uri and " "subject.current_uri are identical");
					_inner_error_ = _tmp30_;
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				} else {
					gboolean _tmp31_ = FALSE;
					ZeitgeistEvent* _tmp32_;
					const gchar* _tmp33_;
					const gchar* _tmp34_;
					gboolean _tmp41_;
					_tmp32_ = event;
					_tmp33_ = zeitgeist_event_get_interpretation (_tmp32_);
					_tmp34_ = _tmp33_;
					if (g_strcmp0 (_tmp34_, ZEITGEIST_ZG_MOVE_EVENT) != 0) {
						ZeitgeistSubject* _tmp35_;
						const gchar* _tmp36_;
						const gchar* _tmp37_;
						ZeitgeistSubject* _tmp38_;
						const gchar* _tmp39_;
						const gchar* _tmp40_;
						_tmp35_ = subject;
						_tmp36_ = zeitgeist_subject_get_uri (_tmp35_);
						_tmp37_ = _tmp36_;
						_tmp38_ = subject;
						_tmp39_ = zeitgeist_subject_get_current_uri (_tmp38_);
						_tmp40_ = _tmp39_;
						_tmp31_ = g_strcmp0 (_tmp37_, _tmp40_) != 0;
					} else {
						_tmp31_ = FALSE;
					}
					_tmp41_ = _tmp31_;
					if (_tmp41_) {
						GError* _tmp42_;
						_tmp42_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, "Illegal event: unless event.interpretation is " "'MOVE_EVENT' then subject.uri and " "subject.current_uri have to be the same");
						_inner_error_ = _tmp42_;
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				}
				_tmp43_ = subject;
				_tmp44_ = zeitgeist_subject_get_manifestation (_tmp43_);
				_tmp45_ = _tmp44_;
				_tmp46_ = zeitgeist_utils_is_empty_string (_tmp45_);
				if (_tmp46_) {
					ZeitgeistSubject* _tmp47_;
					const gchar* _tmp48_;
					const gchar* _tmp49_;
					const gchar* _tmp50_ = NULL;
					const gchar* manifestation;
					const gchar* _tmp51_;
					_tmp47_ = subject;
					_tmp48_ = zeitgeist_subject_get_uri (_tmp47_);
					_tmp49_ = _tmp48_;
					_tmp50_ = zeitgeist_manifestation_for_uri (_tmp49_);
					manifestation = _tmp50_;
					_tmp51_ = manifestation;
					if (_tmp51_ != NULL) {
						ZeitgeistSubject* _tmp52_;
						const gchar* _tmp53_;
						_tmp52_ = subject;
						_tmp53_ = manifestation;
						zeitgeist_subject_set_manifestation (_tmp52_, _tmp53_);
					}
				}
				_tmp54_ = subject;
				_tmp55_ = zeitgeist_subject_get_interpretation (_tmp54_);
				_tmp56_ = _tmp55_;
				_tmp57_ = zeitgeist_utils_is_empty_string (_tmp56_);
				if (_tmp57_) {
					ZeitgeistSubject* _tmp58_;
					const gchar* _tmp59_;
					const gchar* _tmp60_;
					const gchar* _tmp61_ = NULL;
					const gchar* interpretation;
					const gchar* _tmp62_;
					_tmp58_ = subject;
					_tmp59_ = zeitgeist_subject_get_mimetype (_tmp58_);
					_tmp60_ = _tmp59_;
					_tmp61_ = zeitgeist_interpretation_for_mimetype (_tmp60_);
					interpretation = _tmp61_;
					_tmp62_ = interpretation;
					if (_tmp62_ != NULL) {
						ZeitgeistSubject* _tmp63_;
						const gchar* _tmp64_;
						_tmp63_ = subject;
						_tmp64_ = interpretation;
						zeitgeist_subject_set_interpretation (_tmp63_, _tmp64_);
					}
				}
			}
		}
	}
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_slist_free__g_free0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_free0_, NULL);
	g_slist_free (self);
}


static guint32 zeitgeist_engine_insert_event (ZeitgeistEngine* self, ZeitgeistEvent* event, GError** error) {
	guint32 result = 0U;
	ZeitgeistEvent* _tmp0_;
	guint32 _tmp1_;
	guint32 _tmp2_;
	ZeitgeistEvent* _tmp3_;
	gint _tmp4_ = 0;
	ZeitgeistEvent* _tmp5_;
	guint32 _tmp6_;
	guint32 _tmp7_;
	ZeitgeistEvent* _tmp106_;
	gint64 _tmp107_ = 0LL;
	gint64 payload_id;
	gint rc = 0;
	ZeitgeistSQLiteDatabase* _tmp108_;
	ZeitgeistSQLiteDatabase* _tmp109_;
	sqlite3_stmt* _tmp110_;
	sqlite3_stmt* insert_stmt;
	sqlite3_stmt* _tmp111_;
	sqlite3_stmt* _tmp112_;
	ZeitgeistEvent* _tmp113_;
	guint32 _tmp114_;
	guint32 _tmp115_;
	sqlite3_stmt* _tmp116_;
	ZeitgeistEvent* _tmp117_;
	gint64 _tmp118_;
	gint64 _tmp119_;
	ZeitgeistSQLiteTableLookup* _tmp120_;
	ZeitgeistEvent* _tmp121_;
	const gchar* _tmp122_;
	const gchar* _tmp123_;
	gint _tmp124_ = 0;
	gint _tmp125_;
	sqlite3_stmt* _tmp126_;
	ZeitgeistSQLiteTableLookup* _tmp127_;
	ZeitgeistEvent* _tmp128_;
	const gchar* _tmp129_;
	const gchar* _tmp130_;
	gint _tmp131_ = 0;
	gint _tmp132_;
	sqlite3_stmt* _tmp133_;
	ZeitgeistSQLiteTableLookup* _tmp134_;
	ZeitgeistEvent* _tmp135_;
	const gchar* _tmp136_;
	const gchar* _tmp137_;
	gint _tmp138_ = 0;
	gint _tmp139_;
	sqlite3_stmt* _tmp140_;
	sqlite3_stmt* _tmp141_;
	ZeitgeistEvent* _tmp142_;
	const gchar* _tmp143_;
	const gchar* _tmp144_;
	gchar* _tmp145_;
	GDestroyNotify _tmp146_;
	sqlite3_stmt* _tmp147_;
	gint64 _tmp148_;
	ZeitgeistEvent* _tmp263_;
	const gchar* _tmp264_;
	const gchar* _tmp265_;
	ZeitgeistEvent* _tmp267_;
	guint32 _tmp268_;
	guint32 _tmp269_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (event != NULL, 0U);
	_tmp0_ = event;
	_tmp1_ = zeitgeist_event_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_val_if_fail (_tmp2_ == ((guint32) 0), 0U);
	_tmp3_ = event;
	_tmp4_ = zeitgeist_event_num_subjects (_tmp3_);
	g_return_val_if_fail (_tmp4_ > 0, 0U);
	_tmp5_ = event;
	_tmp6_ = self->priv->last_id;
	self->priv->last_id = _tmp6_ + 1;
	_tmp7_ = self->priv->last_id;
	zeitgeist_event_set_id (_tmp5_, _tmp7_);
	{
		GPtrArray* _tmp8_;
		GPtrArray* uris;
		GPtrArray* _tmp9_;
		GPtrArray* texts;
		GPtrArray* _tmp10_;
		GPtrArray* storages;
		GSList* subj_uris;
		ZeitgeistEvent* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gboolean _tmp14_ = FALSE;
		_tmp8_ = g_ptr_array_new_with_free_func (_g_free0_);
		uris = _tmp8_;
		_tmp9_ = g_ptr_array_new_with_free_func (_g_free0_);
		texts = _tmp9_;
		_tmp10_ = g_ptr_array_new_with_free_func (_g_free0_);
		storages = _tmp10_;
		subj_uris = NULL;
		_tmp11_ = event;
		_tmp12_ = zeitgeist_event_get_origin (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = zeitgeist_utils_is_empty_string (_tmp13_);
		if (!_tmp14_) {
			GPtrArray* _tmp15_;
			ZeitgeistEvent* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp15_ = uris;
			_tmp16_ = event;
			_tmp17_ = zeitgeist_event_get_origin (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strdup (_tmp18_);
			g_ptr_array_add (_tmp15_, _tmp19_);
		}
		{
			gint i;
			i = 0;
			{
				gboolean _tmp20_;
				_tmp20_ = TRUE;
				while (TRUE) {
					gboolean _tmp21_;
					gint _tmp23_;
					ZeitgeistEvent* _tmp24_;
					gint _tmp25_ = 0;
					ZeitgeistEvent* _tmp26_;
					GPtrArray* _tmp27_;
					GPtrArray* _tmp28_;
					gint _tmp29_;
					gconstpointer _tmp30_ = NULL;
					ZeitgeistSubject* subject;
					GSList* _tmp31_;
					ZeitgeistSubject* _tmp32_;
					const gchar* _tmp33_;
					const gchar* _tmp34_;
					GCompareFunc _tmp35_;
					GSList* _tmp36_ = NULL;
					ZeitgeistSubject* _tmp37_;
					const gchar* _tmp38_;
					const gchar* _tmp39_;
					gchar* _tmp40_;
					GPtrArray* _tmp41_;
					ZeitgeistSubject* _tmp42_;
					const gchar* _tmp43_;
					const gchar* _tmp44_;
					gchar* _tmp45_;
					ZeitgeistSubject* _tmp46_;
					const gchar* _tmp47_;
					const gchar* _tmp48_;
					ZeitgeistSubject* _tmp49_;
					const gchar* _tmp50_;
					const gchar* _tmp51_;
					ZeitgeistSubject* _tmp57_;
					const gchar* _tmp58_;
					const gchar* _tmp59_;
					gboolean _tmp60_ = FALSE;
					ZeitgeistSubject* _tmp66_;
					const gchar* _tmp67_;
					const gchar* _tmp68_;
					gboolean _tmp69_ = FALSE;
					ZeitgeistSubject* _tmp75_;
					const gchar* _tmp76_;
					const gchar* _tmp77_;
					gboolean _tmp78_ = FALSE;
					_tmp21_ = _tmp20_;
					if (!_tmp21_) {
						gint _tmp22_;
						_tmp22_ = i;
						i = _tmp22_ + 1;
					}
					_tmp20_ = FALSE;
					_tmp23_ = i;
					_tmp24_ = event;
					_tmp25_ = zeitgeist_event_num_subjects (_tmp24_);
					if (!(_tmp23_ < _tmp25_)) {
						break;
					}
					_tmp26_ = event;
					_tmp27_ = zeitgeist_event_get_subjects (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = i;
					_tmp30_ = g_ptr_array_index (_tmp28_, (guint) _tmp29_);
					subject = (ZeitgeistSubject*) _tmp30_;
					_tmp31_ = subj_uris;
					_tmp32_ = subject;
					_tmp33_ = zeitgeist_subject_get_uri (_tmp32_);
					_tmp34_ = _tmp33_;
					_tmp35_ = g_strcmp0;
					_tmp36_ = g_slist_find_custom (_tmp31_, _tmp34_, _tmp35_);
					if (_tmp36_ != NULL) {
						g_warning ("engine.vala:167: Events with two subjects with the same URI are not su" \
"pported");
						result = (guint32) 0;
						__g_slist_free__g_free0_0 (subj_uris);
						_g_ptr_array_unref0 (storages);
						_g_ptr_array_unref0 (texts);
						_g_ptr_array_unref0 (uris);
						return result;
					}
					_tmp37_ = subject;
					_tmp38_ = zeitgeist_subject_get_uri (_tmp37_);
					_tmp39_ = _tmp38_;
					_tmp40_ = g_strdup (_tmp39_);
					subj_uris = g_slist_append (subj_uris, _tmp40_);
					_tmp41_ = uris;
					_tmp42_ = subject;
					_tmp43_ = zeitgeist_subject_get_uri (_tmp42_);
					_tmp44_ = _tmp43_;
					_tmp45_ = g_strdup (_tmp44_);
					g_ptr_array_add (_tmp41_, _tmp45_);
					_tmp46_ = subject;
					_tmp47_ = zeitgeist_subject_get_uri (_tmp46_);
					_tmp48_ = _tmp47_;
					_tmp49_ = subject;
					_tmp50_ = zeitgeist_subject_get_current_uri (_tmp49_);
					_tmp51_ = _tmp50_;
					if (g_strcmp0 (_tmp48_, _tmp51_) != 0) {
						GPtrArray* _tmp52_;
						ZeitgeistSubject* _tmp53_;
						const gchar* _tmp54_;
						const gchar* _tmp55_;
						gchar* _tmp56_;
						_tmp52_ = uris;
						_tmp53_ = subject;
						_tmp54_ = zeitgeist_subject_get_current_uri (_tmp53_);
						_tmp55_ = _tmp54_;
						_tmp56_ = g_strdup (_tmp55_);
						g_ptr_array_add (_tmp52_, _tmp56_);
					}
					_tmp57_ = subject;
					_tmp58_ = zeitgeist_subject_get_origin (_tmp57_);
					_tmp59_ = _tmp58_;
					_tmp60_ = zeitgeist_utils_is_empty_string (_tmp59_);
					if (!_tmp60_) {
						GPtrArray* _tmp61_;
						ZeitgeistSubject* _tmp62_;
						const gchar* _tmp63_;
						const gchar* _tmp64_;
						gchar* _tmp65_;
						_tmp61_ = uris;
						_tmp62_ = subject;
						_tmp63_ = zeitgeist_subject_get_origin (_tmp62_);
						_tmp64_ = _tmp63_;
						_tmp65_ = g_strdup (_tmp64_);
						g_ptr_array_add (_tmp61_, _tmp65_);
					}
					_tmp66_ = subject;
					_tmp67_ = zeitgeist_subject_get_text (_tmp66_);
					_tmp68_ = _tmp67_;
					_tmp69_ = zeitgeist_utils_is_empty_string (_tmp68_);
					if (!_tmp69_) {
						GPtrArray* _tmp70_;
						ZeitgeistSubject* _tmp71_;
						const gchar* _tmp72_;
						const gchar* _tmp73_;
						gchar* _tmp74_;
						_tmp70_ = texts;
						_tmp71_ = subject;
						_tmp72_ = zeitgeist_subject_get_text (_tmp71_);
						_tmp73_ = _tmp72_;
						_tmp74_ = g_strdup (_tmp73_);
						g_ptr_array_add (_tmp70_, _tmp74_);
					}
					_tmp75_ = subject;
					_tmp76_ = zeitgeist_subject_get_storage (_tmp75_);
					_tmp77_ = _tmp76_;
					_tmp78_ = zeitgeist_utils_is_empty_string (_tmp77_);
					if (!_tmp78_) {
						GPtrArray* _tmp79_;
						ZeitgeistSubject* _tmp80_;
						const gchar* _tmp81_;
						const gchar* _tmp82_;
						gchar* _tmp83_;
						_tmp79_ = storages;
						_tmp80_ = subject;
						_tmp81_ = zeitgeist_subject_get_storage (_tmp80_);
						_tmp82_ = _tmp81_;
						_tmp83_ = g_strdup (_tmp82_);
						g_ptr_array_add (_tmp79_, _tmp83_);
					}
				}
			}
		}
		{
			GPtrArray* _tmp84_;
			gint _tmp85_;
			gint _tmp86_;
			GPtrArray* _tmp90_;
			gint _tmp91_;
			gint _tmp92_;
			GPtrArray* _tmp96_;
			gint _tmp97_;
			gint _tmp98_;
			_tmp84_ = uris;
			_tmp85_ = g_ptr_array_get_length (_tmp84_);
			_tmp86_ = _tmp85_;
			if (_tmp86_ > 0) {
				ZeitgeistSQLiteDatabase* _tmp87_;
				ZeitgeistSQLiteDatabase* _tmp88_;
				GPtrArray* _tmp89_;
				_tmp87_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
				_tmp88_ = _tmp87_;
				_tmp89_ = uris;
				zeitgeist_sq_lite_database_insert_or_ignore_into_table (_tmp88_, "uri", _tmp89_, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						goto __catch8_zeitgeist_engine_error;
					}
					__g_slist_free__g_free0_0 (subj_uris);
					_g_ptr_array_unref0 (storages);
					_g_ptr_array_unref0 (texts);
					_g_ptr_array_unref0 (uris);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0U;
				}
			}
			_tmp90_ = texts;
			_tmp91_ = g_ptr_array_get_length (_tmp90_);
			_tmp92_ = _tmp91_;
			if (_tmp92_ > 0) {
				ZeitgeistSQLiteDatabase* _tmp93_;
				ZeitgeistSQLiteDatabase* _tmp94_;
				GPtrArray* _tmp95_;
				_tmp93_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
				_tmp94_ = _tmp93_;
				_tmp95_ = texts;
				zeitgeist_sq_lite_database_insert_or_ignore_into_table (_tmp94_, "text", _tmp95_, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						goto __catch8_zeitgeist_engine_error;
					}
					__g_slist_free__g_free0_0 (subj_uris);
					_g_ptr_array_unref0 (storages);
					_g_ptr_array_unref0 (texts);
					_g_ptr_array_unref0 (uris);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0U;
				}
			}
			_tmp96_ = storages;
			_tmp97_ = g_ptr_array_get_length (_tmp96_);
			_tmp98_ = _tmp97_;
			if (_tmp98_ > 0) {
				ZeitgeistSQLiteDatabase* _tmp99_;
				ZeitgeistSQLiteDatabase* _tmp100_;
				GPtrArray* _tmp101_;
				_tmp99_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
				_tmp100_ = _tmp99_;
				_tmp101_ = storages;
				zeitgeist_sq_lite_database_insert_or_ignore_into_table (_tmp100_, "storage", _tmp101_, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						goto __catch8_zeitgeist_engine_error;
					}
					__g_slist_free__g_free0_0 (subj_uris);
					_g_ptr_array_unref0 (storages);
					_g_ptr_array_unref0 (texts);
					_g_ptr_array_unref0 (uris);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0U;
				}
			}
		}
		goto __finally8;
		__catch8_zeitgeist_engine_error:
		{
			GError* e = NULL;
			GError* _tmp102_;
			const gchar* _tmp103_;
			gchar* _tmp104_;
			gchar* _tmp105_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp102_ = e;
			_tmp103_ = _tmp102_->message;
			_tmp104_ = g_strconcat ("Can't insert data for event: ", _tmp103_, NULL);
			_tmp105_ = _tmp104_;
			g_warning ("engine.vala:195: %s", _tmp105_);
			_g_free0 (_tmp105_);
			result = (guint32) 0;
			_g_error_free0 (e);
			__g_slist_free__g_free0_0 (subj_uris);
			_g_ptr_array_unref0 (storages);
			_g_ptr_array_unref0 (texts);
			_g_ptr_array_unref0 (uris);
			return result;
		}
		__finally8:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				__g_slist_free__g_free0_0 (subj_uris);
				_g_ptr_array_unref0 (storages);
				_g_ptr_array_unref0 (texts);
				_g_ptr_array_unref0 (uris);
				return 0U;
			} else {
				__g_slist_free__g_free0_0 (subj_uris);
				_g_ptr_array_unref0 (storages);
				_g_ptr_array_unref0 (texts);
				_g_ptr_array_unref0 (uris);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0U;
			}
		}
		__g_slist_free__g_free0_0 (subj_uris);
		_g_ptr_array_unref0 (storages);
		_g_ptr_array_unref0 (texts);
		_g_ptr_array_unref0 (uris);
	}
	_tmp106_ = event;
	_tmp107_ = zeitgeist_engine_store_payload (self, _tmp106_);
	payload_id = _tmp107_;
	_tmp108_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp109_ = _tmp108_;
	_tmp110_ = _tmp109_->event_insertion_stmt;
	insert_stmt = _tmp110_;
	_tmp111_ = insert_stmt;
	sqlite3_reset (_tmp111_);
	_tmp112_ = insert_stmt;
	_tmp113_ = event;
	_tmp114_ = zeitgeist_event_get_id (_tmp113_);
	_tmp115_ = _tmp114_;
	sqlite3_bind_int64 (_tmp112_, 1, (gint64) _tmp115_);
	_tmp116_ = insert_stmt;
	_tmp117_ = event;
	_tmp118_ = zeitgeist_event_get_timestamp (_tmp117_);
	_tmp119_ = _tmp118_;
	sqlite3_bind_int64 (_tmp116_, 2, _tmp119_);
	_tmp120_ = ((ZeitgeistDbReader*) self)->interpretations_table;
	_tmp121_ = event;
	_tmp122_ = zeitgeist_event_get_interpretation (_tmp121_);
	_tmp123_ = _tmp122_;
	_tmp124_ = zeitgeist_sq_lite_table_lookup_id_for_string (_tmp120_, _tmp123_, &_inner_error_);
	_tmp125_ = _tmp124_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0U;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0U;
		}
	}
	_tmp126_ = insert_stmt;
	sqlite3_bind_int64 (_tmp126_, 3, (gint64) _tmp125_);
	_tmp127_ = ((ZeitgeistDbReader*) self)->manifestations_table;
	_tmp128_ = event;
	_tmp129_ = zeitgeist_event_get_manifestation (_tmp128_);
	_tmp130_ = _tmp129_;
	_tmp131_ = zeitgeist_sq_lite_table_lookup_id_for_string (_tmp127_, _tmp130_, &_inner_error_);
	_tmp132_ = _tmp131_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0U;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0U;
		}
	}
	_tmp133_ = insert_stmt;
	sqlite3_bind_int64 (_tmp133_, 4, (gint64) _tmp132_);
	_tmp134_ = ((ZeitgeistDbReader*) self)->actors_table;
	_tmp135_ = event;
	_tmp136_ = zeitgeist_event_get_actor (_tmp135_);
	_tmp137_ = _tmp136_;
	_tmp138_ = zeitgeist_sq_lite_table_lookup_id_for_string (_tmp134_, _tmp137_, &_inner_error_);
	_tmp139_ = _tmp138_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0U;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0U;
		}
	}
	_tmp140_ = insert_stmt;
	sqlite3_bind_int64 (_tmp140_, 5, (gint64) _tmp139_);
	_tmp141_ = insert_stmt;
	_tmp142_ = event;
	_tmp143_ = zeitgeist_event_get_origin (_tmp142_);
	_tmp144_ = _tmp143_;
	_tmp145_ = g_strdup (_tmp144_);
	_tmp146_ = g_free;
	sqlite3_bind_text (_tmp141_, 6, _tmp145_, -1, _tmp146_);
	_tmp147_ = insert_stmt;
	_tmp148_ = payload_id;
	sqlite3_bind_int64 (_tmp147_, 7, _tmp148_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp149_;
			_tmp149_ = TRUE;
			while (TRUE) {
				gboolean _tmp150_;
				gint _tmp152_;
				ZeitgeistEvent* _tmp153_;
				gint _tmp154_ = 0;
				sqlite3_stmt* _tmp155_;
				ZeitgeistEvent* _tmp156_;
				GPtrArray* _tmp157_;
				GPtrArray* _tmp158_;
				gint _tmp159_;
				gconstpointer _tmp160_ = NULL;
				ZeitgeistSubject* subject;
				sqlite3_stmt* _tmp161_;
				ZeitgeistSubject* _tmp162_;
				const gchar* _tmp163_;
				const gchar* _tmp164_;
				gchar* _tmp165_;
				GDestroyNotify _tmp166_;
				sqlite3_stmt* _tmp167_;
				ZeitgeistSubject* _tmp168_;
				const gchar* _tmp169_;
				const gchar* _tmp170_;
				gchar* _tmp171_;
				GDestroyNotify _tmp172_;
				ZeitgeistSQLiteTableLookup* _tmp173_;
				ZeitgeistSubject* _tmp174_;
				const gchar* _tmp175_;
				const gchar* _tmp176_;
				gint _tmp177_ = 0;
				gint _tmp178_;
				sqlite3_stmt* _tmp179_;
				ZeitgeistSQLiteTableLookup* _tmp180_;
				ZeitgeistSubject* _tmp181_;
				const gchar* _tmp182_;
				const gchar* _tmp183_;
				gint _tmp184_ = 0;
				gint _tmp185_;
				sqlite3_stmt* _tmp186_;
				sqlite3_stmt* _tmp187_;
				ZeitgeistSubject* _tmp188_;
				const gchar* _tmp189_;
				const gchar* _tmp190_;
				gchar* _tmp191_;
				GDestroyNotify _tmp192_;
				ZeitgeistSQLiteTableLookup* _tmp193_;
				ZeitgeistSubject* _tmp194_;
				const gchar* _tmp195_;
				const gchar* _tmp196_;
				gint _tmp197_ = 0;
				gint _tmp198_;
				sqlite3_stmt* _tmp199_;
				sqlite3_stmt* _tmp200_;
				ZeitgeistSubject* _tmp201_;
				const gchar* _tmp202_;
				const gchar* _tmp203_;
				gchar* _tmp204_;
				GDestroyNotify _tmp205_;
				sqlite3_stmt* _tmp206_;
				ZeitgeistSubject* _tmp207_;
				const gchar* _tmp208_;
				const gchar* _tmp209_;
				gchar* _tmp210_;
				GDestroyNotify _tmp211_;
				sqlite3_stmt* _tmp212_;
				gint _tmp213_ = 0;
				gint _tmp214_;
				_tmp150_ = _tmp149_;
				if (!_tmp150_) {
					gint _tmp151_;
					_tmp151_ = i;
					i = _tmp151_ + 1;
				}
				_tmp149_ = FALSE;
				_tmp152_ = i;
				_tmp153_ = event;
				_tmp154_ = zeitgeist_event_num_subjects (_tmp153_);
				if (!(_tmp152_ < _tmp154_)) {
					break;
				}
				_tmp155_ = insert_stmt;
				sqlite3_reset (_tmp155_);
				_tmp156_ = event;
				_tmp157_ = zeitgeist_event_get_subjects (_tmp156_);
				_tmp158_ = _tmp157_;
				_tmp159_ = i;
				_tmp160_ = g_ptr_array_index (_tmp158_, (guint) _tmp159_);
				subject = (ZeitgeistSubject*) _tmp160_;
				_tmp161_ = insert_stmt;
				_tmp162_ = subject;
				_tmp163_ = zeitgeist_subject_get_uri (_tmp162_);
				_tmp164_ = _tmp163_;
				_tmp165_ = g_strdup (_tmp164_);
				_tmp166_ = g_free;
				sqlite3_bind_text (_tmp161_, 8, _tmp165_, -1, _tmp166_);
				_tmp167_ = insert_stmt;
				_tmp168_ = subject;
				_tmp169_ = zeitgeist_subject_get_current_uri (_tmp168_);
				_tmp170_ = _tmp169_;
				_tmp171_ = g_strdup (_tmp170_);
				_tmp172_ = g_free;
				sqlite3_bind_text (_tmp167_, 9, _tmp171_, -1, _tmp172_);
				_tmp173_ = ((ZeitgeistDbReader*) self)->interpretations_table;
				_tmp174_ = subject;
				_tmp175_ = zeitgeist_subject_get_interpretation (_tmp174_);
				_tmp176_ = _tmp175_;
				_tmp177_ = zeitgeist_sq_lite_table_lookup_id_for_string (_tmp173_, _tmp176_, &_inner_error_);
				_tmp178_ = _tmp177_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0U;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0U;
					}
				}
				_tmp179_ = insert_stmt;
				sqlite3_bind_int64 (_tmp179_, 10, (gint64) _tmp178_);
				_tmp180_ = ((ZeitgeistDbReader*) self)->manifestations_table;
				_tmp181_ = subject;
				_tmp182_ = zeitgeist_subject_get_manifestation (_tmp181_);
				_tmp183_ = _tmp182_;
				_tmp184_ = zeitgeist_sq_lite_table_lookup_id_for_string (_tmp180_, _tmp183_, &_inner_error_);
				_tmp185_ = _tmp184_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0U;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0U;
					}
				}
				_tmp186_ = insert_stmt;
				sqlite3_bind_int64 (_tmp186_, 11, (gint64) _tmp185_);
				_tmp187_ = insert_stmt;
				_tmp188_ = subject;
				_tmp189_ = zeitgeist_subject_get_origin (_tmp188_);
				_tmp190_ = _tmp189_;
				_tmp191_ = g_strdup (_tmp190_);
				_tmp192_ = g_free;
				sqlite3_bind_text (_tmp187_, 12, _tmp191_, -1, _tmp192_);
				_tmp193_ = ((ZeitgeistDbReader*) self)->mimetypes_table;
				_tmp194_ = subject;
				_tmp195_ = zeitgeist_subject_get_mimetype (_tmp194_);
				_tmp196_ = _tmp195_;
				_tmp197_ = zeitgeist_sq_lite_table_lookup_id_for_string (_tmp193_, _tmp196_, &_inner_error_);
				_tmp198_ = _tmp197_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0U;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0U;
					}
				}
				_tmp199_ = insert_stmt;
				sqlite3_bind_int64 (_tmp199_, 13, (gint64) _tmp198_);
				_tmp200_ = insert_stmt;
				_tmp201_ = subject;
				_tmp202_ = zeitgeist_subject_get_text (_tmp201_);
				_tmp203_ = _tmp202_;
				_tmp204_ = g_strdup (_tmp203_);
				_tmp205_ = g_free;
				sqlite3_bind_text (_tmp200_, 14, _tmp204_, -1, _tmp205_);
				_tmp206_ = insert_stmt;
				_tmp207_ = subject;
				_tmp208_ = zeitgeist_subject_get_storage (_tmp207_);
				_tmp209_ = _tmp208_;
				_tmp210_ = g_strdup (_tmp209_);
				_tmp211_ = g_free;
				sqlite3_bind_text (_tmp206_, 15, _tmp210_, -1, _tmp211_);
				_tmp212_ = insert_stmt;
				_tmp213_ = sqlite3_step (_tmp212_);
				rc = _tmp213_;
				_tmp214_ = rc;
				if (_tmp214_ != SQLITE_DONE) {
					gint _tmp215_;
					guint32 _tmp222_;
					ZeitgeistSQLiteDatabase* _tmp223_;
					ZeitgeistSQLiteDatabase* _tmp224_;
					sqlite3_stmt* _tmp225_;
					sqlite3_stmt* retrieval_stmt;
					sqlite3_stmt* _tmp226_;
					sqlite3_stmt* _tmp227_;
					ZeitgeistEvent* _tmp228_;
					gint64 _tmp229_;
					gint64 _tmp230_;
					ZeitgeistSQLiteTableLookup* _tmp231_;
					ZeitgeistEvent* _tmp232_;
					const gchar* _tmp233_;
					const gchar* _tmp234_;
					gint _tmp235_ = 0;
					gint _tmp236_;
					sqlite3_stmt* _tmp237_;
					ZeitgeistSQLiteTableLookup* _tmp238_;
					ZeitgeistEvent* _tmp239_;
					const gchar* _tmp240_;
					const gchar* _tmp241_;
					gint _tmp242_ = 0;
					gint _tmp243_;
					sqlite3_stmt* _tmp244_;
					ZeitgeistSQLiteTableLookup* _tmp245_;
					ZeitgeistEvent* _tmp246_;
					const gchar* _tmp247_;
					const gchar* _tmp248_;
					gint _tmp249_ = 0;
					gint _tmp250_;
					sqlite3_stmt* _tmp251_;
					sqlite3_stmt* _tmp252_;
					gint _tmp253_ = 0;
					gint _tmp254_;
					sqlite3_stmt* _tmp261_;
					gint _tmp262_ = 0;
					_tmp215_ = rc;
					if (_tmp215_ != SQLITE_CONSTRAINT) {
						ZeitgeistSQLiteDatabase* _tmp216_;
						ZeitgeistSQLiteDatabase* _tmp217_;
						gint _tmp218_;
						gint _tmp219_;
						sqlite3* _tmp220_;
						const gchar* _tmp221_ = NULL;
						_tmp216_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
						_tmp217_ = _tmp216_;
						_tmp218_ = rc;
						zeitgeist_sq_lite_database_assert_not_corrupt (_tmp217_, _tmp218_, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
								g_propagate_error (error, _inner_error_);
								return 0U;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return 0U;
							}
						}
						_tmp219_ = rc;
						_tmp220_ = ((ZeitgeistDbReader*) self)->db;
						_tmp221_ = sqlite3_errmsg (_tmp220_);
						g_warning ("engine.vala:245: SQL error: %d, %s\n", _tmp219_, _tmp221_);
						result = (guint32) 0;
						return result;
					}
					_tmp222_ = self->priv->last_id;
					self->priv->last_id = _tmp222_ - 1;
					_tmp223_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
					_tmp224_ = _tmp223_;
					_tmp225_ = _tmp224_->id_retrieval_stmt;
					retrieval_stmt = _tmp225_;
					_tmp226_ = retrieval_stmt;
					sqlite3_reset (_tmp226_);
					_tmp227_ = retrieval_stmt;
					_tmp228_ = event;
					_tmp229_ = zeitgeist_event_get_timestamp (_tmp228_);
					_tmp230_ = _tmp229_;
					sqlite3_bind_int64 (_tmp227_, 1, _tmp230_);
					_tmp231_ = ((ZeitgeistDbReader*) self)->interpretations_table;
					_tmp232_ = event;
					_tmp233_ = zeitgeist_event_get_interpretation (_tmp232_);
					_tmp234_ = _tmp233_;
					_tmp235_ = zeitgeist_sq_lite_table_lookup_id_for_string (_tmp231_, _tmp234_, &_inner_error_);
					_tmp236_ = _tmp235_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							return 0U;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return 0U;
						}
					}
					_tmp237_ = retrieval_stmt;
					sqlite3_bind_int64 (_tmp237_, 2, (gint64) _tmp236_);
					_tmp238_ = ((ZeitgeistDbReader*) self)->manifestations_table;
					_tmp239_ = event;
					_tmp240_ = zeitgeist_event_get_manifestation (_tmp239_);
					_tmp241_ = _tmp240_;
					_tmp242_ = zeitgeist_sq_lite_table_lookup_id_for_string (_tmp238_, _tmp241_, &_inner_error_);
					_tmp243_ = _tmp242_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							return 0U;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return 0U;
						}
					}
					_tmp244_ = retrieval_stmt;
					sqlite3_bind_int64 (_tmp244_, 3, (gint64) _tmp243_);
					_tmp245_ = ((ZeitgeistDbReader*) self)->actors_table;
					_tmp246_ = event;
					_tmp247_ = zeitgeist_event_get_actor (_tmp246_);
					_tmp248_ = _tmp247_;
					_tmp249_ = zeitgeist_sq_lite_table_lookup_id_for_string (_tmp245_, _tmp248_, &_inner_error_);
					_tmp250_ = _tmp249_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							return 0U;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return 0U;
						}
					}
					_tmp251_ = retrieval_stmt;
					sqlite3_bind_int64 (_tmp251_, 4, (gint64) _tmp250_);
					_tmp252_ = retrieval_stmt;
					_tmp253_ = sqlite3_step (_tmp252_);
					rc = _tmp253_;
					_tmp254_ = rc;
					if (_tmp254_ != SQLITE_ROW) {
						ZeitgeistSQLiteDatabase* _tmp255_;
						ZeitgeistSQLiteDatabase* _tmp256_;
						gint _tmp257_;
						gint _tmp258_;
						sqlite3* _tmp259_;
						const gchar* _tmp260_ = NULL;
						_tmp255_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
						_tmp256_ = _tmp255_;
						_tmp257_ = rc;
						zeitgeist_sq_lite_database_assert_not_corrupt (_tmp256_, _tmp257_, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
								g_propagate_error (error, _inner_error_);
								return 0U;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return 0U;
							}
						}
						_tmp258_ = rc;
						_tmp259_ = ((ZeitgeistDbReader*) self)->db;
						_tmp260_ = sqlite3_errmsg (_tmp259_);
						g_warning ("engine.vala:266: SQL error: %d, %s\n", _tmp258_, _tmp260_);
						result = (guint32) 0;
						return result;
					}
					_tmp261_ = retrieval_stmt;
					_tmp262_ = sqlite3_column_int (_tmp261_, 0);
					result = (guint32) _tmp262_;
					return result;
				}
			}
		}
	}
	_tmp263_ = event;
	_tmp264_ = zeitgeist_event_get_interpretation (_tmp263_);
	_tmp265_ = _tmp264_;
	if (g_strcmp0 (_tmp265_, ZEITGEIST_ZG_MOVE_EVENT) == 0) {
		ZeitgeistEvent* _tmp266_;
		_tmp266_ = event;
		zeitgeist_engine_handle_move_event (self, _tmp266_);
	}
	_tmp267_ = event;
	_tmp268_ = zeitgeist_event_get_id (_tmp267_);
	_tmp269_ = _tmp268_;
	result = _tmp269_;
	return result;
}


static gint _sqlite3_exec (sqlite3* self, const gchar* sql, sqlite3_callback callback, void* callback_target, gchar** errmsg) {
	gchar* _vala_errmsg = NULL;
	gint result = 0;
	const gchar* sqlite_errmsg = NULL;
	const gchar* _tmp0_;
	sqlite3_callback _tmp1_;
	void* _tmp1__target;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint ec;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = sql;
	_tmp1_ = callback;
	_tmp1__target = callback_target;
	_tmp3_ = sqlite3_exec (self, _tmp0_, _tmp1_, _tmp1__target, (char**) (&_tmp2_));
	sqlite_errmsg = _tmp2_;
	ec = _tmp3_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = sqlite_errmsg;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp5_;
	}
	_tmp6_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp6_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}


ZeitgeistTimeRange* zeitgeist_engine_delete_events (ZeitgeistEngine* self, guint32* event_ids, int event_ids_length1, const char* sender, GError** error) {
	ZeitgeistTimeRange* result = NULL;
	guint32* _tmp0_;
	gint _tmp0__length1;
	ZeitgeistExtensionCollection* _tmp1_;
	guint32* _tmp2_;
	gint _tmp2__length1;
	const char* _tmp3_;
	gint _tmp4_ = 0;
	guint32* _tmp5_ = NULL;
	ZeitgeistSQLiteDatabase* _tmp6_;
	ZeitgeistSQLiteDatabase* _tmp7_;
	guint32* _tmp8_;
	gint _tmp8__length1;
	ZeitgeistTimeRange* _tmp9_ = NULL;
	ZeitgeistTimeRange* time_range;
	ZeitgeistSQLiteDatabase* _tmp10_;
	ZeitgeistSQLiteDatabase* _tmp11_;
	guint32* _tmp12_;
	gint _tmp12__length1;
	gchar* _tmp13_ = NULL;
	gchar* sql_event_ids;
	ZeitgeistTimeRange* _tmp14_;
	sqlite3* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	gint _tmp22_ = 0;
	gint _tmp23_;
	gint rc;
	ZeitgeistSQLiteDatabase* _tmp24_;
	ZeitgeistSQLiteDatabase* _tmp25_;
	gint _tmp26_;
	sqlite3* _tmp27_;
	gint _tmp28_ = 0;
	guint32* _tmp29_;
	gint _tmp29__length1;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_;
	ZeitgeistExtensionCollection* _tmp32_;
	guint32* _tmp33_;
	gint _tmp33__length1;
	const char* _tmp34_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = event_ids;
	_tmp0__length1 = event_ids_length1;
	g_return_val_if_fail (_tmp0__length1 > 0, NULL);
	_tmp1_ = self->priv->extension_collection;
	_tmp2_ = event_ids;
	_tmp2__length1 = event_ids_length1;
	_tmp3_ = sender;
	_tmp5_ = zeitgeist_extension_collection_call_pre_delete_events (_tmp1_, _tmp2_, _tmp2__length1, _tmp3_, &_tmp4_);
	event_ids = _tmp5_;
	event_ids_length1 = _tmp4_;
	_tmp6_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = event_ids;
	_tmp8__length1 = event_ids_length1;
	_tmp9_ = zeitgeist_sq_lite_database_get_time_range_for_event_ids (_tmp7_, _tmp8_, _tmp8__length1, &_inner_error_);
	time_range = _tmp9_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp10_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp11_ = _tmp10_;
	_tmp12_ = event_ids;
	_tmp12__length1 = event_ids_length1;
	_tmp13_ = zeitgeist_sq_lite_database_get_sql_string_from_event_ids (_tmp11_, _tmp12_, _tmp12__length1);
	sql_event_ids = _tmp13_;
	_tmp14_ = time_range;
	if (_tmp14_ == NULL) {
		const gchar* _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		_tmp15_ = sql_event_ids;
		_tmp16_ = g_strdup_printf ("Tried to delete non-existing event(s): %s", _tmp15_);
		_tmp17_ = _tmp16_;
		g_warning ("engine.vala:297: %s", _tmp17_);
		_g_free0 (_tmp17_);
		result = NULL;
		_g_free0 (sql_event_ids);
		_g_object_unref0 (time_range);
		return result;
	}
	_tmp18_ = ((ZeitgeistDbReader*) self)->db;
	_tmp19_ = sql_event_ids;
	_tmp20_ = g_strdup_printf ("DELETE FROM event WHERE id IN (%s)", _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = _sqlite3_exec (_tmp18_, _tmp21_, NULL, NULL, NULL);
	_tmp23_ = _tmp22_;
	_g_free0 (_tmp21_);
	rc = _tmp23_;
	_tmp24_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp25_ = _tmp24_;
	_tmp26_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (_tmp25_, _tmp26_, "engine.vala:304: SQL Error", SQLITE_OK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql_event_ids);
			_g_object_unref0 (time_range);
			return NULL;
		} else {
			_g_free0 (sql_event_ids);
			_g_object_unref0 (time_range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp27_ = ((ZeitgeistDbReader*) self)->db;
	_tmp28_ = sqlite3_changes (_tmp27_);
	_tmp29_ = event_ids;
	_tmp29__length1 = event_ids_length1;
	_tmp30_ = g_strdup_printf ("Deleted %d (out of %d) events.", _tmp28_, _tmp29__length1);
	_tmp31_ = _tmp30_;
	g_message ("engine.vala:305: %s", _tmp31_);
	_g_free0 (_tmp31_);
	_tmp32_ = self->priv->extension_collection;
	_tmp33_ = event_ids;
	_tmp33__length1 = event_ids_length1;
	_tmp34_ = sender;
	zeitgeist_extension_collection_call_post_delete_events (_tmp32_, _tmp33_, _tmp33__length1, _tmp34_);
	result = time_range;
	_g_free0 (sql_event_ids);
	return result;
}


/**
     * Clear all resources Engine is using (close database connection,
     * unload extensions, etc.).
     *
     * After executing this method on an Engine instance, no other function
     * of said instance may be called.
     */
static void zeitgeist_engine_real_close (ZeitgeistDbReader* base) {
	ZeitgeistEngine * self;
	self = (ZeitgeistEngine*) base;
	_g_object_unref0 (self->priv->extension_collection);
	self->priv->extension_collection = NULL;
	ZEITGEIST_DB_READER_CLASS (zeitgeist_engine_parent_class)->close (ZEITGEIST_DB_READER (self));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void zeitgeist_engine_handle_move_event (ZeitgeistEngine* self, ZeitgeistEvent* event) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				ZeitgeistEvent* _tmp4_;
				GPtrArray* _tmp5_;
				GPtrArray* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				ZeitgeistEvent* _tmp9_;
				GPtrArray* _tmp10_;
				GPtrArray* _tmp11_;
				gint _tmp12_;
				gconstpointer _tmp13_ = NULL;
				ZeitgeistSubject* _tmp14_;
				ZeitgeistSubject* subject;
				gint rc = 0;
				ZeitgeistSQLiteDatabase* _tmp15_;
				ZeitgeistSQLiteDatabase* _tmp16_;
				sqlite3_stmt* _tmp17_;
				sqlite3_stmt* move_stmt;
				sqlite3_stmt* _tmp18_;
				sqlite3_stmt* _tmp19_;
				ZeitgeistSubject* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				GDestroyNotify _tmp24_;
				sqlite3_stmt* _tmp25_;
				ZeitgeistSubject* _tmp26_;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				gchar* _tmp29_;
				GDestroyNotify _tmp30_;
				sqlite3_stmt* _tmp31_;
				ZeitgeistEvent* _tmp32_;
				const gchar* _tmp33_;
				const gchar* _tmp34_;
				gchar* _tmp35_;
				GDestroyNotify _tmp36_;
				sqlite3_stmt* _tmp37_;
				ZeitgeistEvent* _tmp38_;
				gint64 _tmp39_;
				gint64 _tmp40_;
				sqlite3_stmt* _tmp41_;
				gint _tmp42_ = 0;
				gint _tmp43_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = event;
				_tmp5_ = zeitgeist_event_get_subjects (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_ptr_array_get_length (_tmp6_);
				_tmp8_ = _tmp7_;
				if (!(_tmp3_ < _tmp8_)) {
					break;
				}
				_tmp9_ = event;
				_tmp10_ = zeitgeist_event_get_subjects (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = i;
				_tmp13_ = g_ptr_array_index (_tmp11_, (guint) _tmp12_);
				_tmp14_ = _g_object_ref0 ((ZeitgeistSubject*) _tmp13_);
				subject = _tmp14_;
				_tmp15_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
				_tmp16_ = _tmp15_;
				_tmp17_ = _tmp16_->move_handling_stmt;
				move_stmt = _tmp17_;
				_tmp18_ = move_stmt;
				sqlite3_reset (_tmp18_);
				_tmp19_ = move_stmt;
				_tmp20_ = subject;
				_tmp21_ = zeitgeist_subject_get_current_uri (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = g_strdup (_tmp22_);
				_tmp24_ = g_free;
				sqlite3_bind_text (_tmp19_, 1, _tmp23_, -1, _tmp24_);
				_tmp25_ = move_stmt;
				_tmp26_ = subject;
				_tmp27_ = zeitgeist_subject_get_uri (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_strdup (_tmp28_);
				_tmp30_ = g_free;
				sqlite3_bind_text (_tmp25_, 2, _tmp29_, -1, _tmp30_);
				_tmp31_ = move_stmt;
				_tmp32_ = event;
				_tmp33_ = zeitgeist_event_get_interpretation (_tmp32_);
				_tmp34_ = _tmp33_;
				_tmp35_ = g_strdup (_tmp34_);
				_tmp36_ = g_free;
				sqlite3_bind_text (_tmp31_, 3, _tmp35_, -1, _tmp36_);
				_tmp37_ = move_stmt;
				_tmp38_ = event;
				_tmp39_ = zeitgeist_event_get_timestamp (_tmp38_);
				_tmp40_ = _tmp39_;
				sqlite3_bind_int64 (_tmp37_, 4, _tmp40_);
				_tmp41_ = move_stmt;
				_tmp42_ = sqlite3_step (_tmp41_);
				rc = _tmp42_;
				_tmp43_ = rc;
				if (_tmp43_ != SQLITE_DONE) {
					gint _tmp44_;
					_tmp44_ = rc;
					if (_tmp44_ != SQLITE_CONSTRAINT) {
						gint _tmp48_;
						sqlite3* _tmp49_;
						const gchar* _tmp50_ = NULL;
						{
							ZeitgeistSQLiteDatabase* _tmp45_;
							ZeitgeistSQLiteDatabase* _tmp46_;
							gint _tmp47_;
							_tmp45_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
							_tmp46_ = _tmp45_;
							_tmp47_ = rc;
							zeitgeist_sq_lite_database_assert_not_corrupt (_tmp46_, _tmp47_, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
									goto __catch9_zeitgeist_engine_error;
								}
								_g_object_unref0 (subject);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						goto __finally9;
						__catch9_zeitgeist_engine_error:
						{
							GError* err = NULL;
							err = _inner_error_;
							_inner_error_ = NULL;
							_g_error_free0 (err);
						}
						__finally9:
						if (_inner_error_ != NULL) {
							_g_object_unref0 (subject);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						_tmp48_ = rc;
						_tmp49_ = ((ZeitgeistDbReader*) self)->db;
						_tmp50_ = sqlite3_errmsg (_tmp49_);
						g_warning ("engine.vala:350: SQL error: %d, %s\n", _tmp48_, _tmp50_);
					}
				}
				_g_object_unref0 (subject);
			}
		}
	}
}


static gint64 zeitgeist_engine_store_payload (ZeitgeistEngine* self, ZeitgeistEvent* event) {
	gint64 result = 0LL;
	ZeitgeistEvent* _tmp0_;
	GByteArray* _tmp1_;
	GByteArray* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0LL);
	g_return_val_if_fail (event != NULL, 0LL);
	_tmp0_ = event;
	_tmp1_ = zeitgeist_event_get_payload (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		gint rc = 0;
		ZeitgeistSQLiteDatabase* _tmp3_;
		ZeitgeistSQLiteDatabase* _tmp4_;
		sqlite3_stmt* _tmp5_;
		sqlite3_stmt* payload_insertion_stmt;
		sqlite3_stmt* _tmp6_;
		sqlite3_stmt* _tmp7_;
		ZeitgeistEvent* _tmp8_;
		GByteArray* _tmp9_;
		GByteArray* _tmp10_;
		guint8* _tmp11_;
		gint _tmp11__length1;
		ZeitgeistEvent* _tmp12_;
		GByteArray* _tmp13_;
		GByteArray* _tmp14_;
		guint8* _tmp15_;
		gint _tmp15__length1;
		sqlite3_stmt* _tmp16_;
		gint _tmp17_ = 0;
		gint _tmp18_;
		ZeitgeistSQLiteDatabase* _tmp26_;
		ZeitgeistSQLiteDatabase* _tmp27_;
		sqlite3* _tmp28_;
		gint64 _tmp29_ = 0LL;
		_tmp3_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_->payload_insertion_stmt;
		payload_insertion_stmt = _tmp5_;
		_tmp6_ = payload_insertion_stmt;
		sqlite3_reset (_tmp6_);
		_tmp7_ = payload_insertion_stmt;
		_tmp8_ = event;
		_tmp9_ = zeitgeist_event_get_payload (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_->data;
		_tmp11__length1 = (gint) _tmp10_->len;
		_tmp12_ = event;
		_tmp13_ = zeitgeist_event_get_payload (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_->data;
		_tmp15__length1 = (gint) _tmp14_->len;
		sqlite3_bind_blob (_tmp7_, 1, _tmp11_, _tmp15__length1, NULL);
		_tmp16_ = payload_insertion_stmt;
		_tmp17_ = sqlite3_step (_tmp16_);
		rc = _tmp17_;
		_tmp18_ = rc;
		if (_tmp18_ != SQLITE_DONE) {
			gint _tmp19_;
			_tmp19_ = rc;
			if (_tmp19_ != SQLITE_CONSTRAINT) {
				gint _tmp20_;
				sqlite3* _tmp21_;
				const gchar* _tmp22_ = NULL;
				_tmp20_ = rc;
				_tmp21_ = ((ZeitgeistDbReader*) self)->db;
				_tmp22_ = sqlite3_errmsg (_tmp21_);
				g_warning ("engine.vala:375: SQL error: %d, %s\n", _tmp20_, _tmp22_);
				{
					ZeitgeistSQLiteDatabase* _tmp23_;
					ZeitgeistSQLiteDatabase* _tmp24_;
					gint _tmp25_;
					_tmp23_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
					_tmp24_ = _tmp23_;
					_tmp25_ = rc;
					zeitgeist_sq_lite_database_assert_not_corrupt (_tmp24_, _tmp25_, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							goto __catch10_zeitgeist_engine_error;
						}
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0LL;
					}
				}
				goto __finally10;
				__catch10_zeitgeist_engine_error:
				{
					GError* err = NULL;
					err = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (err);
				}
				__finally10:
				if (_inner_error_ != NULL) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0LL;
				}
			}
		}
		_tmp26_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
		_tmp27_ = _tmp26_;
		_tmp28_ = _tmp27_->database;
		_tmp29_ = sqlite3_last_insert_rowid (_tmp28_);
		result = _tmp29_;
		return result;
	}
	result = (gint64) 0;
	return result;
}


static GObject * zeitgeist_engine_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ZeitgeistEngine * self;
	ZeitgeistExtensionStore* _tmp0_;
	parent_class = G_OBJECT_CLASS (zeitgeist_engine_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = ZEITGEIST_ENGINE (obj);
	_tmp0_ = zeitgeist_extension_store_new (self);
	_g_object_unref0 (self->extension_store);
	self->extension_store = _tmp0_;
	return obj;
}


static void zeitgeist_engine_class_init (ZeitgeistEngineClass * klass) {
	zeitgeist_engine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistEnginePrivate));
	ZEITGEIST_DB_READER_CLASS (klass)->close = zeitgeist_engine_real_close;
	G_OBJECT_CLASS (klass)->constructor = zeitgeist_engine_constructor;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_engine_finalize;
}


static void zeitgeist_engine_instance_init (ZeitgeistEngine * self) {
	self->priv = ZEITGEIST_ENGINE_GET_PRIVATE (self);
}


static void zeitgeist_engine_finalize (GObject* obj) {
	ZeitgeistEngine * self;
	self = ZEITGEIST_ENGINE (obj);
	_g_object_unref0 (self->extension_store);
	_g_object_unref0 (self->priv->extension_collection);
	G_OBJECT_CLASS (zeitgeist_engine_parent_class)->finalize (obj);
}


GType zeitgeist_engine_get_type (void) {
	static volatile gsize zeitgeist_engine_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistEngine), 0, (GInstanceInitFunc) zeitgeist_engine_instance_init, NULL };
		GType zeitgeist_engine_type_id;
		zeitgeist_engine_type_id = g_type_register_static (ZEITGEIST_TYPE_DB_READER, "ZeitgeistEngine", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_engine_type_id__volatile, zeitgeist_engine_type_id);
	}
	return zeitgeist_engine_type_id__volatile;
}



