use Test::More tests => 30;

use File::BaseDir qw/xdg_data_dirs/;
$ENV{XDG_DATA_DIRS} = join ':', 'share', xdg_data_dirs;

for my $class (qw/
	Zim::File
	Zim::Template
	Zim::Formats::Wiki
	Zim::Formats::Html
	Zim::Page
	Zim::Page::Text
	Zim::History
	Zim::Selection
	Zim::Repository
	Zim::Repository::Base
	Zim::Repository::Files
	Zim::Repository::Man
	Gtk2::Ex::PathBar
	Gtk2::Ex::HyperTextView
	Gtk2::Ex::HyperTextBuffer
	Zim::GUI::Component
	Zim::GUI::PageView
	Zim::GUI::TreeView
	Zim::GUI::PathBar
	Zim::GUI::Calendar
	Zim::GUI::SearchDialog
	Zim::GUI::FindReplaceDialog
	Zim::GUI::ExportDialog
	Zim::GUI::PreferencesDialog
	Zim::GUI::PropertiesDialog
	Zim::GUI
/) {
	use_ok($class);
}

SKIP: {
	eval "use Gtk2::TrayIcon";
	skip('No Gtk2::TrayIcon available', 1) if $@;
	use_ok('Zim::GUI::TrayIcon');
};

SKIP: {
	eval "use Gtk2::Spell";
	skip('No Gtk2::Spell available', 1) if $@;
	use_ok('Zim::GUI::Spell');
};

SKIP: {
	skip("use Win32 module", 1) unless $^O eq 'MSWin32';
	use_ok('Zim::Win32');
};

SKIP: {
	eval 'use File::MimeInfo::Applications';
	skip('No File::MimeInfo::Applications available', 1) if $@;
	use_ok('Gtk2::Ex::DesktopEntryMenu');
};

