"""
$RCSfile: XSLTChallenges.py,v $
Some tests for compliance of XSLT processors
Edge cases, areas where the spec is unclear,
and processors are likely to break or produce
widely differing results

Author: <a href="mailto:cstrong@arielpartners.com">Craeg Strong</a>
Release: 1.0
"""

__cvstag__  = '$Name:  $'[6:-2]
__date__    = '$Date: 2003/03/30 20:51:59 $'[6:-2]
__version__ = '$Revision: 1.4 $'[10:-2]

import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

# Load fixture
from Testing import ZopeTestCase

ZopeTestCase.installProduct('ZopeXMLMethods')

# XMLTransform
from Products.ZopeXMLMethods.ProcessorChooser import ProcessorChooser

class XSLTChallengesTestCase(ZopeTestCase.ZopeTestCase):
    """

    XSLT Processor challenge cases.  This is particularly useful to
    test the differences between XSLT processors, for example between
    Pyana and different releases of 4Suite.  This file is not included
    in the automated test suite, rather it is invoked by hand.  The
    reason is that these edge cases or pathological cases will rarely
    or never be encountered in actual practice.

    """

    ################################################################
    # Fixture
    ################################################################

    def afterSetUp(self):
        '''Add object to default fixture'''
        prod               = self.folder.manage_addProduct['ZopeXMLMethods']
        self.chooser       = ProcessorChooser()
        self.processorList = self.chooser.processors()
        if len(self.processorList) == 0:
            raise Exception('Error: no supported XSLT Processors found')

        # If you want to choose only a specific XSLT processor,
        # manipulate the processorList here or in ProcessorChooser.py

    def afterClear(self):
        '''Clean up after myself'''
        try: del self.prod
        except AttributeError: pass

    ################################################################
    # Test Cases
    ################################################################

    def test_01(self):
        "Test that the processor supports EXSLT func dyn:evalute"

        xmlFile      = open('testfiles/evaluate.xml', 'rb')
        xmlContents  = xmlFile.read()
        xsltFile     = open('testfiles/dynevaluate.xsl','rb')
        xsltContents = xsltFile.read()

        print
        for name in self.processorList:
            print "Testing processor", name,
            processor = self.chooser.processorObject(name)
            result = processor.transformGuts(xmlContents, "", xsltContents,
                                             "", None, None, None)
            self.assertEquals(result.strip(), "Hello, world")
            print "...ok"

    def test_02(self):
        "Test that the processor supports namespaces in attributes edgecases"

        xmlFile      = open('testfiles/simple.xml', 'rb')
        xmlContents  = xmlFile.read()
        xsltFile     = open('testfiles/namespaces.xsl','rb')
        xsltContents = xsltFile.read()

        print
        for name in self.processorList:
            print "Testing processor", name
            processor = self.chooser.processorObject(name)
            result = processor.transformGuts(xmlContents, "", xsltContents,
                                             "", None, None, None)
            print result.strip()
            print "...ok"

    def test_03(self):
        "Test self:: axis stuff"

        xmlContents  = []
        xsltContents = []
        xmlFile      = open('testfiles/selftest1.xml', 'rb')
        xmlContents.append(xmlFile.read())
        xmlFile      = open('testfiles/selftest2.xml', 'rb')
        xmlContents.append(xmlFile.read())
        xmlFile      = open('testfiles/selftest2.xml', 'rb')
        xmlContents.append(xmlFile.read())
        xsltFile      = open('testfiles/selftest1.xsl','rb')
        xsltContents.append(xsltFile.read())
        xsltFile      = open('testfiles/selftest2.xsl','rb')
        xsltContents.append(xsltFile.read())
        xsltFile      = open('testfiles/selftest3.xsl','rb')
        xsltContents.append(xsltFile.read())

        print
        for i in range(3):
            for name in self.processorList:
                print "Testing processor", name
                processor = self.chooser.processorObject(name)
                result = processor.transformGuts(xmlContents[i], "",
                                                 xsltContents[i], "",
                                                 None, None, None)
                print result.strip()
                print "...ok"

    def test_04(self):
        "Test namespace stuff"

        xmlFile      = open('testfiles/selftest1.xml', 'rb')
        xmlContents  = xmlFile.read()
        xsltFile     = open('testfiles/bar.xsl','rb')
        xsltContents = xsltFile.read()

        print
        for name in self.processorList:
            print "Testing processor", name
            processor = self.chooser.processorObject(name)
            result = processor.transformGuts(xmlContents, "", xsltContents,
                                             "", None, None, None)
            print result.strip()
            print "...ok"

    ################################################################
    # Test Runner Setup
    ################################################################

if __name__ == '__main__':
    framework(descriptions=1, verbosity=2)
else:
    # While framework.py provides its own test_suite() 
    # method the testrunner utility does not.
    import unittest
    def test_suite():
        suite = unittest.TestSuite()
        suite.addTest(unittest.makeSuite(XSLTChallengesTestCase))
        return suite
