##############################################################################
#
# Copyright (c) 2002 Ingeniweb SARL
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
#
##############################################################################

"""
ZAttachmentAttribute product

Configuration file.
You can edit this file.
"""

import sys
import string
import App.Common
import string
import os.path

from Products.ZAttachmentAttribute.Log import *


# Converter program
PACKAGE_HOME = App.Common.package_home(globals())
CONVERTER_PROGRAM = None
if sys.platform == 'win32':
    # Windows platform
    CONVERTER_PROGRAM = '"' + os.path.join(PACKAGE_HOME, "win32", "xlhtml.exe", ) + '"' 
    Log(LOG_DEBUG, "Using '%s'." % (CONVERTER_PROGRAM,))
    try:
        open(CONVERTER_PROGRAM[1:-1], "r")
    except:
        Log(LOG_WARNING, "Converter program '%s' not found ! Please check your installation" % (CONVERTER_PROGRAM,))

else:
    # Unix platform
    import commands
    program = commands.getoutput("which xlhtml")
    if not program:
        Log(LOG_WARNING, "MSExcelAttachment: xlhtml not found ! Indexing won't work.")
    else:
        CONVERTER_PROGRAM = string.strip(program)
        Log(LOG_NOTICE, "MSExcelAttachment: Using '%s' for indexing." % (CONVERTER_PROGRAM, ))
