# Copyright (c) 2001-2004 Twisted Matrix Laboratories.
# See LICENSE for details.

#

"""Interface definitions for working with raw packets"""

from twisted.internet import protocol
from twisted.python import components

class IRawDatagramProtocol(components.Interface):
    """An interface for protocols such as UDP, ICMP and TCP."""

    def addProto():
        """
        Add a protocol on top of this one.
        """

    def datagramReceived():
        """
        An IP datagram has been received. Parse and process it.
        """

class IRawPacketProtocol(components.Interface):
    """An interface for low-level protocols such as IP and ARP."""

    def addProto():
        """
        Add a protocol on top of this one.
        """

    def datagramReceived():
        """
        An IP datagram has been received. Parse and process it.
        """
