############################################################################
##
## Copyright (c) 2000, 2001, 2002, 2003, 2004, 2005 BalaBit IT Ltd, Budapest, Hungary
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##
## $Id: Telnet.py,v 1.21 2004/07/28 14:36:07 sasa Exp $
##
## Author  : hidden
## Auditor :
## Last audited version:
## Notes:
##
############################################################################

"""Module defining interface to the Telnet proxy.

This module defines the interface to the Telnet proxy implemented by
the Zorp Telnet module, and provides pre-configured classes for different
tasks.
"""


from Zorp import *
from Proxy import Proxy

TELNET_OPT_ACCEPT = 1
TELNET_OPT_REJECT = 3
TELNET_OPT_ABORT  = 4
TELNET_OPT_DROP   = 5
TELNET_OPT_POLICY = 6

# No negotation is needed for that command
TELNET_NEG_NONE = 255

# option name				value	RFC
# ------------------------- ------	------
#TELNET_BINARY				= "0"	# 856

TELNET_ECHO					= "1"	# 857

TELNET_SUPPRESS_GO_AHEAD	= "3"	# 858

#TELNET_STATUS				= "5"	# 859 
#TELNET_SB_STATUS_SB_IS				= "0"
#TELNET_SB_STATUS_SB_SEND			= "1"

#TELNET_TIMING_MARK			= "6"	# 860

#TELNET_RCTE				= "7"	# 726

#TELNET_NAOCRD				= "10"	# 652
#TELNET_SB_NAOCRD_DR				= "0"
#TELNET_SB_NAOCRD_DS				= "1"

#TELNET_NAOHTS				= "11"	# 653
#TELNET_SB_NAOHTS_DR				= "0"
#TELNET_SB_NAOHTS_DS				= "1"

#TELNET_NAOHTD				= "12"	# 654
#TELNET_SB_NAOHTD_DR				= "0"
#TELNET_SB_NAOHTD_DS				= "1"

#TELNET_NAOFFD				= "13"	# 655
#TELNET_SB_NAOFFD_DR				= "0"
#TELNET_SB_NAOFFD_DS				= "1"

#TELNET_NAOVTS				= "14"	# 656
#TELNET_SB_NAOVTS_DR				= "0"
#TELNET_SB_NAOVTS_DS				= "1"

#TELNET_NAOVTD				= "15"	# 657
#TELNET_SB_NAOVTD_DR				= "0"
#TELNET_SB_NAOVTD_DS				= "1"

#TELNET_NAOLFD				= "16"	# 658
#TELNET_SB_NAOLFD_DR				= "0"
#TELNET_SB_NAOLFD_DS				= "1"

#TELNET_EXTEND_ASCII		= "17"	# 698

#TELNET_LOGOUT				= "18"	# 727

#TELNET_BM					= "19"	# 735
#TELNET_SB_BM_DEFINE				= "1"
#TELNET_SB_BM_ACCEPT				= "2"
#TELNET_SB_BM_REFUSE				= "3"
#TELNET_SB_BM_LITERAL				= "4"
#TELNET_SB_BM_CANCEL				= "5"

#TELNET_DET					= "20"	# 1043, 732
#TELNET_SB_DET_DEFINE				= "1"
#TELNET_SB_DET_ERASE				= "2"
#TELNET_SB_DET_TRANSMIT				= "3"
#TELNET_SB_DET_FORMAT				= "4"
#TELNET_SB_DET_MOVE_CURSOR			= "5"
#TELNET_SB_DET_SKIP_TO_LINE			= "6"
#TELNET_SB_DET_SKIP_TO_CHAR			= "7"
#TELNET_SB_DET_UP					= "8"
#TELNET_SB_DET_DOWN					= "9"
#TELNET_SB_DET_LEFT					= "10"
#TELNET_SB_DET_RIGHT				= "11"
#TELNET_SB_DET_HOME					= "12"
#TELNET_SB_DET_LINE_INSERT			= "13"
#TELNET_SB_DET_LINE_DELETE			= "14"
#TELNET_SB_DET_CHAR_INSERT			= "15"
#TELNET_SB_DET_CHAR_DELETE			= "16"
#TELNET_SB_DET_READ_CURSOR			= "17"
#TELNET_SB_DET_CURSOR_POSITION		= "18"
#TELNET_SB_DET_REVERSE_TAB			= "19"
#TELNET_SB_DET_TRANSMIT_SCREEN		= "20"
#TELNET_SB_DET_TRANSMIT_UNPROTECTED	= "21"
#TELNET_SB_DET_TRANSMIT_LINE		= "22"
#TELNET_SB_DET_TRANSMIT_FIELD		= "23"
#TELNET_SB_DET_TRANSMIT_REST_SCREEN	= "24"
#TELNET_SB_DET_TRANSMIT_REST_LINE	= "25"
#TELNET_SB_DET_TRANSMIT_REST_FIELD	= "26"
#TELNET_SB_DET_TRANSMIT_MODIFIED	= "27"
#TELNET_SB_DET_DATA_TRANSMIT		= "28"
#TELNET_SB_DET_ERASE_SCREEN			= "29"
#TELNET_SB_DET_ERASE_LINE			= "30"
#TELNET_SB_DET_ERASE_FIELD			= "31"
#TELNET_SB_DET_ERASE_REST_SCREEN	= "32"
#TELNET_SB_DET_ERASE_REST_LINE		= "33"
#TELNET_SB_DET_ERASE_REST_FIELD		= "34"
#TELNET_SB_DET_ERASE_UNPROTECTED	= "35"
#TELNET_SB_DET_FORMAT_DATA			= "36"
#TELNET_SB_DET_REPEAT				= "37"
#TELNET_SB_DET_SUPPRESS_PROTECTION	= "38"
#TELNET_SB_DET_FIELD_SEPARATOR		= "39"
#TELNET_SB_DET_FN					= "40"
#TELNET_SB_DET_ERROR				= "41"

#TELNET_SUPDUP				= "21"	# 736, 734

#TELNET_SUPDUP_OUTPUT		= "22"	# 749

#TELNET_SEND_LOCATION		= "23"	# 779

TELNET_TERMINAL_TYPE		= "24"	# 1091
TELNET_SB_TERMINAL_TYPE_IS			= "0"
TELNET_SB_TERMINAL_TYPE_SEND		= "1"

TELNET_EOR					= "25"	# 885

#TELNET_TUID				= "26"	# 927

#TELNET_OUTMRK				= "27"	# 933

#TELNET_TTYLOC				= "28	# 946

#TELNET_3270_REGIME			= "29"	# 1041
#TELNET_SB_3270_REGIME_IS			= "0"
#TELNET_SB_3270_REGIME_ARE			= "1"

#TELNET_X3_PAD				= "30"	# 1053
#TELNET_SB_X3_PAD_SET				= "0"
#TELNET_SB_X3_PAD_RESPONSE_SET		= "1"
#TELNET_SB_X3_PAD_IS				= "2"
#TELNET_SB_X3_PAD_RESPONSE_IS		= "3"
#TELNET_SB_X3_PAD_SEND				= "4"

TELNET_NAWS					= "31"	# 1073

TELNET_TERMINAL_SPEED		= "32"	# 1079
TELNET_SB_TERMINAL_SPEED_IS			= "0"
TELNET_SB_TERMINAL_SPEED_SEND		= "1"

#TELNET_TOGGLE_FLOW_CONTROL	= "33"	# 1372
#TELNET_SB_TOGGLE_FLOW_CONTROL_OFF			= "0"
#TELNET_SB_TOGGLE_FLOW_CONTROL_ON			= "1"
#TELNET_SB_TOGGLE_FLOW_CONTROL_RESTART_ANY	= "2"
#TELNET_SB_TOGGLE_FLOW_CONTROL_RESTART_XON	= "3"

#TELNET_LINEMODE			= "34"	# 1184
#TELNET_SB_LINEMODE_MODE			= "1"
#TELNET_SB_LINEMODE_FORWARDMASK		= "2"
#TELNET_SB_LINEMODE_SLC				= "3"

TELNET_X_DISPLAY_LOCATION	= "35"	# 1096
TELNET_SB_X_DISPLAY_LOCATION_IS		= "0"
TELNET_SB_X_DISPLAY_LOCATION_SEND	= "1"

#TELNET_OLD_ENVIRONMENT		= "36"	# 1408
#TELNET_SB_OLD_ENVIRONMENT_IS		= "0"
#TELNET_SB_OLD_ENVIRONMENT_SEND		= "1"
#TELNET_SB_OLD_ENVIRONMENT_INFO		= "2"

#TELNET_AUTHENTICATION		= "37"	# 2941
#TELNET_SB_AUTHENTICATION_IS		= "0"
#TELNET_SB_AUTHENTICATION_SEND		= "1"
#TELNET_SB_AUTHENTICATION_REPLY		= "2"
#TELNET_SB_AUTHENTICATION_NAME		= "3"

#TELNET_ENCRYPT				= "38"	# 2946
#TELNET_SB_ENCRYPT_IS				= "0"
#TELNET_SB_ENCRYPT_SUPPORT			= "1"
#TELNET_SB_ENCRYPT_REPLY			= "2"
#TELNET_SB_ENCRYPT_START			= "3"
#TELNET_SB_ENCRYPT_END				= "4"
#TELNET_SB_ENCRYPT_REQUEST_START	= "5"
#TELNET_SB_ENCRYPT_REQUEST_END		= "6"
#TELNET_SB_ENCRYPT_ENC_KEYID		= "7"
#TELNET_SB_ENCRYPT_DEC_KEYID		= "8"

TELNET_ENVIRONMENT			= "39"	# 1572
TELNET_SB_ENVIRONMENT_IS			= "0"
TELNET_SB_ENVIRONMENT_SEND			= "1"
TELNET_SB_ENVIRONMENT_INFO			= "2"

#TELNET_TN3270E				= "40"	# 1647
#TELNET_SB_TN3270E_ASSOCIATE		= "0"
#TELNET_SB_TN3270E_CONNECT			= "1"
#TELNET_SB_TN3270E_DEVICE_TYPE		= "2"
#TELNET_SB_TN3270E_FUNCTIONS		= "3"
#TELNET_SB_TN3270E_IS				= "4"
#TELNET_SB_TN3270E_REASON			= "5"
#TELNET_SB_TN3270E_REJECT			= "6"
#TELNET_SB_TN3270E_REQUEST			= "7"
#TELNET_SB_TN3270E_SEND				= "8"

#TELNET_CHARSET				= "42"	# 2066
#TELNET_SB_CHARSET_REQUEST			= "1"
#TELNET_SB_CHARSET_ACCEPTED			= "2"
#TELNET_SB_CHARSET_REJECTED			= "3"
#TELNET_SB_CHARSET_TTABLE_IS		= "4"
#TELNET_SB_CHARSET_TTABLE_REJECTED	= "5"
#TELNET_SB_CHARSET_TTABLE_ACK		= "6"
#TELNET_SB_CHARSET_TTABLE_NAK		= "7"

#TELNET_COM_PORT            = "44"	# 2217
#TELNET_SB_COM_PORT_CLI_SET_BAUDRATE		= "1"
#TELNET_SB_COM_PORT_CLI_SET_DATASIZE		= "2"
#TELNET_SB_COM_PORT_CLI_SET_PARITY			= "3"
#TELNET_SB_COM_PORT_CLI_SET_STOPSIZE		= "4"
#TELNET_SB_COM_PORT_CLI_SET_CONTROL			= "5"
#TELNET_SB_COM_PORT_CLI_NOTIFY_LINESTATE	= "6"
#TELNET_SB_COM_PORT_CLI_NOTIFY_MODEMSTATE	= "7"
#TELNET_SB_COM_PORT_CLI_FLOWCONTROL_SUSPEND	= "8"
#TELNET_SB_COM_PORT_CLI_FLOWCONTROL_RESUME	= "9"
#TELNET_SB_COM_PORT_CLI_SET_LINESTATE_MASK	= "10"
#TELNET_SB_COM_PORT_CLI_SET_MODEMSTATE_MASK	= "11"
#TELNET_SB_COM_PORT_CLI_PURGE_DATA			= "12"
#TELNET_SB_COM_PORT_SVR_SET_BAUDRATE		= "101"
#TELNET_SB_COM_PORT_SVR_SET_DATASIZE		= "102"
#TELNET_SB_COM_PORT_SVR_SET_PARITY			= "103"
#TELNET_SB_COM_PORT_SVR_SET_STOPSIZE		= "104"
#TELNET_SB_COM_PORT_SVR_SET_CONTROL			= "105"
#TELNET_SB_COM_PORT_SVR_NOTIFY_LINESTATE	= "106"
#TELNET_SB_COM_PORT_SVR_NOTIFY_MODEMSTATE	= "107"
#TELNET_SB_COM_PORT_SVR_FLOWCONTROL_SUSPEND	= "108"
#TELNET_SB_COM_PORT_SVR_FLOWCONTROL_RESUME	= "109"
#TELNET_SB_COM_PORT_SVR_SET_LINESTATE_MASK	= "110"
#TELNET_SB_COM_PORT_SVR_SET_MODEMSTATE_MASK	= "111"
#TELNET_SB_COM_PORT_SVR_PURGE_DATA			= "112"

#TELNET_KERMIT				= "47"	# 2840
#TELNET_SB_KERMIT_START_SERVER		= "0"
#TELNET_SB_KERMIT_STOP_SERVER		= "1"
#TELNET_SB_KERMIT_REQ_START_SERVER	= "2"
#TELNET_SB_KERMIT_REQ_STOP_SERVER	= "3"
#TELNET_SB_KERMIT_SOP				= "4"
#TELNET_SB_KERMIT_RESP_START_SERVER	= "8"
#TELNET_SB_KERMIT_RESP_STOP_SERVER	= "9"

TELNET_EXOPL				= "255"	# 861

#TELNET_SUBLIMINAL_MSG		= "257" # 1097


################################################################################
# Non-RFC telnet options
#
# 2 - reconnection					# [nic 50005]
# 4 - approx msg size negotiation	# [ethernet]
# 8 - output line width				# [nic 50005]
# 9 - output page size				# [nic 50005]
# 41 - xauth						# [Earhart]
# 43 - remote serial port			# [Barnes]
# 45 - suppress local echo			# [Atmar]
# 46 - start tls					# [Boe]
# 48 - send url						# [Croft]
# 49 - forward X					# [Altman]
# 50-137 - unassigned				# [IANA]
# 138 - telopt pragma logon			# [McGregory]
# 139 - telopt sspi logon			# [McGregory]
# 140 - telopt pargma heartbeat		# [McGregory]
# 141-254 - unassigned				# [IANA]
# 256 - unassigned					# [IANA]

TELNET_SB_IS   = "0"
TELNET_SB_SEND = "1"
TELNET_SB_INFO = "2"

TELNET_POLICY = "telnet.policy"

class AbstractTelnetProxy(Proxy):
	"""Wrapper class for the Telnet proxy

	TelnetProxy is a wrapper class for the built-in Telnet proxy in Zorp. It
	implements the Telnet protocol, as described in RFC 854, and most common
	extensions. Although not all possible options are checked at the low
	level proxy, the administrator has the possibility to filter any option
	and suboption negotiation sequence using policy callbacks.

	Usage

	  Default policy

	    The low level Telnet proxy denies every option and suboption negotiation
	    sequences by default, and provides the administrator with methods to
	    change this default behaviour. As the low level implementation denies
	    everything, the default policy of the TelnetProxy class has been set
	    so that all important options (which are necessary to use Telnet to
	    log in to other machines) and their suboption negotiation sequences are
	    allowed. These are: Telnet Terminal Type, Telnet X Display Location,
	    Telnet Environment, Telnet Suppress Go Ahead, Telnet NAWS (Negotiation
	    About Window Size), and Telnet Echo.

	  Setting policy in general

	    As Telnet is a symmetrical protocol, there is no point in dividing the
	    data stream into requests and responses. Instead of this, the administrator
	    can define which options the Telnet session may use, and can filter the
	    suboption negotiation sequences of these options. Changing the default policy
	    can be done using the multi-dimensional hash (DimHash) 'policy'. It is
	    indexed with one or two values: the first is the option, and the optional
	    second one is the suboption which you want to filter.

	  Setting policy for option negotiation

	    To determine which options to enable in the session, the low level Telnet
	    proxy consults the 'policy' hash: the proxy looks up the hash value corresponding
	    the option number as a key. If the hash contains no entry for that number, the
	    default policy '*' is looked used. If there is no default policy defined,
	    the option negotiation is denied: the option won't be used in the session.

	    If a match is found, the corresponding tuple is used to determine the action
	    to take. This tuple consists of one or two elements. The first is an integer,
	    the second is optional: if the first value is TELNET_OPTION_POLICY, the second
	    must be the name of the callback function)

	      TELNET_OPT_ACCEPT -- [] allow option

	      TELNET_OPT_DROP   -- [] drop option

	      TELNET_OPT_ABORT  -- [] deny option and terminate the Telnet session

	      TELNET_OPT_POLICY -- [METHOD] call the function given in the second tuple item
	      			      This second item must be a callable Python function,
				      taking exactly two parameters: self and option (option
				      is an integer). The function must return one of these
				      action codes, excluding TELNET_OPTION_POLICY.

	      Example (Sample for disabling Telnet X Display Location option)

	        class MyTelnetProxy(TelnetProxy):

		  def config(self):
		    TelnetProxy.config(self)
		    self.policy[TELNET_X_DISPLAY_LOCATION] = (TELNET_OPT_REJECT)

		    
	  Setting policy for suboption negotiation

	    To change the default processing (deny) of suboption negotiation sequences,
	    you must enable the suboption negotiation subcommands for each option. You
	    can do this by adding tuples to the 'policy' hash, indexed by two values: the
	    option and the suboption negotiation subcommand. For example, if the low
	    level implementation detects that a suboption negotiation sequence follows,
	    it looks up the tuple corresponding the indexes (option number, subcommand).
	    If a match is not found, the subcommand is substituted with '*', and the lookup
	    is repeated. If there is still no match, the subcommand is restored and the
	    option is substituted with '*'. The last combination of index values looked up
	    is ('*', '*'). For example, for the SEND subcommand of Telnet Terminal Type
	    option, the following lookups are made (in this order):

	      1. "24", "1"	(24 is the code of Telnet Terminal Type option)
	      2. "24", "*"
	      3. "*",  "1"
	      4. "*",  "*"

	    If a match is found, the corresponding tuple is used to determine the necessary
	    action. This tuple has one or two elements: the first one defines the action,
	    the second may be the name of a function, used only if the first one is
	    TELNET_OPTION_POLICY. Possible values for the first value:

	      TELNET_OPT_ACCEPT -- [] allow suboption negotiation sequence

	      TELNET_OPT_DROP   -- [] deny suboption negotiation sequence

	      TELNET_OPT_ABORT  -- [] deny suboption negotiation, and terminate session

	      TELNET_OPT_POLICY -- [METHOD] call the function given in the second tuple item
	      			      This second item must be a callable Python function,
				      taking exactly four parameters: self, option, name
				      and value. The function must return one of these
				      action codes, excluding TELNET_OPTION_POLICY.

	    Policy callback functions can be used to make decisions based on the
	    conent of the suboption negotiation sequence. For example, the Telnet
	    Environment option's suboption negotiation sequences transfer environment
	    variables. The low level proxy implementation parses these variables, and
	    passes their name and value to the callback function, one at a time. These
	    values van be also changed during transfer, by changing the var_name and
	    var_value attributes of the proxy class.

	    Example (Rewriting the DISPLAY environment variable):

	      class MyRewritingTelnetProxy(TelnetProxy):

	        def config(self):
		  TelnetProxy.config()
		  self.policy[TELNET_ENVIRONMENT, TELNET_SB_IS] = (TELNET_OPTION_POLICY, self.rewriteVar)

		def rewriteVar(self, option, name, value):
		  if name == "DISPLAY":
		  	self.var_value = "rewritten_value:0"
		  return TELNET_OPTION_ACCEPT

	Attributes
	
	  option                      -- [HASH;STRING_multi;TELNET_OPT:empty:RW:RW] multi-dimensional
					 policy hash, directing the proxy to do
					 something with incoming negotiation
					 sequences

	  negotiation		      -- [HASH;STRING;INTEGER:empty:RW:RW]
					 This normative hash describe that
					 for a command whcih option must be
					 negotiated. There a special key,
					 TELNET_NEG_NONE, when no negotation
					 needed.

	  current_var_name            -- [STRING:n/a:-:RW] name of the variable
					 negotiated

	  current_var_value           -- [STRING:n/a:-:RW] value of the variable
					 negotiated (for example: value of an
					 environment variable, an X display
					 location value, etc.)

	  timeout                     -- [INTEGER:600000:RW:R] I/O timeout in
					 milliseconds
	
	"""

	name = "telnet"

	def __init__(self, session):
		"""Constructor to initialize a TelnetProxy instance.

		This function initializes a TelnetProxy instance by calling
		the inherited __init__ constructor with appropriate
		parameters.
		"""
		Proxy.__init__(self, session)

	def config(self):
		pass

class TelnetProxy(AbstractTelnetProxy):

	def config(self):
		self.option["*"] = TELNET_OPT_ACCEPT
		self.option["*", "*"] = TELNET_OPT_ACCEPT
		self.negotiation["239"] = int(TELNET_EOR)

class TelnetProxyStrict(AbstractTelnetProxy):

	def config(self):
		"""Configuration for Strict TelnetProxy

		It enables all options needed for a useful Telnet session.
		"""
		self.option[TELNET_ECHO]		= TELNET_OPT_ACCEPT
		self.option[TELNET_SUPPRESS_GO_AHEAD]	= TELNET_OPT_ACCEPT
		self.option[TELNET_TERMINAL_TYPE]	= TELNET_OPT_ACCEPT
		self.option[TELNET_NAWS]		= TELNET_OPT_ACCEPT
		self.option[TELNET_EOR]			= TELNET_OPT_ACCEPT
		self.option[TELNET_TERMINAL_SPEED]	= TELNET_OPT_ACCEPT
		self.option[TELNET_X_DISPLAY_LOCATION]	= TELNET_OPT_ACCEPT
		self.option[TELNET_ENVIRONMENT]		= TELNET_OPT_ACCEPT

		self.option["*"]			= TELNET_OPT_REJECT

		self.option[TELNET_TERMINAL_TYPE,	TELNET_SB_TERMINAL_TYPE_IS] 		= TELNET_OPT_ACCEPT
		self.option[TELNET_TERMINAL_TYPE,	TELNET_SB_TERMINAL_TYPE_SEND] 		= TELNET_OPT_ACCEPT
		self.option[TELNET_TERMINAL_SPEED,	TELNET_SB_TERMINAL_SPEED_IS] 		= TELNET_OPT_ACCEPT
		self.option[TELNET_TERMINAL_SPEED,	TELNET_SB_TERMINAL_SPEED_SEND] 		= TELNET_OPT_ACCEPT
		self.option[TELNET_X_DISPLAY_LOCATION,	TELNET_SB_X_DISPLAY_LOCATION_IS] 	= TELNET_OPT_ACCEPT
		self.option[TELNET_X_DISPLAY_LOCATION,	TELNET_SB_X_DISPLAY_LOCATION_SEND]	= TELNET_OPT_ACCEPT
		self.option[TELNET_ENVIRONMENT,		TELNET_SB_ENVIRONMENT_IS] 		= TELNET_OPT_ACCEPT
		self.option[TELNET_ENVIRONMENT,		TELNET_SB_ENVIRONMENT_SEND] 		= TELNET_OPT_ACCEPT
		self.option[TELNET_ENVIRONMENT,		TELNET_SB_ENVIRONMENT_INFO] 		= TELNET_OPT_ACCEPT
		self.option[TELNET_NAWS,		"*"]					= TELNET_OPT_ACCEPT
		self.option[TELNET_EOR,			"*"]					= TELNET_OPT_ACCEPT

		self.option["*",			"*"]					= TELNET_OPT_REJECT

		self.negotiation["239"] 		= int(TELNET_EOR)
