'\" t
.TH x3270 1 "25 June 2001"
.SH "NAME"
x3270 \-
\s-1IBM\s+1 host access tool
.SH "SYNOPSIS"
\fBx3270\fP
[\fIoptions\fP]
[\fIhost\fP]
.SH "DESCRIPTION"
\fBx3270\fP opens a telnet connection to an \s-1IBM\s+1
host in an X window.
It implements RFCs 2355 (TN3270E), 1576 (TN3270) and 1646 (LU name selection),
and supports IND$FILE file transfer.
The window created by \fBx3270\fP
can use its own font for displaying characters, so it is a fairly accurate
representation of an \s-1IBM\s+1 3278 or 3279.
It is similar to \fItn3270\fP(1) except that it is X-based, not curses-based.
.LP
The full syntax for \fIhost\fP is:
.RS
[\fIprefix\fP:]...[\fILUname\fP@]\fIhostname\fP[:\fIport\fP]
.RE
.LP
Prepending a \fBp:\fP onto \fIhostname\fP causes the connection to go
through the \fItelnet-passthru\fP service rather than directly to the host.
See \s-1PASSTHRU\s+1 below.
.LP
Prepending an \fBs:\fP onto \fIhostname\fP removes the "extended data
stream" option reported to the host.
See \fB\-tn\fP below for further information.
.LP
Prepending an \fBn:\fP onto \fIhostname\fP
turns off TN3270E support for the session.
.LP
A specific LU name to use may be specified by prepending it to the
\fIhostname\fP with an `\fB@\fP'.
Multiple LU names to try can be separated by commas.
An empty LU can be placed in the list with an extra comma.
.LP
On systems that support the \fIforkpty\fP library call, the
\fIhostname\fP may be replaced with \fB\-e\fP and a command string.
This will cause \fBx3270\fP to connect to a local child process, such as
a shell.
.LP
The port to connect to defaults to
\fBtelnet\fP.
This can be overridden with the \fB\-port\fP option, or by appending
a \fIport\fP to the \fIhostname\fP with a colon
`\fB:\fP'.
(For compatability with previous versions of \fBx3270\fP
and with \fItn3270\fP(1), the \fIport\fP
may also be specified as a second, separate argument.)
.SH "OPTIONS"
\fBx3270\fP
is a toolkit based program, so it understands standard Xt options and
resources.
It also understands
the following options:
.TP
\fB\-activeicon\fP
Specifies that the icon should be a miniature version of the screen image.
See \s-1ICONS\s+1 below.
.TP
\fB\-apl\fP
Sets up \s-1APL\s+1 mode.
This is actually an abbreviation for several options.
See \s-1APL SUPPORT\s+1 below.
.TP
\fB\-cc\fP \fIrange\fP:\fIvalue\fP[,...]
Sets character classes.
See \s-1CHARACTER CLASSES\s+1, below.
.TP
\fB\-charset\fP \fIname\fP
Specifies an \s-1EBCDIC\s+1 national character set.
See \s-1CHARACTER SETS\s+1 below.
.TP
\fB\-clear\fP \fItoggle\fP
Sets the initial value of \fItoggle\fP to \fBfalse\fP.
The list of toggle names is under \s-1MENUS\s+1
below.
.TP
\fB\-efont\fP \fIname\fP
Specifies a font for the emulator window.
See \s-1FONTS\s+1 below.
.TP
\fB\-iconname\fP \fIname\fP
Specifies an alternate title for the program icon.
.TP
\fB\-iconx\fP \fIx\fP
Specifies the initial x coordinate for the program icon.
.TP
\fB\-icony\fP \fIy\fP
Specifies the initial y coordinate for the program icon.
.TP
\fB\-keymap\fP \fIname\fP
Specifies a keymap name and optional modifiers.
See \s-1KEYMAPS\s+1 below.
.TP
\fB\-keypad\fP
Turns on the keypad as soon as \fBx3270\fP starts.
.TP
\fB\-model\fP \fIname\fP
The model of 3270 display to be emulated.
The model name is in three parts, any of which may be omitted:
.IP
The first part is the
\fBbase model\fP,
which is either \fB3278\fP or \fB3279\fP.
\fB3278\fP specifies a monochrome 3270 display;
\fB3279\fP specifies a color 3270 display.
When 3278 emulation is specified for a color X display, fields are displayed
using pseudo-colors; see \s-1PSEUDO-COLOR\s+1 below.
.IP
The second part is the
\fBmodel number\fP,
which specifies the number of rows and columns.
Model 4 is the default.
.PP
.TS
center;
c c c .
Model Number	Columns	Rows
_
2	80	24
3	80	30
4	80	43
5	132	27
.TE
.IP
Note: Technically, there is no such 3270 display as a 3279-4 or 3279-5, but
most hosts seem to work with them anyway.
.IP
The third part specifies the Extended 3270 Data Stream, and is given as
\fB\-E\fP.
It signals the host that the 3270 display is capable of displaying
extended field attributes, and supports structured fields and query replies.
A 3279 always uses the Extended Data Stream (whether or not \fB\-E\fP
is specified); for a 3278 it is optional.
.IP
The default model
for a color X display
is \fB3279\-4\-E\fP.
For a monochrome X display, it is
\fB3278\-4\-E\fP.
(The behavior of previous versions of \fBx3270\fP on color X displays
can be specified as \fB3278\-4)\fP.
.TP
\fB\-mono\fP
Forces \fBx3270\fP to believe it is running on a monochrome X display.
.TP
\fB\-once\fP
Causes \fBx3270\fP to exit after a host disconnects.
This option has effect only if a hostname is specified on the command line.
.TP
\fB\-oversize\fP \fIcols\fP\fBx\fP\fIrows\fP
Makes the screen larger than the default for the chosen model number.
This option has effect only in combination with extended data stream support
(the
\fB\-E\fP
suffix on the model), and only if the host supports the Query Reply structured
field.
The number of columns multiplied by the number of rows must not exceed
16383 (3fff hex), the limit of 14-bit 3270 buffer addressing.
.TP
\fB\-port\fP \fIn\fP
Specifies a different \s-1TCP\s+1 port to connect to.
\fIn\fP can be a name from \fB/etc/services\fP like \fBtelnet\fP, or a
number.
This option changes the default port number used for all connections.
(The positional parameter affects only the initial connection.)
.TP
\fB\-reconnect\fP
Causes \fBx3270\fP
to automatically reconnect to the host if it ever disconnects.
This option has effect only if a hostname is specified on the command line.
.TP
\fB\-sb\fP
Turns on the scrollbar.
.TP
\fB+sb\fP
Turns the scrollbar off.
.TP
\fB\-scheme\fP \fIname\fP
Specifes a color scheme to use in 3279 mode.
This option has effect only in combination with 3279 emulation.
See \s-1COLOR SCHEMES\s+1 below.
.TP
\fB\-script\fP
Causes
\fBx3270\fP
to read commands from standard input, with the results written to standard
output.
The protocol for these commands is documented in
\fIx3270-script\fP(1).
.TP
\fB\-sl\fP \fIn\fP
Specifies that \fIn\fP lines should be saved for scrolling back.
The default is 64.
.TP
\fB\-set\fP \fItoggle\fP
Sets the initial value of \fItoggle\fP to \fBtrue\fP.
The list of toggle names is under \s-1MENUS\s+1
below.
.TP
\fB\-tn\fP \fIname\fP
Specifies the terminal name to be transmitted over the telnet connection.
The default name is
\fBIBM\-\fP\fImodel_name\fP,
for example,
\fBIBM\-3279\-4\-E\fP
for a color X display, or
\fBIBM\-3278\-4\-E\fP
for a monochrome X display.
.IP
Some hosts are confused by the \fB\-E\fP
suffix on the terminal name, and will ignore the extra screen area on
models 3, 4 and 5.
Prepending an \fB:s\fP on the hostname removes the \fB\-E\fP
from the terminal name when connecting to such hosts.
.IP
The name can also be specified with the "x3270.termName" resource.
.TP
\fB\-trace\fP
Turns on data stream tracing at startup.
Unlike turning it on from a menu option,
there is no pop-up to confirm the file name, which defaults to
\fB/tmp/x3trc.\fP\fIprocess_id\fP.
.TP
\fB\-tracefile\fP \fIfile\fP
Specifies a file to save data stream and event traces into, overriding the
default of
\fB/tmp/x3trc.\fP\fIprocess_id\fP.
If the value \fBstdout\fP
is given, then traces will be written to standard output.
If the value \fBnone\fP
is given, then traces will be piped directly to the monitor window, and no
file will be created.
.LP
After reading resource definitions from the X server
and any standandard X11 resource definition files
(\fB$HOME/.Xdefaults\fP, etc.), \fBx3270\fP will read definitions
from the file \fB$HOME/.x3270pro\fP.
This file contains local customizations and is also used to save changed
options by the \fBSave Changed Options in File\fP menu option.
.LP
Note that \fB\-xrm\fP options override any definitions in
the \fB.x3270pro\fP file.
.SH "FONTS"
By default, \fBx3270\fP does not use the "*font" resource for its main
window.
Instead, it uses a custom 14-point font called
\fB3270\fP,
which is a close
approximation of a real 3270 display and allows \fBx3270\fP
to display a complete \s-1EBCDIC\s+1 character set and special status-line
symbols.
A more compact font, \fB3270\-12\fP, is also supported, as are the
various sized fonts \fB3270gt8\fP, \fB3270gt12\fP, \fB3270gt16\fP,
\fB3270-20\fP, \fB3270gt24\fP, and \fB3270gt32\fP.
The font \fB3270h\fP is also included to allow display of Hebrew text.
.LP
The font may be specified with the \fB\-efont\fP
option or the "x3270.emulatorFont" resource.
.LP
\fBx3270\fP can also use any constant-spaced X font, but unless the font
implements the
entire \s-1ISO\s+1 8859\-1 (Latin\-1) character set,
\fBx3270\fP may not properly display several \s-1EBCDIC\s+1 graphics that
do not have \s-1ASCII\s+1 equivalents.
.PP
One additional font,
\fB3270d\fP,
is supplied.
This font is identical to the default \fB3270\fP
font, except that it has bitmaps defined for field attribute characters.
This means that field attributes, which are normally displayed as blanks,
are now visible on the screen.
The characters displayed are hexadecimal codes, which can be translated
using a document provided with the \fBx3270\fP sources.
.LP
The font can be changed at any time through a menu option.
It can also be implicitly changed by changing the size of the \fBx3270\fP
window with the mouse: if the window is made larger, x3270 will try to
change to a larger font, and vice-versa.
.SH "CHARACTER SETS"
The \fB\-charset\fP
option or the "x3270.charset" resource controls the \s-1EBCDIC\s+1
national character set used by \fBx3270\fP.
Available sets include:
.PP
.TS
center;
l l l
lfB l l.
Charset Name	Code Page	Font	
_
belgian	500	iso8859-1
bracket	37	iso8859-1
finnish	278	iso8859-1
french	297	iso8859-1
german	273	iso8859-1
greek	423	3270gr
hebrew	424	3270h
icelandic	871	iso8859-1
iso-hebrew	424	iso8859-8
iso-turkish	1026	iso8859-9
italian	280	iso8859-1
norwegian	277	iso8859-1
uk	285	iso8859-1
us-intl	37	iso8859-1
.TE
.PP
The default character set is
\fBbracket\fP,
which is useful for common \s-1IBM\s+1 hosts which use \s-1EBCDIC\s+1
codes 0xAD and 0xBD for the `[' and `]' characters,
respectively.
.PP
Most 3270 fonts (3270, 3270-12, 3270gt8, etc.) implement the ISO 8859-1
character set.  3270h and 3270gr implement special character sets for Hebrew
and Greek, respsectively.  Some character sets work only with standard X fonts
that implement that character set.  These are prefixed with the
name \fBiso-\fP.
.PP
You can also specify national-language translations for your keyboard;
see \s-1KEYMAPS\s+1 below.
.SH "CHARACTER CLASSES"
\fBx3270\fP supports character classes (groupings of characters chosen
with a double mouse click) in the same manner as \fIxterm\fP(1).
The "x3270.charClass" resource or the
\fB\-cc\fP option can be used to alter the character class table.
The default table is the same as
\fIxterm\fP's;
It groups letters together, and puts most punctuation characters in individual
classes.
To put all non-whitespace characters together in the same class (and
duplicate the behavior of some early versions of
\fBx3270\fP,
use the following value:
.PP
.RS
33-127:48,161-255:48
.RE
.PP
See \fIxterm\fP(1) for further syntax details.
.SH "KEYPAD"
A keypad may optionally be displayed, with a mouse-clickable button for each
3270 function key (these functions are also available from the keyboard).
The keypad can be turned on and off by clicking on the "keypad" button in the
upper-right-hand corner of the window.
The "x3270.keypad" resource controls where it is displayed.
Options are:
.PP
.TS
center;
l l.
left	in a separate window, to the left of the screen
right	in a separate window, to the right of the screen
bottom	in a separate window, below the screen
integral	in the same window as the screen, below it
.TE
.PP
The default is \fBright\fP.
.PP
If the "x3270.keypadOn" resource is set to
\fBtrue\fP,
the keypad will be displayed at startup.
.SH "HOSTS DATABASE"
\fBx3270\fP uses the \fIibm_hosts\fP database to
construct a pull-down menu of hosts to connect to.
It also allows host name aliases to be defined, as well as specifying
macros to be executed when a connection is first made.
See \fIibm_hosts\fP(5) for details.
.LP
You may specify a different \fIibm_hosts\fP
database with the "x3270.hostsFile" resource.
.SH "COLOR SCHEMES"
When emulating a 3279 display, the X colors used to draw the display
are selected by two resources: the "x3270.colorScheme" resource, which gives
the name of the color scheme to use, and the
individual "x3270.colorScheme.\fIxxx\fP" resources, which
give the actual definitions.
The color scheme resources are documented in the \fBResources\fP
file with the \fBx3270\fP source.
.LP
The color scheme may also be changed while \fBx3270\fP
is running with a selection from the \fBOptions\fP menu.
.SH "PSEUDO-COLOR"
When emulating a 3278 display on a color X display, \fBx3270\fP
does not understand \s-1IBM\s+1 3270 color protocols.
Instead, it draws text in one of three colors depending on the field attributes.
Those colors may be customized using the following resources (shown with their
default values):
.RS
.br
x3270.normalColor:	green
.br
x3270.boldColor:	cyan
.br
x3270.inputColor:	orange
.br
x3270.colorBackground:	black
.br
x3270.selectBackground:	dim gray
.RE
.SH "NVT (ANSI) MODE"
Some hosts use an \s-1ASCII\s+1 front-end to do initial login negotiation,
then later switch to 3270 mode.
\fBx3270\fP will emulate an \s-1ANSI\s+1 X.64 terminal until the host
places it in 3270 mode (telnet \s-1BINARY\s+1 and \s-1SEND EOR\s+1 modes, or
\s-1TN3270E\s+1 mode negotiation).
The emulation is fairly complete; however, it is
not intended to make \fBx3270\fP a replacement for \fIxterm\fP(1).
.PP
If the host later negotiates to stop functioning in 3270 mode,
\fBx3270\fP will return to \s-1ANSI\s+1 emulation.
.PP
In \s-1NVT\s+1 mode, \fBx3270\fP
supports both character-at-a-time mode and line mode operation.
You may select the mode with a menu option.
When in line mode, the special characters and operational characteristics are
defined by resources:
.PP
.TS
center;
l c c.
Mode/Character	Resource	Default
_
Translate CR to NL	x3270.icrnl	true
Translate NL to CR	x3270.inlcr	false
Erase previous character	x3270.erase	^?
Erase entire line	x3270.kill	^U
Erase previous word	x3270.werase	^W
Redisplay line	x3270.rprnt	^R
Ignore special meaning of next character	x3270.lnext	^V
Interrupt	x3270.intr	^C
Quit	x3270.quit	^\e
End of file	x3270.eof	^D
.TE
.LP
Separate keymaps can be defined for use only when \fBx3270\fP is in
3270 mode or \s-1NVT\s+1 mode.
See \s-1KEYMAPS\s+1 for details.
.SH "MENUS"
\fBx3270\fP has a menu bar with three pull-down menus (File, Options, and
Connect) and a button to turn the keypad on and off.
The pull-down menus are also available as pop-up menus by using the "Ctrl"
key and the left, middle and right mouse buttons, respectively.
.PP
The menu bar can be turned off by setting the "x3270.menuBar" resource to
\fBfalse.\fP
.PP
Many sections of the File and Options menus are toggles,
options that may be either on or off.
The entries under the File menu are as follows:
.TP
\fBFile Transfer\fP
Initiates transferring a file between the IBM host and the local workstation,
using the \fBIND$FILE\fP protocol.
A pop-up menu allows specifying the file names and other attributes of the
transfer.
.br
The IND$FILE program must be installed on the IBM host, and the 3270 cursor
must be located in a field that will accept a TSO or VM/CMS command.
.TP
\fBPrinter Session\fP
Starts or stops a printer session.
.TP
\fBTrace Data Stream\fP
If set, network traffic (both a hexadecimal representation and its
interpretation) are logged to the file
\fB/tmp/x3trc.\fP\fIprocess_id\fP,
and a window is popped up to monitor the data.
The file name is confirmed with a pop-up; the default directory name for the
trace file can be changed with the "x3270.traceDir" resource.
.TP
\fBTrace Keyboard/Mouse Events\fP
If set, information about keyboard and mouse events and the actions that
\fBx3270\fP takes in response are logged to a file.
This is the same file as used for tracing the data stream, above.
Event tracing is useful for creating and debugging custom keymaps, macros
and scripts.
For example, it will tell you precisely what action was taken in response to
pressing a particular key.
If the key is not mapped, it will tell you the keysym name and keycode so you
can add it to a custom keymap.
.TP
\fBSave Screen(s) in File\fP
If set, saves an \s-1ASCII\s+1 representation of the current screen image in
the file \fB/tmp/x3scr.\fP\fIprocess_id\fP.
A pop-up allows the file name to be changed; the default directory name can be
changed with the "x3270.traceDir" resource.
The pop-up also has buttons to choose between saving just the current image,
or continuously saving it as it is redrawn.
.TP
\fBSave Changed Options in File\fP
Saves into a file the values of all options that have been changed since
\fBx3270\fP was started.
A pop-up allows the file name to be changed; the default file
is \fB.x3270pro\fP in the user's home directory.
If the file already exists, it is appended to.
\fBx3270\fP will read the contents of this file the next time it starts up.
The options settings in the file override any resources defined
with \fBxrdb\fP or in the user's \fB.Xdefaults\fP
file; command-line switches override the file.
A different options file can be specified by the \fBX3270PRO\fP
environment variable.
If the environment variable \fBNOX3270PRO\fP
is set, no options file will be read.
.TP
\fBExecute an Action\fP
Allows an action name and parameters to be entered from the keyboard.
This allows experimentation with actions without having to edit keymaps
and repeatedly restart \fBx3270\fP.
.LP
The toggles under the Options menu are as follows:
.TP
\fBMonocase\fP
If set, \fBx3270\fP operates in uppercase-only mode.
.TP
\fBBlinking Cursor\fP
If set, the cursor blinks once per second.
.TP
\fBBlank Fill\fP
If set, \fBx3270\fP behaves in some un-3270-like ways.
First, when a character is typed into a field, all nulls in the field to the
left of that character are changed to blanks.
This eliminates a common 3270 data-entry surprise.
Second, in insert mode, trailing blanks in a field are treated like nulls,
eliminating the annoying `lock-up' that often occurs when inserting into an
field with (apparent) space at the end.
.TP
\fBShow Timing\fP
If set, the time taken by the host to process an \s-1AID\s+1 is displayed on
the status line.
.TP
\fBTrack Cursor\fP
If set, the cursor position is displayed on the status line.
.TP
\fBScrollbar\fP
If set, the scrollbar appears.
.TP
\fBWraparound\fP
If set, the \s-1ANSI\s+1 terminal emulator automatically assumes a \s-1NEWLINE\s+1
character when it reaches the end of a line.
.TP
\fBPaste with Left Margin\fP
If set, puts restrictions on how pasted text is placed on the screen.
The position of the cursor at the time the paste operation is begun is
used as a left margin.
No pasted text will fill any area of the screen to the left of that
position.
This option is useful for pasting into certain \s-1IBM\s+1 editors that use the
left side of the screen for control information.
.TP
\fBSelect by Rectangles\fP
If set, \fBx3270\fP will always select rectangular areas of the screen.
Otherwise, \fBx3270\fP
selects by rectangles when in 3270 mode, but in \s-1ANSI\s+1 mode it selects
continuous regions of the screen like \fIxterm\fP(1).
.LP
The names of the toggles for use with the \fB\-set\fP
and \fB\-clear\fP
options are as follows:
.LP
.TS
center;
l l .
Menu Option	Name
_
Monocase	monoCase
Blinking Cursor	cursorBlink
Blank Fill	blankFill
Show Timing	showTiming
Track Cursor	cursorPos
Trace Data Stream	dsTrace
Trace Keyboard/Mouse Events	eventTrace
Save Screen(s) in File	screenTrace
Scrollbar	scrollBar
Wraparound	lineWrap
Paste with Left Margin	marginedPaste
Select by Rectangles	rectangleSelect
.TE
.LP
In addition, the toggle \fBaltCursor\fP can be used to select the cursor type.
If set, an underline cursor will be used.
If clear, the normal block cursor will be used.
.LP
These names also represent resources that can be set in your .Xdefaults
file.
For example, if you always want to have the scrollbar on, you can add
the following to your .Xdefaults:
.br
.RS
x3270.scrollBar:	true
.RE
.br
.SH "STATUS LINE"
The \fBx3270\fP status line contains a variety of information.
From left to right, the fields are:
.TP
\fBcomm status\fP
Three symbols indicate the state of the connection to the host.
If connected, the right-hand symbol is a solid box; if not, it is a
question mark.
.TP
\fBkeyboard lock\fP
If the keyboard is locked, an "X" symbol and a message field indicate the
reason for the keyboard lock.
.TP
\fBshift\fP
Three characters indicate the keyboard modifier status.
"M" indicates the Meta key, "A" the Alt key, and an up-arrow or "^"
indicates the Shift key.
.TP
\fBcompose\fP
The letter "C" indicates that a composite character is in progress.
If another symbol follows the "C", it is the first character of the
composite.
.TP
\fBtypeahead\fP
The letter "T" indicates that one or more keystrokes are in the typeahead
buffer.
.TP
\fBtemporary keymap\fP
The letter "K" indicates that a temporary keymap is in effect.
.TP
\fBreverse\fP
The letter "R" indicates that the keyboard is in reverse field entry mode.
.TP
\fBinsert mode\fP
A thick caret "^" or the 
letter "I" indicates that the keyboard is in insert mode.
.TP
\fBtiming\fP
A clock symbol and a time in seconds indicate the time it took to process
the last \s-1AID\s+1 or the time to connect to a host.
This display is optional.
.TP
\fBcursor position\fP
The cursor row and column are optionally displayed, separated by a "/".
.SH "ICONS"
If the \fB\-activeicon\fP
option is given (or the "x3270.activeIcon" resource is set to
\fBtrue\fP),
\fBx3270\fP will attempt to make its icon a miniature version of the
current screen image.
This function is highly dependent on your window manager:
.TP
\fBmwm\fP
The size of the icon is limited by the "Mwm.iconImageMaximum" resource, which
defaults to \fB50x50\fP.
The image will be clipped at the bottom and right.
The icon cannot accept keyboard input.
.TP
\fBolwm\fP
The full screen image of all 3270 models can be displayed on the icon.
However, the icon cannot be resized, so if the model is later changed with an
\fBx3270\fP menu option, the icon image will be corrupted.
The icon cannot accept keyboard input.
.TP
\fBtwm\fP and \fBtvtwm\fP
The full screen image of all 3270 models can be displayed on the icon, and the
icon can be resized.
The icon can accept keyboard input.
.IP
However, \fBtwm\fP does not put labels on application-supplied icon windows.
You can have \fBx3270\fP
add its own label to the icon by setting the "x3270.labelIcon" resource to
\fBtrue\fP.
The default font for icon labels is
\fB8x13\fP;
you may change it with the "x3270.iconLabelFont" resource.
.SH "KEYMAPS"
.PP
The type of keyboard may be specified with the \fB\-keymap\fP
switch or using either the \s-1KEYMAP\s+1 or \s-1KEYBD\s+1 environment variables.
The types of supported keyboards include
\fBsun_k3\fP,
\fBsun_k4\fP,
\fBsun_k5\fP,
\fBhp\-k1\fP,
\fBhp\-pc\fP
and
\fBncd\fP.
.PP
The keymap may also be specified as a comma-separated list of names.
Later definitions override earlier ones.
This is used to specify both a primary keyboard type and a set of modifiers.
The modifiers defined include:
.TP
\fBow\fP
(OpenWindows) Swaps the middle and right mouse button definitions, so the
middle button performs the "Extend" function and the right-hand button
performs the "Paste" function.
Also changes the cut and paste actions to use the OpenWindows \s-1CLIPBOARD\s+1.
.TP
\fBalt\fP
Replaces the default "Meta" key definitions with "Alt" definitions,
for keyboards which do not have a "Meta" key.
.TP
\fBapl\fP
Allows entry of \s-1APL\s+1 characters (see \s-1APL SUPPORT\s+1
below).
.TP
\fBfinnish7\fP
Replaces the bracket, brace and bar keys with common Finnish characters.
.TP
\fBnorwegian7\fP
Replaces the bracket, brace and bar keys with common Norwegian characters.
.PP
A temporary keymap can also be specified while \fBx3270\fP
is running with the \fBKeymap\fP action.
When the action \fBKeymap\fP(\fIn\fP) is executed, temporary keymap
\fIn\fP
is added to or deleted from the current keymap.
Multiple temporary keymaps can be active simultaneously.
The action \fBKeymap(None)\fP restores the original keymap.
\fBNote:\fP
When Keymap() is specified as part of a list of multiple actions in a keymap,
it must be the last action in the list.
.PP
The temporary keymap \fBhebrew\fP
is provided to allow entry of Hebrew characters.
.PP
The X Toolkit translation mechanism is used to provide keyboard emulation.
It maps \fBevents\fP into \fBactions.\fP
The best documentation can be found with X toolkit documents, but the
following should suffice for simple customization.
.PP
An Xt event consists of (at least) four fields.  The first is called a
\fBmodifier\fP.
It may be any combination of \fBMeta\fP, \fBShift\fP and \fBCtrl\fP.  If it
is prefaced by \fB!\fP,
it means those modifiers only.  The second field is the specific event,
in \fBx3270\fP
usually just <Key>.
The third field is the detail field, which gives the actual key.
The name of the key may be determined using the \fIxev\fP
program or with the "Trace X Events" menu option.
The last field is the action, which is the internal emulator function.
A complete list of actions may be found later in the manual.
.PP
There are three levels of translation tables in \fBx3270\fP.
The first is a defined by the resource
\fBx3270.keymap.base\fP.
It defines alphabetic, numeric,
function keys, and such basic functions as Enter and Delete.
It allows a minimal useful functionality.
It is generally compiled in \fBx3270\fP, but can be overridden.
.PP
The second level is a keyboard specific table, which is selected by the
\fBx3270.keymap\fP resource, and defined by the
\fBx3270.keymap.\fP\fIname\fP resource (where \fIname\fP is the value
of the \fBx3270.keymap\fP resource).
This keymap defines actions for such things as keypad
keys, and keys unique to certain keyboards.
Several predefined keymaps are included with \fBx3270\fP.
.PP
The third level is a user customizable table which may be used to augment or
override key definitions.
This keymap is defined by the \fBx3270.keymap.\fP\fIname\fP\fB.user\fP
resource.
.PP
In addition, keymaps may be defined for use in 3270 mode or \s-1NVT\s+1 mode
only.
These keymaps use the suffixes \fB.3270\fP and \fB.nvt\fP in their names,
respectively.
If a keymap \fBx3270.keymap.\fP\fIname\fP.\fImode\fP is defined, it
will augment the keymap \fBx3270.keymap.\fP\fIname\fP when \fBx3270\fP
is in the given \fImode\fP.
If a keymap \fBx3270.keymap.\fP\fIname\fP.\fBuser\fP.\fImode\fP is
defined, it will augment the
keymap \fBx3270.keymap\fP.\fIname\fP.\fBuser\fP when
\fBx3270\fP
is in the given \fImode\fP.
.PP
The default translation table \fBx3270.keymap.base\fP is:
.TS
l l .
<Key>Multi_key	Compose()
Shift<Key>Left	KybdSelect(Left,PRIMARY)
<Key>Left	Left()
Meta<Key>Right	NextWord()
Shift<Key>Right	KybdSelect(Right,PRIMARY)
<Key>Right	Right()
Shift<Key>Up	KybdSelect(Up,PRIMARY)
<Key>Up	Up()
Shift<Key>Down	KybdSelect(Down,PRIMARY)
<Key>Down	Down()
Ctrl<Btn1Down>	HandleMenu(quitMenu)
Ctrl<Btn2Down>	HandleMenu(optionsMenu)
Ctrl<Btn3Down>	HandleMenu(hostMenu)
Shift<Btn1Down>	MoveCursor()
<Btn1Down>	select\-start()
<Btn1Motion>	select\-extend()
<Btn2Down>	ignore()
<Btn2Motion>	ignore()
<Btn2Up>	insert\-selection(PRIMARY)
<Btn3Down>	start\-extend()
<Btn3Motion>	select\-extend()
<BtnUp>	select\-end(PRIMARY)
Meta<Key>F1	PF(13)
Meta<Key>F2	PF(14)
Meta<Key>F3	PF(15)
Meta<Key>F4	PF(16)
Meta<Key>F5	PF(17)
Meta<Key>F6	PF(18)
Meta<Key>F7	PF(19)
Meta<Key>F8	PF(20)
Meta<Key>F9	PF(21)
Meta<Key>F10	PF(22)
Meta<Key>F11	PF(23)
Meta<Key>F12	PF(24)
<Key>F1	PF(1)
<Key>F2	PF(2)
<Key>F3	PF(3)
<Key>F4	PF(4)
<Key>F5	PF(5)
<Key>F6	PF(6)
<Key>F7	PF(7)
<Key>F8	PF(8)
<Key>F9	PF(9)
<Key>F10	PF(10)
<Key>F11	PF(11)
<Key>F12	PF(12)
Alt<Key>q	Quit()
:<Key>	Default()
.TE
.PP
The default 3270-mode table \fBx3270.keymap.base.3270\fP adds the
following definitions:
.TS
l l .
Shift<Key>Return	Newline()
<Key>Return	Enter()
<Key>Linefeed	Newline()
Shift<Key>Tab	BackTab()
<Key>Tab	Tab()
<Key>Home	Home()
Meta<Key>Left	PreviousWord()
Meta<Key>Right	NextWord()
<Key>Insert	Insert()
<Key>Delete	Delete()
<Key>BackSpace	BackSpace()
Ctrl Shift<Btn1Down>	MouseSelect()
Shift<Btn1Down>	MoveCursor()
Meta<Key>1	PA(1)
Meta<Key>2	PA(2)
Meta<Key>3	PA(3)
Meta<Key>a	Attn()
Meta<Key>b	PrintWindow()
Meta<Key>c	Clear()
Meta<Key>d	Delete()
Meta<Key>h	Home()
Meta<Key>i	Insert()
Meta<Key>l	Redraw()
Meta<Key>p	PrintText()
Meta<Key>r	Reset()
Meta<Key>u	Unselect()
Ctrl<Key>u	DeleteField()
Ctrl<Key>w	DeleteWord()
:Meta<Key>asciicircum	Key(notsign)
.TE
.PP
Meta is the diamond shaped key on a sun_k4, "Alt" on an \s-1NCD\s+1,
"Extend Char" on an \s-1HP\s+1.
The following
\fIxmodmap\fP
command must be used on the \s-1NCD\s+1 to allow use the the "Alt"
key:
.PP
.RS
xmodmap \-e "keysym Alt_L = Meta_L"
.RE
.PP
The left mouse button may be used to make a selection.
Clicking once unselects the current selection.
Clicking twice selects the word under the mouse cursor.
Clicking three times selects the line under the mouse cursor.
Clicking and dragging selects a rectangular area of the display.
.PP
The middle mouse button may be used to paste a selection.
.PP
The right mouse button may also be used for selections, selecting the
rectangular area between the current position and where the left button was
last pressed.
.PP
.PP
On color X displays, the "x3270.selectBackground" resource is used to
distinguish the selected text from the rest of the screen.
On monochrome X displays, selected text is in reverse video.
(It can be distinguished from a block cursor because the block cursor covers
slightly less than an entire character position on the screen.)
.PP
The left mouse button, when pressed with the "Shift" key held down, moves the
3270 cursor to the where the mouse cursor is pointing.
.PP
This is the complete list of keymap-callable actions.
Other actions are defined for use by scripts and are documented in
\fIx3270-script\fP(1);
still others are defined for internal use by \fBx3270\fP
and are not documented here.
.PP
.TS
l l
.
Attn	attention key
AltCursor	switch between block and underscore cursor
BackSpace	move cursor left (or send \s-1ASCII BS\s+1)
BackTab	tab to start of previous input field
CircumNot	input "^" in \s-1NVT\s+1 mode, or "notsign" in 3270 mode
Clear	clear screen
Compose	next two keys form a special symbol
Connect(\fIhost\fP)	connect to \fIhost\fP
CursorSelect	Cursor Select \s-1AID\s+1
Cut	erase selected text
Default	enter key literally
Delete	delete character under cursor (or send \s-1ASCII DEL\s+1)
DeleteField	delete the entire field
DeleteWord	delete the current or previous word
Disconnect	disconnect from host
Down	move cursor down
Dup	duplicate field
Enter	Enter \s-1AID\s+1 (or send \s-1ASCII CR\s+1)
Erase	erase previous character (or send \s-1ASCII BS\s+1)
EraseEOF	erase to end of current field
EraseInput	erase all input fields
Execute(\fIcmd\fP)	execute a command in a shell
FieldEnd	move cursor to end of field
FieldExit	clear to end of field and skip to next (5250 emulation)
FieldMark	mark field
HandleMenu(\fIname\fP)	pop up a menu
HexString(\fIhex_digits\fP)	insert control-character string
Home	move cursor to first input field
Insert	set insert mode
Interrupt	send \s-1TELNET IP\s+1 to host
Key(\fIkeysym\fP)	insert key \fIkeysym\fP
Key(0x\fIxx\fP)	insert key with \s-1ASCII\s+1 code \fIxx\fP
Keymap(\fIkeymap\fP)	toggle alternate \fIkeymap\fP (or remove with \fBNone\fP)
KybdSelect(\fIdirection\fP[,\fIatom\fP...])	Extend selection by one row or column)
Left	move cursor left
Left2	move cursor left 2 positions
Macro(\fImacro\fP)	run a macro
MonoCase	toggle uppercase-only mode
MoveCursor	move cursor to mouse position
MoveCursor(\fIrow\fP,\fIcol\fP)	move cursor to (\fIrow\fP,\fIcol\fP)
MoveCursorSelect	move cursor to mouse position, light pen selection
Newline	move cursor to first field on next line (or send \s-1ASCII LF\s+1)
NextWord	move cursor to next word
PA(\fIn\fP)	Program Attention \s-1AID\s+1 (\fIn\fP from 1 to 3)
PF(\fIn\fP)	Program Function \s-1AID\s+1 (\fIn\fP from 1 to 24)
PreviousWord	move cursor to previous word
Printer(Start[,\fIlu\fP]|Stop)	Start or stop printer session
PrintText(\fIcommand\fP)	print screen text on printer
PrintWindow(\fIcommand\fP)	print screen image (bitmap) on printer
Quit	exit \fBx3270\fP
Reconnect	reconnect to previous host
Redraw	redraw window
Reset	reset locked keyboard
Right	move cursor right
Right2	move cursor right 2 positions
SetFont(\fIfont\fP)	change emulator font
Script(\fIcommand\fP[,\fIarg\fP...])	run a script
String(\fIstring\fP)	insert string (simple macro facility)
SysReq	System Request \s-1AID\s+1
Tab	move cursor to next input field
ToggleInsert	toggle insert mode
ToggleReverse	toggle reverse-input mode
Transfer(\fIoption\fP=\fIvalue\fP...)	file transfer
Unselect	release selection
Up	move cursor up
_
(the following are similar to xterm)
_
ignore	do nothing
insert-selection([\fIatom\fP[,\fIatom\fP...]])	paste selection
move-select	a combination of \fBMoveCursor\fP and \fBselect-start\fP
select-end(\fIatom\fP[,\fIatom\fP...]])	complete selection and assign to atom(s)
select-extend	move the end of a selection
select-start	mark the beginning of a selection
set-select(\fIatom\fP[,\fIatom\fP...]])	assign existing selection to atom(s)
start-extend	begin marking the end of a selection
.TE
.SH "MACROS AND SCRIPTS"
There are several types of
macros and script functions available.
.TP
\fBThe String Action\fP
The simplest method for
macros is provided via the \fBString\fP
action.
The arguments to \fBString\fP are one or more double-quoted strings which are
inserted directly as if typed.
The C backslash conventions are honored as follows.
(Entries marked * mean that after sending the \s-1AID\s+1 code to the host,
\fBx3270\fP will wait for the host to unlock the keyboard before further
processing the string.)
.TS
l l.
\eb	Left
\ef	Clear*
\en	Enter*
\epa\fIn\fP	PA(\fIn\fP)*
\epf\fInn\fP	PF(\fInn\fP)*
\er	Newline
\et	Tab
\eT	BackTab
.TE
.IP
An example keymap entry would be:
.RS
Meta<Key>p: String("probs clearrdr\en")
.RE
.IP
\fBNote:\fP
The strings are in \s-1ASCII\s+1 and converted to \s-1EBCDIC\s+1,
so beware of inserting
control codes.
Also, a backslash before a \fBp\fP may need to be
doubled so it will not be removed when a resource file is read.
.IP
There is also an alternate form of the \fBString\fP action, \fBHexString\fP,
which is used to enter non-printing data.
The argument to \fBHexString\fP is a string of hexadecimal digits, two per
character.  A leading 0x or 0X is optional.
In 3270 mode, the hexadecimal data represent \s-1EBCDIC\s+1 characters, which
are entered into the current field.
In \s-1NVT\s+1 mode, the hexadecimal data represent \s-1ASCII\s+1 characters,
which are sent directly to the host.
.TP
\fBThe Script Action\fP
This action causes \fBx3270\fP to start a child process which can
execute \fBx3270\fP actions.
Standard input and output from the child process are piped back to
\fBx3270\fP.
The \fBScript\fP action is fully documented in
\fIx3270-script\fP(1).
.TP
\fBThe macros Resource\fP
An alternate method of defining macros is the "x3270.macros" resource.
This resource is similar to a keymap, but instead of defining keyboard
mappings, it associates a list of X actions with a name.
These names are displayed on a Macros menu that appears when \fBx3270\fP
is connected to a host.
Selecting one of the names on the menu executes the X actions associated with
it.
Typically the actions are \fBString\fP calls, but any action may be specified.
Here is a sample macros resource definition, which would result in a four-entry
Macros menu:
.RS
x3270.macros: \e
.br
	log off: String("logout\en")\en\e
.br
	vtam: String("dial vtam\en")\en\e
.br
	pa1: PA(1)\en\e
.br
	alt printer: PrintText("lpr -Plw2")
.RE
.IP
You can also  a different set of macros for each host.
If there is a resource named
`x3270.\fImacros\fP.\fIsomehost\fP',
it defines the macros menu for when \fBx3270\fP
is connected to \fIsomehost\fP.
.TP
\fBThe \-script Option\fP
This facility allows \fBx3270\fP
to operate under the complete control of a script.
\fBx3270\fP
accepts actions from standard input, and prints results on standard output.
The \fB\-script\fP option is fully documented in
\fIx3270-script\fP(1).
.SH "COMPOSITE CHARACTERS"
\fBx3270\fP
allows the direct entry of accented letters and special symbols.
Pressing and releasing the "Compose" key, followed by two other keys, causes
entry of the symbol combining those two keys.
For example, "Compose" followed by the "C" key and the "," (comma) key, enters
the "C-cedilla" symbol.
A C on the status line indicates a pending composite character.
.PP
The mappings between these pairs of ordinary keys and the symbols they
represent is controlled by the "x3270.composeMap" resource; it gives the
name of the map to use.
The maps themselves are named "x3270.composeMap.\fIname\fP".
The default is "latin1", which gives mappings for most of the symbols in
the \s-1ISO\s+1 8859-1 Latin-1 character set that are not in the
7-bit \s-1ASCII\s+1
character set.
.PP
\fBNote:\fP
The default keymap defines
the "Multi_key" keysym
as the "Compose" key.
If your keyboard lacks such a key, you
may set up your own "Compose" key with
a keymap that maps some other keysym onto the \fBCompose\fP action.
.SH "APL SUPPORT"
\fBx3270\fP supports the full \s-1APL2\s+1 character set and the entry of
\s-1APL\s+1 characters from the keyboard.
.PP
\s-1APL\s+1 characters are supported only in the special \fB3270\fP font.
.PP
Keyboard entry of \s-1APL\s+1 characters is supported through the \fBapl\fP
keymap modifier.
This modifier defines the "Alt" key as an \s-1APL\s+1  key, with a
typical \s-1APL\s+1 keyboard layout, e.g.,
"Alt" pressed with the \fBA\fP key results in the \s-1APL\s+1 "alpha" symbol.
Overstruck characters such as "quad-quote" are not defined as single
keystrokes; instead they are entered as
composites (see \s-1COMPOSITE CHARACTERS\s+1
above).
A special composite map,
\fBapl\fP,
is provided for this purpose.
.PP
\fBNote:\fP
Some keyboards do not  the "Alt" key as a modifier, so keymaps that use
the "Alt" key will not function.
On a Sun for example, this can be remedied with the command:
.IP
.RS
xmodmap \-e "add mod2 = Alt_L"
.RE
.PP
For convenience, an \fB\-apl\fP
option is defined, which is an abbreviation for the following resource
definitions:
.RS
x3270.keymap: \fIyour_keymap_name\fP,apl
.br
x3270.charset: apl
.br
x3270.composeMap: apl
.br
.RE
.PP
There are a number of \s-1APL\s+1 characters that are similar in appearance to
non-\s-1APL\s+1
characters.
In particular, the \s-1APL\s+1 "stile", "slope," "tilde" and "quotedot"
characters are similar to the \s-1EBCDIC\s+1 "bar", "backslash," "tilde"
and "exclaim" characters.
The \s-1APL\s+1 characters are entered with the "Alt" key, and have slightly
different appearances.
.PP
The complete list of special \s-1APL\s+1 keysyms is as follows.
Entries marked with an asterisk (*) represent
simple aliases for standard \s-1EBCDIC\s+1 characters.
Entries marked with an (S) represent Sharp APL charatcers.
.PP
.TS
l c l l l.
APL Symbol	Hex	x3270 Keysym	x3270 Key	x3270 Composed Keys
_
A underbar	41	apl_Aunderbar	Alt-A	A + underbar
alpha	B0	apl_alpha	Alt-a	\ 
B underbar	42	apl_Bunderbar	Alt-B	B + underbar
bar	60*	apl_bar	-	\ 
brace left	C0	apl_braceleft	Alt-{	\ 
brace right	D0	apl_braceright	Alt-}	\ 
C underbar	43	apl_Cunderbar	Alt-C	C + underbar
circle	9D	apl_circle	Alt-o	\ 
circle bar	ED	apl_circlebar	\ 	circle + bar
circle slope	CF	apl_circleslope	\ 	circle + slope
circle star	FD	apl_circlestar	\ 	circle + star
circle stile	CD	apl_circlestile	\ 	circle + stile
colon	7A*	apl_colon	:	\ 
comma	6B*	apl_comma	,	\ 
comma bar (S)	E5	apl_commabar	\ 	comma + bar
D underbar	44	apl_Dunderbar	Alt-D	D + underbar
del	BA	apl_del	Alt-g	\ 
del stile	DC	apl_delstile	\ 	del + stile
del tilde	FB	apl_deltilde	\ 	del + tilde
delta	BB	apl_delta	Alt-h	\ 
delta stile	DD	apl_deltastile	\ 	delta + stile
delta underbar	FC	apl_deltaunderbar	\ 	delta + underbar
diamond	70	apl_diamond	\ 	up caret + down caret
dieresis	72	apl_dieresis	Alt-1	\ 
dieresis circle (S)	E5	apl_dieresiscircle	\ 	dieresis + circle
dieresis dot	EC	apl_dieresisdot	\ 	dieresis + dot
dieresis jot (S)	E4	apl_dieresisjot	\ 	dieresis + jot
divide	B8	apl_divide	Alt-+	\ 
dot	4B*	apl_dot	.	\ 
down arrow	8B	apl_downarrow	Alt-u	\ 
down caret	78	apl_downcaret	Alt-9	\ 
down caret tilde	CB	apl_downcarettilde	\ 	down caret + tilde
down shoe	AB	apl_downshoe	Alt-v	\ 
down stile	8E	apl_downstile	Alt-d	\ 
down tack	AC	apl_downtack	Alt-b	\ 
down tack jot	FE	apl_downtackjot	\ 	down tack + jot
down tack up tack	DA	apl_downtackuptack	\ 	down tack + up tack
E underbar	45	apl_Eunderbar	Alt-E	E + underbar
epsilon	B1	apl_epsilon	Alt-e	\ 
epsilon underbar	75	apl_epsilonunderbar	\ 	epsilon + underbar
equal	7E*	apl_equal	"="	\ 
equal underbar	E1	apl_equalunderbar	\ 	equal + underbar
euro (S)	E7	apl_euro	\ 	C + =
F underbar	46	apl_Funderbar	Alt-F	F + underbar
G underbar	47	apl_Gunderbar	Alt-G	G + underbar
greater	6E*	apl_greater	>	\ 
H underbar	48	apl_Hunderbar	Alt-H	H + underbar
I underbar	49	apl_Iunderbar	Alt-I	I + underbar
iota	B2	apl_iota	Alt-i	\ 
iota underbar	74	apl_iotaunderbar	\ 	iota + underbar
J underbar	51	apl_Junderbar	Alt-J	J + underbar
jot	AF	apl_jot	alt-j	\ 
K underbar	52	apl_Kunderbar	Alt-K	K + underbar
L underbar	53	apl_Lunderbar	Alt-L	L + underbar
left arrow	9F	apl_leftarrow	Alt-[	\ 
left bracket	AD	apl_leftbracket	[	\ 
left paren	4D*	apl_leftparen	(	\ 
left shoe	9B	apl_leftshoe	Alt-z	\ 
less	4C*	apl_less	<	\ 
M underbar	54	apl_Munderbar	Alt-M	M + underbar
N underbar	55	apl_Nunderbar	Alt-N	N + underbar
not equal	BE	apl_notequal	Alt-8	equal + slash
not greater	8C	apl_notgreater	Alt-4	less + equal
not less	AE	apl_notless	Alt-6	greater + equal
O underbar	56	apl_Ounderbar	Alt-O	O + underbar
omega	B4	apl_omega	Alt-w	\ 
overbar	A0	apl_overbar	Alt-2	\ 
P underbar	57	apl_Punderbar	Alt-P	P + underbar
plus	4E*	apl_plus	+	\ 
Q underbar	58	apl_Qunderbar	Alt-Q	Q + underbar
quad	90	apl_quad	Alt-l	\ 
quad divide	EE	apl_quaddivide	\ 	quad + divide
quad jot	73	apl_quadjot	\ 	quad + jot
quad quote	DE	apl_quadquote	\ 	quad + quote
quad slope	CE	apl_quadslope	\ 	quad + slope
query	6F*	apl_query	?	\ 
quote	7D*	apl_quote	'	\ 
quote dot	DB	apl_quotedot	\ 	quote + dot
R underbar	59	apl_Runderbar	Alt-R	R + underbar
rho	B3	apl_rho	Alt-r	\ 
right arrow	8F	apl_rightarrow	Alt-]	\ 
right bracket	BD	apl_rightbracket	]	\ 
right paren	5D*	apl_rightparen	)	\ 
right shoe	9A	apl_rightshoe	Alt-x	\ 
S underbar	62	apl_Sunderbar	Alt-S	S + underbar
semicolon	5E*	apl_semicolon	;	\ 
slash	61*	apl_slash	/	\ 
slash bar	EA	apl_slashbar	\ 	slash + bar
slope	B7	apl_slope	Alt-\e	\ 
slope bar	EB	apl_slopebar	\ 	slope + bar
squad	CC	apl_squad	\ 	quad + quad
star	5C*	apl_star	*	\ 
stile	BF	apl_stile	Alt-|	\ 
T underbar	63	apl_Tunderbar	Alt-T	T + underbar
tilde	80	apl_tilde	Alt-~	\ 
times	B6	apl_times	Alt-=	\ 
U underbar	64	apl_Uunderbar	Alt-U	U + underbar
underbar	6D*	apl_underbar	"_"	\ 
up arrow	8A	apl_uparrow	Alt-y	\ 
up caret	71	apl_upcaret	Alt-0	\ 
up caret tilde	CA	apl_upcarettilde	\ 	up caret + tilde
up shoe	AA	apl_upshoe	Alt-c	\ 
up shoe jot	DF	apl_upshoejot	\ 	up shoe + jot
up stile	8D	apl_upstile	Alt-s	\ 
up tack	BC	apl_uptack	Alt-n	\ 
up tack jot	EF	apl_uptackjot	\ 	up tack + jot
V underbar	65	apl_Vunderbar	Alt-V	V + underbar
W underbar	66	apl_Wunderbar	Alt-W	W + underbar
X underbar	67	apl_Xunderbar	Alt-X	X + underbar
Y underbar	68	apl_Yunderbar	Alt-Y	Y + underbar
Z underbar	69	apl_Zunderbar	Alt-Z	Z + underbar
.TE
.SH "5250 (AS/400) SUPPORT"
\fBx3270\fP provides limited support for 5250 (AS/400) emulation.
This is not native 5250 terminal emulation, but rather for use with hosts
which allow a 3270 terminal to emulate a 5250.
A \fB5250\fP
keymap is defined, which maps the keyboard function keys to the 5250 emulators
PA/PF key sequences, as well as redefining the Return key to use the special
\fBFieldExit\fP action.
The command line for 5250 support is:
.br
.RS
x3270 -model 2 -keymap 5250
.RE
.br
.SH "SCREEN PRINTING"
Screen printing is handled through options on the \fBFile\fP menu or by the
\fBPrintText\fP and \fBPrintWindow\fP actions.
Each results in a pop-up to confirm the print command.
.PP
The \fBPrintText\fP action (usually assigned to the key <Meta>p) sends
the current
screen image to the printer as \s-1ASCII\s+1 characters.
The default command used to print the data is controlled by
the "x3270.printTextCommand" resource; the default is
\fBlpr\fP.
You may also use a keymap definition to pass a print command the
\fBPrintText\fP action itself.
The command receives the screen text as its standard input.
For example, the following keymap will save the screen text in a file:
.IP
.RS
Meta<Key>f: PrintText("cat >screen.image")
.RE
.PP
Note: \fBHardPrint\fP is an alias for \fBPrintText\fP.
.PP
The \fBPrintWindow\fP action (usually assigned to the key <Meta>b) sends the current
screen image to the printer as a bitmap.
The default command used to print the data is controlled by
the "x3270.printWindowCommand" resource; the default is
.IP
.RS
\fBxwd \-id %d | xpr | lpr\fP.
.RE
.PP
You may also use a keymap definition to pass a print command to the
\fBPrintWindow\fP action itself.
If the command contains the text "%d", the window ID of
\fBx3270\fP will be substituted before it is run.
For example, the following keymap will pop up a duplicate of the current
screen image:
.IP
.RS
Meta<Key>g: PrintWindow("xwd \-id %d | xwud &")
.RE
.LP
If the command for PrintWindow or PrintText begins with an "@" character,
the initial pop-up menu to confirm the print command is not displayed and
the command cannot be edited.
.SH "BUGS"
Cursor highlighting will not work with if you use the \fBNoTitleFocus\fP
option in your .twmrc file.
.SH "PASSTHRU"
\fBx3270\fP supports the Sun \fItelnet-passthru\fP
service provided by the \fIin.telnet-gw\fP server.
This allows outbound telnet connections through a firewall machine.
When a \fBp:\fP is prepended to a hostname, \fBx3270\fP
acts much like the \fIitelnet\fP(1) command.
It contacts the machine named \fBinternet-gateway\fP at the port defined in
\fB/etc/services\fP as \fBtelnet-passthru\fP
(which defaults to 3514).
It then passes the requested hostname and port to the
\fBin.telnet-gw\fP server.
.SH "FILES"
/usr/lib/X11/x3270/ibm_hosts
.br
$HOME/.x3270pro

.SH "SEE ALSO"
s3270(1), c3270(1), tcl3270(1), ibm_hosts(5), x3270-script(1), pr3287(1), telnet(1), tn3270(1)
.br
X Toolkit Intrinsics
.br
Data Stream Programmer's Reference, IBM GA23-0059
.br
Character Set Reference, IBM GA27-3831
.br
RFC 1576, TN3270 Current Practices
.br
RFC 1646, TN3270 Extensions for LUname and Printer Selection
.br
RFC 2355, TN3270 Enhancements
.SH "COPYRIGHTS"
.LP
Modifications Copyright 1993, 1994, 1995, 1996, 1997, 1999, 2000, 2001 by Paul Mattes.
.br
Original X11 Port Copyright 1990 by Jeff Sparkes.
.RS
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.
.RE
Copyright 1989 by Georgia Tech Research Corporation, Atlanta, GA 30332.
.RS
All Rights Reserved.  GTRC hereby grants public use of this software.
Derivative works based on this software must incorporate this copyright
notice.
.RE
5250 Emulation Code Copyright Minolta (Schweiz) AG, Beat Rubischon.
.SH "VERSION"
x3270 3.2.17
