#######################
# (c) Jan Walter 2000 #
#######################

# CVS
# $Author: jan $
# $Date: 2001/02/06 10:53:28 $
# $RCSfile: mimport.py,v $
# $Revision: 1.1 $

import Blender
import string

Mscale = 10

def testMImport(filename):
    print 'testMImport("%s")' % filename
    file = open(filename, "r")
    lines = file.readlines()
    linenumber = 1
    print "import into Blender ..."
    scene  = Blender.getCurrentScene()
    mesh   = Blender.Mesh("3DS")
    object = Blender.Object("3DS")
    mesh.enterEditMode()
    for line in lines:
        words = string.split(line)
        if words and words[0] == "#":
            pass # ignore comments
        elif words and words[0] == "Vertex":
            # words[1] is the index of the vertex
            x = Mscale * string.atof(words[2])
            y = Mscale * string.atof(words[3])
            z = Mscale * string.atof(words[4])
            mesh.addVertex(x, y, z, 0, 0, 0)
        elif words and words[0] == "Face":
            # triangle
            # words[1] is the index of the face
            i1 = string.atof(words[2])
            i2 = string.atof(words[3])
            i3 = string.atof(words[4])
            mesh.addFace(i1, i2, i3, 0, 0, 0)
        else:
            print line
    Blender.connect(object, mesh)
    Blender.connect(scene, object)
    mesh.leaveEditMode()
    file.close()
    print "... finished"

def callback(fs):
    filename = fs.filename
    testMImport(filename)

if __name__ == "__main__":
    try:
        import GUI
    except:
        print "This script is only working with the new GUI module ..."
    else:
        fs = GUI.FileSelector()
        fs.activate(callback, fs)
