#######################
# (c) Jan Walter 2000 #
#######################

# CVS
# $Author: jan $
# $Date: 2001/01/08 12:31:15 $
# $RCSfile: povexport.py,v $
# $Revision: 1.1 $

import Blender
import math
import string

exportAnimations = 1

class PovrayExport:
    def __init__(self, filename):
        self.filename = filename
        self.file    = None
        self.scene   = None
        self.display = None
        self.lampNames = []
        self.meshNames = []
        self.materialNames = []

    def export(self, scene):
        global exportAnimations

        print "exporting ..."
        self.scene = scene
        self.display = Blender.getDisplaySettings()
        file = open("povsize.ini", "w")
        file.write("Width=%s\n" % self.display.xResolution)
        file.write("Height=%s\n" % self.display.yResolution)
        file.close()
        if exportAnimations:
            for frame in xrange(self.display.startFrame,
                                self.display.endFrame + 1):
                self.writeFrame(frame)
        else:
            self.writeFrame(self.display.currentFrame)
        self.writeEnd()

    def writeCamera(self):
        camobj = self.scene.getCurrentCamera()
        camera = Blender.getCamera(camobj.data)
        angle = 360.0 * math.atan(16.0 / camera.Lens) / math.pi
        self.file.write("camera {\n")
        self.file.write("    right <-%s, 0, 0>\n" %
                        (self.display.xResolution /
                         float(self.display.yResolution)))
        self.file.write("    up    <0, 1, 0>\n")
        self.file.write("    angle %s\n" % angle)
        self.file.write("    rotate <%s, %s, %s>\n" % (0, 180, 0))
        self.file.write("}\n")

    def writeData(self, name):
        if Blender.isLamp(name):
            lampobj = Blender.getObject(name)
            lamp    = Blender.getLamp(lampobj.data)
            if lampobj.data not in self.lampNames:
                self.lampNames.append(lampobj.data)
                self.writeIdentifier(lampobj.data)
                povname = string.replace(lampobj.data, ".", "_")
                povname = string.upper(povname)
                self.file.write("#declare %s = light_source {\n" % povname)
                self.file.write("    <0, 0, 0>\n")
                self.file.write("    color rgb <%s, %s, %s>\n" %
                                (lamp.R, lamp.G, lamp.B))
                self.file.write("}\n")
        elif Blender.isMesh(name):
            meshobj = Blender.getObject(name)
            mesh    = Blender.getMesh(meshobj.data)
            if meshobj.data not in self.meshNames:
                self.meshNames.append(meshobj.data)
                self.writeIdentifier(meshobj.data)
                povname = string.replace(meshobj.data, ".", "_")
                povname = string.upper(povname)
                self.file.write("#declare %s = mesh {\n" % povname)
                for face in mesh.faces:
                    if face[4]: # smooth
                        # first triangle
                        self.file.write("    smooth_triangle {\n")
                        self.file.write("        <%s, %s, %s>,\n" %
                                        (mesh.vertices[face[0]][0],
                                         mesh.vertices[face[0]][1],
                                         mesh.vertices[face[0]][2]))
                        self.file.write("        <%s, %s, %s>,\n" %
                                        (mesh.normals[face[0]][0],
                                         mesh.normals[face[0]][1],
                                         mesh.normals[face[0]][2]))
                        self.file.write("        <%s, %s, %s>,\n" %
                                        (mesh.vertices[face[1]][0],
                                         mesh.vertices[face[1]][1],
                                         mesh.vertices[face[1]][2]))
                        self.file.write("        <%s, %s, %s>,\n" %
                                        (mesh.normals[face[1]][0],
                                         mesh.normals[face[1]][1],
                                         mesh.normals[face[1]][2]))
                        self.file.write("        <%s, %s, %s>,\n" %
                                        (mesh.vertices[face[2]][0],
                                         mesh.vertices[face[2]][1],
                                         mesh.vertices[face[2]][2]))
                        self.file.write("        <%s, %s, %s>\n" %
                                        (mesh.normals[face[2]][0],
                                         mesh.normals[face[2]][1],
                                         mesh.normals[face[2]][2]))
                        # material
                        if meshobj.materials and meshobj.materials[face[5]]:
                            povname = meshobj.materials[face[5]]
                            povname = string.replace(povname, ".", "_")
                            povname = "MA" + string.upper(povname)
                            self.file.write("        texture { %s }\n" %
                                            povname)
                        self.file.write("    }\n")
                        if face[3]:
                            # second triangle
                            self.file.write("    smooth_triangle {\n")
                            self.file.write("        <%s, %s, %s>,\n" %
                                            (mesh.vertices[face[0]][0],
                                             mesh.vertices[face[0]][1],
                                             mesh.vertices[face[0]][2]))
                            self.file.write("        <%s, %s, %s>,\n" %
                                            (mesh.normals[face[0]][0],
                                             mesh.normals[face[0]][1],
                                             mesh.normals[face[0]][2]))
                            self.file.write("        <%s, %s, %s>,\n" %
                                            (mesh.vertices[face[2]][0],
                                             mesh.vertices[face[2]][1],
                                             mesh.vertices[face[2]][2]))
                            self.file.write("        <%s, %s, %s>,\n" %
                                            (mesh.normals[face[2]][0],
                                             mesh.normals[face[2]][1],
                                             mesh.normals[face[2]][2]))
                            self.file.write("        <%s, %s, %s>,\n" %
                                            (mesh.vertices[face[3]][0],
                                             mesh.vertices[face[3]][1],
                                             mesh.vertices[face[3]][2]))
                            self.file.write("        <%s, %s, %s>\n" %
                                            (mesh.normals[face[3]][0],
                                             mesh.normals[face[3]][1],
                                             mesh.normals[face[3]][2]))
                            # material
                            if (meshobj.materials and
                                meshobj.materials[face[5]]):
                                povname = meshobj.materials[face[5]]
                                povname = string.replace(povname, ".", "_")
                                povname = "MA" + string.upper(povname)
                                self.file.write("        texture { %s }\n" %
                                                povname)
                            self.file.write("    }\n")
                    else:
                        # first triangle
                        self.file.write("    triangle {\n")
                        self.file.write("        <%s, %s, %s>,\n" %
                                        (mesh.vertices[face[0]][0],
                                         mesh.vertices[face[0]][1],
                                         mesh.vertices[face[0]][2]))
                        self.file.write("        <%s, %s, %s>,\n" %
                                        (mesh.vertices[face[1]][0],
                                         mesh.vertices[face[1]][1],
                                         mesh.vertices[face[1]][2]))
                        self.file.write("        <%s, %s, %s>\n" %
                                        (mesh.vertices[face[2]][0],
                                         mesh.vertices[face[2]][1],
                                         mesh.vertices[face[2]][2]))
                        # material
                        if meshobj.materials and meshobj.materials[face[5]]:
                            povname = meshobj.materials[face[5]]
                            povname = string.replace(povname, ".", "_")
                            povname = "MA" + string.upper(povname)
                            self.file.write("        texture { %s }\n" %
                                            povname)
                        self.file.write("    }\n")
                        if face[3]:
                            # second triangle
                            self.file.write("    triangle {\n")
                            self.file.write("        <%s, %s, %s>,\n" %
                                            (mesh.vertices[face[0]][0],
                                             mesh.vertices[face[0]][1],
                                             mesh.vertices[face[0]][2]))
                            self.file.write("        <%s, %s, %s>,\n" %
                                            (mesh.vertices[face[2]][0],
                                             mesh.vertices[face[2]][1],
                                             mesh.vertices[face[2]][2]))
                            self.file.write("        <%s, %s, %s>\n" %
                                            (mesh.vertices[face[3]][0],
                                             mesh.vertices[face[3]][1],
                                             mesh.vertices[face[3]][2]))
                            # material
                            if (meshobj.materials and
                                meshobj.materials[face[5]]):
                                povname = meshobj.materials[face[5]]
                                povname = string.replace(povname, ".", "_")
                                povname = "MA" + string.upper(povname)
                                self.file.write("        texture { %s }\n" %
                                                povname)
                            self.file.write("    }\n")
                self.file.write("}\n")
        else:
            print "Sorry can export meshes only ..."

    def writeEnd(self):
        print "... finished"

    def writeFrame(self, frame):
        self.lampNames = []
        self.meshNames = []
        self.materialNames = []
        print "frame:", frame
        Blender.setCurrentFrame(frame)
        self.file = open(self.filename + "%04d.pov" % frame, "w")
        self.writeHeader()
        self.writeCamera()
        self.writeWorld()
        self.file.close()

    def writeHeader(self):
        self.file.write('#include "%s"\n' % "finish.inc")

    def writeIdentifier(self, name):
        self.file.write("// %s\n" % name)

    def writeMaterial(self, name):
        if Blender.isMesh(name):
            object = Blender.getObject(name)
            for matName in object.materials:
                # materials can be shared !!!
                if matName not in self.materialNames:
                    self.materialNames.append(matName)
                    self.writeIdentifier(matName)
                    material = Blender.getMaterial(matName)
                    povname = string.replace(matName, ".", "_")
                    povname = "MA" + string.upper(povname)
                    self.file.write("#declare %s = texture {\n" % povname)
                    self.file.write("    pigment { " +
                                    "color rgb <%s, %s, %s> }\n" %
                                    (material.R, material.G, material.B))
                    self.file.write("    finish { Phong_Glossy }\n")
                    self.file.write("}\n")

    def writeObject(self, name):
        if Blender.isLamp(name) or Blender.isMesh(name):
            self.writeIdentifier(name)
            object = Blender.getObject(name)
            povname = string.replace(object.data, ".", "_")
            povname = string.upper(povname)
            self.file.write("    object { %s\n" % povname)
            if not object.materials:
                self.file.write("        texture {\n")
                self.file.write("            pigment { " +
                                "color rgb <1, 1, 1> }\n")
                self.file.write("            finish { Phong_Glossy }\n")
                self.file.write("}\n")
            self.file.write("        matrix <%s, %s, %s,\n" %
                            (object.matrix[0][0],
                             object.matrix[0][1],
                             object.matrix[0][2]))
            self.file.write("                %s, %s, %s,\n" %
                            (object.matrix[1][0],
                             object.matrix[1][1],
                             object.matrix[1][2]))
            self.file.write("                %s, %s, %s,\n" %
                            (object.matrix[2][0],
                             object.matrix[2][1],
                             object.matrix[2][2]))
            self.file.write("                %s, %s, %s>\n" %
                            (object.matrix[3][0],
                             object.matrix[3][1],
                             object.matrix[3][2]))
            self.file.write("    }\n")

    def writeWorld(self):
        # materials
        for name in self.scene.objects:
            if not Blender.isCamera(name):
                self.writeMaterial(name)
        # first write the data before ...
        for name in self.scene.objects:
            if not Blender.isCamera(name):
                self.writeData(name)
        # ... you use it with the objects
        self.file.write("union {\n")
        for name in self.scene.objects:
            if Blender.isLamp(name):
                self.writeObject(name)
        for name in self.scene.objects:
            if not Blender.isCamera(name) and not Blender.isLamp(name):
                self.writeObject(name)
        # rotate scene with inverse camera matrix
        camobj = self.scene.getCurrentCamera()
        camera = Blender.getCamera(camobj.data)
        self.file.write("    matrix <%s, %s, %s,\n" %
                        (camobj.inverseMatrix[0][0],
                         camobj.inverseMatrix[0][1],
                         camobj.inverseMatrix[0][2]))
        self.file.write("            %s, %s, %s,\n" %
                        (camobj.inverseMatrix[1][0],
                         camobj.inverseMatrix[1][1],
                         camobj.inverseMatrix[1][2]))
        self.file.write("            %s, %s, %s,\n" %
                        (camobj.inverseMatrix[2][0],
                         camobj.inverseMatrix[2][1],
                         camobj.inverseMatrix[2][2]))
        self.file.write("            %s, %s, %s>\n" %
                        (camobj.inverseMatrix[3][0],
                         camobj.inverseMatrix[3][1],
                         camobj.inverseMatrix[3][2]))
        self.file.write("}\n")

povexport = PovrayExport("test")
scene = Blender.getCurrentScene()
povexport.export(scene)
