// Copyright (c) 1997-2003  Utrecht University (The Netherlands),
// ETH Zurich (Switzerland), Freie Universitaet Berlin (Germany),
// INRIA Sophia-Antipolis (France), Martin-Luther-University Halle-Wittenberg
// (Germany), Max-Planck-Institute Saarbruecken (Germany), RISC Linz (Austria),
// and Tel-Aviv University (Israel).  All rights reserved.
//
// This file is part of CGAL (www.cgal.org); you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; version 2.1 of the License.
// See the file LICENSE.LGPL distributed with CGAL.
//
// Licensees holding a valid commercial license may use this file in
// accordance with the commercial license agreement provided with the software.
//
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
// $URL: svn+ssh://scm.gforge.inria.fr/svn/cgal/branches/CGAL-3.2-branch/Interval_arithmetic/include/CGAL/Arithmetic_filter/predicates/kernel_ftC2.h $
// $Id: kernel_ftC2.h 29562 2006-03-16 20:48:01Z reichel $
// 
//
// Author(s)     : Sylvain Pion

// This file is automatically generated by
// scripts/cgal_filtered_predicates_generator.pl

#ifndef CGAL_ARITHMETIC_FILTER_PREDICATES_KERNEL_FTC2_H
#define CGAL_ARITHMETIC_FILTER_PREDICATES_KERNEL_FTC2_H

#include <CGAL/Profile_counter.h>

CGAL_BEGIN_NAMESPACE
template <class ET> class Lazy_exact_nt;
CGAL_END_NAMESPACE

CGAL_BEGIN_NAMESPACE

template < class CT, class ET, bool Protected, class Cache >
/* inline */
bool
parallelC2(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l1a,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l1b,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l2a,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l2b)
{
  try
  {
    CGAL_PROFILER("IA parallelC2 calls");
    Protect_FPU_rounding<Protected> Protection;
    return parallelC2(
		l1a.interval(),
		l1b.interval(),
		l2a.interval(),
		l2b.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA parallelC2 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return parallelC2(
		l1a.exact(),
		l1b.exact(),
		l2a.exact(),
		l2b.exact());
  }
}

template < class ET >
/* inline */
bool
parallelC2(
    const Lazy_exact_nt<ET> &l1a,
    const Lazy_exact_nt<ET> &l1b,
    const Lazy_exact_nt<ET> &l2a,
    const Lazy_exact_nt<ET> &l2b)
{
  try
  {
    CGAL_PROFILER("Lazy IA parallelC2 calls");
    Protect_FPU_rounding<true> Protection;
    return parallelC2(
		l1a.interval(),
		l1b.interval(),
		l2a.interval(),
		l2b.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA parallelC2 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return parallelC2(
		l1a.exact(),
		l1b.exact(),
		l2a.exact(),
		l2b.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/*  */
bool
parallelC2(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s1sx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s1sy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s1tx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s1ty,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s2sx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s2sy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s2tx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s2ty)
{
  try
  {
    CGAL_PROFILER("IA parallelC2 calls");
    Protect_FPU_rounding<Protected> Protection;
    return parallelC2(
		s1sx.interval(),
		s1sy.interval(),
		s1tx.interval(),
		s1ty.interval(),
		s2sx.interval(),
		s2sy.interval(),
		s2tx.interval(),
		s2ty.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA parallelC2 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return parallelC2(
		s1sx.exact(),
		s1sy.exact(),
		s1tx.exact(),
		s1ty.exact(),
		s2sx.exact(),
		s2sy.exact(),
		s2tx.exact(),
		s2ty.exact());
  }
}

template < class ET >
/*  */
bool
parallelC2(
    const Lazy_exact_nt<ET> &s1sx,
    const Lazy_exact_nt<ET> &s1sy,
    const Lazy_exact_nt<ET> &s1tx,
    const Lazy_exact_nt<ET> &s1ty,
    const Lazy_exact_nt<ET> &s2sx,
    const Lazy_exact_nt<ET> &s2sy,
    const Lazy_exact_nt<ET> &s2tx,
    const Lazy_exact_nt<ET> &s2ty)
{
  try
  {
    CGAL_PROFILER("Lazy IA parallelC2 calls");
    Protect_FPU_rounding<true> Protection;
    return parallelC2(
		s1sx.interval(),
		s1sy.interval(),
		s1tx.interval(),
		s1ty.interval(),
		s2sx.interval(),
		s2sy.interval(),
		s2tx.interval(),
		s2ty.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA parallelC2 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return parallelC2(
		s1sx.exact(),
		s1sy.exact(),
		s1tx.exact(),
		s1ty.exact(),
		s2sx.exact(),
		s2sy.exact(),
		s2tx.exact(),
		s2ty.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_MEDIUM_INLINE */
bool
equal_lineC2(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l1a,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l1b,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l1c,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l2a,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l2b,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l2c)
{
  try
  {
    CGAL_PROFILER("IA equal_lineC2 calls");
    Protect_FPU_rounding<Protected> Protection;
    return equal_lineC2(
		l1a.interval(),
		l1b.interval(),
		l1c.interval(),
		l2a.interval(),
		l2b.interval(),
		l2c.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA equal_lineC2 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return equal_lineC2(
		l1a.exact(),
		l1b.exact(),
		l1c.exact(),
		l2a.exact(),
		l2b.exact(),
		l2c.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_MEDIUM_INLINE */
bool
equal_lineC2(
    const Lazy_exact_nt<ET> &l1a,
    const Lazy_exact_nt<ET> &l1b,
    const Lazy_exact_nt<ET> &l1c,
    const Lazy_exact_nt<ET> &l2a,
    const Lazy_exact_nt<ET> &l2b,
    const Lazy_exact_nt<ET> &l2c)
{
  try
  {
    CGAL_PROFILER("Lazy IA equal_lineC2 calls");
    Protect_FPU_rounding<true> Protection;
    return equal_lineC2(
		l1a.interval(),
		l1b.interval(),
		l1c.interval(),
		l2a.interval(),
		l2b.interval(),
		l2c.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA equal_lineC2 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return equal_lineC2(
		l1a.exact(),
		l1b.exact(),
		l1c.exact(),
		l2a.exact(),
		l2b.exact(),
		l2c.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_MEDIUM_INLINE */
Comparison_result
compare_xC2(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &px,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &la,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &lb,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &lc,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &ha,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &hb,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &hc)
{
  try
  {
    CGAL_PROFILER("IA compare_xC2 calls");
    Protect_FPU_rounding<Protected> Protection;
    return compare_xC2(
		px.interval(),
		la.interval(),
		lb.interval(),
		lc.interval(),
		ha.interval(),
		hb.interval(),
		hc.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA compare_xC2 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return compare_xC2(
		px.exact(),
		la.exact(),
		lb.exact(),
		lc.exact(),
		ha.exact(),
		hb.exact(),
		hc.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_MEDIUM_INLINE */
Comparison_result
compare_xC2(
    const Lazy_exact_nt<ET> &px,
    const Lazy_exact_nt<ET> &la,
    const Lazy_exact_nt<ET> &lb,
    const Lazy_exact_nt<ET> &lc,
    const Lazy_exact_nt<ET> &ha,
    const Lazy_exact_nt<ET> &hb,
    const Lazy_exact_nt<ET> &hc)
{
  try
  {
    CGAL_PROFILER("Lazy IA compare_xC2 calls");
    Protect_FPU_rounding<true> Protection;
    return compare_xC2(
		px.interval(),
		la.interval(),
		lb.interval(),
		lc.interval(),
		ha.interval(),
		hb.interval(),
		hc.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA compare_xC2 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return compare_xC2(
		px.exact(),
		la.exact(),
		lb.exact(),
		lc.exact(),
		ha.exact(),
		hb.exact(),
		hc.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_MEDIUM_INLINE */
Comparison_result
compare_xC2(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &la,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &lb,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &lc,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &h1a,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &h1b,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &h1c,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &h2a,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &h2b,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &h2c)
{
  try
  {
    CGAL_PROFILER("IA compare_xC2 calls");
    Protect_FPU_rounding<Protected> Protection;
    return compare_xC2(
		la.interval(),
		lb.interval(),
		lc.interval(),
		h1a.interval(),
		h1b.interval(),
		h1c.interval(),
		h2a.interval(),
		h2b.interval(),
		h2c.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA compare_xC2 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return compare_xC2(
		la.exact(),
		lb.exact(),
		lc.exact(),
		h1a.exact(),
		h1b.exact(),
		h1c.exact(),
		h2a.exact(),
		h2b.exact(),
		h2c.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_MEDIUM_INLINE */
Comparison_result
compare_xC2(
    const Lazy_exact_nt<ET> &la,
    const Lazy_exact_nt<ET> &lb,
    const Lazy_exact_nt<ET> &lc,
    const Lazy_exact_nt<ET> &h1a,
    const Lazy_exact_nt<ET> &h1b,
    const Lazy_exact_nt<ET> &h1c,
    const Lazy_exact_nt<ET> &h2a,
    const Lazy_exact_nt<ET> &h2b,
    const Lazy_exact_nt<ET> &h2c)
{
  try
  {
    CGAL_PROFILER("Lazy IA compare_xC2 calls");
    Protect_FPU_rounding<true> Protection;
    return compare_xC2(
		la.interval(),
		lb.interval(),
		lc.interval(),
		h1a.interval(),
		h1b.interval(),
		h1c.interval(),
		h2a.interval(),
		h2b.interval(),
		h2c.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA compare_xC2 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return compare_xC2(
		la.exact(),
		lb.exact(),
		lc.exact(),
		h1a.exact(),
		h1b.exact(),
		h1c.exact(),
		h2a.exact(),
		h2b.exact(),
		h2c.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_MEDIUM_INLINE */
Comparison_result
compare_xC2(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l1a,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l1b,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l1c,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &h1a,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &h1b,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &h1c,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l2a,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l2b,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l2c,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &h2a,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &h2b,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &h2c)
{
  try
  {
    CGAL_PROFILER("IA compare_xC2 calls");
    Protect_FPU_rounding<Protected> Protection;
    return compare_xC2(
		l1a.interval(),
		l1b.interval(),
		l1c.interval(),
		h1a.interval(),
		h1b.interval(),
		h1c.interval(),
		l2a.interval(),
		l2b.interval(),
		l2c.interval(),
		h2a.interval(),
		h2b.interval(),
		h2c.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA compare_xC2 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return compare_xC2(
		l1a.exact(),
		l1b.exact(),
		l1c.exact(),
		h1a.exact(),
		h1b.exact(),
		h1c.exact(),
		l2a.exact(),
		l2b.exact(),
		l2c.exact(),
		h2a.exact(),
		h2b.exact(),
		h2c.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_MEDIUM_INLINE */
Comparison_result
compare_xC2(
    const Lazy_exact_nt<ET> &l1a,
    const Lazy_exact_nt<ET> &l1b,
    const Lazy_exact_nt<ET> &l1c,
    const Lazy_exact_nt<ET> &h1a,
    const Lazy_exact_nt<ET> &h1b,
    const Lazy_exact_nt<ET> &h1c,
    const Lazy_exact_nt<ET> &l2a,
    const Lazy_exact_nt<ET> &l2b,
    const Lazy_exact_nt<ET> &l2c,
    const Lazy_exact_nt<ET> &h2a,
    const Lazy_exact_nt<ET> &h2b,
    const Lazy_exact_nt<ET> &h2c)
{
  try
  {
    CGAL_PROFILER("Lazy IA compare_xC2 calls");
    Protect_FPU_rounding<true> Protection;
    return compare_xC2(
		l1a.interval(),
		l1b.interval(),
		l1c.interval(),
		h1a.interval(),
		h1b.interval(),
		h1c.interval(),
		l2a.interval(),
		l2b.interval(),
		l2c.interval(),
		h2a.interval(),
		h2b.interval(),
		h2c.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA compare_xC2 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return compare_xC2(
		l1a.exact(),
		l1b.exact(),
		l1c.exact(),
		h1a.exact(),
		h1b.exact(),
		h1c.exact(),
		l2a.exact(),
		l2b.exact(),
		l2c.exact(),
		h2a.exact(),
		h2b.exact(),
		h2c.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_MEDIUM_INLINE */
Comparison_result
compare_y_at_xC2(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &px,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &py,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &la,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &lb,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &lc)
{
  try
  {
    CGAL_PROFILER("IA compare_y_at_xC2 calls");
    Protect_FPU_rounding<Protected> Protection;
    return compare_y_at_xC2(
		px.interval(),
		py.interval(),
		la.interval(),
		lb.interval(),
		lc.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA compare_y_at_xC2 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return compare_y_at_xC2(
		px.exact(),
		py.exact(),
		la.exact(),
		lb.exact(),
		lc.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_MEDIUM_INLINE */
Comparison_result
compare_y_at_xC2(
    const Lazy_exact_nt<ET> &px,
    const Lazy_exact_nt<ET> &py,
    const Lazy_exact_nt<ET> &la,
    const Lazy_exact_nt<ET> &lb,
    const Lazy_exact_nt<ET> &lc)
{
  try
  {
    CGAL_PROFILER("Lazy IA compare_y_at_xC2 calls");
    Protect_FPU_rounding<true> Protection;
    return compare_y_at_xC2(
		px.interval(),
		py.interval(),
		la.interval(),
		lb.interval(),
		lc.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA compare_y_at_xC2 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return compare_y_at_xC2(
		px.exact(),
		py.exact(),
		la.exact(),
		lb.exact(),
		lc.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_MEDIUM_INLINE */
Comparison_result
compare_y_at_xC2(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &px,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l1a,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l1b,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l1c,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l2a,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l2b,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l2c)
{
  try
  {
    CGAL_PROFILER("IA compare_y_at_xC2 calls");
    Protect_FPU_rounding<Protected> Protection;
    return compare_y_at_xC2(
		px.interval(),
		l1a.interval(),
		l1b.interval(),
		l1c.interval(),
		l2a.interval(),
		l2b.interval(),
		l2c.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA compare_y_at_xC2 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return compare_y_at_xC2(
		px.exact(),
		l1a.exact(),
		l1b.exact(),
		l1c.exact(),
		l2a.exact(),
		l2b.exact(),
		l2c.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_MEDIUM_INLINE */
Comparison_result
compare_y_at_xC2(
    const Lazy_exact_nt<ET> &px,
    const Lazy_exact_nt<ET> &l1a,
    const Lazy_exact_nt<ET> &l1b,
    const Lazy_exact_nt<ET> &l1c,
    const Lazy_exact_nt<ET> &l2a,
    const Lazy_exact_nt<ET> &l2b,
    const Lazy_exact_nt<ET> &l2c)
{
  try
  {
    CGAL_PROFILER("Lazy IA compare_y_at_xC2 calls");
    Protect_FPU_rounding<true> Protection;
    return compare_y_at_xC2(
		px.interval(),
		l1a.interval(),
		l1b.interval(),
		l1c.interval(),
		l2a.interval(),
		l2b.interval(),
		l2c.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA compare_y_at_xC2 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return compare_y_at_xC2(
		px.exact(),
		l1a.exact(),
		l1b.exact(),
		l1c.exact(),
		l2a.exact(),
		l2b.exact(),
		l2c.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_LARGE_INLINE */
Comparison_result
compare_y_at_xC2(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l1a,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l1b,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l1c,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l2a,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l2b,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l2c,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &ha,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &hb,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &hc)
{
  try
  {
    CGAL_PROFILER("IA compare_y_at_xC2 calls");
    Protect_FPU_rounding<Protected> Protection;
    return compare_y_at_xC2(
		l1a.interval(),
		l1b.interval(),
		l1c.interval(),
		l2a.interval(),
		l2b.interval(),
		l2c.interval(),
		ha.interval(),
		hb.interval(),
		hc.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA compare_y_at_xC2 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return compare_y_at_xC2(
		l1a.exact(),
		l1b.exact(),
		l1c.exact(),
		l2a.exact(),
		l2b.exact(),
		l2c.exact(),
		ha.exact(),
		hb.exact(),
		hc.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_LARGE_INLINE */
Comparison_result
compare_y_at_xC2(
    const Lazy_exact_nt<ET> &l1a,
    const Lazy_exact_nt<ET> &l1b,
    const Lazy_exact_nt<ET> &l1c,
    const Lazy_exact_nt<ET> &l2a,
    const Lazy_exact_nt<ET> &l2b,
    const Lazy_exact_nt<ET> &l2c,
    const Lazy_exact_nt<ET> &ha,
    const Lazy_exact_nt<ET> &hb,
    const Lazy_exact_nt<ET> &hc)
{
  try
  {
    CGAL_PROFILER("Lazy IA compare_y_at_xC2 calls");
    Protect_FPU_rounding<true> Protection;
    return compare_y_at_xC2(
		l1a.interval(),
		l1b.interval(),
		l1c.interval(),
		l2a.interval(),
		l2b.interval(),
		l2c.interval(),
		ha.interval(),
		hb.interval(),
		hc.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA compare_y_at_xC2 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return compare_y_at_xC2(
		l1a.exact(),
		l1b.exact(),
		l1c.exact(),
		l2a.exact(),
		l2b.exact(),
		l2c.exact(),
		ha.exact(),
		hb.exact(),
		hc.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_LARGE_INLINE */
Comparison_result
compare_y_at_xC2(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l1a,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l1b,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l1c,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l2a,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l2b,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l2c,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &h1a,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &h1b,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &h1c,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &h2a,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &h2b,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &h2c)
{
  try
  {
    CGAL_PROFILER("IA compare_y_at_xC2 calls");
    Protect_FPU_rounding<Protected> Protection;
    return compare_y_at_xC2(
		l1a.interval(),
		l1b.interval(),
		l1c.interval(),
		l2a.interval(),
		l2b.interval(),
		l2c.interval(),
		h1a.interval(),
		h1b.interval(),
		h1c.interval(),
		h2a.interval(),
		h2b.interval(),
		h2c.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA compare_y_at_xC2 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return compare_y_at_xC2(
		l1a.exact(),
		l1b.exact(),
		l1c.exact(),
		l2a.exact(),
		l2b.exact(),
		l2c.exact(),
		h1a.exact(),
		h1b.exact(),
		h1c.exact(),
		h2a.exact(),
		h2b.exact(),
		h2c.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_LARGE_INLINE */
Comparison_result
compare_y_at_xC2(
    const Lazy_exact_nt<ET> &l1a,
    const Lazy_exact_nt<ET> &l1b,
    const Lazy_exact_nt<ET> &l1c,
    const Lazy_exact_nt<ET> &l2a,
    const Lazy_exact_nt<ET> &l2b,
    const Lazy_exact_nt<ET> &l2c,
    const Lazy_exact_nt<ET> &h1a,
    const Lazy_exact_nt<ET> &h1b,
    const Lazy_exact_nt<ET> &h1c,
    const Lazy_exact_nt<ET> &h2a,
    const Lazy_exact_nt<ET> &h2b,
    const Lazy_exact_nt<ET> &h2c)
{
  try
  {
    CGAL_PROFILER("Lazy IA compare_y_at_xC2 calls");
    Protect_FPU_rounding<true> Protection;
    return compare_y_at_xC2(
		l1a.interval(),
		l1b.interval(),
		l1c.interval(),
		l2a.interval(),
		l2b.interval(),
		l2c.interval(),
		h1a.interval(),
		h1b.interval(),
		h1c.interval(),
		h2a.interval(),
		h2b.interval(),
		h2c.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA compare_y_at_xC2 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return compare_y_at_xC2(
		l1a.exact(),
		l1b.exact(),
		l1c.exact(),
		l2a.exact(),
		l2b.exact(),
		l2c.exact(),
		h1a.exact(),
		h1b.exact(),
		h1c.exact(),
		h2a.exact(),
		h2b.exact(),
		h2c.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_LARGE_INLINE */
Comparison_result
compare_y_at_x_segment_C2(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &px,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s1sx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s1sy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s1tx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s1ty,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s2sx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s2sy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s2tx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s2ty)
{
  try
  {
    CGAL_PROFILER("IA compare_y_at_x_segment_C2 calls");
    Protect_FPU_rounding<Protected> Protection;
    return compare_y_at_x_segment_C2(
		px.interval(),
		s1sx.interval(),
		s1sy.interval(),
		s1tx.interval(),
		s1ty.interval(),
		s2sx.interval(),
		s2sy.interval(),
		s2tx.interval(),
		s2ty.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA compare_y_at_x_segment_C2 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return compare_y_at_x_segment_C2(
		px.exact(),
		s1sx.exact(),
		s1sy.exact(),
		s1tx.exact(),
		s1ty.exact(),
		s2sx.exact(),
		s2sy.exact(),
		s2tx.exact(),
		s2ty.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_LARGE_INLINE */
Comparison_result
compare_y_at_x_segment_C2(
    const Lazy_exact_nt<ET> &px,
    const Lazy_exact_nt<ET> &s1sx,
    const Lazy_exact_nt<ET> &s1sy,
    const Lazy_exact_nt<ET> &s1tx,
    const Lazy_exact_nt<ET> &s1ty,
    const Lazy_exact_nt<ET> &s2sx,
    const Lazy_exact_nt<ET> &s2sy,
    const Lazy_exact_nt<ET> &s2tx,
    const Lazy_exact_nt<ET> &s2ty)
{
  try
  {
    CGAL_PROFILER("Lazy IA compare_y_at_x_segment_C2 calls");
    Protect_FPU_rounding<true> Protection;
    return compare_y_at_x_segment_C2(
		px.interval(),
		s1sx.interval(),
		s1sy.interval(),
		s1tx.interval(),
		s1ty.interval(),
		s2sx.interval(),
		s2sy.interval(),
		s2tx.interval(),
		s2ty.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA compare_y_at_x_segment_C2 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return compare_y_at_x_segment_C2(
		px.exact(),
		s1sx.exact(),
		s1sy.exact(),
		s1tx.exact(),
		s1ty.exact(),
		s2sx.exact(),
		s2sy.exact(),
		s2tx.exact(),
		s2ty.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_MEDIUM_INLINE */
bool
equal_directionC2(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &dx1,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &dy1,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &dx2,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &dy2)
{
  try
  {
    CGAL_PROFILER("IA equal_directionC2 calls");
    Protect_FPU_rounding<Protected> Protection;
    return equal_directionC2(
		dx1.interval(),
		dy1.interval(),
		dx2.interval(),
		dy2.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA equal_directionC2 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return equal_directionC2(
		dx1.exact(),
		dy1.exact(),
		dx2.exact(),
		dy2.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_MEDIUM_INLINE */
bool
equal_directionC2(
    const Lazy_exact_nt<ET> &dx1,
    const Lazy_exact_nt<ET> &dy1,
    const Lazy_exact_nt<ET> &dx2,
    const Lazy_exact_nt<ET> &dy2)
{
  try
  {
    CGAL_PROFILER("Lazy IA equal_directionC2 calls");
    Protect_FPU_rounding<true> Protection;
    return equal_directionC2(
		dx1.interval(),
		dy1.interval(),
		dx2.interval(),
		dy2.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA equal_directionC2 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return equal_directionC2(
		dx1.exact(),
		dy1.exact(),
		dx2.exact(),
		dy2.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_MEDIUM_INLINE */
Comparison_result
compare_slopesC2(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l1a,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l1b,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l2a,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &l2b)
{
  try
  {
    CGAL_PROFILER("IA compare_slopesC2 calls");
    Protect_FPU_rounding<Protected> Protection;
    return compare_slopesC2(
		l1a.interval(),
		l1b.interval(),
		l2a.interval(),
		l2b.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA compare_slopesC2 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return compare_slopesC2(
		l1a.exact(),
		l1b.exact(),
		l2a.exact(),
		l2b.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_MEDIUM_INLINE */
Comparison_result
compare_slopesC2(
    const Lazy_exact_nt<ET> &l1a,
    const Lazy_exact_nt<ET> &l1b,
    const Lazy_exact_nt<ET> &l2a,
    const Lazy_exact_nt<ET> &l2b)
{
  try
  {
    CGAL_PROFILER("Lazy IA compare_slopesC2 calls");
    Protect_FPU_rounding<true> Protection;
    return compare_slopesC2(
		l1a.interval(),
		l1b.interval(),
		l2a.interval(),
		l2b.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA compare_slopesC2 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return compare_slopesC2(
		l1a.exact(),
		l1b.exact(),
		l2a.exact(),
		l2b.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_MEDIUM_INLINE */
Comparison_result
compare_slopesC2(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s1_src_x,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s1_src_y,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s1_tgt_x,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s1_tgt_y,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s2_src_x,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s2_src_y,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s2_tgt_x,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s2_tgt_y)
{
  try
  {
    CGAL_PROFILER("IA compare_slopesC2 calls");
    Protect_FPU_rounding<Protected> Protection;
    return compare_slopesC2(
		s1_src_x.interval(),
		s1_src_y.interval(),
		s1_tgt_x.interval(),
		s1_tgt_y.interval(),
		s2_src_x.interval(),
		s2_src_y.interval(),
		s2_tgt_x.interval(),
		s2_tgt_y.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA compare_slopesC2 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return compare_slopesC2(
		s1_src_x.exact(),
		s1_src_y.exact(),
		s1_tgt_x.exact(),
		s1_tgt_y.exact(),
		s2_src_x.exact(),
		s2_src_y.exact(),
		s2_tgt_x.exact(),
		s2_tgt_y.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_MEDIUM_INLINE */
Comparison_result
compare_slopesC2(
    const Lazy_exact_nt<ET> &s1_src_x,
    const Lazy_exact_nt<ET> &s1_src_y,
    const Lazy_exact_nt<ET> &s1_tgt_x,
    const Lazy_exact_nt<ET> &s1_tgt_y,
    const Lazy_exact_nt<ET> &s2_src_x,
    const Lazy_exact_nt<ET> &s2_src_y,
    const Lazy_exact_nt<ET> &s2_tgt_x,
    const Lazy_exact_nt<ET> &s2_tgt_y)
{
  try
  {
    CGAL_PROFILER("Lazy IA compare_slopesC2 calls");
    Protect_FPU_rounding<true> Protection;
    return compare_slopesC2(
		s1_src_x.interval(),
		s1_src_y.interval(),
		s1_tgt_x.interval(),
		s1_tgt_y.interval(),
		s2_src_x.interval(),
		s2_src_y.interval(),
		s2_tgt_x.interval(),
		s2_tgt_y.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA compare_slopesC2 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return compare_slopesC2(
		s1_src_x.exact(),
		s1_src_y.exact(),
		s1_tgt_x.exact(),
		s1_tgt_y.exact(),
		s2_src_x.exact(),
		s2_src_y.exact(),
		s2_tgt_x.exact(),
		s2_tgt_y.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* inline */
Comparison_result
compare_deltax_deltayC2(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &px,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &ry,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &sy)
{
  try
  {
    CGAL_PROFILER("IA compare_deltax_deltayC2 calls");
    Protect_FPU_rounding<Protected> Protection;
    return compare_deltax_deltayC2(
		px.interval(),
		qx.interval(),
		ry.interval(),
		sy.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA compare_deltax_deltayC2 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return compare_deltax_deltayC2(
		px.exact(),
		qx.exact(),
		ry.exact(),
		sy.exact());
  }
}

template < class ET >
/* inline */
Comparison_result
compare_deltax_deltayC2(
    const Lazy_exact_nt<ET> &px,
    const Lazy_exact_nt<ET> &qx,
    const Lazy_exact_nt<ET> &ry,
    const Lazy_exact_nt<ET> &sy)
{
  try
  {
    CGAL_PROFILER("Lazy IA compare_deltax_deltayC2 calls");
    Protect_FPU_rounding<true> Protection;
    return compare_deltax_deltayC2(
		px.interval(),
		qx.interval(),
		ry.interval(),
		sy.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA compare_deltax_deltayC2 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return compare_deltax_deltayC2(
		px.exact(),
		qx.exact(),
		ry.exact(),
		sy.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* inline */
Orientation
orientationC2(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &px,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &py,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &rx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &ry)
{
  try
  {
    CGAL_PROFILER("IA orientationC2 calls");
    Protect_FPU_rounding<Protected> Protection;
    return orientationC2(
		px.interval(),
		py.interval(),
		qx.interval(),
		qy.interval(),
		rx.interval(),
		ry.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA orientationC2 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return orientationC2(
		px.exact(),
		py.exact(),
		qx.exact(),
		qy.exact(),
		rx.exact(),
		ry.exact());
  }
}

template < class ET >
/* inline */
Orientation
orientationC2(
    const Lazy_exact_nt<ET> &px,
    const Lazy_exact_nt<ET> &py,
    const Lazy_exact_nt<ET> &qx,
    const Lazy_exact_nt<ET> &qy,
    const Lazy_exact_nt<ET> &rx,
    const Lazy_exact_nt<ET> &ry)
{
  try
  {
    CGAL_PROFILER("Lazy IA orientationC2 calls");
    Protect_FPU_rounding<true> Protection;
    return orientationC2(
		px.interval(),
		py.interval(),
		qx.interval(),
		qy.interval(),
		rx.interval(),
		ry.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA orientationC2 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return orientationC2(
		px.exact(),
		py.exact(),
		qx.exact(),
		qy.exact(),
		rx.exact(),
		ry.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* inline */
Angle
angleC2(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &px,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &py,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &rx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &ry)
{
  try
  {
    CGAL_PROFILER("IA angleC2 calls");
    Protect_FPU_rounding<Protected> Protection;
    return angleC2(
		px.interval(),
		py.interval(),
		qx.interval(),
		qy.interval(),
		rx.interval(),
		ry.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA angleC2 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return angleC2(
		px.exact(),
		py.exact(),
		qx.exact(),
		qy.exact(),
		rx.exact(),
		ry.exact());
  }
}

template < class ET >
/* inline */
Angle
angleC2(
    const Lazy_exact_nt<ET> &px,
    const Lazy_exact_nt<ET> &py,
    const Lazy_exact_nt<ET> &qx,
    const Lazy_exact_nt<ET> &qy,
    const Lazy_exact_nt<ET> &rx,
    const Lazy_exact_nt<ET> &ry)
{
  try
  {
    CGAL_PROFILER("Lazy IA angleC2 calls");
    Protect_FPU_rounding<true> Protection;
    return angleC2(
		px.interval(),
		py.interval(),
		qx.interval(),
		qy.interval(),
		rx.interval(),
		ry.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA angleC2 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return angleC2(
		px.exact(),
		py.exact(),
		qx.exact(),
		qy.exact(),
		rx.exact(),
		ry.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_LARGE_INLINE */
Oriented_side
side_of_oriented_circleC2(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &px,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &py,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &rx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &ry,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &tx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &ty)
{
  try
  {
    CGAL_PROFILER("IA side_of_oriented_circleC2 calls");
    Protect_FPU_rounding<Protected> Protection;
    return side_of_oriented_circleC2(
		px.interval(),
		py.interval(),
		qx.interval(),
		qy.interval(),
		rx.interval(),
		ry.interval(),
		tx.interval(),
		ty.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA side_of_oriented_circleC2 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return side_of_oriented_circleC2(
		px.exact(),
		py.exact(),
		qx.exact(),
		qy.exact(),
		rx.exact(),
		ry.exact(),
		tx.exact(),
		ty.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_LARGE_INLINE */
Oriented_side
side_of_oriented_circleC2(
    const Lazy_exact_nt<ET> &px,
    const Lazy_exact_nt<ET> &py,
    const Lazy_exact_nt<ET> &qx,
    const Lazy_exact_nt<ET> &qy,
    const Lazy_exact_nt<ET> &rx,
    const Lazy_exact_nt<ET> &ry,
    const Lazy_exact_nt<ET> &tx,
    const Lazy_exact_nt<ET> &ty)
{
  try
  {
    CGAL_PROFILER("Lazy IA side_of_oriented_circleC2 calls");
    Protect_FPU_rounding<true> Protection;
    return side_of_oriented_circleC2(
		px.interval(),
		py.interval(),
		qx.interval(),
		qy.interval(),
		rx.interval(),
		ry.interval(),
		tx.interval(),
		ty.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA side_of_oriented_circleC2 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return side_of_oriented_circleC2(
		px.exact(),
		py.exact(),
		qx.exact(),
		qy.exact(),
		rx.exact(),
		ry.exact(),
		tx.exact(),
		ty.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_LARGE_INLINE */
Bounded_side
side_of_bounded_circleC2(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &px,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &py,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &rx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &ry,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &tx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &ty)
{
  try
  {
    CGAL_PROFILER("IA side_of_bounded_circleC2 calls");
    Protect_FPU_rounding<Protected> Protection;
    return side_of_bounded_circleC2(
		px.interval(),
		py.interval(),
		qx.interval(),
		qy.interval(),
		rx.interval(),
		ry.interval(),
		tx.interval(),
		ty.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA side_of_bounded_circleC2 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return side_of_bounded_circleC2(
		px.exact(),
		py.exact(),
		qx.exact(),
		qy.exact(),
		rx.exact(),
		ry.exact(),
		tx.exact(),
		ty.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_LARGE_INLINE */
Bounded_side
side_of_bounded_circleC2(
    const Lazy_exact_nt<ET> &px,
    const Lazy_exact_nt<ET> &py,
    const Lazy_exact_nt<ET> &qx,
    const Lazy_exact_nt<ET> &qy,
    const Lazy_exact_nt<ET> &rx,
    const Lazy_exact_nt<ET> &ry,
    const Lazy_exact_nt<ET> &tx,
    const Lazy_exact_nt<ET> &ty)
{
  try
  {
    CGAL_PROFILER("Lazy IA side_of_bounded_circleC2 calls");
    Protect_FPU_rounding<true> Protection;
    return side_of_bounded_circleC2(
		px.interval(),
		py.interval(),
		qx.interval(),
		qy.interval(),
		rx.interval(),
		ry.interval(),
		tx.interval(),
		ty.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA side_of_bounded_circleC2 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return side_of_bounded_circleC2(
		px.exact(),
		py.exact(),
		qx.exact(),
		qy.exact(),
		rx.exact(),
		ry.exact(),
		tx.exact(),
		ty.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_LARGE_INLINE */
Bounded_side
side_of_bounded_circleC2(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &px,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &py,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &tx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &ty)
{
  try
  {
    CGAL_PROFILER("IA side_of_bounded_circleC2 calls");
    Protect_FPU_rounding<Protected> Protection;
    return side_of_bounded_circleC2(
		px.interval(),
		py.interval(),
		qx.interval(),
		qy.interval(),
		tx.interval(),
		ty.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA side_of_bounded_circleC2 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return side_of_bounded_circleC2(
		px.exact(),
		py.exact(),
		qx.exact(),
		qy.exact(),
		tx.exact(),
		ty.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_LARGE_INLINE */
Bounded_side
side_of_bounded_circleC2(
    const Lazy_exact_nt<ET> &px,
    const Lazy_exact_nt<ET> &py,
    const Lazy_exact_nt<ET> &qx,
    const Lazy_exact_nt<ET> &qy,
    const Lazy_exact_nt<ET> &tx,
    const Lazy_exact_nt<ET> &ty)
{
  try
  {
    CGAL_PROFILER("Lazy IA side_of_bounded_circleC2 calls");
    Protect_FPU_rounding<true> Protection;
    return side_of_bounded_circleC2(
		px.interval(),
		py.interval(),
		qx.interval(),
		qy.interval(),
		tx.interval(),
		ty.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA side_of_bounded_circleC2 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return side_of_bounded_circleC2(
		px.exact(),
		py.exact(),
		qx.exact(),
		qy.exact(),
		tx.exact(),
		ty.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* inline */
Comparison_result
cmp_dist_to_pointC2(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &px,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &py,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &rx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &ry)
{
  try
  {
    CGAL_PROFILER("IA cmp_dist_to_pointC2 calls");
    Protect_FPU_rounding<Protected> Protection;
    return cmp_dist_to_pointC2(
		px.interval(),
		py.interval(),
		qx.interval(),
		qy.interval(),
		rx.interval(),
		ry.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA cmp_dist_to_pointC2 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return cmp_dist_to_pointC2(
		px.exact(),
		py.exact(),
		qx.exact(),
		qy.exact(),
		rx.exact(),
		ry.exact());
  }
}

template < class ET >
/* inline */
Comparison_result
cmp_dist_to_pointC2(
    const Lazy_exact_nt<ET> &px,
    const Lazy_exact_nt<ET> &py,
    const Lazy_exact_nt<ET> &qx,
    const Lazy_exact_nt<ET> &qy,
    const Lazy_exact_nt<ET> &rx,
    const Lazy_exact_nt<ET> &ry)
{
  try
  {
    CGAL_PROFILER("Lazy IA cmp_dist_to_pointC2 calls");
    Protect_FPU_rounding<true> Protection;
    return cmp_dist_to_pointC2(
		px.interval(),
		py.interval(),
		qx.interval(),
		qy.interval(),
		rx.interval(),
		ry.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA cmp_dist_to_pointC2 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return cmp_dist_to_pointC2(
		px.exact(),
		py.exact(),
		qx.exact(),
		qy.exact(),
		rx.exact(),
		ry.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* inline */
Comparison_result
cmp_signed_dist_to_directionC2(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &la,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &lb,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &px,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &py,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qy)
{
  try
  {
    CGAL_PROFILER("IA cmp_signed_dist_to_directionC2 calls");
    Protect_FPU_rounding<Protected> Protection;
    return cmp_signed_dist_to_directionC2(
		la.interval(),
		lb.interval(),
		px.interval(),
		py.interval(),
		qx.interval(),
		qy.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA cmp_signed_dist_to_directionC2 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return cmp_signed_dist_to_directionC2(
		la.exact(),
		lb.exact(),
		px.exact(),
		py.exact(),
		qx.exact(),
		qy.exact());
  }
}

template < class ET >
/* inline */
Comparison_result
cmp_signed_dist_to_directionC2(
    const Lazy_exact_nt<ET> &la,
    const Lazy_exact_nt<ET> &lb,
    const Lazy_exact_nt<ET> &px,
    const Lazy_exact_nt<ET> &py,
    const Lazy_exact_nt<ET> &qx,
    const Lazy_exact_nt<ET> &qy)
{
  try
  {
    CGAL_PROFILER("Lazy IA cmp_signed_dist_to_directionC2 calls");
    Protect_FPU_rounding<true> Protection;
    return cmp_signed_dist_to_directionC2(
		la.interval(),
		lb.interval(),
		px.interval(),
		py.interval(),
		qx.interval(),
		qy.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA cmp_signed_dist_to_directionC2 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return cmp_signed_dist_to_directionC2(
		la.exact(),
		lb.exact(),
		px.exact(),
		py.exact(),
		qx.exact(),
		qy.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* inline */
Comparison_result
cmp_signed_dist_to_lineC2(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &px,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &py,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &rx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &ry,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &sx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &sy)
{
  try
  {
    CGAL_PROFILER("IA cmp_signed_dist_to_lineC2 calls");
    Protect_FPU_rounding<Protected> Protection;
    return cmp_signed_dist_to_lineC2(
		px.interval(),
		py.interval(),
		qx.interval(),
		qy.interval(),
		rx.interval(),
		ry.interval(),
		sx.interval(),
		sy.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA cmp_signed_dist_to_lineC2 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return cmp_signed_dist_to_lineC2(
		px.exact(),
		py.exact(),
		qx.exact(),
		qy.exact(),
		rx.exact(),
		ry.exact(),
		sx.exact(),
		sy.exact());
  }
}

template < class ET >
/* inline */
Comparison_result
cmp_signed_dist_to_lineC2(
    const Lazy_exact_nt<ET> &px,
    const Lazy_exact_nt<ET> &py,
    const Lazy_exact_nt<ET> &qx,
    const Lazy_exact_nt<ET> &qy,
    const Lazy_exact_nt<ET> &rx,
    const Lazy_exact_nt<ET> &ry,
    const Lazy_exact_nt<ET> &sx,
    const Lazy_exact_nt<ET> &sy)
{
  try
  {
    CGAL_PROFILER("Lazy IA cmp_signed_dist_to_lineC2 calls");
    Protect_FPU_rounding<true> Protection;
    return cmp_signed_dist_to_lineC2(
		px.interval(),
		py.interval(),
		qx.interval(),
		qy.interval(),
		rx.interval(),
		ry.interval(),
		sx.interval(),
		sy.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA cmp_signed_dist_to_lineC2 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return cmp_signed_dist_to_lineC2(
		px.exact(),
		py.exact(),
		qx.exact(),
		qy.exact(),
		rx.exact(),
		ry.exact(),
		sx.exact(),
		sy.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* inline */
Oriented_side
side_of_oriented_lineC2(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &a,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &b,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &c,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &x,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &y)
{
  try
  {
    CGAL_PROFILER("IA side_of_oriented_lineC2 calls");
    Protect_FPU_rounding<Protected> Protection;
    return side_of_oriented_lineC2(
		a.interval(),
		b.interval(),
		c.interval(),
		x.interval(),
		y.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA side_of_oriented_lineC2 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return side_of_oriented_lineC2(
		a.exact(),
		b.exact(),
		c.exact(),
		x.exact(),
		y.exact());
  }
}

template < class ET >
/* inline */
Oriented_side
side_of_oriented_lineC2(
    const Lazy_exact_nt<ET> &a,
    const Lazy_exact_nt<ET> &b,
    const Lazy_exact_nt<ET> &c,
    const Lazy_exact_nt<ET> &x,
    const Lazy_exact_nt<ET> &y)
{
  try
  {
    CGAL_PROFILER("Lazy IA side_of_oriented_lineC2 calls");
    Protect_FPU_rounding<true> Protection;
    return side_of_oriented_lineC2(
		a.interval(),
		b.interval(),
		c.interval(),
		x.interval(),
		y.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA side_of_oriented_lineC2 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return side_of_oriented_lineC2(
		a.exact(),
		b.exact(),
		c.exact(),
		x.exact(),
		y.exact());
  }
}

CGAL_END_NAMESPACE

#endif // CGAL_ARITHMETIC_FILTER_PREDICATES_KERNEL_FTC2_H
