/*************************************************************************
** $Id: qtdatetime.h,v 1.1 2007/07/09 13:43:45 tilo Exp $
**
** Definition of date and time classes
**
** Created : 940124
**
** Copyright (C) 1992-2005 Trolltech AS.  All rights reserved.
**
** This file is part of the tools module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef QTDATETIME_H
#define QTDATETIME_H

#ifndef QT_H
#include "qstring.h"
#include "qnamespace.h"
#endif // QT_H


/*****************************************************************************
  QtDate class
 *****************************************************************************/

class QtDate
{
public:
    QtDate() { jd = 0; }
    QtDate( int y, int m, int d );

    bool isNull() const { return jd == 0; }
    bool isValid() const;

    int year() const;
    int month() const;
    int day() const;
    int dayOfWeek() const;
    int dayOfYear() const;
    int daysInMonth() const;
    int daysInYear() const;
    int weekNumber( int *yearNum = 0 ) const;

#ifndef QT_NO_TEXTDATE
#ifndef QT_NO_COMPAT
    static QString monthName( int month ) { return shortMonthName( month ); }
    static QString dayName( int weekday ) { return shortDayName( weekday ); }
#endif
    static QString shortMonthName( int month );
    static QString shortDayName( int weekday );
    static QString longMonthName( int month );
    static QString longDayName( int weekday );
#endif //QT_NO_TEXTDATE
#ifndef QT_NO_TEXTSTRING
#if !defined(QT_NO_SPRINTF)
    QString toString( Qt::DateFormat f = Qt::TextDate ) const;
#endif
    QString toString( const QString& format ) const;
#endif
    bool   setYMD( int y, int m, int d );

    QtDate  addDays( int days )		const;
    QtDate  addMonths( int months )      const;
    QtDate  addYears( int years )        const;
    int	   daysTo( const QtDate & )	const;

    bool   operator==( const QtDate &d ) const { return jd == d.jd; }
    bool   operator!=( const QtDate &d ) const { return jd != d.jd; }
    bool   operator<( const QtDate &d )	const { return jd < d.jd; }
    bool   operator<=( const QtDate &d ) const { return jd <= d.jd; }
    bool   operator>( const QtDate &d )	const { return jd > d.jd; }
    bool   operator>=( const QtDate &d ) const { return jd >= d.jd; }

    static QtDate currentDate();
    static QtDate currentDate( Qt::TimeSpec );
#ifndef QT_NO_DATESTRING
    static QtDate fromString( const QString& s, Qt::DateFormat f = Qt::TextDate );
#endif
    static bool	 isValid( int y, int m, int d );
    static bool	 leapYear( int year );

    static uint	 gregorianToJulian( int y, int m, int d );
    static void	 julianToGregorian( uint jd, int &y, int &m, int &d );
private:
    uint	 jd;
    friend class QtDateTime;
#ifndef QT_NO_DATASTREAM
    friend QDataStream &operator<<( QDataStream &, const QtDate & );
    friend QDataStream &operator>>( QDataStream &, QtDate & );
#endif
};


/*****************************************************************************
  QtTime class
 *****************************************************************************/

class QtTime
{
public:
    QtTime() { ds=0; }				// set null time
    QtTime( int h, int m, int s=0, int ms=0 );	// set time

    bool   isNull()	 const { return ds == 0; }
    bool   isValid()	 const;			// valid time

    int	   hour()	 const;			// 0..23
    int	   minute()	 const;			// 0..59
    int	   second()	 const;			// 0..59
    int	   msec()	 const;			// 0..999
#ifndef QT_NO_DATESTRING
#ifndef QT_NO_SPRINTF
    QString toString( Qt::DateFormat f = Qt::TextDate )	 const;
#endif
    QString toString( const QString& format ) const;
#endif
    bool   setHMS( int h, int m, int s, int ms=0 );

    QtTime  addSecs( int secs )		const;
    int	   secsTo( const QtTime & )	const;
    QtTime  addMSecs( int ms )		const;
    int	   msecsTo( const QtTime & )	const;

    bool   operator==( const QtTime &d ) const { return ds == d.ds; }
    bool   operator!=( const QtTime &d ) const { return ds != d.ds; }
    bool   operator<( const QtTime &d )	const { return ds < d.ds; }
    bool   operator<=( const QtTime &d ) const { return ds <= d.ds; }
    bool   operator>( const QtTime &d )	const { return ds > d.ds; }
    bool   operator>=( const QtTime &d ) const { return ds >= d.ds; }

    static QtTime currentTime();
    static QtTime currentTime( Qt::TimeSpec );
#ifndef QT_NO_DATESTRING
    static QtTime fromString( const QString& s, Qt::DateFormat f = Qt::TextDate );
#endif
    static bool	 isValid( int h, int m, int s, int ms=0 );

    void   start();
    int	   restart();
    int	   elapsed() const;

private:
    static bool currentTime( QtTime * );
    static bool currentTime( QtTime *, Qt::TimeSpec );

    uint   ds;
    friend class QtDateTime;
#ifndef QT_NO_DATASTREAM
    friend QDataStream &operator<<( QDataStream &, const QtTime & );
    friend QDataStream &operator>>( QDataStream &, QtTime & );
#endif
};


/*****************************************************************************
  QtDateTime class
 *****************************************************************************/

class QtDateTime
{
public:
    QtDateTime() {}				// set null date and null time
    QtDateTime( const QtDate & );
    QtDateTime( const QtDate &, const QtTime & );

    bool   isNull()	const		{ return d.isNull() && t.isNull(); }
    bool   isValid()	const		{ return d.isValid() && t.isValid(); }

    QtDate  date()	const		{ return d; }
    QtTime  time()	const		{ return t; }
    uint   toTime_t()	const;
    void   setDate( const QtDate &date ) { d = date; }
    void   setTime( const QtTime &time ) { t = time; }
    void   setTime_t( uint secsSince1Jan1970UTC );
    void   setTime_t( uint secsSince1Jan1970UTC, Qt::TimeSpec );
#ifndef QT_NO_DATESTRING
#ifndef QT_NO_SPRINTF
    QString toString( Qt::DateFormat f = Qt::TextDate )	const;
#endif
    QString toString( const QString& format ) const;
#endif
    QtDateTime addDays( int days )	const;
    QtDateTime addMonths( int months )   const;
    QtDateTime addYears( int years )     const;
    QtDateTime addSecs( int secs )	const;
    int	   daysTo( const QtDateTime & )	const;
    int	   secsTo( const QtDateTime & )	const;

    bool   operator==( const QtDateTime &dt ) const;
    bool   operator!=( const QtDateTime &dt ) const;
    bool   operator<( const QtDateTime &dt )  const;
    bool   operator<=( const QtDateTime &dt ) const;
    bool   operator>( const QtDateTime &dt )  const;
    bool   operator>=( const QtDateTime &dt ) const;

    static QtDateTime currentDateTime();
    static QtDateTime currentDateTime( Qt::TimeSpec );
#ifndef QT_NO_DATESTRING
    static QtDateTime fromString( const QString& s, Qt::DateFormat f = Qt::TextDate );
#endif
private:
    QtDate  d;
    QtTime  t;
#ifndef QT_NO_DATASTREAM
    friend QDataStream &operator<<( QDataStream &, const QtDateTime &);
    friend QDataStream &operator>>( QDataStream &, QtDateTime & );
#endif
};


/*****************************************************************************
  Date and time stream functions
 *****************************************************************************/

#ifndef QT_NO_DATASTREAM
QDataStream &operator<<( QDataStream &, const QtDate & );
QDataStream &operator>>( QDataStream &, QtDate & );
QDataStream &operator<<( QDataStream &, const QtTime & );
QDataStream &operator>>( QDataStream &, QtTime & );
QDataStream &operator<<( QDataStream &, const QtDateTime & );
QDataStream &operator>>( QDataStream &, QtDateTime & );
#endif // QT_NO_DATASTREAM

#endif // QTDATETIME_H

