/****************************************************************************
**
** Copyright (C) 2001-2006 Tilo Riemer <riemer@crossvc.com>,
**                         Frank Hemer <frank@hemer.org>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** CrossVC is available under two different licenses:
**
** If CrossVC is linked against the GPLed version of Qt 
** CrossVC is released under the terms of GPL also.
**
** If CrossVC is linked against a nonGPLed version of Qt 
** CrossVC is released under the terms of the 
** CrossVC License for non-Unix platforms (CLNU)
**
**
** CrossVC License for non-Unix platforms (CLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than CrossVC.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** CrossVC License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation, version 2 of the License.
** This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License version 2 for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#include "ExtTimer.h"

CExtTimer::CExtTimer(QObject * parent /* = 0 */, const char * name /* = 0 */) : QTimer(parent,name),m_remaining(-1) {
  connect(this,SIGNAL(timeout()),this,SLOT(timedOut()));
}

CExtTimer::~CExtTimer() {}

int CExtTimer::start ( int msec, bool sshot /* = FALSE */ ) {
  QTimer::stop();
  m_msec = msec;
  m_sshot = sshot;
  m_remaining = -1;
  m_runtime = 0;
  m_start = QTime::currentTime();
//   qDebug(QString(name())+" starting at: "+m_start.toString("mm:ss:zzz"));
  return QTimer::start( msec, sshot);
}

void CExtTimer::stop() {
  QTimer::stop();
//   qDebug(QString(name())+" stopped at: "+QTime::currentTime().toString("mm:ss:zzz"));
  m_remaining = -1;
}

void CExtTimer::changeInterval( int msec) {
    start(msec,m_sshot);
}

void CExtTimer::pause() {
  if (isActive()) {
    QTimer::stop();
    int runtime = m_start.msecsTo(QTime::currentTime());
    if (runtime < 0) runtime += 86400000;
//     qDebug(QString(name())+" ran for: "+QString::number(runtime)+" msecs");
    m_runtime += runtime;
    m_remaining = m_msec - m_runtime;
//     qDebug(QString(name())+" paused at: "+QTime::currentTime().toString("mm:ss:zzz")+", remaining: "+QString::number(m_remaining));
    if (m_remaining < 0) m_remaining = 0;
  }
}

void CExtTimer::proceed() {
  if (!isActive() && (m_remaining > -1) ) {
    m_start = QTime::currentTime();
    QTimer::start(m_remaining,m_sshot);
//     qDebug( QString(name())+" proceeding at: "+QTime::currentTime().toString("mm:ss:zzz")+", remaining: "+QString::number(m_remaining));
  }
}

void CExtTimer::timedOut() {
  m_start = QTime::currentTime();
  if (!m_sshot && (m_remaining > -1) ) {
    QTimer::changeInterval(m_msec);
    m_runtime = 0;
    m_remaining = -1;
  }
}

