/****************************************************************************
**
** Copyright (C) 2004-2006 Frank Hemer <frank@hemer.org>,
**                         Tilo Riemer <riemer@crossvc.com>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** CrossVC is available under two different licenses:
**
** If CrossVC is linked against the GPLed version of Qt 
** CrossVC is released under the terms of GPL also.
**
** If CrossVC is linked against a nonGPLed version of Qt 
** CrossVC is released under the terms of the 
** CrossVC License for non-Unix platforms (CLNU)
**
**
** CrossVC License for non-Unix platforms (CLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than CrossVC.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** CrossVC License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation, version 2 of the License.
** This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License version 2 for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#ifndef PATCHDIALOGIMPL_H
#define PATCHDIALOGIMPL_H

#include "PatchDialog.h"

class PatchDialogImpl : public PatchDialog
{
   Q_OBJECT

signals:
   void getSelectedTags();
   void getProjectTags();
   void accept();
   void reject();

public:

   PatchDialogImpl( QString, QString, QStringList *, QString,
	 const QIconSet &, QWidget *);
   PatchDialogImpl( QString, QStringList, QStringList *, QString,
	 const QIconSet &, QWidget *);
   ~PatchDialogImpl();

   void init(const QIconSet &);
   QString getPatchFile();
   QString getCvsCmd();
  
public slots:
   void tagListUpdated();
   void detailsToggled(bool);
   void enterWhatsThisMode();
   
protected slots:
   void closeEvent(QCloseEvent *);
   void fileNameChanged(const QString &);
   
private slots:
   void okClicked();
   void cancelClicked();
   void fetchClicked();
   void browseClicked();
   void setSelectionFirstTag();
   void activatedFirstTag(const QString &);
   void textChangedFirstTag(const QString &);
   
private:
   void readProjectNameList();
   void setPixmaps(QComboBox *);
   void removeRevisionSelection();
   QWidget * m_parent;
   QString m_name;
   
   QString m_dirName;
   QString m_file;
   QStringList * m_pSelectedTagList;
   QString m_topModuleName;
   bool m_fetchOverall;
   bool m_firstTagListOnEdit;
   QPixmap * m_pOldFirstTagPixmap;
   
   QStringList m_ProjectTagList;
   int m_oldFirstTagIdx;
   bool m_firstTagListOnUpdate;
   QString m_oldFirstTagText;
   int m_lastFirstTagLen;
   
   bool m_running;
   QString m_patchFile;
};

#endif

