/****************************************************************************
**
** Copyright (C) 2001-2006 Tilo Riemer <riemer@crossvc.com>,
**                         Frank Hemer <frank@hemer.org>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** CrossVC is available under two different licenses:
**
** If CrossVC is linked against the GPLed version of Qt 
** CrossVC is released under the terms of GPL also.
**
** If CrossVC is linked against a nonGPLed version of Qt 
** CrossVC is released under the terms of the 
** CrossVC License for non-Unix platforms (CLNU)
**
**
** CrossVC License for non-Unix platforms (CLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than CrossVC.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** CrossVC License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation, version 2 of the License.
** This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License version 2 for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#include "config.h"

//----------------------------------------------------------------------------

#include <qwhatsthis.h>
#include <qpushbutton.h>
#include <qlistview.h>

//----------------------------------------------------------------------------

#include "globals.h"
#include "ProfilesDialogImpl.h"
#include "EditProfilesDialogImpl.h"

//----------------------------------------------------------------------------

CProfilesDialogImpl::CProfilesDialogImpl(QStringList *pUserList,
                                         QStringList *pServerList,
                                         QStringList *pRepositoryList,
                                         QStringList &profileNameList,
                                         QValueList<CLincvsProfile> &profileContentList,
                                         const QIconSet &whatsThisIconSet,
                                         QWidget* parent,  const char* name)
   : CProfilesDialog (parent, name, true, LookAndFeel::g_modalF),
     m_pUserList(pUserList), m_pServerList(pServerList),
     m_pRepositoryList(pRepositoryList), m_profileNameList(profileNameList),
     m_profileContentList(profileContentList)
{
   m_pWhatsThis->setIconSet(whatsThisIconSet);
#ifdef Q_WS_MAC
   m_pWhatsThis->setMaximumWidth(m_pWhatsThis->height() * 2);
#else
   m_pWhatsThis->setMaximumWidth(m_pWhatsThis->height());
#endif

   fillListView();
   enableButtons();
}

//----------------------------------------------------------------------------

CProfilesDialogImpl::~CProfilesDialogImpl()
{
   // no need to delete child widgets, Qt does it all for us
}

//----------------------------------------------------------------------------

void CProfilesDialogImpl::fillListView()
{
   QValueList<CLincvsProfile>::const_iterator it;
   for (it = m_profileContentList.begin(); it != m_profileContentList.end(); it++) {
      addListViewEntry(*it);
   }
}

//----------------------------------------------------------------------------

void CProfilesDialogImpl::addEntry()
{
   CEditProfilesDialogImpl *pDlg = new CEditProfilesDialogImpl(m_pUserList,
                                                               m_pServerList,
                                                               m_pRepositoryList,
                                                               m_profileNameList,
                                                               *(m_pWhatsThis->iconSet()),
                                                               this);
   if (pDlg->exec() == QDialog::Accepted) {
      m_profileContentList.append(pDlg->profile());
      m_profileNameList.append(pDlg->profile().name());
      addListViewEntry(pDlg->profile());
   }
   
   delete pDlg;
}

//----------------------------------------------------------------------------

void CProfilesDialogImpl::editEntry()
{
   QListViewItem *pItem = m_pProfileListView->selectedItem();
   QString name = pItem->text(0);

   CLincvsProfile profile;
   QValueList<CLincvsProfile>::iterator it;
   for (it = m_profileContentList.begin(); it != m_profileContentList.end(); it++) {
      if ((*it).name() == name) {
         profile = *it;
         break;
      }
   }

   CEditProfilesDialogImpl *pDlg = new CEditProfilesDialogImpl(m_pUserList,
                                                               m_pServerList,
                                                               m_pRepositoryList,
                                                               m_profileNameList,
                                                               profile,
                                                               *(m_pWhatsThis->iconSet()),
                                                               this);
   if (pDlg->exec() == QDialog::Accepted) {
      *it = pDlg->profile();

      // remove name in name list: maybe the name has been changed
      m_profileNameList.remove(name);

      // and now append the [new|old] name
      m_profileNameList.append(pDlg->profile().name());

      // change entry in list
      changeListViewEntry(*it, pItem);
   }
   
   delete pDlg;
}

//----------------------------------------------------------------------------

void CProfilesDialogImpl::deleteEntry()
{
   QListViewItem *pItem = m_pProfileListView->selectedItem();
   QString name = pItem->text(0);
   m_pProfileListView->takeItem(pItem);

   QValueList<CLincvsProfile>::iterator it;
   for (it = m_profileContentList.begin(); it != m_profileContentList.end(); it++) {
      if ((*it).name() == name) {
         m_profileContentList.remove(it);
         break;
      }
   }

   // remove name in name list
   m_profileNameList.remove(name);
}

//----------------------------------------------------------------------------

void CProfilesDialogImpl::enableButtons()
{
   bool bE = false;
   
   QListViewItem *pI = m_pProfileListView->currentItem();
   if (pI && m_pProfileListView->isSelected(pI)) bE = true;

   m_pEditBtn->setEnabled(bE);
   m_pDeleteBtn->setEnabled(bE);
}

//----------------------------------------------------------------------------

void CProfilesDialogImpl::addListViewEntry(const CLincvsProfile &p)
{
   new CProfileItem(m_pProfileListView,p);
}

//----------------------------------------------------------------------------

void CProfilesDialogImpl::changeListViewEntry(const CLincvsProfile &p,
                                              QListViewItem *pItem)
{
   pItem->setText(0, p.name());
   pItem->setText(1, p.user());
   pItem->setText(2, p.server());
   pItem->setText(3, p.repository());
   pItem->setText(4, access(p.method()));
   pItem->setText(5, sshClientPreset(p.sshClientPreset(), p.method()));
}

//----------------------------------------------------------------------------

QString CProfilesDialogImpl::access(const int method)
{
   switch (method)
   {
   case PSERVER: return tr("Password");
   case RSH:     return tr("Remote Shell");
   case LOCAL:   return tr("Local/NFS");
   case SSPI:    return tr("SSPI");
   }

   return QString::null;
}

//----------------------------------------------------------------------------

QString CProfilesDialogImpl::sshClientPreset(const int preset, const int method)
{
   if (method != RSH) return QString::null;

   switch (preset)
   {
   case NOSSH:           return tr("no ssh");
   case USESSH:          return tr("use ssh");
   case USESSHAGENT:     return tr("use own ssh-agent");
   case USESSHAGENTVARS: return tr("use running ssh-agent");
   }
   
   return QString::null;
}

//----------------------------------------------------------------------------

void CProfilesDialogImpl::enterWhatsThisMode()
{
   QWhatsThis::enterWhatsThisMode();
}

//----------------------------------------------------------------------------

