static char     manager_rcsid[] = "$Id";
/***********************************************************
 * globals.h - include file for qmon
 *
 * Version 3.3 by Jeff Snyder
 * Date: 6/24/92
 *
 * Versions 3.4 & 3.5 by Lakhamraju R. Raju
 * Date: 11/02/93
 *
 * Major modifications: Removed motif calls and replaced 
 *	               with athena widget set calls.
 *
 * Copyright 1992, 1993, 1994
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *
 *  manager.c,v
 * Revision 1.2  1994/11/28  16:55:13  kerce
 * *** empty log message ***
 *
 * Revision 1.4  1994/09/13  18:01:59  raju
 * *** empty log message ***
 *
 * Revision 1.3  1994/08/21  02:58:22  raju
 * *** empty log message ***
 *
 *
 **********************************************************/
#include "globals.h"

static Widget           manager_popup;
static Widget           widget_managerrc;
static Widget           widget_managerlabel;
static Widget           widget_managerframe;
static Widget           widget_managermenu;
static Widget           widget_managermain;
static Widget           widget_managerexec;
static Widget           widget_managerclear;
static Widget           widget_managerclose;
static Widget           widget_managerseparator;
static Widget           widget_manageropt;

struct optionstruct managermenu[]={
  0,"Cell         ","-cell",MENUTYPE,NULL,NULL,
  0,"Add             ","-am",ACTIONTYPE,NULL,NULL,
  0,"Delete          ","-dm",ACTIONTYPE,NULL,NULL,
  0,"Manager Name ",NULL,MENUTYPE,NULL,NULL,
  0,"Show Managers   ","-sm",ACTIONTYPE,NULL,NULL,
  0,NULL,NULL,(int)NULL,NULL,NULL
};


/***********************************************************
 * pb_managerexec - Activate callback for exec
 */
XtCallbackProc pb_managerexec(Widget w,caddr_t client_data,caddr_t call_data)
{
  char          command[MAX_STRING_SIZE];
  char          *ptr=NULL;
  
  sprintf(command,"%s -cell %s",QCONF_BINARY,current_cell);
  buildcommand(command,managermenu,0);
}


/***********************************************************
 * pb_managerclear - Activate callback for clear
 */
XtCallbackProc pb_managerclear(Widget w,caddr_t client_data,caddr_t call_data)
{
  int ii;
  Arg args[5];

/*
  clearsubmenu(managermenu);
*/
  QmonTextSetString(managermenu[0].widgetid ,current_cell );
  if(manager_list) 
  	QmonTextSetString(managermenu[3].widgetid ,manager_list->name );
}


/***********************************************************
 * pb_managerclose - Activate callback for close
 */
XtCallbackProc pb_managerclose(Widget w,caddr_t client_data,caddr_t call_data)
{
  closesubmenuwin();
}


/***********************************************************
 * manageraction - Activate callback for action type menu
 */
XtCallbackProc manageraction(Widget w,caddr_t client_data,caddr_t call_data)
{
  int             ii;
  char            command[MAX_STRING_SIZE];
  char            *ptr=NULL;
  char            *ptr1=NULL;

  ptr=QmonTextGetString(managermenu[3].widgetid);
  ptr1=QmonTextGetString(managermenu[0].widgetid);

  if(w==managermenu[1].widgetid) {
    sprintf(command,"%s -cell %s %s %s &", QCONF_BINARY,ptr1,managermenu[1].flag,ptr);
  }
  else if(w==managermenu[2].widgetid) {
    sprintf(command,"%s -cell %s %s %s &", QCONF_BINARY,ptr1,managermenu[2].flag,ptr);
  }
  else if(w==managermenu[4].widgetid) {
    sprintf(command,"%s -cell %s %s &", QCONF_BINARY,ptr1,managermenu[4].flag);
  }
  execit(command);
}


/***********************************************************
 * create_manager_dialog - Create widgets used for the manager menu
 */
int create_manager_dialog(Widget w,XtPointer client_data,XtPointer call_data)
{
  int             ii;
  Arg             args[32];
  Widget        manager_form;
  Position    x, y;
  Dimension   width, height;
  Widget exec, clear, close;

  managermenu[0].list = cell_list;
  managermenu[3].list = manager_list;

  ii = 0;
  XtSetArg(args[0], XtNwidth, &width); ii++;
  XtSetArg(args[1], XtNheight, &height); ii++;
  XtGetValues(w, args, ii);
  XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
                    &x, &y);

  ii = 0;
  XtSetArg(args[ii], XtNx, x);                         ii++;
  XtSetArg(args[ii], XtNy, y);                         ii++;

  manager_popup = XtCreatePopupShell("managerpop", transientShellWidgetClass, w,
                             args, ii);

  ii = 0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  manager_form = XtCreateManagedWidget("form", formWidgetClass, manager_popup,args,
ii);

  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_managerlabel=
        XtCreateManagedWidget("Configure Manager",labelWidgetClass,manager_form,args,ii);

  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_managerlabel); ii++;
  widget_managermain=XtCreateManagedWidget("box",formWidgetClass,manager_form,
                                        args,ii);

/*
 exec=QmonAddButtonN(widget_managermain,NULL,"Exec",pb_managerexec,NULL);
*/
 clear=QmonAddButtonN(widget_managermain,NULL,"Reset",(XtCallbackProc)pb_managerclear,NULL);
 close=QmonAddButtonN(widget_managermain,clear,"Close",(XtCallbackProc)pb_managerclose,NULL);

  widget_manageropt=createmenuoptions(manager_form,widget_managermain,managermenu,(XtCallbackProc)manageraction);
  
}


/***********************************************************
 * openwidget_managersub - Open the manager menu
 */
int openwidget_managersub()
{
  pb_managerclear(NULL,NULL,NULL);
  XtPopup(manager_popup,XtGrabNone);
}


/***********************************************************
 * closewidget_managersub - Close the manager menu
 */
int closewidget_managersub()
{
  XtPopdown(manager_popup);
}
