static char qacct_rcsid[]="qacct.c,v 1.2 1994/11/28 16:55:25 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *
 *  qacct.c,v
 * Revision 1.2  1994/11/28  16:55:25  kerce
 * *** empty log message ***
 *
 * Revision 1.3  1994/09/13  18:03:59  raju
 * *** empty log message ***
 *
 * Revision 1.2  1994/08/21  02:59:18  raju
 * *** empty log message ***
 *
 * Revision 1.1  1994/07/11  15:29:34  raju
 * Initial revision
 *
 *
 **********************************************************/
#include "globals.h"

static Widget           qacct_popup;
static Widget           widget_qacctrc;
static Widget           widget_qacctlabel;
static Widget           widget_qacctframe;
static Widget           widget_qacctmenu;
static Widget           widget_qacctmain;
static Widget           widget_qacctexec;
static Widget           widget_qacctclear;
static Widget           widget_qacctclose;
static Widget           widget_qacctseparator;
static Widget           widget_qacctopt;

struct optionstruct qacctmenu[]={
  0,"Help            ","-help",FLAGTYPE,"False",   NULL,
  0,"Resource List   ","-l",INPUTTYPE,NULL,NULL,
  0,"Long            ","-long",FLAGTYPE,"False",NULL,
  0,"Destination List","-q",INPUTTYPE,NULL,NULL,
  0,"User List       ","-u",INPUTTYPE,NULL,NULL,
  0,"Verify          ","-verify",FLAGTYPE,"False",NULL,
  0,NULL,NULL,(int)NULL,NULL, NULL
};


/***********************************************************
 * pb_qacctexec - Activate callback for exec
 */
XtCallbackProc pb_qacctexec(Widget w, caddr_t client_data, caddr_t call_data)
{
  buildcommand(QACCT_BINARY,qacctmenu,0);
}


/***********************************************************
 * pb_qacctclear - Activate callback for clear
 */
XtCallbackProc pb_qacctclear(Widget w, caddr_t client_data, caddr_t call_data)
{
  clearsubmenu(qacctmenu);
}


/***********************************************************
 * pb_qacctclose - Activate callback for close
 */

XtCallbackProc pb_qacctclose(Widget w, caddr_t client_data, caddr_t call_data)
{
  closemainmenuwin();
}


/***********************************************************
 * create_qacct_dialog - Create widgets used for the qacct menu
 */
int create_qacct_dialog(Widget w, XtPointer client_data, XtPointer call_data)
{
  int             ii;
  Arg             args[32];
  Widget        qacct_form;
  Position    x, y;
  Dimension   width, height;
  Widget exec, clear, close;

  ii = 0;
  XtSetArg(args[0], XtNwidth, &width); ii++;
  XtSetArg(args[1], XtNheight, &height); ii++;
  XtGetValues(w, args, ii);
  XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
                    &x, &y);

  ii = 0;
  XtSetArg(args[ii], XtNx, x);                         ii++;
  XtSetArg(args[ii], XtNy, y);                         ii++;

  qacct_popup = XtCreatePopupShell("popup", transientShellWidgetClass, w,
                             args, ii);

  ii = 0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  qacct_form = XtCreateManagedWidget("form", formWidgetClass, qacct_popup,args,
ii);
  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_qacctlabel=
        XtCreateManagedWidget("Qacct",labelWidgetClass,qacct_form,args,ii);

  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_qacctlabel); ii++;
  widget_qacctmain=XtCreateManagedWidget("box",formWidgetClass,qacct_form,
                                        args,ii);

 exec=QmonAddButtonN(widget_qacctmain,NULL,"Exec",(XtCallbackProc)pb_qacctexec,NULL);
 clear=QmonAddButtonN(widget_qacctmain,exec,"Clear",(XtCallbackProc)pb_qacctclear,NULL);
 close=QmonAddButtonN(widget_qacctmain,clear,"Close",(XtCallbackProc)pb_qacctclose,NULL);

  widget_qacctopt=createmenuoptions(qacct_form,widget_qacctmain,qacctmenu,(XtCallbackProc)NULL);
  
}


/***********************************************************
 * openwidget_qacct - Open the qacct menu
 */
int openwidget_qacct()
{
  XtPopup(qacct_popup,XtGrabNone);
}


/***********************************************************
 * closewidget_qacct - Close the qacct menu
 */
int closewidget_qacct()
{
  XtPopdown(qacct_popup);
}
