static char qmsg_rcsid[]="qmsg.c,v 1.2 1994/11/28 16:55:50 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *  qmsg.c,v
 * Revision 1.2  1994/11/28  16:55:50  kerce
 * *** empty log message ***
 *
 * Revision 1.3  1994/09/13  18:03:59  raju
 * *** empty log message ***
 *
 * Revision 1.2  1994/08/21  02:59:18  raju
 * *** empty log message ***
 *
 * Revision 1.1  1994/07/11  15:29:34  raju
 * Initial revision
 *
 *
 *
 **********************************************************/
#include "globals.h"

static Widget           qmsg_popup;
static Widget           widget_qmsgrc;
static Widget           widget_qmsglabel;
static Widget           widget_qmsgframe;
static Widget           widget_qmsgmenu;
static Widget           widget_qmsgmain;
static Widget           widget_qmsgexec;
static Widget           widget_qmsgclear;
static Widget           widget_qmsgclose;
static Widget           widget_qmsgseparator;
static Widget           widget_qmsgopt;

struct optionstruct qmsgmenu[]={
  0,"Std Error  ","-E",FLAGTYPE,"False",NULL,
  0,"Help       ","-help",FLAGTYPE,"False",NULL,
  0,"Std Output ","-O",FLAGTYPE,"False",NULL,
  0,"Verify     ","-verify",FLAGTYPE,"False",NULL,
  0,"Message    ",NULL,INPUTTYPE,NULL,NULL,
  0,"Job ID List",NULL,INPUTTYPE,NULL,NULL,
  0,NULL,NULL,(int)NULL,NULL,NULL
};


/***********************************************************
 * pb_qmsgexec - Activate callback for exec
 */
XtCallbackProc pb_qmsgexec(Widget w, caddr_t client_data, caddr_t call_data)
{
  buildcommand(QMSG_BINARY,qmsgmenu,0);
  sleep(1);
  UnMapIconWin ();
  refreshicons();
  MapIconWin ();
}


/***********************************************************
 * pb_qmsgclear - Activate callback for clear
 */
XtCallbackProc pb_qmsgclear(Widget w, caddr_t client_data, caddr_t call_data)
{
  clearsubmenu(qmsgmenu);
}


/***********************************************************
 * pb_qmsgclose - Activate callback for close
 */

XtCallbackProc pb_qmsgclose(Widget w, caddr_t client_data, caddr_t call_data)
{
  closemainmenuwin();
}


/***********************************************************
 * create_qmsg_dialog - Create widgets used for the qmsg menu
 */
int create_qmsg_dialog(Widget w,XtPointer client_data, XtPointer call_data)
{
  int             ii;
  Arg             args[32];
  Widget        qmsg_form;
  Position    x, y;
  Dimension   width, height;
  Widget exec, clear, close;

  ii = 0;
  XtSetArg(args[0], XtNwidth, &width); ii++;
  XtSetArg(args[1], XtNheight, &height); ii++;
  XtGetValues(w, args, ii);
  XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
                    &x, &y);

  ii = 0;
  XtSetArg(args[ii], XtNx, x);                         ii++;
  XtSetArg(args[ii], XtNy, y);                         ii++;

  qmsg_popup = XtCreatePopupShell("popup", transientShellWidgetClass, w,
                             args, ii);

  ii = 0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  qmsg_form = XtCreateManagedWidget("form", formWidgetClass, qmsg_popup,args,
ii);

  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_qmsglabel=
	XtCreateManagedWidget("Qmsg",labelWidgetClass,qmsg_form,args,ii);

  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_qmsglabel); ii++;
  widget_qmsgmain=XtCreateManagedWidget("box",formWidgetClass,qmsg_form,
                                        args,ii);
  exec=QmonAddButtonN(widget_qmsgmain,NULL,"Exec",(XtCallbackProc)pb_qmsgexec,NULL);
  clear=QmonAddButtonN(widget_qmsgmain,exec,"Clear",(XtCallbackProc)pb_qmsgclear,NULL);
  close=QmonAddButtonN(widget_qmsgmain,clear,"Close",(XtCallbackProc)pb_qmsgclose,NULL);

  widget_qmsgopt=createmenuoptions(qmsg_form,widget_qmsgmain,qmsgmenu,(XtCallbackProc)NULL);
  
}


/***********************************************************
 * openwidget_qmsg - Open the qmsg menu
 */
int openwidget_qmsg()
{
  XtPopup(qmsg_popup,XtGrabNone);
}


/***********************************************************
 * closewidget_qmsg - Close the qmsg menu
 */
int closewidget_qmsg()
{
  XtPopdown(qmsg_popup);
}
