;;;
;;; tm-mail.el --- mail-mode extension.
;;;
;;; Copyright (C) 1995 KOBAYASHI Shuhei
;;; 
;;; Author: KOBAYASHI Shuhei <shuhei@cmpt01.phys.tohoku.ac.jp>
;;; modified by MORIOKA Tomohiko <morioka@jaist.ac.jp>
;;; Maintainer: MORIOKA Tomohiko <morioka@jaist.ac.jp>
;;; Created: 1995/11/27
;;; Version: $Id: tm-mail.el,v 2.0 1995/12/15 13:53:55 morioka Exp $
;;; Keywords: mail, MIME, multimedia
;;;
;;; This file is part of tm (Tools for MIME).
;;;
;;; This program is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License as
;;; published by the Free Software Foundation; either version 2, or
;;; (at your option) any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with This program.  If not, write to the Free Software
;;; Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
;;;
;;; Code:

(require 'tm-edit)

(defun tm-mail/insert-message (&optional message)
  (interactive)
  (let* (mail-yank-hooks
	 (mail-citation-hook '(mime-editor/inserted-message-filter))
	 )
    (cond
     ((and (boundp 'vm-mail-buffer) vm-mail-buffer)
      ;; called from VM.
      (let ((mail-reply-buffer vm-mail-buffer))
        (if (null message)
            (call-interactively 'vm-yank-message)
          (vm-yank-message message)))
      )
     ((boundp 'rmail-send-actions-rmail-buffer)
      ;; called from RMAIL, emacs-19.29 or later.
      (mail-yank-original nil)
      )
     ((and (boundp 'gnus-article-buffer) (get-buffer gnus-article-buffer))
      ;; maybe called from Gnus.
      (tm-gnus/insert-article)
      )
     ((and (boundp 'mail-reply-buffer) mail-reply-buffer)
      ;; maybe called from RMAIL.
      (mail-yank-original nil)
      )
     (t
      (message "Sorry, I don't have message inserter for your MUA.")
      ))
    ))

(defvar tm-mail/use-xemacs-popup-menu t)

(if (and (string-match "XEmacs\\|Lucid" emacs-version)
	 tm-mail/use-xemacs-popup-menu)
    (setq mail-mode-menu
	  (append mail-mode-menu
		  (list "---"
			mime-editor/popup-menu-for-xemacs)))
  )


;;; @ end
;;;

(provide 'tm-mail)
