#include <qwidget.h>
#include <qfile.h>
#include "BoardInfo.h"

#ifdef FGLRX_OGL_INFO
// please define either or...
//#define FGLRX_OGL_INFO_GLGET
#define FGLRX_OGL_INFO_SHELL
#endif /* FGLRX_OGL_INFO */

#ifdef FGLRX_USE_XEXTENSIONS
#include "FGLRXExtensions.h"
#endif // FGLRX_USE_XEXTENSIONS

#ifdef FGLRX_OGL_INFO
//#include "FGLRX_OglInfo.h"
//extern "C" { 
    // bool ExtGetDriverData(FGLRXDriverDataPtr pDriverData);
//}
#endif // FGLRX_OGL_INFO

#ifdef DEBUG
#define DEB(s)  s
#else
#define DEB(s)
#endif // DEBUG



bool bHasSecondary;
bool bHas_Screen1_Line;
unsigned long ulDesktopSetup;

#ifdef FGLRX_OGL_INFO_SHELL

#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>

#define FILENAME_STRING_LENGTH  256
int ExecRemoteCommand(char* pcommand, char* ptempfile)
{
    int i;
    int status;
    pid_t pid;
    int ret = 0;

    if (!ptempfile)
        return -1;

    ptempfile[0] = '\0'; // clean - this is an indicator that no tempfile exists

    if (!pcommand)
        return -1;

    if (!pcommand[0])
        return -1;

    sprintf(ptempfile, "/tmp/fglrxconfig_%08x_XXXXXX", getpid());
    i = mkstemp(ptempfile);
    if( i == -1 )
    {
        ptempfile[0] = '\0'; /* mark temp file as non existant */
        return -1;  /* error */
    }
    close(i); // the file exists now !!! caller must care for cleanup

    pid = fork();
    switch(pid)
    {
    case -1: /* error in thread creation */
        ret = -2;
        break;

    case  0: /* child thread - execution path */
//        printf("child - calling exec*\n");

        // note: this call will never return in the success case!!!
        {
            char full_command[2*FILENAME_STRING_LENGTH+16];
            sprintf(full_command, "%s &> %s", pcommand, ptempfile); // append to file !!!
            i = execlp("bash", "bash", "-c", full_command, NULL);
        }

//        printf("child - exec* seems to have failed and returned %i\n", i);
        if( i == -1 )
        {
            ret = -2;
        }
        else
        {
            ret = -3;
        }
        break;

    default : /* main thread - got a valid pid */       
        i = waitpid(pid, &status, 0);
//        printf("main - waitpid(%i,&status,0) was called\n", pid);       
//        printf("main - waitpid returned pid=%i and status of %08x\n", i, status);
        switch(pid)
        {
        case -1: /* error */
            ret = -4;
            break;
        case 0: /* WNOHANG - no child available */
            ret = -5;
            break;
        default : /* pid of queried thread got returned */
            if ( WIFEXITED(status) )
            {
                if( WEXITSTATUS(status)==0 )
                {
                    ret = 0;
                }
                else
                {
                    ret = -6;
                }
            }
            else
            {
                ret = -7;
            }
        }
    }

//    printf("[%s:%s] return %i\n",__FILE__,__FUNCTION__,ret);
    return (ret);
} /* ExecRemoteCommand */

#endif /* FGLRX_OGL_INFO_SHELL */


CBoardInfo BoardInfo ;

CBoardInfo::CBoardInfo ( )
{
}

bool CBoardInfo::Init ( )
{
  bool     Found = FALSE ;
#ifdef FGLRX_USE_XEXTENSIONS
  FGLRXDriverDataRec DriverData;
#endif

  char     Line[ 1000 ] ;
  QFile    f ;
  QString  Str ;
  int      Pos ;

  m_MemorySize = 0 ;
  m_DacSpeed = 0 ;

#ifdef FGLRX_USE_XEXTENSIONS
  Found = ExtGetDriverData(&DriverData);


  if (Found)
  {
      bHasSecondary = DriverData.HasSecondary;
      ulDesktopSetup = DriverData.ulDesktopSetup;

      // === family name ==
      // this is only used for the window name
      switch (DriverData.ChipType) {
        // R200
        case DEVICE_ID_R200_QL:
        case DEVICE_ID_R200_QT:
        case DEVICE_ID_R200_BB:
            m_FamilyName = "Radeon 8500";
            break;
        case DEVICE_ID_R200_QM:
            m_FamilyName = "Radeon 9100";
            break;
        case DEVICE_ID_R200_QH:
            switch (DriverData.BoardType) {
            case SUBSYSTEMID_8700LE:
            case SUBSYSTEMID_8700:
            case SUBSYSTEMID_8800LE:
            case SUBSYSTEMID_8800:
            case SUBSYSTEMID_E1:
                m_FamilyName = "FireGL";
                break;
            default: 
                m_FamilyName = "Radeon";
                break;
            }
            break;
        // RV250
        case DEVICE_ID_RV250_ID:
        case DEVICE_ID_RV250_IE:
        case DEVICE_ID_RV250_IF:
        case DEVICE_ID_RV250_IG:
        case DEVICE_ID_RV250_IL:
        case DEVICE_ID_RV250_IM:
        case DEVICE_ID_RV250_IN:
        case DEVICE_ID_RV250_IO:
            m_FamilyName = "Radeon 9000";
            break;
        // RV250 Mobility = M9
        case DEVICE_ID_RV250_LD:
        case DEVICE_ID_RV250_LE:
        case DEVICE_ID_RV250_LF:
        case DEVICE_ID_RV250_LG:
        case DEVICE_ID_RV250_LL:
        case DEVICE_ID_RV250_LM:
        case DEVICE_ID_RV250_LN:
        case DEVICE_ID_RV250_LO:
            m_FamilyName = "Radeon Mobility M9";
            break;
        // RV280
        case DEVICE_ID_RV280_5960:
        case DEVICE_ID_RV280_5961:
        case DEVICE_ID_RV280_5964:
            m_FamilyName = "Radeon 9200";
            break;
        // RV280
        case DEVICE_ID_RV280_5C61:
        case DEVICE_ID_RV280_5C63:
            m_FamilyName = "Radeon Mobility M9+";
            break;
        // R300
        case DEVICE_ID_R300_AD:
        case DEVICE_ID_R300_AE:
        case DEVICE_ID_R300_AF:
            m_FamilyName = "Radeon 9500";
            break;
        case DEVICE_ID_R300_ND:
        case DEVICE_ID_R300_NE:
        case DEVICE_ID_R300_NF:
            m_FamilyName = "Radeon 9700";
            break;
        case DEVICE_ID_R300_AG:
        case DEVICE_ID_R300_NG:
            switch (DriverData.BoardType) {
            case SUBSYSTEMID_FIREGLZ1AGPPRO:
            case SUBSYSTEMID_FIREGLX1AGPPRO:
            case SUBSYSTEMID_OEM1_FIREGLX1AGP:
                m_FamilyName = "FireGL";
                break;
            default:
                if (DEVICE_ID_R300_AG == DriverData.ChipType)
                    m_FamilyName = "Radeon 9500";
                else
                    m_FamilyName = "Radeon 9700";
            }
            break;
        // R350
        case DEVICE_ID_R350_AK:
        case DEVICE_ID_R350_NK:
            m_FamilyName = "FireGL";
            break;
        case DEVICE_ID_R350_AH:
        case DEVICE_ID_R350_NH:
        case DEVICE_ID_R350_NI:
        case DEVICE_ID_R350_NJ:
            m_FamilyName = "Radeon 9800";
            break;
        // RV350
        case DEVICE_ID_RV350_AT:
        case DEVICE_ID_RV350_AU:
        case DEVICE_ID_RV350_AV:
        case DEVICE_ID_RV350_AW:
            m_FamilyName = "FireGL";
            break;
        case DEVICE_ID_RV350_AP:
        case DEVICE_ID_RV350_AQ:
        case DEVICE_ID_RV350_AR:
            m_FamilyName = "Radeon 9600";
            break;
        case DEVICE_ID_M10_NP:
            m_FamilyName = "Radeon Mobility M10";
            break;
        // RV350 Mobility = M10
        case DEVICE_ID_M10_NT:
            m_FamilyName = "FireGL";
            break;
        default:
            m_FamilyName = "unknown";
      }

      // === board name ==
      m_BoardName = DriverData.sBoardName;

      // === BIOS Version ===
      // The bios version is taken from /proc/dri/0/biosversion
      f.setName ( "/proc/dri/0/biosversion" ) ;
      m_BIOSVersion = "unknown";
      if ( f.open ( IO_ReadOnly ) ) 
      {
          while ( f.readLine ( Line, sizeof(Line) ) != -1 )
          {
              Str = Line;
              Pos = Str.find ("BIOS_KIT_VERSION=", 0 , TRUE ) ;
              if ( Pos  >= 0)
              {
                  Pos += 18;
                  Str = Str.right ( Str.length() - Pos ) ;
                  Pos = Str.find ( "\"", 0, TRUE ) ;
                  if ( Pos >= 0 ) 
                  {
                      Str = Str.left ( Pos ) ;
                      m_BIOSVersion.sprintf(Str);
                      break;
                  }

              }
          }
          f.close();
      }

      // === Chip Revision ===
      // duplicate the received string
      m_ChipRevision = DriverData.sATiRevID;

      // === DAC Speed ===
      m_DacSpeed = 400;

      // === Memory Type ===
      m_MemoryType = "DDR SDRAM";

      // === Memory Size ===
      m_MemorySize = ( DriverData.ulVideoRam / 1024 ) / 1024;

      // === Transfer Mode ===
      switch (DriverData.usAGPTransferMode) {
          case 0:
              m_TransferMode = "PCI";
              break;
          case 1:
              m_TransferMode = "AGP 1x";
              break;
          case 2:
              m_TransferMode = "AGP 2x";
              break;
          case 4:
              m_TransferMode = "AGP 4x";
              break;
          case 8:
              m_TransferMode = "AGP 8x";
              break;
          default:
              m_TransferMode = "unknown";
      }

      if ((DriverData.uiAGPCapPtr | DriverData.uiAGPStatus | DriverData.uiAGPCommand) != 0)
      {
        QString buffer;
        unsigned int major, minor;
        unsigned int uiStatCmd;

        uiStatCmd = DriverData.uiAGPStatus & DriverData.uiAGPCommand;
        if (uiStatCmd & (1<<9))
            m_TransferMode += ", SBA";
        if (uiStatCmd & (1<<4))
            m_TransferMode += ", FW";

        major = (DriverData.uiAGPCapPtr >> 20) & 0x0f;
        minor = (DriverData.uiAGPCapPtr >> 16) & 0x0f;

        if (major+minor == 0)
        {
            major = 1;
            minor = 0;
        }

        if (major >= 3)
            buffer.sprintf(" (AGP v%u.%u %s mode)", major, minor,
                (DriverData.uiAGPStatus & (1<<3)) ? "native" : "compat.");
        else
            buffer.sprintf(" (AGP v%u.%u)", major, minor);
        
        m_TransferMode += buffer;
      }

      // === Driver Version ===
      m_DriverVersion.sprintf("%d.%02d.%02d",
          DriverData.majorVersion,DriverData.minorVersion,DriverData.patchlevel);

  }
  else
  {
    m_BoardName = "unknown";
    m_BIOSVersion = "unknown";
    m_ChipType = "unknown";
    m_ChipRevision = "unknown";
    m_DacSpeed = 0;
    m_MemoryType = "unknown";
    m_MemorySize = 0;
    m_TransferMode = "unknown";
    m_DriverVersion = "unknown";
  }

#else /* FGLRX_USE_XEXTENSIONS */
  f.setName ( LOG_FILE ) ;

  if ( !f.open ( IO_ReadOnly ) ) return ( FALSE ) ;
  while ( f.readLine ( Line, sizeof(Line) ) != -1 )
  {
    Str = Line ;
    if ( Str.find ( "Fire GL8", 0, TRUE ) < 0 ) continue ;
    if ( !Found )
    {
      Found = TRUE ;
      if ( Str.find ( "Fire GL8700", 0, TRUE ) >= 0 )
        m_BoardName = "Fire GL8700" ;
      else
        m_BoardName = "Fire GL8800";
    }

    //look for ChipType
    Pos = Str.find ( "Chipset: ", 0, TRUE ) ;
    if ( Pos > 0 )
    {
      Pos += 10 ;
      Str = Str.right ( Str.length() - Pos ) ;
      Pos = Str.find ( "\"", 0, TRUE ) ;
      if ( Pos > 0 ) Str = Str.left ( Pos ) ;
      m_ChipType = Str ;
      continue ;
    }

    //look for MemorySize
    Pos = Str.find ( "VideoRAM: ", 0, TRUE ) ;
    if ( Pos > 0 )
    {
      Pos += 10 ;
      Str = Str.right ( Str.length() - Pos ) ;
      sscanf ( Str, "%d", &m_MemorySize ) ;
      continue ;
    }

    //look for DacSpeed
    Pos = Str.find ( "Max pixel clock is ", 0, TRUE ) ;
    if ( Pos > 0 )
    {
      Pos += 19 ;
      Str = Str.right ( Str.length() - Pos ) ;
      sscanf ( Str, "%d", &m_DacSpeed ) ;
      continue ;
    }
  }
  f.close ( ) ;
#endif // FGLRX_USE_XEXTENSIONS

#ifdef FGLRX_OGL_INFO
  // get OGL data from somewhere
  {
#ifdef FGLRX_OGL_INFO_GLGET
    // TODO - direct access to X11 (first open display and so on...)
    // Note: if we implement this code than our panels will need
    // some symbols to libGL, libGLU, libGLUT, libGLX that might
    // raise loading problems in serveral configurations.
    // -> better do not like this!
    const char *glVendor = (const char *) glGetString(GL_VENDOR);
    const char *glRenderer = (const char *) glGetString(GL_RENDERER);
    const char *glVersion = (const char *) glGetString(GL_VERSION);

    m_OGLVendor  .sprintf("%s",glVendor);
    m_OGLRenderer.sprintf("%s",glRenderer);
    m_OGLVersion .sprintf("%s",glVersion);
#endif /*  FGLRX_OGL_INFO_GLGET */
#ifdef FGLRX_OGL_INFO_SHELL
    char output_file[FILENAME_STRING_LENGTH];

//#define FGL_LOCAL_DEBUG_OGLSTRING

    if ( ExecRemoteCommand("fglrxinfo", output_file)==0 )
    {   
#define BUF_LEN     256
        // browse the supplied output for the expected results
        {
            char buffer[BUF_LEN];
            FILE *hFile;
            char c;
            unsigned int i;

#ifdef FGL_LOCAL_DEBUG_OGLSTRING
            printf("browsing output file\n");
#endif

            hFile = fopen(output_file, "rb");

            i = 0;
            c = fgetc(hFile);
            while( !feof(hFile) )
            {
                // hide special chars and treat them all as separators
                if (c<' ')
                    c = '\0';

                // hits will only happen in short lines
                if( i<BUF_LEN )
                {
                    buffer[i] = c;
                    i++;
                    if(!c)
                    {
#define VENDOR_STRING   "OpenGL vendor string: "
#define RENDERER_STRING "OpenGL renderer string: "
#define VERSION_STRING  "OpenGL version string: "
                        if(strncmp(buffer,VENDOR_STRING,strlen(VENDOR_STRING))==0)
                        {
                            m_OGLVendor.sprintf("%s",&buffer[strlen(VENDOR_STRING)]);
#ifdef FGL_LOCAL_DEBUG_OGLSTRING
                            printf("%s\n",&buffer[strlen(VENDOR_STRING)]);
#endif
                        }
                        else
                        if(strncmp(buffer,RENDERER_STRING,strlen(RENDERER_STRING))==0)
                        {
                            m_OGLRenderer.sprintf("%s",&buffer[strlen(RENDERER_STRING)]);
#ifdef FGL_LOCAL_DEBUG_OGLSTRING
                            printf("%s\n",&buffer[strlen(RENDERER_STRING)]);
#endif
                        }
                        else
                        if(strncmp(buffer,VERSION_STRING,strlen(VERSION_STRING))==0)
                        {
                            m_OGLVersion.sprintf("%s",&buffer[strlen(VERSION_STRING)]);
#ifdef FGL_LOCAL_DEBUG_OGLSTRING
                            printf("%s\n",&buffer[strlen(VERSION_STRING)]);
#endif
                        }
                        else
                        {
                            // not a hit -> ignore
                        }
                    }
                }

                // if the sequence ended then clear the buffer
                if(!c)
                    i = 0;

                c = fgetc(hFile);
            }

            // if final buffer is unterminated then terminate and check it
            if(i>0)
            {
#ifdef FGL_LOCAL_DEBUG_OGLSTRING
                printf("buffer contains extra chars - terminating last line and checking again\n");
#endif
                buffer[i]=0;

                        if(strncmp(buffer,VENDOR_STRING,strlen(VENDOR_STRING))==0)
                        {
                            m_OGLVendor.sprintf("%s",&buffer[strlen(VENDOR_STRING)]);
#ifdef FGL_LOCAL_DEBUG_OGLSTRING
                            printf("%s\n",&buffer[strlen(VENDOR_STRING)]);
#endif
                        }
                        else
                        if(strncmp(buffer,RENDERER_STRING,strlen(RENDERER_STRING))==0)
                        {
                            m_OGLRenderer.sprintf("%s",&buffer[strlen(RENDERER_STRING)]);
#ifdef FGL_LOCAL_DEBUG_OGLSTRING
                            printf("%s\n",&buffer[strlen(RENDERER_STRING)]);
#endif
                        }
                        else
                        if(strncmp(buffer,VERSION_STRING,strlen(VERSION_STRING))==0)
                        {
                            m_OGLVersion.sprintf("%s",&buffer[strlen(VERSION_STRING)]);
#ifdef FGL_LOCAL_DEBUG_OGLSTRING
                            printf("%s\n",&buffer[strlen(VERSION_STRING)]);
#endif
                        }
                        else
                        {
                            // not a hit -> ignore
                        }
            }

            fclose(hFile);
        }

    }

    // finally remove the tempfile that the ExecRemoteCommand() call did create
    if( output_file[0] )
    {
        remove(output_file);
    }
#endif /* FGLRX_OGL_INFO_SHELL */
  }
#endif // FGLRX_OGL_INFO
  return ( Found ) ;
}

QString CBoardInfo::FamilyName ( )
{
  return ( m_FamilyName ) ;
}

QString CBoardInfo::BoardName ( )
{
  return ( m_BoardName ) ;
}

QString CBoardInfo::BusType ( )
{
  return ( QWidget::tr("unavailable") ) ;
}

QString CBoardInfo::BiosVersion ( )
{
  if ( m_BIOSVersion.isEmpty ( ) )
    return ( QWidget::tr("unavailable") ) ;
  return ( m_BIOSVersion ) ;
}

QString CBoardInfo::ChipType ( )
{
  if ( m_ChipType.isEmpty ( ) )
    return ( QWidget::tr("unavailable") ) ;
  return ( m_ChipType ) ;
}

QString CBoardInfo::ChipRevision ( )
{
  if ( m_ChipRevision.isEmpty ( ) )
    return ( QWidget::tr("unavailable") ) ;
  return ( m_ChipRevision ) ;
}

#if 0
QString CBoardInfo::ChipSpeed ( )
{
  return ( QWidget::tr("unavailable") ) ;
}
#endif

QString CBoardInfo::DacSpeed ( )
{
  QString Str ;

  if ( !m_DacSpeed )
    return ( QWidget::tr("unavailable") ) ;

  Str.sprintf ( "%d MHz", m_DacSpeed ) ;
  return ( Str ) ;
}

QString CBoardInfo::MemoryType ( )
{
  if ( m_MemoryType.isEmpty ( ) )
    return ( QWidget::tr("unavailable") ) ;
  return ( m_MemoryType ) ;
}

QString CBoardInfo::MemorySize ( )
{
  QString Str ;

  if ( !m_MemorySize )
    return ( QWidget::tr("unavailable") ) ;

  Str.sprintf ( "%d MByte", m_MemorySize ) ;
  return ( Str ) ;
}

QString CBoardInfo::TransferMode ( )
{
  if ( m_TransferMode.isEmpty ( ) )
    return ( QWidget::tr("unavailable") ) ;
  return ( m_TransferMode ) ;
}

#if 0
QString CBoardInfo::MemorySpeed ( )
{
  return ( QWidget::tr("unavailable") ) ;
}
#endif

QString CBoardInfo::DriverVersion ( )
{
  if ( m_DriverVersion.isEmpty ( ) )
    return ( QWidget::tr("unavailable") ) ;
  return ( m_DriverVersion ) ;
}

#ifdef FGLRX_OGL_INFO
QString CBoardInfo::OGLVendor ( )
{
  if ( m_OGLVendor.isEmpty ( ) )
    return ( QWidget::tr("unavailable") ) ;
  return ( m_OGLVendor ) ;
}

QString CBoardInfo::OGLRenderer ( )
{
  if ( m_OGLRenderer.isEmpty ( ) )
    return ( QWidget::tr("unavailable") ) ;
  return ( m_OGLRenderer ) ;
}

QString CBoardInfo::OGLVersion ( )
{
  if ( m_OGLVersion.isEmpty ( ) )
    return ( QWidget::tr("unavailable") ) ;
  return ( m_OGLVersion ) ;
}
#endif // FGLRX_OGL_INFO

// ### EOF ###
