/*****************************************************************************/
/*                                                                           */
/* NAME:      TVOExt.h                                                       */
/*                                                                           */
/*            part of TV out extension test programs                         */
/*                                                                           */
/* Copyright (c) 2003, ATI, ATI Research GmbH, Starnberg, Germany            */
/*                                                                           */
/*****************************************************************************/

#ifndef _TVO_EXT_H_
#define _TVO_EXT_H_


#define ATITVOUT_EXTENSION_NAME     "ATITVOUT"

static XExtensionInfo _atitvo_info_data;
static XExtensionInfo *atitvo_info = &_atitvo_info_data;
static char *atitvo_extension_name = ATITVOUT_EXTENSION_NAME;


//////////////////////////////////////////////////////////////////////////////
// extension specific data

#define ATITVOUT_NUMBER_EVENTS          6
#define ATITVOUT_NUMBER_ERRORS          0

#define X_ATITVOEnableDisable           0
#define X_ATITVOSetStandard             1
#define X_ATITVOGetData                 2
#define X_ATITVOAdjustPosition          3
#define X_ATITVOAdjustSize              4
#define X_ATITVOAdjustColor             5

// extension protocoll defines
#define XREP_SZ(name)       sizeof(x##name##Reply)
#define XREQ_SZ(name)       sizeof(x##name##Req)


//////////////////////////////////////////////////////////////////////////////
// ProcATITVOEnableDisable

// requests must be multiple of 4
typedef struct _ATITVOEnableDisable {
    CARD8   reqType;            //    1
    CARD8   fireglReqType;      //    1
    CARD16  length B16;         //    2
    /* specific */
    CARD32  screen B32;         //    4
    CARD32  TVEnable B32;     //    4
} xATITVOEnableDisableReq;        // = 12

//  replies must be ...
//      - 4 byte alligned, 
//      - minimum 32 bytes (pad the structure)
typedef struct {
    BYTE    type;                //    1    (X_Reply)
    BYTE    pad1;                //    1
    CARD16  sequenceNumber B16;  //    2
    CARD32  length B32;          //    4
    /* specific */
    CARD32  screen B32;          //    4
    CARD32  error B32;           //    4
    CARD32  pad2 B32;            //    4
    CARD32  pad3 B32;            //    4
    CARD32  pad4 B32;            //    4
    CARD32  pad5 B32;            //    4
    CARD32  pad6 B32;            //    4
} xATITVOEnableDisableReply;       // = 32
// 32 bytes (reply needs)

#define sz_xATITVOEnableDisableReq      XREQ_SZ(ATITVOEnableDisable)
#define sz_xATITVOEnableDisableReply    XREP_SZ(ATITVOEnableDisable)

//////////////////////////////////////////////////////////////////////////////
// ProcATITVOSetStandard

// requests must be multiple of 4
typedef struct _ATITVOSetStandard {
    CARD8   reqType;            //    1
    CARD8   fireglReqType;      //    1
    CARD16  length B16;         //    2
    /* specific */
    CARD32  screen B32;         //    4
    CARD32  TVStandard B32;     //    4
} xATITVOSetStandardReq;        // =  8

//  replies must be ...
//      - 4 byte alligned, 
//      - minimum 32 bytes (pad the structure)
typedef struct {
    BYTE    type;               //    1    (X_Reply)
    BYTE    pad1;               //    1
    CARD16  sequenceNumber B16; //    2
    CARD32  length B32;         //    4
    /* specific */
    CARD32  screen B32;          //    4
    CARD32  error B32;           //    4
    CARD32  pad2 B32;            //    4
    CARD32  pad3 B32;            //    4
    CARD32  pad4 B32;            //    4
    CARD32  pad5 B32;            //    4
    CARD32  pad6 B32;            //    4
} xATITVOSetStandardReply;       // = 32
// 32 bytes (reply needs)

#define sz_xATITVOSetStandardReq      XREQ_SZ(ATITVOSetStandard)
#define sz_xATITVOSetStandardReply    XREP_SZ(ATITVOSetStandard)

//////////////////////////////////////////////////////////////////////////////
// ProcATITVOGetData

// requests must be multiple of 4
typedef struct _ATITVOGetData {
    CARD8   reqType;            //    1
    CARD8   fireglReqType;      //    1
    CARD16  length B16;         //    2
    /* specific */
    CARD32  screen B32;         //    4
} xATITVOGetDataReq;            // =  8

//  replies must be ...
//      - 4 byte alligned, 
//      - minimum 32 bytes (pad the structure)
typedef struct {
    BYTE    type;                //    1    (X_Reply)
    BYTE    pad1;                //    1
    CARD16  sequenceNumber B16;  //    2
    CARD32  length B32;          //    4
    /* specific */
    CARD32  TVConnected B32;     //    4
    CARD32  TVStd B32;           //    4
    CARD32  MVMode B32;          //    4
    CARD32  tvHSizeAdj B32;      //    4
    CARD32  tvVSizeAdj B32;      //    4
    CARD32  tvHPosAdj B32;       //    4
    CARD32  tvVPosAdj B32;       //    4
    CARD32  tvHStartAdj B32;     //    4
    CARD32  tvColorAdj B32;      //    4
    CARD32  error B32;           //    4
} xATITVOGetDataReply;           // = 48
// 32 bytes (reply needs)

#define sz_xATITVOGetDataReq      XREQ_SZ(ATITVOGetData)
#define sz_xATITVOGetDataReply    XREP_SZ(ATITVOGetData)

//////////////////////////////////////////////////////////////////////////////
// ProcATITVOAdjustSize

// requests must be multiple of 4
typedef struct _ATITVOAdjustSize {
    CARD8   reqType;            //    1
    CARD8   fireglReqType;      //    1
    CARD16  length B16;         //    2
    /* specific */
    CARD32  screen B32;         //    4
    CARD32  tvHSizeAdj B32;     //    4
    CARD32  tvVSizeAdj B32;     //    4
} xATITVOAdjustSizeReq;         // = 12

//  replies must be ...
//      - 4 byte alligned, 
//      - minimum 32 bytes (pad the structure)
typedef struct {
    BYTE    type;               //    1    (X_Reply)
    BYTE    pad1;               //    1
    CARD16  sequenceNumber B16; //    2
    CARD32  length B32;         //    4
    /* specific */
    CARD32  error B32;           //    4
    CARD32  pad2 B32;            //    4
    CARD32  pad3 B32;            //    4
    CARD32  pad4 B32;            //    4
    CARD32  pad5 B32;            //    4
    CARD32  pad6 B32;            //    4
} xATITVOAdjustSizeReply;        // = 32
// 32 bytes (reply needs)

#define sz_xATITVOAdjustSizeReq      XREQ_SZ(ATITVOAdjustSize)
#define sz_xATITVOAdjustSizeReply    XREP_SZ(ATITVOAdjustSize)

//////////////////////////////////////////////////////////////////////////////
// ProcATITVOAdjustPosition

// requests must be multiple of 4
typedef struct _ATITVOAdjustPosition {
    CARD8   reqType;            //    1
    CARD8   fireglReqType;      //    1
    CARD16  length B16;         //    2
    /* specific */
    CARD32  screen B32;         //    4
    CARD32  tvHPosAdj B32;      //    4
    CARD32  tvVPosAdj B32;      //    4
    CARD32  tvHStartAdj B32;    //    4
} xATITVOAdjustPositionReq;     // = 20

//  replies must be ...
//      - 4 byte alligned, 
//      - minimum 32 bytes (pad the structure)
typedef struct {
    BYTE    type;               //    1    (X_Reply)
    BYTE    pad1;               //    1
    CARD16  sequenceNumber B16; //    2
    CARD32  length B32;         //    4
    /* specific */
    CARD32  error B32;          //    4
    CARD32  pad2 B32;           //    4
    CARD32  pad3 B32;           //    4
    CARD32  pad4 B32;           //    4
    CARD32  pad5 B32;           //    4
    CARD32  pad6 B32;           //    4
} xATITVOAdjustPositionReply;  // = 32
// 32 bytes (reply needs)

#define sz_xATITVOAdjustPositionReq      XREQ_SZ(ATITVOAdjustPosition)
#define sz_xATITVOAdjustPositionReply    XREP_SZ(ATITVOAdjustPosition)

//////////////////////////////////////////////////////////////////////////////
// ProcATITVOAdjustColor

// requests must be multiple of 4
typedef struct _ATITVOAdjustColor {
    CARD8   reqType;            //    1
    CARD8   fireglReqType;      //    1
    CARD16  length B16;         //    2
    /* specific */
    CARD32  screen B32;         //    4
    CARD32  tvColorAdj B32;     //    4
} xATITVOAdjustColorReq;        // = 12

//  replies must be ...
//      - 4 byte alligned, 
//      - minimum 32 bytes (pad the structure)
typedef struct {
    BYTE    type;               //    1    (X_Reply)
    BYTE    pad1;               //    1
    CARD16  sequenceNumber B16; //    2
    CARD32  length B32;         //    4
    /* specific */
    CARD32  error B32;          //    4
    CARD32  pad2 B32;           //    4
    CARD32  pad3 B32;           //    4
    CARD32  pad4 B32;           //    4
    CARD32  pad5 B32;           //    4
    CARD32  pad6 B32;           //    4
} xATITVOAdjustColorReply;      // = 32
// 32 bytes (reply needs)

#define sz_xATITVOAdjustColorReq      XREQ_SZ(ATITVOAdjustColor)
#define sz_xATITVOAdjustColorReply    XREP_SZ(ATITVOAdjustColor)

//////////////////////////////////////////////////////////////////////////////
// private functions

XExtDisplayInfo *info;

// X shutdown hook function that will cleanup the opened extension
static XEXT_GENERATE_CLOSE_DISPLAY (close_display_atitvo, 
                                    atitvo_info)

// table with X hooks
static /* const */ XExtensionHooks atitvo_extension_hooks = {
    NULL,                   /* create_gc */
    NULL,                   /* copy_gc */
    NULL,                   /* flush_gc */
    NULL,                   /* free_gc */
    NULL,                   /* create_font */
    NULL,                   /* free_font */
    close_display_atitvo,   /* close_display */
    NULL,                   /* wire_to_event */
    NULL,                   /* event_to_wire */
    NULL,                   /* error */
    NULL,                   /* error_string */
};

// find_display_atitvo - get the display info block for atitvo extension
static XEXT_GENERATE_FIND_DISPLAY (find_display_atitvo, 
                                   atitvo_info,
                                   atitvo_extension_name, 
                                   &atitvo_extension_hooks, 
                                   ATITVOUT_NUMBER_EVENTS, 
                                   NULL)



static int 
answerisyes(char *s)
{
    if (s[0] == '\'')   /* For fools that type the ' literally. */
        return tolower(s[1]) == 'y';
    return tolower(s[0]) == 'y';
}


static void 
getstring(char *s)
{
    char *cp;
    fgets(s, 80, stdin);
    cp = strchr(s, '\n');
    if (cp)
        *cp=0;
}



#endif // _TVO_EXT_H_
