/*
 *
 */

typedef struct
{
    int n, maxPoint;
    int finished;
    short *x, *y;      /* trace */
    GC     gc;
} Figure;

typedef void (*tool_cmd)(Figure *);

typedef struct
{
    tool_cmd     pen_init;
    tool_cmd     pen_down;
    tool_cmd     pen_move;
    tool_cmd     pen_up;
    tool_cmd     pen_motion;
    tool_cmd     pen_undo;
    tool_cmd     pen_end;
    tool_cmd     pen_finish;
    tool_cmd     pen_outline;

    int spray;
    int closed;
} Tool;


static void check_figure(Figure *figure)
{
     if (figure->maxPoint == 0)
          figure->maxPoint = 5;

     if (figure->n >= figure->maxPoint-1)
     {
         figure->maxPoint *= 2;
         figure->x = realloc(figure->x, figure->maxPoint*sizeof(*figure->x);
         figure->y = realloc(figure->y, figure->maxPoint*sizeof(*figure->y);
     }
}

/*************************************************************************
 * Free hand
 ************************************************************************/

void freehand_init(Window win, Figure *figure)
{
     check_figure();
     figure->GC = XCreateGC(xfl->display, win, 0, 0);
}

void freehand_down(Figure *figure, int x, int y)
{
     check_figure(figure);
     figure->x[figure->n] = x;
     figure->y[figure->n] = y;
     figure->n++;
}

void freehand_move(Figure *figure, int x, int y)
{
     int n = figure->n;

     check_figure(figure);
     figure->x[n] = x;
     figure->y[n] = y;
     fl_line(figure->x[n-1], figure->y[n-1], figure->x[n], figure->y[n]);
     figure->n++;
}
