/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Routine:
  WVpar.h

Description:
  Declarations for RIFF WAVE file headers

Author / revision:
  P. Kabal  Copyright (C) 1997
  $Revision: 1.10 $  $Date: 1997/03/04 19:36:40 $

----------------------------------------------------------------------*/

#ifndef WVpar_h_
#define WVpar_h_

#include <libtsp/UTtypes.h>		/* typedef for uint2_t, etc */


#define WV_FMT_CKSIZE	16
#define WV_LHMIN	(8 + 4 + 8 + WV_FMT_CKSIZE + 8)

/* File magic in file byte order */
#define FM_RIFF		"RIFF"
#define FM_WAVE		"WAVE"

#define WAVE_FORMAT_UNKNOWN		(0x0000)
#define WAVE_FORMAT_PCM			(0x0001) 
#define WAVE_FORMAT_ADPCM		(0x0002)
#define WAVE_FORMAT_IBM_CVSD		(0x0005)
#define WAVE_FORMAT_ALAW		(0x0006)
#define WAVE_FORMAT_MULAW		(0x0007)
#define WAVE_FORMAT_OKI_ADPCM		(0x0010)
#define WAVE_FORMAT_DVI_ADPCM		(0x0011)
#define WAVE_FORMAT_IMA_ADPCM		(WAVE_FORMAT_DVI_ADPCM)
#define WAVE_FORMAT_MEDIASPACE_ADPCM	(0x0012)
#define WAVE_FORMAT_SIERRA_ADPCM	(0x0013)
#define WAVE_FORMAT_G723_ADPCM		(0x0014)
#define WAVE_FORMAT_DIGISTD		(0x0015)
#define WAVE_FORMAT_DIGIFIX		(0x0016)
#define WAVE_FORMAT_YAMAHA_ADPCM	(0x0020)
#define WAVE_FORMAT_SONARC		(0x0021)
#define WAVE_FORMAT_DSPGROUP_TRUESPEECH	(0x0022)
#define WAVE_FORMAT_ECHOSC1		(0x0023)
#define WAVE_FORMAT_AUDIOFILE_AF36	(0x0024)
#define WAVE_FORMAT_APTX		(0x0025)
#define WAVE_FORMAT_AUDIOFILE_AF10	(0x0026)
#define WAVE_FORMAT_DOLBY_AC2		(0x0030)
#define WAVE_FORMAT_GSM610		(0x0031)
#define WAVE_FORMAT_ANTEXT_ADPCME	(0x0033)
#define WAVE_FORMAT_CONTROL_RES_VQLPC	(0x0034)
#define WAVE_FORMAT_DIGIREAL		(0x0035)
#define WAVE_FORMAT_DIGIADPCM		(0x0036)
#define WAVE_FORMAT_CONTROL_RES_CR10	(0x0037)
#define WAVE_FORMAT_NMS_VBXADPCM	(0x0038)
#define WAVE_FORMAT_G721_ADPCM		(0x0040)
#define WAVE_FORMAT_MPEG		(0x0050)
#define IBM_FORMAT_MULAW		(0x0101)
#define IBM_FORMAT_ALAW			(0x0102)
#define IBM_FORMAT_ADPCM		(0x0103)
#define WAVE_FORMAT_CREATIVE_ADPCM	(0x0200)
#define WAVE_FORMAT_FM_TOWNS_SND	(0x0300)
#define WAVE_FORMAT_OLIGSM		(0x1000)
#define WAVE_FORMAT_OLIADPCM		(0x1001)
#define WAVE_FORMAT_OLICELP		(0x1002)
#define WAVE_FORMAT_OLISBC		(0x1003)
#define WAVE_FORMAT_OLIOPR		(0x1004)

#define WV_SF_MULAW	(1.)
#define WV_SF_ALAW	(1.)
#define WV_SF_PCM8	(128.)
#define WV_SF_PCM16	(1.)

struct WV_CkPreamb {
  char ckid[4];
  uint4_t cksize;
};

struct WV_PCMformat {
  uint2_t FormatTag;
  uint2_t Channels;
  uint4_t SamplesPerSec;
  uint4_t AvgBytesPerSec;
  uint2_t BlockAlign;
  uint2_t BitsPerSample;
};

#endif	/* WVpar_h_ */
