/*  -*- c -*-  */
/* -------------------------------------------------------------------- *
**  copyright (c) 1995 ipvr stuttgart and thomas harrer
** -------------------------------------------------------------------- *
**
**  libhelp
**
**  a comprehensive hypertext help system for OSF/Motif(tm) applications. 
**  based on libhtmlw from NCSA Mosaic(tm) version 2.4
**
**  written by thomas harrer
**  e-mail: Thomas.Harrer@rus.uni-stuttgart.de
**  
** -------------------------------------------------------------------- *
*h  $Id: path.h,v 1.2 1995/06/28 12:59:30 thomas Exp $
** -------------------------------------------------------------------- *
**
*h  module:		path.h
**
**  contents:		header file for module "path"
**
**  interface:		can be included via preprocessor #include
**
** -------------------------------------------------------------------- *
**  license and copying issues:
**
**  this software is free; you can redistribute it and/or modify it 
**  under terms similar to the gnu general public license (version 1 
**  or any later version published by the free software foundation). 
**  see the file Licence for more details.
**
**  this program is distributed in the hope that it will be useful,
**  but without any warranty; without even the implied warranty of
**  merchantability or fitness for a particular purpose.  
** -------------------------------------------------------------------- */
#ifndef _PATH_H_
#define _PATH_H_ 1


/* -------------------------------------------------------------------- *
*g  prototypes
** -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- *
*p  procedure-name:	path_get_helppath
**
**  purpose:		try to add path prefices in front of the help
**			file string. take the first that results in an
**			accessible help file.
**  initialization:	the help path (array of directory strings) is 
**			initialized of not already.
** -------------------------------------------------------------------- *
**  args:		filename and opt. anchor (file#anchor)
**  return type:	static char*
** -------------------------------------------------------------------- */
char*
path_get_helppath (/* i  */ char* str);

/* -------------------------------------------------------------------- *
*p  procedure-name:	path_add_current
**
**  purpose:		adds the current document path to the 
**			help path.
** -------------------------------------------------------------------- */
void
path_add_current (/* i  */ char* path);

/* -------------------------------------------------------------------- *
*p  procedure-name:	path_the_helppath
**
**  purpose:		exports the help path
** -------------------------------------------------------------------- */
char**
path_the_helppath (void);

#endif /* !_PATH_H_ */
/* -------------------------------------------------------------------- *
*l  emacs:
**  local variables:
**  mode:		c
**  outline-regexp:	"\*[HGPLT]"
**  comment-column:	32
**  eval:		(outline-minor-mode t)
**  end:
** -------------------------------------------------------------------- */
