/************************************************************************/
/* File   : window.h				                        */
/* Purpose: text widget data struct		                        */
/* By     : Keith R. Davis	      		                        */
/* Date   : 03/21/98				                        */
/* Notes  : Copyright(c) 1996-98 Mutiny Bay Software                    */
/************************************************************************/

#ifndef _WINDOW_DATA_H
#define _WINDOW_DATA_H

#define MAX_PANES 1

typedef struct _WindowInfo {
  struct _WindowInfo *next;
  Widget	shell;			/* application shell of window        */
  textBuffer    *buffer;                /* ptr to buffer_curr                 */
  Widget	textArea;		/* the first text editing area widget */
  Widget	textPanes[MAX_PANES];	/* additional ones created on demand  */
  Boolean	highlightSyntax;	/* is syntax highlighting turned on?  */
  void    	*highlightData; 	/* info for syntax highlighting       */
  int    	languageMode;	    	/* identifies current language mode   */
  int		nPanes;			/* number of splitter panes           */
  XmFontList	fontList;		/* fontList for the primary font      */
  XFontStruct   *italicFontStruct;	/* fontStructs for highlighting fonts */
  XFontStruct   *boldFontStruct;
  XFontStruct   *boldItalicFontStruct;
} WindowInfo;

extern WindowInfo   *WinDataPtr;        /* global pointer to text widget options */
extern WindowInfo   *WindowList;

#endif
