/*
 *   mwmanywh.c -- Mwave Modem AT Command Parser
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include <mwmspcfc.h>
#include <mwmcntnd.h>
#include <mwmcapi.h>
#include <v42itcb.h>

#include <stddef.h>

static char szThisFile[] = "MWMANYWH.C";


ULONG mwmAnywhereDataToDiscrim(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmAnywhereClass1ToDial(PMWM_DSPINFO pmwmDspInfo);



/*****************************************************************************/
/* Move back to the discriminator base from any of the modem states.         */
/* This code replaces the ProtocolToLineSpeed, and LineSpeedToModem          */
/*****************************************************************************/
ULONG mwmAnywhereToDiscrim(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG  ulRC = 0;
  //ULONG  ulAddress = 0;
  MWM_FCLASS_SUBCLASS  ClassStruct; //$1

   { MW_SYSLOG_1(TRACE_MWMLW32,"mwmanywh::mwmAnywhereToDiscrim entry\n");  }

  DPF("mwmAnywhereToDiscrim\n");

  /***************************************************************************/
  /* Clear the dialing mode flag just in case.                               */
  /* This flag is set during the IPC 30 on dial, and during the IPC 20 on    */
  /* answer.                                                                 */
  /* I am clearing it here because I am worried that some situations may     */
  /* cause us to skip the IPC 20.                                            */
  /***************************************************************************/
  pmwmDspInfo->ulDialingModem = 0;


  /***************************************************************************/
  /* Check FCLASS, then call the appropriate cleanup routine if necessary.   */
  /***************************************************************************/
  ulRC = mwmFaxGetFCLASS(pmwmDspInfo, &ClassStruct.usFCLASS, &ClassStruct.usSubclass); //$6
  if (ulRC)
    return(ulRC);

  { MW_SYSLOG_2(TRACE_MWMLW32,"mwmanywh::mwmAnywhereToDiscrim usFCLASS %x\n",ClassStruct.usFCLASS);  }

  switch(ClassStruct.usFCLASS)              //$1
  {
    case 0:                                 //$1
       if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_V80)
       {
         if (ClassStruct.usSubclass == 1)   //$1
         {
           ulRC = mwmV80LAnywhereV80ToDial(pmwmDspInfo);  //$6
           if (ulRC)
             return ulRC;
         } /* endif */
       } /* endif */
       break;
    case 1:
      ulRC = mwmAnywhereClass1ToDial(pmwmDspInfo);
      if (ulRC)
        return ulRC;
      break;
  }


  /***************************************************************************/
  /* We need to call the datamode cleanup stuff from any mode.               */
  /* It does many cleanup activities that are needed no matter which         */
  /* class (mode) we are in.                                                 */
  /***************************************************************************/
  ulRC = mwmAnywhereDataToDiscrim(pmwmDspInfo);
  if (ulRC)
    return ulRC;

  /* Load caller ID based upon the #CID setting */
  if( pmwmDspInfo->bCIDCapability )
  {
    ulRC = mwmCidlLoad(pmwmDspInfo, mwmCidpQueryCid()); /* load caller ID */
    if (ulRC)
      return ulRC;
  }

  /* Load distinctive ring based upon the -SDR setting */
  if( pmwmDspInfo->bDRingCapability )
  {
    ulRC = mwmCidlLoadDRing(pmwmDspInfo, mwmCidpQueryDRing()); /* load dist. ring */
    if (ulRC)
      return ulRC;
  }

  if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_GETSIZE)
  {
    (*pfnWriteDSPSnapshot)(pmwmDspInfo->hDSP,"anywh.snp");
  }


  pmwmDspInfo->ulDiscrimState = 1;

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmanywh::mwmAnywhereToDiscrim exit\n");  }


  return 0;
}





ULONG mwmAnywhereDataToDiscrim(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG ulRC = 0;
  ULONG ulAddress = 0;
  USHORT usValue = 0;
  ULONG  ulLeaveV34Loaded = 0;
  ULONG  ulLeaveV32Loaded = 0;



  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmanywh::mwmAnywhereDataToDiscrim entry\n");  }



  /***************************************************************************/
  /* Find out if we are going to leave V.34 loaded.                          */
  /***************************************************************************/
  if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_V34)
  {
    ulLeaveV34Loaded = GetPrivateProfileInt("FEATURES","V34STATIC",
                                            0,INIFile );
  }

  if (ulLeaveV34Loaded && pmwmDspInfo->hmodV34 && pmwmDspInfo->hmtV34)
  {
    /*************************************************************************/
    /* 2/23/95                                                               */
    /* At this point, MCTL should have already swapped to the low speed      */
    /* DPITCB.                                                               */
    /* In some abort cases, MCTLFLAG was not getting reset.  To fix this,    */
    /* we swap from the low speed ITCB to the high speed DPITCB.             */
    /* This will clear the MCTLFLAG in the high speed ITCB                   */
    /*************************************************************************/
    /* Swap to V.34 DPITCB                                                   */
    /*************************************************************************/
    ulRC = mwmLoadSwapDatapumpITCB(pmwmDspInfo, 0xfffe);
    if (ulRC)
      return ulRC;

    ulRC = mwmSpcfcSetDPCPF(pmwmDspInfo,pmwmDspInfo->hmtV34, "MINCPF");
    if (ulRC)
      return ulRC;

    ulRC=dspDisconnectITCB(pmwmDspInfo->hmtV34,"DPITCB",pmwmDspInfo->hasyTask,"DPITCB");

    /******** GPC's **************/
    ulRC=dspDisconnectGPC(pmwmDspInfo->hmtV34,"RCVDATA",pmwmDspInfo->hasyTask,"RCVDATA");

    ulRC=dspDisconnectGPC(pmwmDspInfo->hasyTask,"XMITDATA",pmwmDspInfo->hmtV34,"XMITDATA");


    ulRC = mwmPumpsFreeV34Segments(pmwmDspInfo);
    if (ulRC)
      return ulRC;


    if ( ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_V42 ) &&
         ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_V42PRELOAD ) )
    {
      /******** GPC's **************/
      ulRC=dspDisconnectGPC(pmwmDspInfo->hmtV34,"RMNPDATA",
                            pmwmDspInfo->hmtV42MAC,"MAC_RECV");

      /*************************************************************************/
      /* V.42 is connected directly to                                         */
      /* the datapump.                                                         */
      /*************************************************************************/
      ulRC=dspDisconnectGPC(pmwmDspInfo->hmtV42MAC,"MAC_XMT",
                            pmwmDspInfo->hmtV34,"XV42DATA");
    } // end...if V.42

    if ( ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_MNP ) &&
         ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_MNPPRELOAD ) )
    {
      /***********************************************************************/
      /* We only need to disconnect these GPCs if MNP is still loaded.       */
      /* It will only be loaded if 1) it was the protocol used, and          */
      /* 2) we are NOT an automode modem.                                    */
      /* If we are not an Automode Modem, MNP is left loaded anytime it is   */
      /* installed.                                                          */
      /***********************************************************************/

      /******** GPC's **************/
      ulRC=dspDisconnectGPC(pmwmDspInfo->hmtV34,"RMNPDATA",
                            pmwmDspInfo->hmtMNP,"RMNPDATA");

      /******** GPC's **************/
      ulRC=dspDisconnectGPC(pmwmDspInfo->hmtMNP,"XMNPDATA",
                            pmwmDspInfo->hmtV34,"XMNPDATA");
    } // if MNP && MNPPRELOAD


  }




  /***************************************************************************/
  /* Find out if we are going to leave V.32 loaded.                          */
  /***************************************************************************/
  if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_AUTOMODE)
  {
    ulLeaveV32Loaded = GetPrivateProfileInt("FEATURES","V32STATIC",
                                            0,INIFile );
  }

  if (ulLeaveV32Loaded && pmwmDspInfo->hmodVDP && pmwmDspInfo->hvdpTask)
  {
    /*************************************************************************/
    /* 2/23/95                                                               */
    /* At this point, MCTL should have already swapped to the low speed      */
    /* DPITCB.                                                               */
    /* In some abort cases, MCTLFLAG was not getting reset.  To fix this,    */
    /* we swap from the low speed ITCB to the high speed DPITCB.             */
    /* This will clear the MCTLFLAG in the high speed ITCB                   */
    /*************************************************************************/
    /* Swap to V.32 DPITCB                                                   */
    /*************************************************************************/
    ulRC = mwmLoadSwapDatapumpITCB(pmwmDspInfo, 0xffff);
    if (ulRC)
      return ulRC;

    ulRC = mwmSpcfcSetDPCPF(pmwmDspInfo,pmwmDspInfo->hvdpTask, "MINCPF");
    if (ulRC)
      return ulRC;

    ulRC=dspDisconnectITCB(pmwmDspInfo->hvdpTask,"DPITCB",pmwmDspInfo->hasyTask,"DPITCB");

    /******** GPC's **************/
    ulRC=dspDisconnectGPC(pmwmDspInfo->hvdpTask,"RCVDATA",pmwmDspInfo->hasyTask,"RCVDATA");

    ulRC=dspDisconnectGPC(pmwmDspInfo->hasyTask,"XMITDATA",pmwmDspInfo->hvdpTask,"XMITDATA");


    ulRC = mwmPumpsFreeVDPSegments(pmwmDspInfo);
    if (ulRC)
      return ulRC;








    if ( ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_V42 ) &&
         ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_V42PRELOAD ) )
    {
      /******** GPC's **************/
      ulRC=dspDisconnectGPC(pmwmDspInfo->hvdpTask,"RMNPDATA",
                            pmwmDspInfo->hmtV42MAC,"MAC_RECV");

      /*************************************************************************/
      /* V.42 is connected directly to                                         */
      /* the datapump.                                                         */
      /*************************************************************************/
      ulRC=dspDisconnectGPC(pmwmDspInfo->hmtV42MAC,"MAC_XMT",
                            pmwmDspInfo->hvdpTask,"XV42DATA");
    } // end...if V.42

    if ( ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_MNP ) &&
         ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_MNPPRELOAD ) )
    {
      /***********************************************************************/
      /* We only need to disconnect these GPCs if MNP is still loaded.       */
      /* It will only be loaded if 1) it was the protocol used, and          */
      /* 2) we are NOT an automode modem.                                    */
      /* If we are not an Automode Modem, MNP is left loaded anytime it is   */
      /* installed.                                                          */
      /***********************************************************************/

      /******** GPC's **************/
      ulRC=dspDisconnectGPC(pmwmDspInfo->hvdpTask,"RMNPDATA",
                            pmwmDspInfo->hmtMNP,"RMNPDATA");

      /******** GPC's **************/
      ulRC=dspDisconnectGPC(pmwmDspInfo->hmtMNP,"XMNPDATA",
                            pmwmDspInfo->hvdpTask,"XMNPDATA");
    } // if MNP && MNPPRELOAD
  }







  /***************************************************************************/
  /* Switch MCTL to dummy datapump if any pumps are loaded.                  */
  /***************************************************************************/
  if (pmwmDspInfo->hv22Task ||
      pmwmDspInfo->hvdpTask ||
      pmwmDspInfo->hmtV34)
  {
    ulRC = mwmLoadSwapDatapumpITCB(pmwmDspInfo, 0);
    if (ulRC)
      return ulRC;
  }


  /***************************************************************************/
  /* Unload the MCTL DIALT Segment if it is loaded.                          */
  /***************************************************************************/
  if (pmwmDspInfo->hsegMCTLDIALT)
  {
    ulRC = dspFreeSegment(pmwmDspInfo->hsegMCTLDIALT);
    if (ulRC)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC);
      return(ulRC);
    }
    pmwmDspInfo->hsegMCTLDIALT = 0;
  }



  /***************************************************************************/
  /* Unload the ASYNC online segments if they are loaded.                    */
  /***************************************************************************/
  if (pmwmDspInfo->hsegAsyncECMPROC)
  {
    ulRC = dspFreeSegment(pmwmDspInfo->hsegAsyncECMPROC);
    if (ulRC)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC);
      return(ulRC);
    }
    pmwmDspInfo->hsegAsyncECMPROC = 0;
  }


  if (pmwmDspInfo->hsegAsyncACMPROC)
  {
    ulRC = dspFreeSegment(pmwmDspInfo->hsegAsyncACMPROC);
    if (ulRC)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC);
      return(ulRC);
    }
    pmwmDspInfo->hsegAsyncACMPROC = 0;
  }




  if (pmwmDspInfo->hsegV42BTempGPC1)
  {
    ulRC = dspFreeSegment(pmwmDspInfo->hsegV42BTempGPC1);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
    pmwmDspInfo->hsegV42BTempGPC1 = 0;
  }

  if (pmwmDspInfo->hsegV42BTempGPC2)
  {
    ulRC = dspFreeSegment(pmwmDspInfo->hsegV42BTempGPC2);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
    pmwmDspInfo->hsegV42BTempGPC2 = 0;
  }

  if (pmwmDspInfo->hsegV42BTempDSEG)
  {
    ulRC = dspFreeSegment(pmwmDspInfo->hsegV42BTempDSEG);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
    pmwmDspInfo->hsegV42BTempDSEG = 0;
  }



  /***************************************************************************/
  /* First, put all active modules in standby...                             */
  /***************************************************************************/
  if ( (pmwmDspInfo->hmodInterpolator) )
  {
    ulRC = dspChangeModuleState(pmwmDspInfo->hmodInterpolator, DSP_ACTIVATE_STANDBY );
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
  }

  if ( (pmwmDspInfo->hmodV8) )
  {
    ulRC = dspChangeModuleState(pmwmDspInfo->hmodV8, DSP_ACTIVATE_STANDBY );
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
  }

  if ( (pmwmDspInfo->hmodV22) )
  {
    ulRC = dspChangeModuleState(pmwmDspInfo->hmodV22, DSP_ACTIVATE_STANDBY );
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
  }

  if ( (pmwmDspInfo->hmodVDP && !ulLeaveV32Loaded) )
  {
    ulRC = dspChangeModuleState(pmwmDspInfo->hmodVDP, DSP_ACTIVATE_STANDBY );
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
  }

  if ( (pmwmDspInfo->hmodV34) && !ulLeaveV34Loaded )
  {
    ulRC = dspChangeModuleState(pmwmDspInfo->hmodV34, DSP_ACTIVATE_STANDBY );
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
  }

  if ( (pmwmDspInfo->hmodMNP) )
  {
    ulRC = dspChangeModuleState(pmwmDspInfo->hmodMNP, DSP_ACTIVATE_STANDBY );
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
  }

  if ( (pmwmDspInfo->hmodMNP5) )
  {
    ulRC = dspChangeModuleState(pmwmDspInfo->hmodMNP5, DSP_ACTIVATE_STANDBY );
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
  }

  if ( (pmwmDspInfo->hmodV42bis) )
  {
    ulRC = dspChangeModuleState(pmwmDspInfo->hmodV42bis, DSP_ACTIVATE_STANDBY );
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
  }

  if ( (pmwmDspInfo->hmodV42) )
  {
    ulRC = dspChangeModuleState(pmwmDspInfo->hmodV42, DSP_ACTIVATE_STANDBY );
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
  }




  /***************************************************************************/
  /* Unload V.42bis if it is loaded.                                         */
  /***************************************************************************/
  if ( (pmwmDspInfo->hmodV42bis != NULL) )
  {
    /***********************************************************************/
    /* MTS 2948                                                            */
    /* Reset V42bis loaded flag to 0.                                      */
    /***********************************************************************/
    ulRC = dspLabelToAddress(pmwmDspInfo->hmtProtSupr, "V42BIS", &ulAddress);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }

    usValue = 0;

    ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                          &usValue, 1,
                          DSP_MEMXFER_DATA_WRITE);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }

    ulRC = dspFreeModule(pmwmDspInfo->hmodV42bis);

    if (!ulRC)
    {
      pmwmDspInfo->hmodV42bis = NULL;
    }
  }



  /***************************************************************************/
  /* Unload RAMMBASE if it is loaded.                                        */
  /***************************************************************************/
  if ( (pmwmDspInfo->hmodRAMMBASE != NULL) )
  {
    ulRC = dspFreeModule(pmwmDspInfo->hmodRAMMBASE);

    if (!ulRC)
    {
      pmwmDspInfo->hmodRAMMBASE = NULL;
      pmwmDspInfo->hmtRAMMBASE = NULL;
    }
  }


  /***************************************************************************/
  /* Unload MNP5 if it is loaded.                                            */
  /***************************************************************************/
  if ( (pmwmDspInfo->hmodMNP5 != NULL) )
  {
    /***********************************************************************/
    /* MTS 2948                                                            */
    /* Reset MNP5 loaded flag to 0.                                        */
    /***********************************************************************/
    ulRC = dspLabelToAddress(pmwmDspInfo->hmtProtSupr, "MNP5", &ulAddress);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }

    usValue = 0;

    ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                          &usValue, 1,
                          DSP_MEMXFER_DATA_WRITE);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }

    ulRC = dspFreeModule(pmwmDspInfo->hmodMNP5);

    if (!ulRC)
    {
      pmwmDspInfo->hmodMNP5 = NULL;
    }
  }


  /***************************************************************************/
  /* Unload MNP if it is loaded                                              */
  /***************************************************************************/
  if ( (pmwmDspInfo->hmodMNP != NULL) )
  {
    /***********************************************************************/
    /* MTS 2948                                                            */
    /* Reset VDP loaded flag to 0.                                         */
    /***********************************************************************/
    ulRC = dspLabelToAddress(pmwmDspInfo->hmtProtSupr, "MNP", &ulAddress);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }

    usValue = 0;

    ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                          &usValue, 1,
                          DSP_MEMXFER_DATA_WRITE);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }

     ulRC = dspFreeModule(pmwmDspInfo->hmodMNP);

     if (!ulRC)
     {
       pmwmDspInfo->hmodMNP = NULL;
     }
  }


  /***************************************************************************/
  /* Unload V.42 if it is loaded.                                            */
  /***************************************************************************/
  if ( (pmwmDspInfo->hmodV42 != NULL) )
  {
    /***********************************************************************/
    /* MTS 2948                                                            */
    /* Reset VDP loaded flag to 0.                                         */
    /***********************************************************************/
    ulRC = dspLabelToAddress(pmwmDspInfo->hmtProtSupr, "V42", &ulAddress);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }

    usValue = 0;

    ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                          &usValue, 1,
                          DSP_MEMXFER_DATA_WRITE);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }

    ulRC = dspFreeModule(pmwmDspInfo->hmodV42);

    if (!ulRC)
    {
      pmwmDspInfo->hmodV42 = NULL;
    }
  }


  /***************************************************************************/
  /* Unload V.22bis if it is loaded.                                         */
  /***************************************************************************/
  if ( (pmwmDspInfo->hmodV22 != NULL) )
  {
    /***********************************************************************/
    /* MTS 2948                                                            */
    /* Reset VDP loaded flag to 0.                                         */
    /***********************************************************************/
    ulRC = dspLabelToAddress(pmwmDspInfo->hmtProtSupr, "V22", &ulAddress);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }

    usValue = 0;

    ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                          &usValue, 1,
                          DSP_MEMXFER_DATA_WRITE);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }

    ulRC = dspFreeModule(pmwmDspInfo->hmodV22);
    if (!ulRC)
    {
      pmwmDspInfo->hmodV22 = NULL;
      pmwmDspInfo->hv22Task = NULL;
    }
  }


  /***************************************************************************/
  /* Unload V.32 if it is loaded.                                            */
  /***************************************************************************/
  if ( (pmwmDspInfo->hmodVDP != NULL) && !ulLeaveV32Loaded)
  {
    /***********************************************************************/
    /* MTS 2948                                                            */
    /* Reset VDP loaded flag to 0.                                         */
    /***********************************************************************/
    ulRC = dspLabelToAddress(pmwmDspInfo->hmtProtSupr, "VDP", &ulAddress);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }

    usValue = 0;

    ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                          &usValue, 1,
                          DSP_MEMXFER_DATA_WRITE);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }

    ulRC = dspFreeModule(pmwmDspInfo->hmodVDP);
    if (!ulRC)
    {
      pmwmDspInfo->hmodVDP  = NULL;
      pmwmDspInfo->hvdpTask = NULL;
    }
  }


  /***************************************************************************/
  /* Unload V.34 if it is loaded.                                            */
  /***************************************************************************/
  if ( (pmwmDspInfo->hmodV34 != NULL)  && !ulLeaveV34Loaded )
  {
    ulRC = dspFreeModule(pmwmDspInfo->hmodV34);
    if (!ulRC)
    {
      pmwmDspInfo->hmodV34 = NULL;
      pmwmDspInfo->hmtV34  = NULL;
    }
  }


  /***************************************************************************/
  /* Unload V.8 if it is loaded.                                             */
  /***************************************************************************/
  if ( (pmwmDspInfo->hmodV8 != NULL) )
  {
    ulRC = dspFreeModule(pmwmDspInfo->hmodV8);
    if (!ulRC)
    {
      pmwmDspInfo->hmodV8 = NULL;
      pmwmDspInfo->hmtV8  = NULL;
    }
  }


  /***************************************************************************/
  /* Unload Call Progress if it is loaded.                                   */
  /***************************************************************************/
  if ( (pmwmDspInfo->hmodCallProg != NULL) && (ulRC != 0x0034) )
  {
    ulRC = dspFreeModule(pmwmDspInfo->hmodCallProg);
    if (!ulRC)
    {
      pmwmDspInfo->hmodCallProg = NULL;
      pmwmDspInfo->hmtCallProg = NULL;
    }
  }


  /***************************************************************************/
  /* Unload C96 if it is loaded.                                             */
  /***************************************************************************/
  if ( (pmwmDspInfo->hmodInterpolator != NULL) && (ulRC != 0x0034) )
  {
    ulRC = dspFreeModule(pmwmDspInfo->hmodInterpolator);
    if (!ulRC)
    {
      pmwmDspInfo->hmodInterpolator = NULL;
    }
  }



  /***************************************************************************/
  /* Set ASYNC cycles to "OFFLINE Mode"                                      */
  /***************************************************************************/
  if (pmwmDspInfo->hmodAsync && pmwmDspInfo->hasyTask)
  {
    ulRC = mwmSpcfcSetAsyncCycles(pmwmDspInfo, 0, 0, MWM_MUSTHAVE);   /* MTS RADD */
    if (ulRC)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC );
      return ulRC;
    }
  }

  /***************************************************************************/
  /* Switch from ASYNC2X to ASYNC                                            */
  /***************************************************************************/
  if (pmwmDspInfo->hmodAsync && pmwmDspInfo->hasyTask)
  {
    ulRC = mwmLoadSwapAsync(pmwmDspInfo, ASYNC1X);
    if (ulRC)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC );
      return ulRC;
    }
  }

  /***************************************************************************/
  /* MTS 3188   Set UART To 1 instead of 3                                   */
  /* Set the UART back to 1                                                  */
  /***************************************************************************/
  if (pmwmDspInfo->usUARTMode & USE_UART)
  {
    USHORT usFailed;
    ulRC = mwmCntndSetUART(pmwmDspInfo, 1L*11000L/8L, MWM_MUSTHAVE,
                           &usFailed,szThisFile,__LINE__);
    if (usFailed)
      return ulRC;
  }

  /***************************************************************************/
  /* Disconnect the UARTBOOST ITCBs if they are connected.                   */
  /***************************************************************************/
  ulRC = dspDisconnectITCB(pmwmDspInfo->hmtUART,"UARTITCB",
                    NULL,"U7ITCB");
//  if (ulRC)
//    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
//                   MWM_DSP_ERROR, ulRC );

  ulRC = dspDisconnectITCB(pmwmDspInfo->hmtUART,"UARTITCB",
                    NULL,"U31ITCB");
//  if (ulRC)
//    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
//                   MWM_DSP_ERROR, ulRC );

  ulRC = dspDisconnectITCB(pmwmDspInfo->hmtUART,"UARTITCB",
                    NULL,"UNRTITCB");
//  if (ulRC)
//    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
//                   MWM_DSP_ERROR, ulRC );




  /***************************************************************************/
  /* Free all of the V.42bis/V.34 memory pool                                */
  /* 04/26/95 ... now the last piece, CORECHUNK, must be freed separately.   */
  /***************************************************************************/
  ulRC = mwmPoolFreeV42bisDictionary(pmwmDspInfo);
  if (ulRC)
    return ulRC;

  /***************************************************************************/
  /* 04/26/95 MTS 3073                                                       */
  /* Free the CORECHUNK if it has been allocated.                            */
  /***************************************************************************/
  if (pmwmDspInfo->ahsegMemPool[0])
  {
    ulRC = mwmPoolFreeCoreChunk(pmwmDspInfo);
    if (ulRC)
      return ulRC;
  }


  /***************************************************************************/
  /* MTS 5873 09/13/95                                                       */
  /* Reset MNP and V42 features back to what is in ulLongTermFeatures        */
  /* Reverses what was done in function mwmSpcfcSetProtocol                  */
  /***************************************************************************/
  /* MTS 6939 ... Also set V23 to Long term setting...                       */
  /***************************************************************************/


  usValue = GetPrivateProfileInt("DEBUG","IGNORESLASHN",
                                              0,INIFile );
  if (!usValue)
  {
    pmwmDspInfo->ulFeaturesToLoad &= ~(FEATURE_V42 |
                                       FEATURE_MNP   );
     { MW_SYSLOG_2(TRACE_MWMLW32,"mwmanywh::mwmAnywhereDataToDiscrim turning off V42 %lx\n",pmwmDspInfo->ulFeaturesToLoad);  }

    pmwmDspInfo->ulFeaturesToLoad |= (pmwmDspInfo->ulLongTermFeatures & (FEATURE_V42 |
                                                                         FEATURE_MNP   ));

    mwmSpcfcSetFeatures(pmwmDspInfo, 1);   /* tell parser and mctl about change */
  }

  /***************************************************************************/
  /* Reset V42 features back to what is in ulLongTermFeatures                */
  /* Reverses what was done in function mwmSpcfcSetProtocol                  */
  /***************************************************************************/

  if (pmwmDspInfo->ulLongTermFeatures & FEATURE_V42BIS)                   //$7
  {                                                                       //$7
    pmwmDspInfo->ulFeaturesToLoad |= (pmwmDspInfo->ulLongTermFeatures & FEATURE_V42BIS);
                                                                          //$7
    mwmSpcfcSetFeatures(pmwmDspInfo, 1); /* tell parser and mctl about change */
  }                                                                       //$7


  if (pmwmDspInfo->ulLongTermFeatures & FEATURE_V23)
  {
    pmwmDspInfo->ulFeaturesToLoad |= FEATURE_V23;

    mwmSpcfcSetFeatures(pmwmDspInfo, 1);   /* tell parser and mctl about change */
  }


  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmanywh::mwmAnywhereDataToDiscrim exit\n");  }


  return 0;
}




ULONG mwmAnywhereClass1ToDial(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG  ulRC = 0;
  ULONG  ulLeaveCL1_HDLCLoaded = 0;

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmanywh::mwmAnywhereClass1ToDial entry\n");  }


  /***************************************************************************/
  /* 11/21/95                                                                */
  /* Class 1...                                                              */
  /***************************************************************************/
  if ( (pmwmDspInfo->hmodCL1_HDLC != NULL) && (ulRC != 0x0034) )
  {
    ulLeaveCL1_HDLCLoaded = GetPrivateProfileInt("FEATURES","CL1_HDLCSTATIC",
                                            0,INIFile );

    if (!ulLeaveCL1_HDLCLoaded)
    {
      ulRC = dspFreeModule(pmwmDspInfo->hmodCL1_HDLC);
      if (!ulRC)
      {
        pmwmDspInfo->hmodCL1_HDLC = NULL;
        pmwmDspInfo->hmtCL1_HDLC  = NULL;
      }
    }
  }

  DPF("Unloading FAXPMP");

  if ( (pmwmDspInfo->hmodFAXPMP != NULL) && (ulRC != 0x0034) )
  {
    ulRC = dspFreeModule(pmwmDspInfo->hmodFAXPMP);
    if (!ulRC)
    {
      pmwmDspInfo->hmodFAXPMP = NULL;
    }
  }

  /* 01/15/97 DR - Unload Silence Detection */
  DPF("Unloading SILDET");

  if ( (pmwmDspInfo->hmodSILDET != NULL) && (ulRC != 0x0034) )
  {
    ulRC = dspFreeModule(pmwmDspInfo->hmodSILDET);
    if (!ulRC)
    {
      pmwmDspInfo->hmodSILDET = NULL;
    }
  }

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmanywh::mwmAnywhereClass1ToDial exit\n");  }


  return 0;
}



