/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.report.util.SWTGraphicsObject;
import com.nvidia.viper.ui.analysis.DataGrid;
import com.nvidia.viper.ui.analysis.IDataGridPainter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public final class DataGridCanvas
extends Canvas
implements PaintListener {
    private Point size;
    private final DataGrid dataGridDelegate;

    public DataGridCanvas(Composite parent, int style, IDataGridPainter painter) {
        super(parent, style);
        this.dataGridDelegate = new DataGrid(painter);
        this.addPaintListener(this);
    }

    public DataGrid getDataGrid() {
        return this.dataGridDelegate;
    }

    public void addColumn(int width, int style) {
        this.checkWidget();
        this.dataGridDelegate.addColumn(width, style);
        this.redraw();
    }

    public void addRow(Object ... row) {
        this.checkWidget();
        this.dataGridDelegate.addRow(row);
        this.redraw();
    }

    private int computeHeight() {
        int height = 0;
        GC gc = null;
        try {
            gc = new GC((Drawable)this);
            height = this.dataGridDelegate.computeHeight(new SWTGraphicsObject(gc));
        }
        finally {
            gc.dispose();
        }
        return height;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (changed || this.size == null) {
            Rectangle clientArea = this.getClientArea();
            Rectangle bounds = this.getBounds();
            int width = this.computeWidth() + bounds.width - clientArea.width + 4;
            int height = this.computeHeight() + bounds.height - clientArea.height + 4;
            return new Point(width, height);
        }
        return this.size;
    }

    private int computeWidth() {
        if (!this.dataGridDelegate.columnWidths.isEmpty()) {
            int width = 0;
            for (int column : this.dataGridDelegate.columnWidths) {
                width += column;
            }
            return width + 50;
        }
        return 100;
    }

    public void paintControl(PaintEvent e) {
        GC gc = e.gc;
        SWTGraphicsObject wtgo = new SWTGraphicsObject(gc);
        Rectangle bounds = this.getClientArea();
        this.dataGridDelegate.paintDataGrid(wtgo, bounds);
    }

    public void clear() {
        this.dataGridDelegate.clear();
    }

    public void setHeader(boolean b) {
        this.dataGridDelegate.setHeader(b);
    }
}

