// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOP_WireEdgeSet_HeaderFile
#define _BOP_WireEdgeSet_HeaderFile

#ifndef _TopoDS_Face_HeaderFile
#include <TopoDS_Face.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _BOP_ShapeSet_HeaderFile
#include <BOP_ShapeSet.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopAbs_Orientation_HeaderFile
#include <TopAbs_Orientation.hxx>
#endif
class TopoDS_Face;
class TopoDS_Shape;
class TopTools_ListOfShape;
class TopoDS_Edge;
class TopoDS_Vertex;
class gp_Pnt2d;
class gp_Vec2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! The class containing data and methods <br>
//!          for a set of edges and wires <br>
class BOP_WireEdgeSet  : public BOP_ShapeSet {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Empty constructor; <br>
Standard_EXPORT BOP_WireEdgeSet();


//! Creates a WES to build edges connected by vertices <br>
//! on face F. Edges of the WireEdgeSet must have a representation <br>
//! on surface of face F. <br>
Standard_EXPORT BOP_WireEdgeSet(const TopoDS_Face& F);


//! Initialize a WES to build edges connected by vertices <br>
//! on face F. Edges of the WireEdgeSet must have a representation <br>
//! on surface of face F. <br>
Standard_EXPORT   void Initialize(const TopoDS_Face& F) ;


//! Selector <br>
Standard_EXPORT  const TopoDS_Face& Face() const;


//! See  in  base  class,  please <br>
Standard_EXPORT virtual  void AddShape(const TopoDS_Shape& S) ;


//! See  in  base  class,  please <br>
Standard_EXPORT virtual  void AddStartElement(const TopoDS_Shape& S) ;


//! See  in  base  class,  please <br>
Standard_EXPORT virtual  void AddElement(const TopoDS_Shape& S) ;


//! Internal  usage <br>
Standard_EXPORT virtual  void InitNeighbours(const TopoDS_Shape& E) ;


//! Build the list of neighbour edges of edge myCurrentShape <br>
//! Initialize iterator of neighbour edges to edge myCurrentShape <br>
Standard_EXPORT virtual  void FindNeighbours() ;


Standard_EXPORT virtual const TopTools_ListOfShape& MakeNeighboursList(const TopoDS_Shape& E,const TopoDS_Shape& V) ;


//! Internal  usage <br>
Standard_EXPORT static  void IsUVISO(const TopoDS_Edge& E,const TopoDS_Face& F,Standard_Boolean& uiso,Standard_Boolean& viso) ;


//! Removes the edge aE from the WES <br>
Standard_EXPORT   void RemoveEdgeFromWES(const TopoDS_Edge& aE) ;


//! Returns TRUE if the edge aE has been kept twice <br>
//! in  the WES <br>
Standard_EXPORT   Standard_Boolean KeptTwice(const TopoDS_Edge& aE) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


//! Indicates whether vertex V is a good connexity vertex between <br>
//! edges E1 and E2. <br>
//! i.e, returns True if V is shared by E1 and E2 and if V has different <br>
//! orientations on E1 and E2. <br>
//! If V is shared by E1 and E2, returns the orientation of V on E1 and E2 <br>
Standard_EXPORT   Standard_Boolean VertexConnectsEdges(const TopoDS_Shape& V,const TopoDS_Shape& E1,const TopoDS_Shape& E2,TopAbs_Orientation& O1,TopAbs_Orientation& O2) const;


//! Internal  usage <br>
Standard_EXPORT   Standard_Boolean VertexConnectsEdgesClosing(const TopoDS_Shape& V,const TopoDS_Shape& E1,const TopoDS_Shape& E2) const;


//! Internal  usage <br>
Standard_EXPORT   Standard_Integer NbClosingShapes(const TopTools_ListOfShape& L) const;


//! Internal  usage <br>
Standard_EXPORT   void LocalD1(const TopoDS_Face& F,const TopoDS_Edge& E,const TopoDS_Vertex& V,gp_Pnt2d& P2,gp_Vec2d& V2) const;


//! indicates if the edge <E> is a closing edge of myFace <br>
//! Internal  usage <br>
Standard_EXPORT   Standard_Boolean IsClosed(const TopoDS_Shape& E) const;


//! indicates if the edge <E> is a closing edge on U of myFace <br>
//! Internal  usage <br>
Standard_EXPORT   Standard_Boolean IsUClosed(const TopoDS_Shape& E) const;


//! indicates if the edge <E> is a closing edge on V of myFace <br>
//! Internal  usage <br>
Standard_EXPORT   Standard_Boolean IsVClosed(const TopoDS_Shape& E) const;


 // Fields PRIVATE
 //
TopoDS_Face myFace;
Standard_Integer myDEBVertexIndex;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
