// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepPrim_Builder_HeaderFile
#define _BRepPrim_Builder_HeaderFile

#ifndef _BRep_Builder_HeaderFile
#include <BRep_Builder.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class BRep_Builder;
class TopoDS_Shell;
class TopoDS_Face;
class gp_Pln;
class TopoDS_Wire;
class TopoDS_Edge;
class gp_Lin;
class gp_Circ;
class gp_Lin2d;
class gp_Circ2d;
class TopoDS_Vertex;
class gp_Pnt;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! implements the abstract Builder with the BRep Builder <br>
class BRepPrim_Builder  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates an empty, useless  Builder. Necesseray for <br>
//!          compilation. <br>
Standard_EXPORT BRepPrim_Builder();

//! Creates from a Builder. <br>
Standard_EXPORT BRepPrim_Builder(const BRep_Builder& B);

 const BRep_Builder& Builder() const;

//! Make a empty Shell. <br>
Standard_EXPORT   void MakeShell(TopoDS_Shell& S) const;

//! Returns in   <F> a  Face  built  with   the  plane <br>
//!          equation <P>. Used by all primitives. <br>
Standard_EXPORT   void MakeFace(TopoDS_Face& F,const gp_Pln& P) const;

//! Returns in <W> an empty Wire. <br>
Standard_EXPORT   void MakeWire(TopoDS_Wire& W) const;

//! Returns in <E> a degenerated edge. <br>
Standard_EXPORT   void MakeDegeneratedEdge(TopoDS_Edge& E) const;

//! Returns   in <E>  an  Edge  built  with  the  line <br>
//!          equation  <L>. <br>
Standard_EXPORT   void MakeEdge(TopoDS_Edge& E,const gp_Lin& L) const;

//! Returns  in <E>   an  Edge  built  with the circle <br>
//!          equation  <C>. <br>
Standard_EXPORT   void MakeEdge(TopoDS_Edge& E,const gp_Circ& C) const;

//! Sets the line <L> to be the curve representing the <br>
//!          edge <E> in the parametric space of the surface of <br>
//!          <F>. <br>
Standard_EXPORT   void SetPCurve(TopoDS_Edge& E,const TopoDS_Face& F,const gp_Lin2d& L) const;

//! Sets the    lines  <L1,L2>  to   be     the curves <br>
//!          representing the edge <E>  in the parametric space <br>
//!          of the closed surface of <F>. <br>
Standard_EXPORT   void SetPCurve(TopoDS_Edge& E,const TopoDS_Face& F,const gp_Lin2d& L1,const gp_Lin2d& L2) const;

//! Sets the  circle <C> to  be the curve representing <br>
//!          the  edge <E>  in   the  parametric  space of  the <br>
//!          surface of <F>. <br>
Standard_EXPORT   void SetPCurve(TopoDS_Edge& E,const TopoDS_Face& F,const gp_Circ2d& C) const;

//! Returns in <V> a Vertex built with the point <P>. <br>
Standard_EXPORT   void MakeVertex(TopoDS_Vertex& V,const gp_Pnt& P) const;

//! Reverses the Face <F>. <br>
Standard_EXPORT   void ReverseFace(TopoDS_Face& F) const;

//! Adds the Vertex <V> in the Edge <E>.  <P> is the <br>
//!          parameter of the vertex on the  edge.  If direct <br>
//!          is False the Vertex is reversed. <br>
Standard_EXPORT   void AddEdgeVertex(TopoDS_Edge& E,const TopoDS_Vertex& V,const Standard_Real P,const Standard_Boolean direct) const;

//! Adds  the Vertex <V>  in the Edge <E>.   <P1,P2> <br>
//!          are the  parameters of the  vertex on the closed <br>
//!          edge. <br>
Standard_EXPORT   void AddEdgeVertex(TopoDS_Edge& E,const TopoDS_Vertex& V,const Standard_Real P1,const Standard_Real P2) const;

//! <P1,P2> are the parameters of the  vertex on the <br>
//!          edge.  The edge is a closed curve. <br>
Standard_EXPORT   void SetParameters(TopoDS_Edge& E,const TopoDS_Vertex& V,const Standard_Real P1,const Standard_Real P2) const;

//! Adds the Edge <E> in the  Wire <W>, if direct is <br>
//!          False the Edge is reversed. <br>
Standard_EXPORT   void AddWireEdge(TopoDS_Wire& W,const TopoDS_Edge& E,const Standard_Boolean direct) const;

//! Adds the Wire <W> in  the Face <F>. <br>
Standard_EXPORT   void AddFaceWire(TopoDS_Face& F,const TopoDS_Wire& W) const;

//! Adds the Face <F>  in the Shell <Sh>. <br>
Standard_EXPORT   void AddShellFace(TopoDS_Shell& Sh,const TopoDS_Face& F) const;

//! This is called once an edge is completed. It gives <br>
//!          the opportunity to perform any post treatment. <br>
Standard_EXPORT   void CompleteEdge(TopoDS_Edge& E) const;

//! This is called once a wire is  completed. It gives <br>
//!          the opportunity to perform any post treatment. <br>
Standard_EXPORT   void CompleteWire(TopoDS_Wire& W) const;

//! This is called once a face is  completed. It gives <br>
//!          the opportunity to perform any post treatment. <br>
Standard_EXPORT   void CompleteFace(TopoDS_Face& F) const;

//! This is called once a shell is  completed. It gives <br>
//!          the opportunity to perform any post treatment. <br>
Standard_EXPORT   void CompleteShell(TopoDS_Shell& S) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
BRep_Builder myBuilder;


};


#include <BRepPrim_Builder.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
