// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IFSelect_SelectSignedShared_HeaderFile
#define _IFSelect_SelectSignedShared_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IFSelect_SelectSignedShared_HeaderFile
#include <Handle_IFSelect_SelectSignedShared.hxx>
#endif

#ifndef _Handle_IFSelect_Signature_HeaderFile
#include <Handle_IFSelect_Signature.hxx>
#endif
#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _IFSelect_SelectExplore_HeaderFile
#include <IFSelect_SelectExplore.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
class IFSelect_Signature;
class TCollection_AsciiString;
class Standard_Transient;
class Interface_Graph;
class Interface_EntityIterator;


//! In the graph, explore the Shareds of the input entities, <br>
//!           until it encounters some which match a given Signature <br>
//!           (for a limited level, filters the returned list) <br>
//!           By default, fitted for any level <br>
class IFSelect_SelectSignedShared : public IFSelect_SelectExplore {

public:
 // Methods PUBLIC
 // 

//! Creates a SelectSignedShared, defaulted for any level <br>
//!           with a given Signature and text to match <br>
Standard_EXPORT IFSelect_SelectSignedShared(const Handle(IFSelect_Signature)& matcher,const Standard_CString signtext,const Standard_Boolean exact = Standard_True,const Standard_Integer level = 0);

//! Returns the used Signature, then it is possible to access it, <br>
//!           modify it as required <br>
Standard_EXPORT   Handle_IFSelect_Signature Signature() const;

//! Returns Text used to Sort Entity on its Signature <br>
Standard_EXPORT  const TCollection_AsciiString& SignatureText() const;

//! Returns True if match must be exact <br>
Standard_EXPORT   Standard_Boolean IsExact() const;

//! Explores an entity : its Shared entities <br>
//!           <ent> to take if it matches the Signature <br>
//!           At level max, filters the result. Else gives all Shareds <br>
Standard_EXPORT   Standard_Boolean Explore(const Standard_Integer level,const Handle(Standard_Transient)& ent,const Interface_Graph& G,Interface_EntityIterator& explored) const;

//! Returns a text defining the criterium. <br>
//!           (it refers to the text and exact flag to be matched, and is <br>
//!           qualified by the Name provided by the Signature) <br>
Standard_EXPORT   TCollection_AsciiString ExploreLabel() const;
//Standard_EXPORT ~IFSelect_SelectSignedShared();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_IFSelect_Signature thematcher;
TCollection_AsciiString thesigntext;
Standard_Boolean theexact;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
