// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IntAna_IntLinTorus_HeaderFile
#define _IntAna_IntLinTorus_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class StdFail_NotDone;
class Standard_OutOfRange;
class gp_Lin;
class gp_Torus;
class gp_Pnt;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Intersection between a line and a torus. <br>
class IntAna_IntLinTorus  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT IntAna_IntLinTorus();

//! Creates the intersection between a line and a torus. <br>
Standard_EXPORT IntAna_IntLinTorus(const gp_Lin& L,const gp_Torus& T);

//! Intersects a line and a torus. <br>
Standard_EXPORT   void Perform(const gp_Lin& L,const gp_Torus& T) ;
//! Returns True if the computation was successful. <br>
//! <br>
  Standard_Boolean IsDone() const;
//! Returns the number of intersection points. <br>
//! <br>
  Standard_Integer NbPoints() const;
//! Returns the intersection point of range Index. <br>
//! <br>
 const gp_Pnt& Value(const Standard_Integer Index) const;
//! Returns the parameter on the line of the intersection <br>
//!          point of range Index. <br>
//! <br>
  Standard_Real ParamOnLine(const Standard_Integer Index) const;
//! Returns the parameters on the torus of the intersection <br>
//!          point of range Index. <br>
//! <br>
  void ParamOnTorus(const Standard_Integer Index,Standard_Real& FI,Standard_Real& THETA) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean done;
Standard_Integer nbpt;
gp_Pnt thePoint[4];
Standard_Real theParam[4];
Standard_Real theFi[4];
Standard_Real theTheta[4];


};


#include <IntAna_IntLinTorus.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
